/*
 * Copyright (c) 2020, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "ti_msp_dl_config.h"

// typedef struct{
//     uint16_t Result;
//     uint16_t 
// } ;

volatile uint8_t SeqCnt = 0;

uint16_t Result[4][3];

uint16_t ChannelTable[4][3] = {
    {DL_ADC12_INPUT_CHAN_0, DL_ADC12_INPUT_CHAN_1 , DL_ADC12_INPUT_CHAN_2},
    {DL_ADC12_INPUT_CHAN_3, DL_ADC12_INPUT_CHAN_4, DL_ADC12_INPUT_CHAN_5},
    {DL_ADC12_INPUT_CHAN_6, DL_ADC12_INPUT_CHAN_7, DL_ADC12_INPUT_CHAN_8},
    {DL_ADC12_INPUT_CHAN_9, DL_ADC12_INPUT_CHAN_9, DL_ADC12_INPUT_CHAN_9}
};

int main(void)
{
    SYSCFG_DL_init();

    NVIC_EnableIRQ(ADC12_0_INST_INT_IRQN);
    SeqCnt = 0;
    DL_ADC12_startConversion(ADC12_0_INST);

    while (1) {
        __NOP();
    }
}

void ADC12_0_INST_IRQHandler(void)
{
    if(DL_ADC12_getEnabledInterruptStatus(ADC12_0_INST, DL_ADC12_INTERRUPT_MEM2_RESULT_LOADED)) {
        Result[SeqCnt][0] = DL_ADC12_getMemResult(ADC12_0_INST, ADC12_0_ADCMEM_0);
        Result[SeqCnt][1] = DL_ADC12_getMemResult(ADC12_0_INST, ADC12_0_ADCMEM_1);
        Result[SeqCnt][2] = DL_ADC12_getMemResult(ADC12_0_INST, ADC12_0_ADCMEM_2);

        SeqCnt++;
        if(SeqCnt >= 4){
            SeqCnt = 0;
        }

        while(DL_ADC12_getRawInterruptStatus(ADC12_0_INST, DL_ADC12_INTERRUPT_MEM3_RESULT_LOADED) == 0);

        DL_ADC12_configConversionMem(ADC12_0_INST, ADC12_0_ADCMEM_0,
        ChannelTable[SeqCnt][0], DL_ADC12_REFERENCE_VOLTAGE_VDDA_VSSA, DL_ADC12_SAMPLE_TIMER_SOURCE_SCOMP0, DL_ADC12_AVERAGING_MODE_DISABLED,
        DL_ADC12_BURN_OUT_SOURCE_DISABLED, DL_ADC12_TRIGGER_MODE_AUTO_NEXT, DL_ADC12_WINDOWS_COMP_MODE_DISABLED);

        DL_ADC12_configConversionMem(ADC12_0_INST, ADC12_0_ADCMEM_1,
        ChannelTable[SeqCnt][1], DL_ADC12_REFERENCE_VOLTAGE_VDDA_VSSA, DL_ADC12_SAMPLE_TIMER_SOURCE_SCOMP0, DL_ADC12_AVERAGING_MODE_DISABLED,
        DL_ADC12_BURN_OUT_SOURCE_DISABLED, DL_ADC12_TRIGGER_MODE_AUTO_NEXT, DL_ADC12_WINDOWS_COMP_MODE_DISABLED);

        DL_ADC12_configConversionMem(ADC12_0_INST, ADC12_0_ADCMEM_2,
        ChannelTable[SeqCnt][2], DL_ADC12_REFERENCE_VOLTAGE_VDDA_VSSA, DL_ADC12_SAMPLE_TIMER_SOURCE_SCOMP0, DL_ADC12_AVERAGING_MODE_DISABLED,
        DL_ADC12_BURN_OUT_SOURCE_DISABLED, DL_ADC12_TRIGGER_MODE_AUTO_NEXT, DL_ADC12_WINDOWS_COMP_MODE_DISABLED);

        DL_ADC12_enableConversions(ADC12_0_INST);
        DL_ADC12_startConversion(ADC12_0_INST);
        DL_ADC12_clearInterruptStatus(ADC12_0_INST, DL_ADC12_INTERRUPT_MEM2_RESULT_LOADED);
    }
    if(DL_ADC12_getEnabledInterruptStatus(ADC12_0_INST, DL_ADC12_INTERRUPT_WINDOW_COMP_HIGH)){
        DL_GPIO_togglePins(GPIO_LEDS_PORT, GPIO_LEDS_USER_LED_1_PIN);
        DL_ADC12_clearInterruptStatus(ADC12_0_INST, DL_ADC12_INTERRUPT_WINDOW_COMP_HIGH);
    }

}
