/* ======================================================================
*   Copyright (C) 2022-2023 Texas Instruments Incorporated
*
*   All rights reserved. Property of Texas Instruments Incorporated.
*   Restricted rights to use, duplicate or disclose this code are
*   granted through contract.
*
*   The program may not be used without the written permission
*   of Texas Instruments Incorporated or against the terms and conditions
*   stipulated in the agreement under which this program has been
*   supplied.
* ==================================================================== */
 /***************************************************************************
  Project: am263mcal10
  Date   : 2024-12-27 16:47:51
  This file is generated by EB Tresos
  Do not modify this file, otherwise the software may behave in unexpected way.

 *****************************************************************************/

/**
 *  \file     Can_Cfg.h
 *
 *  \brief    This file contains generated pre compile configuration file for
 *            CAN MCAL driver
 *
 */

/**
 *
 ******************************************************************************
 * \defgroup MCAL_CAN_CFG CAN Configuration
 *
 * This files defines CAN MCAL configuration structures
 *  @{
 ******************************************************************************/

#ifndef CAN_CFG_H_
#define CAN_CFG_H_

#ifdef __cplusplus
extern "C" {
#endif

/** \brief CAN Config ID */
#define CAN_CFG_ID          (CAN_CFG_ID_0)

/**
*  \brief CAN Build Variant.
*   Build variants.(i.e Pre Compile,Post Build)
*/

#define CAN_VARIANT_PRE_COMPILE     (STD_OFF)
#define CAN_VARIANT_POST_BUILD      (STD_ON)

/**
 *  \name Can Driver Configuration SW Version Info
 *
 *  Defines for CAN Driver configuration version
 *  @{
 */
/** \brief Can configuration Major Version */
#define CAN_CFG_MAJOR_VERSION           (10U)
/** \brief Can configuration Minor Version */
#define CAN_CFG_MINOR_VERSION           (0U)
/** \brief Can configuration Patch Version */
#define CAN_CFG_PATCH_VERSION           (0U)
/* @} */


/**
 *  \name Can service enable/disable defines
 *
 *  Pre-compile switches for enabling/disabling CAN MCAL APIs
 *  @{
 */
 
 /** \brief Enable/Disable Can_GetVersionInfo */
#define CAN_VERSION_INFO_API   (STD_ON)
/** \brief Enable/Disable DEV error detection */
#define CAN_DEV_ERROR_DETECT  (STD_ON)
/** \brief Enable/Disable Can_DeInit API */
#define CAN_DEINIT_API  (STD_ON)
/** \brief Enable/Disable Can_SetBaudrate API */
#define CAN_SET_BAUDRATE_API  (STD_ON)
/** \brief Enable/Disable Can_TestLoopBackModeEnable */
#define CAN_LOOPBACK_ENABLE   (STD_ON)
/** \brief Enable/Disable Can_ConfigRegReadBack */
#define CAN_REGISTER_READBACK_API           (STD_ON)
/** \brief Enable/Disable Can_CheckWakeup */
#define CAN_WAKEUP_FUNCTIONALITY_API        (STD_OFF)
/** \brief Enable/Disable Multiplexed Transmission */
#define CAN_MULTIPLEXED_TRANSMISSION_ENABLE (STD_OFF)
/** \brief Enable/Disable CanIf_TriggerTransmit */
#define CAN_TRIGGER_TRANSMIT_ENABLE (STD_OFF)
/** \brief Enable/Disable Can_MainFunction_Write */
#define CAN_TX_POLLING      (STD_OFF)
/** \brief Enable/Disable Can_MainFunction_Read */
#define CAN_RX_POLLING      (STD_OFF)
/** \brief Enable/Disable Can_MainFunction_BusOff */
#define CAN_BUSOFF_POLLING  (STD_OFF)
/** \brief Enable/Disable Can_MainFunction_Wakeup */
#define CAN_WAKEUP_POLLING  (STD_OFF)
/** \brief Enable/Disable single bit ECC logic */
#define CAN_ECC_ENABLE      STD_OFF

/* @} */

/**
 *  \name Can Controllers
 * @{
 */
 /** \brief Max number of controllers defined*/
#define CAN_NUM_CONTROLLER          (1U)
/** \brief Max number of mailboxes defined*/
#define CAN_NUM_MAILBOXES           (2U)
/** \brief Max number of mailboxes per controller */
#define CAN_MAX_CONTROLLER          (4U)
/** \brief Total Number of TX mailboxes */
#define CAN_NUM_TX_MAILBOXES 		(1U)
/* @} */
/**
 *  \name Can Controller Id names
 *
 *  Defines for symbolic names for the CanControllerIds
 *  @{
 */
#define CanConf_CanController_CanController_0   (0U)

#define CAN_CONTROLLER_MCAN0

/* @} */
/**
 *  \name Can HW Object names
 *
 *  Defines for symbolic names for the CanHardwareObjectIds
 *  @{
 */

#define CanConf_CanHardwareObject_CanHardwareObject_0   (0U)
#define CAN_HTRH_0         (CanConf_CanHardwareObject_CanHardwareObject_0)

#define CanConf_CanHardwareObject_CanHardwareObject_8   (1U)
#define CAN_HTRH_1         (CanConf_CanHardwareObject_CanHardwareObject_8)

/* @} */

/**
 *  \name Can misc configurations
 *  @{
 */
/** \brief Counter ID for counter used to count wait ticks */
#define CAN_OS_COUNTER_ID               ((CounterType)1U)

/**
*  \brief CAN timeout - used in CAN IFCMD busy wait and Start/Stop busy wait.
*   Specifies the maximum time for blocking function until a timeout is detected.
*   Unit is milli seconds.
*/
#define CAN_TIMEOUT_DURATION            (20000U)
/** \brief Enable/Disable OSEK Category 1 ISR */
#define CAN_ISR_TYPE                (CAN_ISR_VOID)


/* @} */

/**
 *  \name CAN DEM Error codes to report
 *
 *  Pre-compile switches for enabling/disabling DEM events
 *  @{
 */
/* @} */
/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/**
 * \brief Can Mailbox direction enum
 */
typedef enum
{
    CAN_CONTROLLER_INSTANCE_MCAN0 = 0x0U,
    /**< MCAN0 Controller Instance */
    CAN_CONTROLLER_INSTANCE_MCAN1 = 0x1U,
    /**< MCAN1 Controller Instance */
    CAN_CONTROLLER_INSTANCE_MCAN2 = 0x2U,
    /**< MCAN2 Controller Instance */
    CAN_CONTROLLER_INSTANCE_MCAN3 = 0x3U
    /**< MCAN3 Controller Instance */
} Can_ControllerInstance;

/**
 *  \name Can Configuration Structure
 *
 *  @{
 */

extern const struct Can_ConfigType_s CanConfigSet;

extern const struct Can_ControllerStruct_PC CanConfigSet_PC_CanController_0;


/** \brief CAN Controller Pre Compile Configuration List */
extern const struct Can_ControllerStruct_PC
    *CanConfigSet_CanController_List_PC[CAN_NUM_CONTROLLER];

/** \brief CAN Mailbox Pre Compile Configuration List */
extern const struct Can_MailboxStruct_PC
    *CanConfigSet_CanHardwareObject_List_PC[CAN_NUM_MAILBOXES];


/* @} */
#ifdef __cplusplus
}
#endif

#endif /*CAN_CFG_H__*/

/* @} */
/**********************************************************************************************************************
 *  END OF FILE: Can_Cfg.h
 *********************************************************************************************************************/
