/* ======================================================================
 *   Copyright (c) 2022-2023 Texas Instruments Incorporated
 *
 *   All rights reserved. Property of Texas Instruments Incorporated.
 *   Restricted rights to use, duplicate or disclose this code are
 *   granted through contract.
 *
 *   The program may not be used without the written permission
 *   of Texas Instruments Incorporated or against the terms and conditions
 *   stipulated in the agreement under which this program has been
 *   supplied.
 * ==================================================================== */
/***********************************************************************
    Project: am263mcal10
	Date   : 2024-12-27 16:47:51

    This file is generated by EB Tresos
    Do not modify this file, otherwise the software may behave in 
	unexpected way.

 ***********************************************************************/
/**
 *  \file     Dio_Cfg.h
 *
 *  \brief    This file contains generated pre compile configuration file
 *            for DIO MCAL driver
 *
 */

/**
 *  \defgroup MCAL_DIO_CFG DIO Configuration
 *
 *  This files defines DIO MCAL configuration structures
 *  @{
 */

#ifndef DIO_CFG_H_
#define DIO_CFG_H_

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */


#ifdef __cplusplus
extern "C" {
#endif

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */
/** \brief DIO Config ID */
#define DIO_CFG_ID                      (0x1U)

/**
 *  \name Dio Driver Configuration SW Version Info
 *
 *  Defines for Dio Driver configuration version
 *  @{
 */
/** \brief Dio configuration Major Version */
#define DIO_CFG_MAJOR_VERSION           (10U)
/** \brief Dio configuration Minor Version */
#define DIO_CFG_MINOR_VERSION           (0U)
/** \brief Dio configuration Patch Version */
#define DIO_CFG_PATCH_VERSION           (0U)
/* @} */



#define DIO_VARIANT_LINK_TIME            (STD_ON)

/** \brief DIO Driver Instance ID */
#define DIO_INSTANCE_ID                 ((uint8) 0U)

/**
 *  \name GPIO register identifiers
 *
 *  Defines mapping to physical GPIO registers
 *  @{
 */
/** \brief GPIO REG0 identifier */
#define DIO_GPIO_REG_0                 (0U)
/** \brief GPIO REG1 identifier */
#define DIO_GPIO_REG_1                 (1U)
/** \brief GPIO REG2 identifier */
#define DIO_GPIO_REG_2                 (2U)
/** \brief GPIO REG3 identifier */
#define DIO_GPIO_REG_3                 (3U)
/** \brief GPIO REG4 identifier */
#define DIO_GPIO_REG_4                 (4U)

/* @} */

/*
 * Design: MCAL-19942
 */
/* Requirements : SWS_Dio_00103 */
/** \brief Width of GPIO register in this platform */
#define DIO_PORT_WIDTH                 (32U)

/**
 *  \name DIO service enable/diable defines
 *
 *  Pre-compile switches for enabling/disabling DIO MCAL APIs
 *  @{
 */
/** \brief Enable/Disable DEV error detection */
#define DIO_DEV_ERROR_DETECT            (STD_ON)

/** \brief Enable/Disable Dio_GetVersionInfo() */
#define DIO_VERSION_INFO_API            (STD_ON)

/** \brief Enable/Disable Dio_FlipChannel() */
#define DIO_FLIP_CHANNEL_API            (STD_ON)

/** \brief Enable/Disable Dio_RegisterReadback() */
#define DIO_REGISTER_READBACK_API            (STD_ON)

/** \brief GPIO Ownership for R5F Cores */

#define DIO_GPIO_BASE   0x52000000U


/* @} */

/* Requirements : SWS_Dio_00026, SWS_Dio_00113, SWS_Dio_00020 */
/**
 *  \name Symbolic name of DIO PORTs
 *
 *  This is symbolic name of DIO ports generated from configurator
 *  These defines map to physical GPIO register numbers.
 *  @{
 */
/** \brief Symbolic name for GPIO REG #0 */
#define DioConf_DioPort_GPIOAB ((Dio_PortType)  DIO_GPIO_REG_0)

/** \brief Symbolic name for GPIO REG #1 */
#define DioConf_DioPort_GPIOCD ((Dio_PortType)  DIO_GPIO_REG_1)

/** \brief Symbolic name for GPIO REG #2 */
#define DioConf_DioPort_GPIOEF ((Dio_PortType)  DIO_GPIO_REG_2)

/** \brief Symbolic name for GPIO REG #3 */
#define DioConf_DioPort_GPIOGH ((Dio_PortType)  DIO_GPIO_REG_3)

/** \brief Symbolic name for GPIO REG #4 */
#define DioConf_DioPort_GPIOI ((Dio_PortType)  DIO_GPIO_REG_4)

/* @} */

 /** \brief Max number of DIO ports */
#define DIO_ENABLED_PORT_MASK             (0U    | (1U << 0) | (1U << 1) | (1U << 2) | (1U << 3) | (1U << 4))


/** \brief Max number of DIO ports */
#define DIO_MAX_NO_OF_PORTS             5U

/* Requirements : SWS_Dio_00026, SWS_Dio_00113, SWS_Dio_00017 */
/**
 *  \name Symbolic name of DIO Channels
 *
 *  This is symbolic name of DIO channels generated from configurator
 *  These defines map to GPIO register channels
 *  The channel numbers are mapped as
 *  GPIO_REG_0: Channel 0  - Channel 7
 *  GPIO_REG_1: Channel 8 - Channel 15
 *  GPIO_REG_2: Channel 16 - Channel 23
 *  GPIO_REG_3: Channel 24 - Channel 31
 *  GPIO_REG_4: Channel 32  - Channel 39
 *  GPIO_REG_5: Channel 40  - Channel 47
 *  GPIO_REG_6: Channel 48  - Channel 55
 *  GPIO_REG_7: Channel 56  - Channel 63
 *  @{
 */
/** \brief Symbolic name for GPIO channel #0 GPIOAB_Ch0 */
#define DioConf_DioChannel_GPIOAB_Ch0 ((Dio_ChannelType) 0U)
/** \brief Symbolic name for GPIO channel #1 GPIOAB_Ch1 */
#define DioConf_DioChannel_GPIOAB_Ch1 ((Dio_ChannelType) 1U)
/** \brief Symbolic name for GPIO channel #2 GPIOAB_Ch2 */
#define DioConf_DioChannel_GPIOAB_Ch2 ((Dio_ChannelType) 2U)
/** \brief Symbolic name for GPIO channel #3 GPIOAB_Ch3 */
#define DioConf_DioChannel_GPIOAB_Ch3 ((Dio_ChannelType) 3U)
/** \brief Symbolic name for GPIO channel #4 GPIOAB_Ch4 */
#define DioConf_DioChannel_GPIOAB_Ch4 ((Dio_ChannelType) 4U)
/** \brief Symbolic name for GPIO channel #5 GPIOAB_Ch5 */
#define DioConf_DioChannel_GPIOAB_Ch5 ((Dio_ChannelType) 5U)
/** \brief Symbolic name for GPIO channel #6 GPIOAB_Ch6 */
#define DioConf_DioChannel_GPIOAB_Ch6 ((Dio_ChannelType) 6U)
/** \brief Symbolic name for GPIO channel #7 GPIOAB_Ch7 */
#define DioConf_DioChannel_GPIOAB_Ch7 ((Dio_ChannelType) 7U)
/** \brief Symbolic name for GPIO channel #8 GPIOAB_Ch8 */
#define DioConf_DioChannel_GPIOAB_Ch8 ((Dio_ChannelType) 8U)
/** \brief Symbolic name for GPIO channel #9 GPIOAB_Ch9 */
#define DioConf_DioChannel_GPIOAB_Ch9 ((Dio_ChannelType) 9U)
/** \brief Symbolic name for GPIO channel #10 GPIOAB_Ch10 */
#define DioConf_DioChannel_GPIOAB_Ch10 ((Dio_ChannelType) 10U)
/** \brief Symbolic name for GPIO channel #11 GPIOAB_Ch11 */
#define DioConf_DioChannel_GPIOAB_Ch11 ((Dio_ChannelType) 11U)
/** \brief Symbolic name for GPIO channel #12 GPIOAB_Ch12 */
#define DioConf_DioChannel_GPIOAB_Ch12 ((Dio_ChannelType) 12U)
/** \brief Symbolic name for GPIO channel #13 GPIOAB_Ch13 */
#define DioConf_DioChannel_GPIOAB_Ch13 ((Dio_ChannelType) 13U)
/** \brief Symbolic name for GPIO channel #14 GPIOAB_Ch14 */
#define DioConf_DioChannel_GPIOAB_Ch14 ((Dio_ChannelType) 14U)
/** \brief Symbolic name for GPIO channel #15 GPIOAB_Ch15 */
#define DioConf_DioChannel_GPIOAB_Ch15 ((Dio_ChannelType) 15U)
/** \brief Symbolic name for GPIO channel #16 GPIOAB_Ch16 */
#define DioConf_DioChannel_GPIOAB_Ch16 ((Dio_ChannelType) 16U)
/** \brief Symbolic name for GPIO channel #17 GPIOAB_Ch17 */
#define DioConf_DioChannel_GPIOAB_Ch17 ((Dio_ChannelType) 17U)
/** \brief Symbolic name for GPIO channel #18 GPIOAB_Ch18 */
#define DioConf_DioChannel_GPIOAB_Ch18 ((Dio_ChannelType) 18U)
/** \brief Symbolic name for GPIO channel #19 GPIOAB_Ch19 */
#define DioConf_DioChannel_GPIOAB_Ch19 ((Dio_ChannelType) 19U)
/** \brief Symbolic name for GPIO channel #20 GPIOAB_Ch20 */
#define DioConf_DioChannel_GPIOAB_Ch20 ((Dio_ChannelType) 20U)
/** \brief Symbolic name for GPIO channel #21 GPIOAB_Ch21 */
#define DioConf_DioChannel_GPIOAB_Ch21 ((Dio_ChannelType) 21U)
/** \brief Symbolic name for GPIO channel #22 GPIOAB_Ch22 */
#define DioConf_DioChannel_GPIOAB_Ch22 ((Dio_ChannelType) 22U)
/** \brief Symbolic name for GPIO channel #23 GPIOAB_Ch23 */
#define DioConf_DioChannel_GPIOAB_Ch23 ((Dio_ChannelType) 23U)
/** \brief Symbolic name for GPIO channel #24 GPIOAB_Ch24 */
#define DioConf_DioChannel_GPIOAB_Ch24 ((Dio_ChannelType) 24U)
/** \brief Symbolic name for GPIO channel #25 GPIOAB_Ch25 */
#define DioConf_DioChannel_GPIOAB_Ch25 ((Dio_ChannelType) 25U)
/** \brief Symbolic name for GPIO channel #26 GPIOAB_Ch26 */
#define DioConf_DioChannel_GPIOAB_Ch26 ((Dio_ChannelType) 26U)
/** \brief Symbolic name for GPIO channel #27 GPIOAB_Ch27 */
#define DioConf_DioChannel_GPIOAB_Ch27 ((Dio_ChannelType) 27U)
/** \brief Symbolic name for GPIO channel #28 GPIOAB_Ch28 */
#define DioConf_DioChannel_GPIOAB_Ch28 ((Dio_ChannelType) 28U)
/** \brief Symbolic name for GPIO channel #29 GPIOAB_Ch29 */
#define DioConf_DioChannel_GPIOAB_Ch29 ((Dio_ChannelType) 29U)
/** \brief Symbolic name for GPIO channel #30 GPIOAB_Ch30 */
#define DioConf_DioChannel_GPIOAB_Ch30 ((Dio_ChannelType) 30U)
/** \brief Symbolic name for GPIO channel #31 GPIOAB_Ch31 */
#define DioConf_DioChannel_GPIOAB_Ch31 ((Dio_ChannelType) 31U)
/** \brief Symbolic name for GPIO channel #32 GPIOCD_Ch0 */
#define DioConf_DioChannel_GPIOCD_Ch0 ((Dio_ChannelType) 32U)
/** \brief Symbolic name for GPIO channel #33 GPIOCD_Ch1 */
#define DioConf_DioChannel_GPIOCD_Ch1 ((Dio_ChannelType) 33U)
/** \brief Symbolic name for GPIO channel #34 GPIOCD_Ch2 */
#define DioConf_DioChannel_GPIOCD_Ch2 ((Dio_ChannelType) 34U)
/** \brief Symbolic name for GPIO channel #35 GPIOCD_Ch3 */
#define DioConf_DioChannel_GPIOCD_Ch3 ((Dio_ChannelType) 35U)
/** \brief Symbolic name for GPIO channel #36 GPIOCD_Ch4 */
#define DioConf_DioChannel_GPIOCD_Ch4 ((Dio_ChannelType) 36U)
/** \brief Symbolic name for GPIO channel #37 GPIOCD_Ch5 */
#define DioConf_DioChannel_GPIOCD_Ch5 ((Dio_ChannelType) 37U)
/** \brief Symbolic name for GPIO channel #38 GPIOCD_Ch6 */
#define DioConf_DioChannel_GPIOCD_Ch6 ((Dio_ChannelType) 38U)
/** \brief Symbolic name for GPIO channel #39 GPIOCD_Ch7 */
#define DioConf_DioChannel_GPIOCD_Ch7 ((Dio_ChannelType) 39U)
/** \brief Symbolic name for GPIO channel #40 GPIOCD_Ch8 */
#define DioConf_DioChannel_GPIOCD_Ch8 ((Dio_ChannelType) 40U)
/** \brief Symbolic name for GPIO channel #41 GPIOCD_Ch9 */
#define DioConf_DioChannel_GPIOCD_Ch9 ((Dio_ChannelType) 41U)
/** \brief Symbolic name for GPIO channel #42 GPIOCD_Ch10 */
#define DioConf_DioChannel_GPIOCD_Ch10 ((Dio_ChannelType) 42U)
/** \brief Symbolic name for GPIO channel #43 GPIOCD_Ch11 */
#define DioConf_DioChannel_GPIOCD_Ch11 ((Dio_ChannelType) 43U)
/** \brief Symbolic name for GPIO channel #44 GPIOCD_Ch12 */
#define DioConf_DioChannel_GPIOCD_Ch12 ((Dio_ChannelType) 44U)
/** \brief Symbolic name for GPIO channel #45 GPIOCD_Ch13 */
#define DioConf_DioChannel_GPIOCD_Ch13 ((Dio_ChannelType) 45U)
/** \brief Symbolic name for GPIO channel #46 GPIOCD_Ch14 */
#define DioConf_DioChannel_GPIOCD_Ch14 ((Dio_ChannelType) 46U)
/** \brief Symbolic name for GPIO channel #47 GPIOCD_Ch15 */
#define DioConf_DioChannel_GPIOCD_Ch15 ((Dio_ChannelType) 47U)
/** \brief Symbolic name for GPIO channel #48 GPIOCD_Ch16 */
#define DioConf_DioChannel_GPIOCD_Ch16 ((Dio_ChannelType) 48U)
/** \brief Symbolic name for GPIO channel #49 GPIOCD_Ch17 */
#define DioConf_DioChannel_GPIOCD_Ch17 ((Dio_ChannelType) 49U)
/** \brief Symbolic name for GPIO channel #50 GPIOCD_Ch18 */
#define DioConf_DioChannel_GPIOCD_Ch18 ((Dio_ChannelType) 50U)
/** \brief Symbolic name for GPIO channel #51 GPIOCD_Ch19 */
#define DioConf_DioChannel_GPIOCD_Ch19 ((Dio_ChannelType) 51U)
/** \brief Symbolic name for GPIO channel #52 GPIOCD_Ch20 */
#define DioConf_DioChannel_GPIOCD_Ch20 ((Dio_ChannelType) 52U)
/** \brief Symbolic name for GPIO channel #53 GPIOCD_Ch21 */
#define DioConf_DioChannel_GPIOCD_Ch21 ((Dio_ChannelType) 53U)
/** \brief Symbolic name for GPIO channel #54 GPIOCD_Ch22 */
#define DioConf_DioChannel_GPIOCD_Ch22 ((Dio_ChannelType) 54U)
/** \brief Symbolic name for GPIO channel #55 GPIOCD_Ch23 */
#define DioConf_DioChannel_GPIOCD_Ch23 ((Dio_ChannelType) 55U)
/** \brief Symbolic name for GPIO channel #56 GPIOCD_Ch24 */
#define DioConf_DioChannel_GPIOCD_Ch24 ((Dio_ChannelType) 56U)
/** \brief Symbolic name for GPIO channel #57 GPIOCD_Ch25 */
#define DioConf_DioChannel_GPIOCD_Ch25 ((Dio_ChannelType) 57U)
/** \brief Symbolic name for GPIO channel #58 GPIOCD_Ch26 */
#define DioConf_DioChannel_GPIOCD_Ch26 ((Dio_ChannelType) 58U)
/** \brief Symbolic name for GPIO channel #59 GPIOCD_Ch27 */
#define DioConf_DioChannel_GPIOCD_Ch27 ((Dio_ChannelType) 59U)
/** \brief Symbolic name for GPIO channel #60 GPIOCD_Ch28 */
#define DioConf_DioChannel_GPIOCD_Ch28 ((Dio_ChannelType) 60U)
/** \brief Symbolic name for GPIO channel #61 GPIOCD_Ch29 */
#define DioConf_DioChannel_GPIOCD_Ch29 ((Dio_ChannelType) 61U)
/** \brief Symbolic name for GPIO channel #62 GPIOCD_Ch30 */
#define DioConf_DioChannel_GPIOCD_Ch30 ((Dio_ChannelType) 62U)
/** \brief Symbolic name for GPIO channel #63 GPIOCD_Ch31 */
#define DioConf_DioChannel_GPIOCD_Ch31 ((Dio_ChannelType) 63U)
/** \brief Symbolic name for GPIO channel #64 GPIOEF_Ch0 */
#define DioConf_DioChannel_GPIOEF_Ch0 ((Dio_ChannelType) 64U)
/** \brief Symbolic name for GPIO channel #65 GPIOEF_Ch1 */
#define DioConf_DioChannel_GPIOEF_Ch1 ((Dio_ChannelType) 65U)
/** \brief Symbolic name for GPIO channel #66 GPIOEF_Ch2 */
#define DioConf_DioChannel_GPIOEF_Ch2 ((Dio_ChannelType) 66U)
/** \brief Symbolic name for GPIO channel #67 GPIOEF_Ch3 */
#define DioConf_DioChannel_GPIOEF_Ch3 ((Dio_ChannelType) 67U)
/** \brief Symbolic name for GPIO channel #68 GPIOEF_Ch4 */
#define DioConf_DioChannel_GPIOEF_Ch4 ((Dio_ChannelType) 68U)
/** \brief Symbolic name for GPIO channel #69 GPIOEF_Ch5 */
#define DioConf_DioChannel_GPIOEF_Ch5 ((Dio_ChannelType) 69U)
/** \brief Symbolic name for GPIO channel #70 GPIOEF_Ch6 */
#define DioConf_DioChannel_GPIOEF_Ch6 ((Dio_ChannelType) 70U)
/** \brief Symbolic name for GPIO channel #71 GPIOEF_Ch7 */
#define DioConf_DioChannel_GPIOEF_Ch7 ((Dio_ChannelType) 71U)
/** \brief Symbolic name for GPIO channel #72 GPIOEF_Ch8 */
#define DioConf_DioChannel_GPIOEF_Ch8 ((Dio_ChannelType) 72U)
/** \brief Symbolic name for GPIO channel #73 GPIOEF_Ch9 */
#define DioConf_DioChannel_GPIOEF_Ch9 ((Dio_ChannelType) 73U)
/** \brief Symbolic name for GPIO channel #74 GPIOEF_Ch10 */
#define DioConf_DioChannel_GPIOEF_Ch10 ((Dio_ChannelType) 74U)
/** \brief Symbolic name for GPIO channel #75 GPIOEF_Ch11 */
#define DioConf_DioChannel_GPIOEF_Ch11 ((Dio_ChannelType) 75U)
/** \brief Symbolic name for GPIO channel #76 GPIOEF_Ch12 */
#define DioConf_DioChannel_GPIOEF_Ch12 ((Dio_ChannelType) 76U)
/** \brief Symbolic name for GPIO channel #77 GPIOEF_Ch13 */
#define DioConf_DioChannel_GPIOEF_Ch13 ((Dio_ChannelType) 77U)
/** \brief Symbolic name for GPIO channel #78 GPIOEF_Ch14 */
#define DioConf_DioChannel_GPIOEF_Ch14 ((Dio_ChannelType) 78U)
/** \brief Symbolic name for GPIO channel #79 GPIOEF_Ch15 */
#define DioConf_DioChannel_GPIOEF_Ch15 ((Dio_ChannelType) 79U)
/** \brief Symbolic name for GPIO channel #80 GPIOEF_Ch16 */
#define DioConf_DioChannel_GPIOEF_Ch16 ((Dio_ChannelType) 80U)
/** \brief Symbolic name for GPIO channel #81 GPIOEF_Ch17 */
#define DioConf_DioChannel_GPIOEF_Ch17 ((Dio_ChannelType) 81U)
/** \brief Symbolic name for GPIO channel #82 GPIOEF_Ch18 */
#define DioConf_DioChannel_GPIOEF_Ch18 ((Dio_ChannelType) 82U)
/** \brief Symbolic name for GPIO channel #83 GPIOEF_Ch19 */
#define DioConf_DioChannel_GPIOEF_Ch19 ((Dio_ChannelType) 83U)
/** \brief Symbolic name for GPIO channel #84 GPIOEF_Ch20 */
#define DioConf_DioChannel_GPIOEF_Ch20 ((Dio_ChannelType) 84U)
/** \brief Symbolic name for GPIO channel #85 GPIOEF_Ch21 */
#define DioConf_DioChannel_GPIOEF_Ch21 ((Dio_ChannelType) 85U)
/** \brief Symbolic name for GPIO channel #86 GPIOEF_Ch22 */
#define DioConf_DioChannel_GPIOEF_Ch22 ((Dio_ChannelType) 86U)
/** \brief Symbolic name for GPIO channel #87 GPIOEF_Ch23 */
#define DioConf_DioChannel_GPIOEF_Ch23 ((Dio_ChannelType) 87U)
/** \brief Symbolic name for GPIO channel #88 GPIOEF_Ch24 */
#define DioConf_DioChannel_GPIOEF_Ch24 ((Dio_ChannelType) 88U)
/** \brief Symbolic name for GPIO channel #89 GPIOEF_Ch25 */
#define DioConf_DioChannel_GPIOEF_Ch25 ((Dio_ChannelType) 89U)
/** \brief Symbolic name for GPIO channel #90 GPIOEF_Ch26 */
#define DioConf_DioChannel_GPIOEF_Ch26 ((Dio_ChannelType) 90U)
/** \brief Symbolic name for GPIO channel #91 GPIOEF_Ch27 */
#define DioConf_DioChannel_GPIOEF_Ch27 ((Dio_ChannelType) 91U)
/** \brief Symbolic name for GPIO channel #92 GPIOEF_Ch28 */
#define DioConf_DioChannel_GPIOEF_Ch28 ((Dio_ChannelType) 92U)
/** \brief Symbolic name for GPIO channel #93 GPIOEF_Ch29 */
#define DioConf_DioChannel_GPIOEF_Ch29 ((Dio_ChannelType) 93U)
/** \brief Symbolic name for GPIO channel #94 GPIOEF_Ch30 */
#define DioConf_DioChannel_GPIOEF_Ch30 ((Dio_ChannelType) 94U)
/** \brief Symbolic name for GPIO channel #95 GPIOEF_Ch31 */
#define DioConf_DioChannel_GPIOEF_Ch31 ((Dio_ChannelType) 95U)
/** \brief Symbolic name for GPIO channel #96 GPIOGH_Ch0 */
#define DioConf_DioChannel_GPIOGH_Ch0 ((Dio_ChannelType) 96U)
/** \brief Symbolic name for GPIO channel #97 GPIOGH_Ch1 */
#define DioConf_DioChannel_GPIOGH_Ch1 ((Dio_ChannelType) 97U)
/** \brief Symbolic name for GPIO channel #98 GPIOGH_Ch2 */
#define DioConf_DioChannel_GPIOGH_Ch2 ((Dio_ChannelType) 98U)
/** \brief Symbolic name for GPIO channel #99 GPIOGH_Ch3 */
#define DioConf_DioChannel_GPIOGH_Ch3 ((Dio_ChannelType) 99U)
/** \brief Symbolic name for GPIO channel #100 GPIOGH_Ch4 */
#define DioConf_DioChannel_GPIOGH_Ch4 ((Dio_ChannelType) 100U)
/** \brief Symbolic name for GPIO channel #101 GPIOGH_Ch5 */
#define DioConf_DioChannel_GPIOGH_Ch5 ((Dio_ChannelType) 101U)
/** \brief Symbolic name for GPIO channel #102 GPIOGH_Ch6 */
#define DioConf_DioChannel_GPIOGH_Ch6 ((Dio_ChannelType) 102U)
/** \brief Symbolic name for GPIO channel #103 GPIOGH_Ch7 */
#define DioConf_DioChannel_GPIOGH_Ch7 ((Dio_ChannelType) 103U)
/** \brief Symbolic name for GPIO channel #104 GPIOGH_Ch8 */
#define DioConf_DioChannel_GPIOGH_Ch8 ((Dio_ChannelType) 104U)
/** \brief Symbolic name for GPIO channel #105 GPIOGH_Ch9 */
#define DioConf_DioChannel_GPIOGH_Ch9 ((Dio_ChannelType) 105U)
/** \brief Symbolic name for GPIO channel #106 GPIOGH_Ch10 */
#define DioConf_DioChannel_GPIOGH_Ch10 ((Dio_ChannelType) 106U)
/** \brief Symbolic name for GPIO channel #107 GPIOGH_Ch11 */
#define DioConf_DioChannel_GPIOGH_Ch11 ((Dio_ChannelType) 107U)
/** \brief Symbolic name for GPIO channel #108 GPIOGH_Ch12 */
#define DioConf_DioChannel_GPIOGH_Ch12 ((Dio_ChannelType) 108U)
/** \brief Symbolic name for GPIO channel #109 GPIOGH_Ch13 */
#define DioConf_DioChannel_GPIOGH_Ch13 ((Dio_ChannelType) 109U)
/** \brief Symbolic name for GPIO channel #110 GPIOGH_Ch14 */
#define DioConf_DioChannel_GPIOGH_Ch14 ((Dio_ChannelType) 110U)
/** \brief Symbolic name for GPIO channel #111 GPIOGH_Ch15 */
#define DioConf_DioChannel_GPIOGH_Ch15 ((Dio_ChannelType) 111U)
/** \brief Symbolic name for GPIO channel #112 GPIOGH_Ch16 */
#define DioConf_DioChannel_GPIOGH_Ch16 ((Dio_ChannelType) 112U)
/** \brief Symbolic name for GPIO channel #113 GPIOGH_Ch17 */
#define DioConf_DioChannel_GPIOGH_Ch17 ((Dio_ChannelType) 113U)
/** \brief Symbolic name for GPIO channel #114 GPIOGH_Ch18 */
#define DioConf_DioChannel_GPIOGH_Ch18 ((Dio_ChannelType) 114U)
/** \brief Symbolic name for GPIO channel #115 GPIOGH_Ch19 */
#define DioConf_DioChannel_GPIOGH_Ch19 ((Dio_ChannelType) 115U)
/** \brief Symbolic name for GPIO channel #116 GPIOGH_Ch20 */
#define DioConf_DioChannel_GPIOGH_Ch20 ((Dio_ChannelType) 116U)
/** \brief Symbolic name for GPIO channel #117 GPIOGH_Ch21 */
#define DioConf_DioChannel_GPIOGH_Ch21 ((Dio_ChannelType) 117U)
/** \brief Symbolic name for GPIO channel #118 GPIOGH_Ch22 */
#define DioConf_DioChannel_GPIOGH_Ch22 ((Dio_ChannelType) 118U)
/** \brief Symbolic name for GPIO channel #119 GPIOGH_Ch23 */
#define DioConf_DioChannel_GPIOGH_Ch23 ((Dio_ChannelType) 119U)
/** \brief Symbolic name for GPIO channel #120 GPIOGH_Ch24 */
#define DioConf_DioChannel_GPIOGH_Ch24 ((Dio_ChannelType) 120U)
/** \brief Symbolic name for GPIO channel #121 GPIOGH_Ch25 */
#define DioConf_DioChannel_GPIOGH_Ch25 ((Dio_ChannelType) 121U)
/** \brief Symbolic name for GPIO channel #122 GPIOGH_Ch26 */
#define DioConf_DioChannel_GPIOGH_Ch26 ((Dio_ChannelType) 122U)
/** \brief Symbolic name for GPIO channel #123 GPIOGH_Ch27 */
#define DioConf_DioChannel_GPIOGH_Ch27 ((Dio_ChannelType) 123U)
/** \brief Symbolic name for GPIO channel #124 GPIOGH_Ch28 */
#define DioConf_DioChannel_GPIOGH_Ch28 ((Dio_ChannelType) 124U)
/** \brief Symbolic name for GPIO channel #125 GPIOGH_Ch29 */
#define DioConf_DioChannel_GPIOGH_Ch29 ((Dio_ChannelType) 125U)
/** \brief Symbolic name for GPIO channel #126 GPIOGH_Ch30 */
#define DioConf_DioChannel_GPIOGH_Ch30 ((Dio_ChannelType) 126U)
/** \brief Symbolic name for GPIO channel #127 GPIOGH_Ch31 */
#define DioConf_DioChannel_GPIOGH_Ch31 ((Dio_ChannelType) 127U)
/** \brief Symbolic name for GPIO channel #128 GPIOI_Ch0 */
#define DioConf_DioChannel_GPIOI_Ch0 ((Dio_ChannelType) 128U)
/** \brief Symbolic name for GPIO channel #129 GPIOI_Ch1 */
#define DioConf_DioChannel_GPIOI_Ch1 ((Dio_ChannelType) 129U)
/** \brief Symbolic name for GPIO channel #130 GPIOI_Ch2 */
#define DioConf_DioChannel_GPIOI_Ch2 ((Dio_ChannelType) 130U)
/** \brief Symbolic name for GPIO channel #131 GPIOI_Ch3 */
#define DioConf_DioChannel_GPIOI_Ch3 ((Dio_ChannelType) 131U)
/** \brief Symbolic name for GPIO channel #132 GPIOI_Ch4 */
#define DioConf_DioChannel_GPIOI_Ch4 ((Dio_ChannelType) 132U)
/** \brief Symbolic name for GPIO channel #133 GPIOI_Ch5 */
#define DioConf_DioChannel_GPIOI_Ch5 ((Dio_ChannelType) 133U)
/** \brief Symbolic name for GPIO channel #134 GPIOI_Ch6 */
#define DioConf_DioChannel_GPIOI_Ch6 ((Dio_ChannelType) 134U)
/** \brief Symbolic name for GPIO channel #135 GPIOI_Ch7 */
#define DioConf_DioChannel_GPIOI_Ch7 ((Dio_ChannelType) 135U)
/** \brief Symbolic name for GPIO channel #136 GPIOI_Ch8 */
#define DioConf_DioChannel_GPIOI_Ch8 ((Dio_ChannelType) 136U)
/** \brief Symbolic name for GPIO channel #137 GPIOI_Ch9 */
#define DioConf_DioChannel_GPIOI_Ch9 ((Dio_ChannelType) 137U)
/** \brief Symbolic name for GPIO channel #138 GPIOI_Ch10 */
#define DioConf_DioChannel_GPIOI_Ch10 ((Dio_ChannelType) 138U)
/* @} */

/* Requirements : SWS_Dio_00026, SWS_Dio_00113, SWS_Dio_00022 */
/**
 *  \name Symbolic name of DIO Channel Groups
 *
 *  This is the symbolic name of DIO channel groups generated from configurator
 *  The definition of the channel groups is present in the generated
 *  Dio_PBCfg.c file. The other modules will invoke the Dio_channelGroup APIs
 *  using the symbolic name defines
 *
 *  @{
 */
#define DioConf_DioChannelGroup_GPIOAB_Bit5_8_PTR ((Dio_ChannelGroupRefType)(DioConfig_GPIOAB_ChannelGroupRef[0]))
#define DioConf_DioChannelGroup_GPIOAB_Bit1_5_PTR ((Dio_ChannelGroupRefType)(DioConfig_GPIOAB_ChannelGroupRef[1]))
#define DioConf_DioChannelGroup_GPIOCD_Bit2_5_PTR ((Dio_ChannelGroupRefType)(DioConfig_GPIOCD_ChannelGroupRef[0]))
/* @} */

/** \brief Enable/Disable GIO support in DIO */
#define DIO_SUPPORT_GIO             (STD_ON)

/**
 *  \name DIO DEM Error codes to report
 *
 *  Pre-compile switches for enabling/disabling DEM events
 *  @{
 */
 




/* @} */

/* Static tests for configuration integrity can be conducted here */
/* This check throws an error if Dio is configured to support neither Can nor
 * Gio */
#if ((DIO_SUPPORT_GIO == STD_OFF))
  #error "Must enable GPIO. This configuration is not valid."
#endif


/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */
/** \brief Dio reference to the channel group*/

extern P2CONST(void, AUTOMATIC, DIO_CONST) DioConfig_GPIOAB_ChannelGroupRef[2];

extern P2CONST(void, AUTOMATIC, DIO_CONST) DioConfig_GPIOCD_ChannelGroupRef[1];

extern P2CONST(void, AUTOMATIC, DIO_CONST) DioConfig_GPIOEF_ChannelGroupRef[0];

extern P2CONST(void, AUTOMATIC, DIO_CONST) DioConfig_GPIOGH_ChannelGroupRef[0];

extern P2CONST(void, AUTOMATIC, DIO_CONST) DioConfig_GPIOI_ChannelGroupRef[0];


/*LDRA_INSPECTED 33 D: MISRAC_2012_8.6
 * "Reason -  Dio configuration structure declaration" */
/** \brief global DIO channel configuration mask */
extern CONST (uint32,DIO_CONST) DioConfig_ValidChannelMask[DIO_MAX_NO_OF_PORTS];

/** This type is used to access the GIO Registers */
typedef struct
{
    uint32 PID_REG;
    uint32 PCR_REG;
    uint32 BINTEN_REG;
} Dio_RegisterReadbackType;

/* ========================================================================== */
/*                          Function Declarations                             */
/* ========================================================================== */
/* None */

#ifdef __cplusplus
}
#endif

#endif  /* #ifndef DIO_CFG_H_ */

/* @} */

