/* ======================================================================
 *   Copyright (c) 2022 Texas Instruments Incorporated
 *
 *   All rights reserved. Property of Texas Instruments Incorporated.
 *   Restricted rights to use, duplicate or disclose this code are
 *   granted through contract.
 *
 *   The program may not be used without the written permission
 *   of Texas Instruments Incorporated or against the terms and conditions
 *   stipulated in the agreement under which this program has been
 *   supplied.
 * ==================================================================== */

/**
 *  \file     Gpt_Cfg.h
 *
 *  \brief    This file contains generated pre compile configuration file
 *            for GPT MCAL driver
 *
 */

 /*********************************************************************************************************************
    Project: am263mcal10
	Date   : 2024-12-27 16:47:51
	10.0.0
	4.6.0
	AUTOSAR 4.3.1 0
	
    This file is generated by EB Tresos 
    Do not modify this file, otherwise the software may behave in unexpected way.
    
 *********************************************************************************************************************/

/**
 *  \defgroup MCAL_GPT_CFG GPT Configuration
 *
 *  This files defines GPT MCAL configuration structures
 *  @{
 */

#ifndef GPT_CFG_H_
#define GPT_CFG_H_

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */



#ifdef __cplusplus
extern "C" {
#endif

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */
/**
 *  \name Gpt Driver Configuration SW Version Info
 *
 *  Defines for Gpt Driver configuration version
 *  @{
 */
/** \brief Gpt configuration Major Version */
#define GPT_CFG_MAJOR_VERSION           (10U)
/** \brief Gpt configuration Minor Version */
#define GPT_CFG_MINOR_VERSION           (0U)
/** \brief Gpt configuration Patch Version */
#define GPT_CFG_PATCH_VERSION           (0U)
/* @} */

/** \brief GPT Config ID */
#define GPT_CFG_ID                      (0x1U)



/**
*  \brief GPT Build Variant.
*   Build variants.(i.e Pre Compile,Post Build or Link time)
*/
#define GPT_PRE_COMPILE_VARIANT       (STD_OFF)

#define GPT_POST_BUILD_VARIANT        (STD_ON)




/** \brief ISR type */
#define GPT_ISR_TYPE                (GPT_ISR_CAT1)

/**
 *  \name Pre-Compile Switches for API Services
 *  @{
 */
/** \brief Enable/disable GPT get version info API */
#define GPT_VERSION_INFO_API                           (STD_ON)
/** \brief Enable/disable GPT deinit API */
#define GPT_DEINIT_API                                 (STD_ON)
/** \brief Enable/disable GPT get time elapsed API */
#define GPT_TIME_ELAPSED_API                           (STD_ON)
/** \brief Enable/disable GPT time remaining API */
#define GPT_TIME_REMAINING_API                         (STD_ON)
/** \brief Enable/disable GPT enable/disable GPT API */
#define GPT_ENABLE_DISABLE_NOTIFICATION_API            (STD_ON)
/** \brief Enable/disable GPT wakeup functionality API */
#define GPT_WAKEUP_FUNCTIONALITY_API                   (STD_OFF)
/** \brief Enable/disable GPT register read back API */
#define GPT_REGISTER_READBACK_API               (STD_OFF)
/** \brief Enable/disable wakeup source in wakeup related APIs */
/* Requirements: ECUC_Gpt_00322 */
#define GPT_REPORT_WAKEUP_SOURCE            (STD_OFF)
/** \brief Enable/disable GPT dev detect error */
/* Requirements: ECUC_Gpt_00321 */
#define GPT_DEV_ERROR_DETECT                (STD_ON)
/* @} */


/**
 * \name GPT channels
 * GPT channels available for user
 * @{
 */
/** \brief No. of channels configured for GPT driver */
#define GPT_MAX_CHANNELS                                    (12U)

/** \brief GP timer channels available for AM263x */
#define GPT_RTI_CH_MIN              (0U)

#define GPT_RTI_CH_MAX              (15U)

#define GPT_RTI_MAX              	(16U)

/*
 * GPT channels available for user
 */
/** \brief Module 1 */
#define GPT_RTI_CHANNEL1            (0U)
#define GPT_RTI_CHANNEL2            (1U)
#define GPT_RTI_CHANNEL3            (2U)
#define GPT_RTI_CHANNEL4            (3U)
/** \brief Module 2 */
#define GPT_RTI_CHANNEL5            (4U)
#define GPT_RTI_CHANNEL6            (5U)
#define GPT_RTI_CHANNEL7            (6U)
#define GPT_RTI_CHANNEL8            (7U)
/** \brief Module 3 */
#define GPT_RTI_CHANNEL9            (8U)
#define GPT_RTI_CHANNEL10           (9U)
#define GPT_RTI_CHANNEL11           (10U)
#define GPT_RTI_CHANNEL12           (11U)
/** \brief Module 4 */
#define GPT_RTI_CHANNEL13           (12U)
#define GPT_RTI_CHANNEL14           (13U)
#define GPT_RTI_CHANNEL15           (14U)
#define GPT_RTI_CHANNEL16           (15U)
/* @} */

/**
 * \name GPT counters
 * GPT counters available for user
 * @{
 */
/** \brief Counter Block 0 */
#define GPT_RTI_COUNTER0            (0U)
/** \brief Counter Block 1 */
#define GPT_RTI_COUNTER1            (1U)
/** \brief Number of Counter Blocks per RTI Module */
#define GPT_RTI_COUNTERS            (2U)

/*
 * GPT RTI modules available for user
 */
/** \brief GP timer A instance */
#define GPT_RTI_MODULE1             (0U)
/** \brief GP timer B instance */
#define GPT_RTI_MODULE2             (1U)
/** \brief GP timer C instance */
#define GPT_RTI_MODULE3             (2U)
/** \brief GP timer D instance */
#define GPT_RTI_MODULE4             (3U)
/** \brief Number of GPT Modules */
#define GPT_RTI_MODULES             (4U)
/* @} */

/** \brief Macro for enabling predefined timers
 *        This is in case to disable GPT Predef Timers if timers can not be
 *        supported by hardware reasons.
 */
/* Requirements: SWS_Gpt_00385 */
/* Requirements: ECUC_Gpt_00335 */
#define GPT_PREDEF_TIMER_TYPE   (GPT_PREDEF_TIMER_DISABLED)

/** \brief: Specifies the grade of enabling the GPT Predef Timers with 1s
 *         tick duration */
#define GPT_PREDEF_TIMER_1US_ENABLING_GRADE   (GPT_PREDEF_UNDEFINED)


 #define GPT_CHANNEL_4
 #define GPT_CHANNEL_5
 #define GPT_CHANNEL_6
 #define GPT_CHANNEL_7
 #define GPT_CHANNEL_8
 #define GPT_CHANNEL_9
 #define GPT_CHANNEL_10
 #define GPT_CHANNEL_11
 #define GPT_CHANNEL_12
 #define GPT_CHANNEL_13
 #define GPT_CHANNEL_14
 #define GPT_CHANNEL_15

 #define GptConf_GptChannelConfiguration_GptChannelConfiguration_5 (4U)
 #define GptConf_GptChannelConfiguration_GptChannelConfiguration_6 (5U)
 #define GptConf_GptChannelConfiguration_GptChannelConfiguration_7 (6U)
 #define GptConf_GptChannelConfiguration_GptChannelConfiguration_8 (7U)
 #define GptConf_GptChannelConfiguration_GptChannelConfiguration_9 (8U)
 #define GptConf_GptChannelConfiguration_GptChannelConfiguration_10 (9U)
 #define GptConf_GptChannelConfiguration_GptChannelConfiguration_11 (10U)
 #define GptConf_GptChannelConfiguration_GptChannelConfiguration_12 (11U)
 #define GptConf_GptChannelConfiguration_GptChannelConfiguration_13 (12U)
 #define GptConf_GptChannelConfiguration_GptChannelConfiguration_14 (13U)
 #define GptConf_GptChannelConfiguration_GptChannelConfiguration_15 (14U)
 #define GptConf_GptChannelConfiguration_GptChannelConfiguration_0 (15U)

/** \brief Counter ID for counter used to count wait ticks */
#define GPT_OS_COUNTER_ID               ((CounterType)1U)

/**
 *  \brief GPT timeout.
 *   Each tick is 31.25us (for 32K Counter). Wait for 5s which comes to
 *   below value
 */
#define GPT_TIMEOUT_DURATION            (32000U)

#define SOC_RTI1_REG_BASE       (0x52180000U)
#define SOC_RTI2_REG_BASE       (0x52181000U)
#define SOC_RTI3_REG_BASE       (0x52182000U)
#define SOC_RTI4_REG_BASE       (0x52183000U)

/*********************************************************************************************************************
 *  Exported Object Declarations
 *********************************************************************************************************************/
extern const uint32 Gpt_RTIChannelAddr[GPT_RTI_MODULES];
 
 
extern const struct Gpt_ConfigType_s Gpt_ChannelConfigSet_0;


/* ========================================================================== */
/*                          Function Declarations                             */
/* ========================================================================== */

/* None */

#ifdef __cplusplus
}
#endif

#endif  /* #ifndef GPT_CFG_H_ */

/* @} */

