/* ======================================================================
 *   Copyright (C) 2022-2023 Texas Instruments Incorporated
 *
 *   All rights reserved. Property of Texas Instruments Incorporated.
 *   Restricted rights to use, duplicate or disclose this code are
 *   granted through contract.
 *
 *   The program may not be used without the written permission
 *   of Texas Instruments Incorporated or against the terms and conditions
 *   stipulated in the agreement under which this program has been
 *   supplied.
 * ==================================================================== */

/**
 *  \file     Mcu_Cfg.h
 *
 *  \brief    This file contains generated pre compile configuration file
 *            for MCU MCAL driver
 *
 */

/**
 *  \defgroup MCAL_MCU_CFG MCU Configuration
 *
 *  This files defines MCU MCAL configuration structures
 *  @{
 */

 /*********************************************************************************************************************
    Project: am263mcal10
	Date   : 2024-12-27 16:47:51

    This file is generated by EB Tresos
    Do not modify this file, otherwise the software may behave in unexpected way.

 *********************************************************************************************************************/
 /* Protection against multiple inclusion */
#ifndef MCU_CFG_H
#define MCU_CFG_H

/*********************************************************************************************************************
 * Standard Header Files
 *********************************************************************************************************************/

/*********************************************************************************************************************
 * Other Header Files
 *********************************************************************************************************************/
#ifdef __cplusplus
extern "C" {
#endif

/**********************************************************************************************************************
 * Version Check
 *********************************************************************************************************************/
/** \brief MCU Config ID */
#define MCU_CFG_ID                      (0x1U)

/* Requirements: SWS_Mcu_00129 */
/**
 *  \name Mcu Driver Configuration SW Version Info
 *
 *  Defines for Mcu Driver configuration version
 *  @{
 */
/** \brief Mcu configuration Major Version */
#define MCU_CFG_MAJOR_VERSION           (10U)
/** \brief Mcu configuration Minor Version */
#define MCU_CFG_MINOR_VERSION           (0U)
/** \brief Mcu configuration Patch Version */
#define MCU_CFG_PATCH_VERSION           (0U)
/* @} */


/*********************************************************************************************************************
 * Exported enums
 *********************************************************************************************************************/
/**
* \brief  Type of McuModes supported
*/
enum
{
   MCU_MODE_NORMAL = 1 /*!< Mcu normal mode. Only supported mode */
};

/*********************************************************************************************************************
 * Exported Preprocessor #define Constants
 *********************************************************************************************************************/
 
/**
 *  \name Pre-Compile Switches for API Services
 *  @{
 */

/** \brief Enable/Disable Development Error Detection */
#define MCU_DEV_ERROR_DETECT       (STD_ON)
/** \brief Enable/Disable Mcu_CheckRamState() API */
#define MCU_GET_RAM_STATE_API      (STD_ON)
/** \brief Enable/Disable Mcu_InitClock() API */
#define MCU_INIT_CLOCK_API         (STD_ON)
/** \brief Enable/Disable Mcu_PerformReset() API */
#define MCU_PERFORM_RESET_API      (STD_ON)
/** \brief Enable/Disable Mcu_GetVersionInfo() API */
#define MCU_GET_VERSION_INFO_API   (STD_ON)
/** \brief Enable/Disable Mcu_InitRamSection() API */
#define MCU_INIT_RAM_API           (STD_ON)
/** \brief Enable/Disable PLL support */
#define MCU_NO_PLL                 (STD_OFF)
/** \brief Enable/Disable Mcu_ClearResetReason() API */
#define MCU_REGISTER_READBACK_API (STD_ON)
/** \brief Enable/Disable MCU Interrupt Crossbar */
#define MCU_INTRCROSSBAR_ENABLE      (STD_ON)
/** \brief Enable/Disable MCU Input Crossbar */
#define MCU_INPUT_CROSSBAR_ENABLE      (STD_ON)
/** \brief Enable/Disable MCU PWM Enable */
#define MCU_PWM_ENABLE (STD_OFF)
/** \brief Enable/Disable MCU ADC Enable */
#define MCU_ADC_ENABLE (STD_OFF)
/* @} */

/**
* \name Reset Reason Config
* @{
*/
/*<MCU_CFG_RESETREASONUSERCONFIG_LIST>*/

#define McuConf_McuResetReasonConf_MCU_POWER_ON_RESET (1U)


#define McuConf_McuResetReasonConf_MCU_WARM_RESET_WDT0 (2U)


#define McuConf_McuResetReasonConf_MCU_WARM_RESET_WDT1 (3U)


#define McuConf_McuResetReasonConf_MCU_WARM_RESET_WDT2 (4U)


#define McuConf_McuResetReasonConf_MCU_WARM_RESET_WDT3 (5U)


#define McuConf_McuResetReasonConf_MCU_WARM_RESET (6U)


#define McuConf_McuResetReasonConf_MCU_EXT_PAD_RESET (7U)


#define McuConf_McuResetReasonConf_MCU_HSM_WDT_RESET (8U)


#define McuConf_McuResetReasonConf_MCU_DEBUGGER_RESET (9U)


#define McuConf_McuResetReasonConf_MCU_WARM_RESET_TEMP0 (10U)


#define McuConf_McuResetReasonConf_MCU_WARM_RESET_TEMP1 (11U)


#define McuConf_McuResetReasonConf_MCU_RESET_UNDEFINED (12U)


/* @} */


/*
 * The following defines shall be used as input
 * parameter for: Mcu_SetMode(),
 *                Mcu_InitClock()
 *                Mcu_InitRamSection()
 */

/*<MCU_CFG_MODEUSERCONFIG_LIST>*/


#define McuConf_McuModeSettingConf_McuModeSettingConf_0 MCU_MODE_NORMAL


/**
 *  \name Build variant for modules
 *  @{
 */
#define MCU_VARIANT_PRE_COMPILE       (STD_OFF)

#define MCU_VARIANT_POST_BUILD        (STD_ON)


/* @} */

/**
* \name Clock configuration
*@{
*/
/* SourceId : MCU_SourceId_040 */
/*<MCU_CFG_CLOCKUSERCONFIG_LIST>*/
#define McuConf_McuClockSettingConfig_McuClockSettingConfig_QSPI (0U)
#define McuConf_McuClockSettingConfig_McuClockSettingConfig_MCAN0 (1U)
#define McuConf_McuClockSettingConfig_McuClockSettingConfig_MCAN1 (2U)
#define McuConf_McuClockSettingConfig_McuClockSettingConfig_MCAN2 (3U)
#define McuConf_McuClockSettingConfig_McuClockSettingConfig_MCAN3 (4U)
#define McuConf_McuClockSettingConfig_McuClockSettingConfig_RTI0 (5U)
#define McuConf_McuClockSettingConfig_McuClockSettingConfig_RTI1 (6U)
#define McuConf_McuClockSettingConfig_McuClockSettingConfig_RTI2 (7U)
#define McuConf_McuClockSettingConfig_McuClockSettingConfig_RTI3 (8U)
#define McuConf_McuClockSettingConfig_McuClockSettingConfig_MCSPI0 (9U)
#define McuConf_McuClockSettingConfig_McuClockSettingConfig_MCSPI1 (10U)
#define McuConf_McuClockSettingConfig_McuClockSettingConfig_MCSPI2 (11U)
#define McuConf_McuClockSettingConfig_McuClockSettingConfig_MCSPI3 (12U)
#define McuConf_McuClockSettingConfig_McuClockSettingConfig_MCSPI4 (13U)
#define McuConf_McuClockSettingConfig_McuClockSettingConfig_I2C (14U)
#define McuConf_McuClockSettingConfig_McuClockSettingConfig_SCI0 (15U)
#define McuConf_McuClockSettingConfig_McuClockSettingConfig_SCI1 (16U)
#define McuConf_McuClockSettingConfig_McuClockSettingConfig_SCI2 (17U)
#define McuConf_McuClockSettingConfig_McuClockSettingConfig_SCI3 (18U)
#define McuConf_McuClockSettingConfig_McuClockSettingConfig_SCI4 (19U)
#define McuConf_McuClockSettingConfig_McuClockSettingConfig_SCI5 (20U)
#define McuConf_McuClockSettingConfig_McuClockSettingConfig_CPTS (21U)
#define McuConf_McuClockSettingConfig_McuClockSettingConfig_RGMI_CLK (22U)
#define McuConf_McuClockSettingConfig_McuClockSettingConfig_MII100_CLK (23U)
#define McuConf_McuClockSettingConfig_McuClockSettingConfig_MII10_CLK (24U)
#define McuConf_McuClockSettingConfig_McuClockSettingConfig_WDT0 (25U)
#define McuConf_McuClockSettingConfig_McuClockSettingConfig_WDT1 (26U)
#define McuConf_McuClockSettingConfig_McuClockSettingConfig_WDT2 (27U)
#define McuConf_McuClockSettingConfig_McuClockSettingConfig_WDT3 (28U)
#define McuConf_McuClockSettingConfig_McuClockSettingConfig_FSI (29U)

/* @} */
/*</MCU_CFG_CLOCKUSERCONFIG_LIST>*/

/*
   PLL Clock Configuration for AM263x
*/
#define McuCoreDPLLClockout             2000000000U
#define McuCoreDPLLClockout_HSDIV0      400000000U
#define McuCoreDPLLClockout_HSDIV1      500000000U
#define McuCoreDPLLClockout_HSDIV2      400000000U


#define McuPerDPLLClockout              1920000000U
#define McuPerDPLLClockout_HSDIV0       160000000U
#define McuPerDPLLClockout_HSDIV1       192000000U

/*PLL configuration number*/
#define MCU_PLL_CONFIG           (1U)

/*
* RAM Section configuration
*/
/*<MCU_CFG_RAMSECTIONUSERCONFIG_LIST>*/
#define McuRamSectorSettingConf_0 (0U)

/*</MCU_CFG_RAMSECTIONUSERCONFIG_LIST>*/


/** \brief Counter ID for counter used to count wait ticks */
#define MCU_OS_COUNTER_ID               ((CounterType)1U)

/**
*  \name MCU timeout.
*   Each tick is 31.25us (for 32K Counter). Wait for 5s which comes to
*   below value
* @{
*/
#define MCU_TIMEOUT_DURATION            (32000U)

/** \brief MCU PLL timeout.*/
#define MCU_PLL_TIMEOUT_DURATION            (13200U)
/* @} */
/*
*Design: MCAL-14296, MCAL-14294, MCAL-14291
*/
/**
 *  \name MCU DEM Error Codes
 * @{
 */



/* @} */
/* MCU Clock Config Size */
#define MCU_CLOCK_CONFIG (30U)

/* MCU CDD PWM Channel */
#define MCU_NUM_OF_CDD_PWM_CHANNELS (0U)

/* MCU CDD PWM Channel */
#define MCU_NUM_OF_ASR_PWM_CHANNELS (0U)

/* MCU PWM Channel */
#define MCU_PWM_CHANNEL (0U)

/* MCU ADC Channel */
#define MCU_ADC_HWUNIT (1U)

/*********************************************************************************************************************
 * Exported Type Declarations
 *********************************************************************************************************************/
 
/* Design: MCAL-14429, MCAL-14424 */
/**
 *  \brief  This is the type of the reset enumerator containing the subset of
 *  reset types. <br>
 *  It is not required that all reset types are supported by hardware
 *
 */
typedef enum
{

    MCU_RESET_CLEAR,               /*!< Reset Reason Cleared */
    MCU_POWER_ON_RESET,            /*!< POR Reset */
    MCU_WARM_RESET_WDT0,           /*!< Warm Reset due to MSS_WDT0 */
	MCU_WARM_RESET_WDT1,           /*!< Warm Reset due to MSS_WDT1 */
	MCU_WARM_RESET_WDT2,           /*!< Warm Reset due to MSS_WDT2 */
	MCU_WARM_RESET_WDT3,           /*!< Warm Reset due to MSS_WDT3 */
    MCU_WARM_RESET,                /*!< Warm Reset due to TOPRCM WARM_RESET_CONFIG */
    MCU_EXT_PAD_RESET,             /*!< External Pad Reset */
    MCU_HSM_WDT_RESET,             /*!< Warm Reset due to HSM WDT */
	MCU_DEBUGGER_RESET,            /*!< Warm Reset due to Debugger reset */
	MCU_WARM_RESET_TEMP0,          /*!< Warm Reset due to Temprature sensor 0 */
	MCU_WARM_RESET_TEMP1,          /*!< Warm Reset due to Temprature sensor 1 */
    MCU_RESET_UNDEFINED            /*!< UNDEFINED  reset */
} Mcu_ResetType;


/**
 *  \enum Mcu_ClkModuleIdType
 *  \brief Clock source config modules id enum
 *
 *  Clock source config ids defines are used to set clock source for specific
 *  modules
 */
typedef enum
{
    MCU_CLKSRC_MODULE_ID_SYSCLK,            /* System Clock, clock select is ignored */
    MCU_CLKSRC_MODULE_ID_MCAN0,             /* MSS MCAN0 clock */
    MCU_CLKSRC_MODULE_ID_MCAN1,             /* MSS MCAN1 clock */
	MCU_CLKSRC_MODULE_ID_MCAN2,             /* MSS MCAN2 clock */
	MCU_CLKSRC_MODULE_ID_MCAN3,             /* MSS MCAN3 clock */
    MCU_CLKSRC_MODULE_ID_RTI0,              /* MSS RTIA clock */
    MCU_CLKSRC_MODULE_ID_RTI1,              /* MSS RTIB clock */
    MCU_CLKSRC_MODULE_ID_RTI2,              /* MSS RTIC clock */
	MCU_CLKSRC_MODULE_ID_RTI3,              /* MSS RTIC clock */
    MCU_CLKSRC_MODULE_ID_WDT0,               /* MSS WDT clock */
	MCU_CLKSRC_MODULE_ID_WDT1,               /* MSS WDT clock */
	MCU_CLKSRC_MODULE_ID_WDT2,               /* MSS WDT clock */
	MCU_CLKSRC_MODULE_ID_WDT3,               /* MSS WDT clock */
    MCU_CLKSRC_MODULE_ID_QSPI,              /* MSS QSPI clock */
    MCU_CLKSRC_MODULE_ID_MCSPI0,              /* MSS SPIA clock */
	MCU_CLKSRC_MODULE_ID_MCSPI1,              /* MSS SPIA clock */
	MCU_CLKSRC_MODULE_ID_MCSPI2,              /* MSS SPIA clock */
	MCU_CLKSRC_MODULE_ID_MCSPI3,              /* MSS SPIA clock */
	MCU_CLKSRC_MODULE_ID_MCSPI4,              /* MSS SPIA clock */
    MCU_CLKSRC_MODULE_ID_SPIB,              /* MSS SPIB clock */
    MCU_CLKSRC_MODULE_ID_I2C,               /* MSS I2C clock */
    MCU_CLKSRC_MODULE_ID_SCI0,              /* MSS SCIA clock */
    MCU_CLKSRC_MODULE_ID_SCI1,              /* MSS SCIB clock */
	MCU_CLKSRC_MODULE_ID_SCI2,              /* MSS SCIB clock */
	MCU_CLKSRC_MODULE_ID_SCI3,              /* MSS SCIB clock */
	MCU_CLKSRC_MODULE_ID_SCI4,              /* MSS SCIB clock */
	MCU_CLKSRC_MODULE_ID_SCI5,              /* MSS SCIB clock */
    MCU_CLKSRC_MODULE_ID_CPSW,              /* MSS CPSW clock */
    MCU_CLKSRC_MODULE_ID_CPTS,              /* MSS CPTS clock */
    MCU_CLKSRC_MODULE_ID_MCU_CLKOUT0,        /* MSS MCU CLKOUT0 clock */
    MCU_CLKSRC_MODULE_ID_MCU_CLKOUT1,        /* MSS MCU CLKOUT1 clock */
    MCU_CLKSRC_MODULE_ID_PMIC_CLKOUT,       /* MSS PMIC CLKOUT clock */
    MCU_CLKSRC_MODULE_ID_MII100_CLK,        /* MSS MII 100 CLK clock */
    MCU_CLKSRC_MODULE_ID_MII10_CLK,         /* MSS MII 10 CLK clock */    
    MCU_CLKSRC_MODULE_ID_RGMI_CLK,          /* MSS RGMI CLK clock */
	MCU_CLKSRC_MODULE_ID_CONTROLSS_CLK,     /* MSS CONTROLSS CLK clock */
    MCU_CLKSRC_MODULE_ID_MAX
} Mcu_ClkModuleIdType;

/**
 * \brief  This is the type of the clock source in clock tree that is selectable
 *         for  peripheral. Please see TRM to map clock source to module.
 */
typedef enum
{
    MCU_CLKSRC_0 = 0,
    MCU_CLKSRC_1,
    MCU_CLKSRC_2,
    MCU_CLKSRC_3,
    MCU_CLKSRC_4,
    MCU_CLKSRC_5,
    MCU_CLKSRC_6,
    MCU_CLKSRC_7,
    MCU_CLKSRC_MAX
}Mcu_ClkSourceIdType;

/* Requirements: SWS_Mcu_00030 */
/**
 *  \brief Structure for data pre-setting to be initialized
 */
typedef struct
{
    P2VAR(uint8, AUTOMATIC, MCU_RAM_COPY) Mcu_RamSectionBaseAddress;
    /**< RAM section base address, Destination */
    uint8  Mcu_RamDefaultValue;
    /**< RAM Default Value */
    uint32 Mcu_RamSectionBytes;
    /**< Section Size */
} Mcu_RamSectionConfigType;

/* Requirements: SWS_Mcu_00031 */
/**
 *  \brief Structure for module clock setting
 */
typedef struct
{
    Mcu_ClkModuleIdType Mcu_ClockModuleId;
    /**< ModuleId for which clock setting to be applied */
    Mcu_ClkSourceIdType Mcu_ClockSourceId;
    /**< Clock source Id for the module */
    uint32              Mcu_ClockDiv;
    /**< Clock divider value for the module  */
    boolean             Mcu_InitCfg;
    /**< Apply this configuration at Mcu_init time*/
} Mcu_ClockConfigType;

/**
 *  \brief Type for PLL source selection
 */
typedef enum
{
    MCU_CLKSRC_DPLL = 0,
    MCU_CLKSRC_APLL
} Mcu_PllSourceIdType;


/**
 * \brief Structure for enumerating the clock outputs of HSDIVIDER
 */
typedef struct
{
    uint16  N;
    uint16  M2;
    uint16  FracM;
    uint16  sdDiv;
    uint64  MCU_PLL_CLKOUT;
    uint64  MCU_PLL_HSDIV0;
    uint64  MCU_PLL_HSDIV1;
    uint64  MCU_PLL_HSDIV2;
    
} Mcu_PllClkDivType;

/**
 *  \brief MCU PLL CONFIG structure
 */
typedef struct
{
    Mcu_PllClkDivType Mcu_PllClk1;
    Mcu_PllClkDivType Mcu_PllClk2;
   
} Mcu_PllConfigType;

/**
 * @brief HS Divider Clock Out Mux Clock Sources
 */
typedef enum
{
    DPLL_CORE_HSDIV0_CLKOUT2_PreMux = 0x0,
    DPLL_PER_HSDIV0_CLKOUT1_PreMux = 0x0,
    APLL_1p2G_HSDIV0_CLKOUT0 = 0x1,
    APLL_1p2G_HSDIV0_CLKOUT1 = 0x1,
    APLL_1p2G_HSDIV0_CLKOUT2 = 0x1,
    APLL_1p2G_HSDIV0_CLKOUT3 = 0x1,
    APLL_1p8G_HSDIV0_CLKOUT0 = 0x2,
    APLL_1p8G_HSDIV0_CLKOUT1 = 0x2,
    APLL_400MHZ = 0x3
} Mcu_HSDIVClkOutMuxClockSource;

/**
 *  \brief Pointer to PLL Config structure
 */
typedef P2CONST (Mcu_PllConfigType, AUTOMATIC, MCU_PBCFG)
Mcu_PllConfigPtrType;


/**
 *  \brief Structure for PWM clock configuration
 */
typedef struct
{
    uint8 Mcu_PwmChannelId;
    /**< Channel id of PWM */
    uint8 Mcu_PwmGroupId;
    /**< Group id of PWM */
} Mcu_PwmConfigType;

/**
 *  \brief Structure for ADC Buffer configuration
 */
typedef struct
{
    uint8 Mcu_AdcHWUniId;
    /**< HW id of ADC */
} Mcu_AdcConfigType;

/**
 *  \brief Structure for PRCM configuration
 */
typedef struct
{
    uint8 Mcu_RcmModuleId;
    /**< Moudle Id to enable/disable */
    uint8 Mcu_RcmModuleMode;
    /**< Moudle mode to set @sa MCAL_MCU_API:RCM modules mode defines */
} Mcu_RCMConfigType;

/**
 *  \brief Pointer to RamConfig structure
 */
typedef P2CONST (Mcu_RamSectionConfigType, AUTOMATIC, MCU_PBCFG)
Mcu_RamConfigPtrType;

/**
   \brief Pointer to PrcmConfig structure
*
*/
typedef P2CONST (Mcu_RCMConfigType, AUTOMATIC, MCU_PBCFG)
Mcu_RCMConfigPtrType;

/**
 *  \brief Pointer to Clock Config structure
 */
typedef P2CONST (Mcu_ClockConfigType, AUTOMATIC, MCU_PBCFG)
Mcu_ClockConfigPtrType;

/**
 *  \brief Pointer to PWM Clock Config structure
 */
typedef P2CONST (Mcu_PwmConfigType, AUTOMATIC, MCU_PBCFG)
Mcu_PwmConfigPtrType;

/**
 *  \brief Pointer to ADC buffer Config structure
 */
typedef P2CONST (Mcu_AdcConfigType, AUTOMATIC, MCU_PBCFG)
Mcu_AdcConfigPtrType;

/**
 *  \brief MCU CONFIG Register READBACK structure
 */
typedef struct
{
    uint32 CLKSRCSEL0;
}Mcu_RegisterReadbackType;

/* Design: MCAL-14430, MCAL-15238, MCAL-14431, MCAL-14432 */
/**
 *  \brief MCU CONFIG ROOT structure
 */
typedef struct Mcu_ConfigType_s
{
    uint8                    Mcu_ResetMode;
    /**< Reset mode to be used @sa  MCAL_MCU_API:ResetModes */
    /* Requirements: SWS_Mcu_00030 */
    Mcu_RamConfigPtrType     Mcu_ConfigRamSection;
    /**< Configration of Ram Sections */
    uint8                    Mcu_NumberOfRamSectors;
    /**< Number of entries in Mcu_ConfigRamSection */
    /* Requirements: SWS_Mcu_00031, SWS_Mcu_00019 */
    Mcu_ClockConfigPtrType   Mcu_ClockConfig;
    /**< Configuration of Module functional clock source */
    uint8                    Mcu_NumberOfClockConfig;
	#if (STD_OFF == MCU_NO_PLL)
    /**< Number of entries in Mcu_ClockConfig */
    Mcu_PllConfigPtrType     Mcu_PllConfig;
    /**< PLL Configuration */
    Mcu_PllSourceIdType      Mcu_PllSourceId;
    /**< PLL source selection */
	#endif
	#if (STD_ON == MCU_PWM_ENABLE)
	Mcu_PwmConfigPtrType     Mcu_Pwmconfig;
	/**< PWM Configuration */
	#endif
	#if (STD_ON == MCU_ADC_ENABLE)
	Mcu_AdcConfigPtrType     Mcu_AdcConfig;
	/**< ADC Configuration */
	#endif
} Mcu_ConfigType;


/** @brief Number of ETPWM instances */
#define MCU_CSL_ETPWM_PER_CNT                (32U)

/*Control MMRs partition*/
#define MCU_TOP_CTRL_PARTITION0                                (2U)
#define MCU_CONTROLSS_CTRL_PARTITION0                          (3U)
/*Clock and reset MMRs partition*/
#define MCU_TOP_RCM_PARTITION0                                 (5U)

#define MCU_CSL_CONTROLSS_CTRL_EPWM_STATICXBAR_SEL0                          (0x00000004U)

#define MCU_CSL_TOP_RCM_U_BASE                                                   (0x53200000UL)
#define MCU_CSL_TOP_CTRL_U_BASE                                              (0x50D80000UL)
#define MCU_CSL_CONTROLSS_CTRL_U_BASE                                        (0x502F0000UL)
#define MCU_CSL_CONTROLSS_CTRL_LOCK0_KICK0                                   (0x00001008U)
#define MCU_CSL_CONTROLSS_CTRL_LOCK0_KICK1                                   (0x0000100CU)

#define MCU_CSL_CONTROLSS_CTRL_EPWM_CLKSYNC                                  (0x00000010U)

/* EPWM_CLKSYNC */
#define MCU_CSL_CONTROLSS_CTRL_EPWM_CLKSYNC_BIT_MASK                         (0xFFFFFFFFU)

#define MCU_CSL_TOP_CTRL_LOCK0_KICK0                                          (0x00001008U)
#define MCU_CSL_TOP_CTRL_LOCK0_KICK1                                          (0x0000100CU)
#define MCU_CSL_TOP_RCM_LOCK0_KICK0                                           (0x00001008U)
#define MCU_CSL_TOP_RCM_LOCK0_KICK1                                           (0x0000100CU)

/* define the unlock and lock values for MSS_CTRL, TOP_CTRL, MSS_RCM, TOP_RCM*/
#define MCU_TEST_KICK_LOCK_VAL                           (0x00000000U)
#define MCU_TEST_KICK0_UNLOCK_VAL                        (0x01234567U)
#define MCU_TEST_KICK1_UNLOCK_VAL                        (0x0FEDCBA8U)

/* EPWM_CHANNELS */
#define MCU_PWM_CHANNEL_0   0U
#define MCU_PWM_CHANNEL_1   1U
#define MCU_PWM_CHANNEL_2   2U
#define MCU_PWM_CHANNEL_3   3U
#define MCU_PWM_CHANNEL_4   4U
#define MCU_PWM_CHANNEL_5   5U
#define MCU_PWM_CHANNEL_6   6U
#define MCU_PWM_CHANNEL_7   7U
#define MCU_PWM_CHANNEL_8   8U
#define MCU_PWM_CHANNEL_9   9U
#define MCU_PWM_CHANNEL_10 10U
#define MCU_PWM_CHANNEL_11 11U
#define MCU_PWM_CHANNEL_12 12U
#define MCU_PWM_CHANNEL_13 13U
#define MCU_PWM_CHANNEL_14 14U
#define MCU_PWM_CHANNEL_15 15U
#define MCU_PWM_CHANNEL_16 16U
#define MCU_PWM_CHANNEL_17 17U
#define MCU_PWM_CHANNEL_18 18U
#define MCU_PWM_CHANNEL_19 19U
#define MCU_PWM_CHANNEL_20 20U
#define MCU_PWM_CHANNEL_21 21U
#define MCU_PWM_CHANNEL_22 22U
#define MCU_PWM_CHANNEL_23 23U
#define MCU_PWM_CHANNEL_24 24U
#define MCU_PWM_CHANNEL_25 25U
#define MCU_PWM_CHANNEL_26 26U
#define MCU_PWM_CHANNEL_27 27U
#define MCU_PWM_CHANNEL_28 28U
#define MCU_PWM_CHANNEL_29 29U
#define MCU_PWM_CHANNEL_30 30U
#define MCU_PWM_CHANNEL_31 31U

/* EPWM_GROUPS */
#define MCU_PWM_CONTROLSS_G0   0U
#define MCU_PWM_CONTROLSS_G1   1U
#define MCU_PWM_CONTROLSS_G2   2U
#define MCU_PWM_CONTROLSS_G3   3U

/* ADC_GROUPS */
#define MCU_ADC_HWUNIT_0   0U
#define MCU_ADC_HWUNIT_1   1U
#define MCU_ADC_HWUNIT_2   2U
#define MCU_ADC_HWUNIT_3   3U
#define MCU_ADC_HWUNIT_4   4U

/* ADC BUFFER CONTROL */
#define MCU_CSL_TOP_CTRL_ADC_REFBUF0_CTRL                                     (0x00000C00U)
#define MCU_CSL_TOP_CTRL_ADC_REFBUF1_CTRL                                     (0x00000C04U)
		 
#define MCU_CSL_TOP_CTRL_ADC_REF_COMP_CTRL                                    (0x00000C08U)
	
void Mcu_IntXbar(void);
void Mcu_InputXbar(void);
void Mcu_GpioXbarConfig(void);

/*********************************************************************************************************************
 *  Exported Object Declarations
 *********************************************************************************************************************/

/** \brief MCU Configuration struct declaration */
extern const struct Mcu_ConfigType_s McuModuleConfiguration;



#ifdef __cplusplus
}
#endif

#endif /* #ifndef MCU_CFG_H */
/**********************************************************************************************************************
 *  End of File: Mcu_Cfg.h
 *********************************************************************************************************************/
