/* ======================================================================
 *   Copyright (C) 2022-2023 Texas Instruments Incorporated
 *
 *   All rights reserved. Property of Texas Instruments Incorporated.
 *   Restricted rights to use, duplicate or disclose this code are
 *   granted through contract.
 *
 *   The program may not be used without the written permission
 *   of Texas Instruments Incorporated or against the terms and conditions
 *   stipulated in the agreement under which this program has been
 *   supplied.
 * ==================================================================== */

/**
 *  \file     Port_Cfg.h
 *
 *  \brief    This file contains generated pre compile configuration file
 *            for PORT MCAL driver
 *
 */

/**
 *  \defgroup MCAL_PORT_CFG PORT Configuration
 *
 *  This files defines PORT MCAL configuration structures
 *  @{
 */

/**********************************************************************************************************************
    Project: am263mcal10
    Date   : 2024-12-27 16:47:51

    This file is generated by EB Tresos
    Do not modify this file, otherwise the software may behave in unexpected way.

 *********************************************************************************************************************/
#ifndef PORT_CFG_H
#define PORT_CFG_H

/**********************************************************************************************************************
 * INCLUDES
 *********************************************************************************************************************/
#include "Std_Types.h"


#ifdef __cplusplus
extern "C" {
#endif

/**********************************************************************************************************************
 *  GLOBAL CONSTANT MACROS
 *********************************************************************************************************************/
/** \brief PORT Config ID */
#define PORT_CFG_ID                      (0x1U)

/**
 *  \name Port Driver Configuration SW Version Info
 *
 *  Defines for Port Driver configuration version
 *  @{
 */
/** \brief Port configuration Major Version */
#define PORT_CFG_MAJOR_VERSION           (10U)
/** \brief Port configuration Minor Version */
#define PORT_CFG_MINOR_VERSION           (0U)
/** \brief Port configuration Patch Version */
#define PORT_CFG_PATCH_VERSION           (0U)
/* @} */

/**
*  \brief PORT Build Variant.
*   Build variants.(i.e Pre Compile,Post Build)
*/
#define PORT_PRE_COMPILE_VARIANT   (STD_OFF)

#define PORT_POST_BUILD_VARIANT    (STD_ON)



/*
*Design: MCAL-14021,MCAL-14036, MCAL-13988
*/
/* List of symbolic names for Dio pin channels */
/*<PORT_PIN_CHANNEL_LIST>*/


#define PortConf_PortPin_PortPin_0 				(41U)

#define PortConf_PortPin_PortPin_1 				(24U)

#define PortConf_PortPin_PortPin_2 				(6U)

#define PortConf_PortPin_PortPin_3 				(14U)

#define PortConf_PortPin_PortPin_4 				(13U)

#define PortConf_PortPin_PortPin_5 				(2U)

#define PortConf_PortPin_PortPin_6 				(37U)

#define PortConf_PortPin_PortPin_7 				(36U)

#define PortConf_PortPin_PortPin_8 				(19U)

#define PortConf_PortPin_PortPin_9 				(126U)

#define PortConf_PortPin_PortPin_10 				(122U)

#define PortConf_PortPin_PortPin_11 				(127U)

#define PortConf_PortPin_PortPin_12 				(121U)

#define PortConf_PortPin_PortPin_13 				(134U)

#define PortConf_PortPin_PortPin_14 				(128U)

#define PortConf_PortPin_PortPin_15 				(102U)

#define PortConf_PortPin_PortPin_16 				(103U)

#define PortConf_PortPin_PortPin_17 				(95U)

#define PortConf_PortPin_PortPin_18 				(94U)

#define PortConf_PortPin_PortPin_19 				(101U)

#define PortConf_PortPin_PortPin_20 				(100U)

#define PortConf_PortPin_PortPin_21 				(116U)

#define PortConf_PortPin_PortPin_22 				(115U)

#define PortConf_PortPin_PortPin_23 				(90U)

#define PortConf_PortPin_PortPin_24 				(89U)

#define PortConf_PortPin_PortPin_25 				(108U)

#define PortConf_PortPin_PortPin_26 				(91U)

#define PortConf_PortPin_PortPin_27 				(117U)

#define PortConf_PortPin_PortPin_28 				(123U)

#define PortConf_PortPin_PortPin_29 				(142U)

#define PortConf_PortPin_PortPin_30 				(140U)

#define PortConf_PortPin_PortPin_31 				(143U)

#define PortConf_PortPin_PortPin_32 				(141U)

#define PortConf_PortPin_PortPin_33 				(137U)

#define PortConf_PortPin_PortPin_34 				(136U)

#define PortConf_PortPin_PortPin_35 				(130U)

#define PortConf_PortPin_PortPin_36 				(131U)

#define PortConf_PortPin_PortPin_37 				(132U)

#define PortConf_PortPin_PortPin_38 				(124U)

#define PortConf_PortPin_PortPin_39 				(118U)

#define PortConf_PortPin_PortPin_40 				(125U)

#define PortConf_PortPin_PortPin_41 				(4U)

#define PortConf_PortPin_PortPin_42 				(21U)

#define PortConf_PortPin_PortPin_43 				(49U)

#define PortConf_PortPin_PortPin_44 				(32U)

#define PortConf_PortPin_PortPin_45 				(114U)

#define PortConf_PortPin_PortPin_46 				(107U)

#define PortConf_PortPin_PortPin_47 				(111U)

#define PortConf_PortPin_PortPin_48 				(99U)

#define PortConf_PortPin_PortPin_49 				(80U)

#define PortConf_PortPin_PortPin_50 				(55U)

#define PortConf_PortPin_PortPin_51 				(113U)

#define PortConf_PortPin_PortPin_52 				(138U)

#define PortConf_PortPin_PortPin_53 				(3U)

#define PortConf_PortPin_PortPin_54 				(20U)

#define PortConf_PortPin_PortPin_55 				(1U)

#define PortConf_PortPin_PortPin_56 				(51U)

#define PortConf_PortPin_PortPin_57 				(18U)

#define PortConf_PortPin_PortPin_58 				(64U)

#define PortConf_PortPin_PortPin_59 				(34U)

#define PortConf_PortPin_PortPin_60 				(16U)

#define PortConf_PortPin_PortPin_61 				(33U)

#define PortConf_PortPin_PortPin_62 				(15U)

#define PortConf_PortPin_PortPin_63 				(22U)

#define PortConf_PortPin_PortPin_64 				(5U)

#define PortConf_PortPin_PortPin_65 				(104U)

#define PortConf_PortPin_PortPin_66 				(38U)

#define PortConf_PortPin_PortPin_67 				(53U)

#define PortConf_PortPin_PortPin_68 				(12U)

#define PortConf_PortPin_PortPin_69 				(48U)

#define PortConf_PortPin_PortPin_70 				(31U)

#define PortConf_PortPin_PortPin_71 				(11U)

#define PortConf_PortPin_PortPin_72 				(87U)

#define PortConf_PortPin_PortPin_73 				(98U)

#define PortConf_PortPin_PortPin_74 				(144U)

#define PortConf_PortPin_PortPin_75 				(105U)

#define PortConf_PortPin_PortPin_76 				(106U)

#define PortConf_PortPin_PortPin_77 				(96U)

#define PortConf_PortPin_PortPin_78 				(112U)

#define PortConf_PortPin_PortPin_79 				(120U)

#define PortConf_PortPin_PortPin_80 				(88U)

#define PortConf_PortPin_PortPin_81 				(97U)

#define PortConf_PortPin_PortPin_82 				(30U)

#define PortConf_PortPin_PortPin_83 				(10U)

#define PortConf_PortPin_PortPin_84 				(54U)

#define PortConf_PortPin_PortPin_85 				(7U)

#define PortConf_PortPin_PortPin_86 				(135U)

#define PortConf_PortPin_PortPin_87 				(129U)

#define PortConf_PortPin_PortPin_88 				(65U)

#define PortConf_PortPin_PortPin_89 				(78U)

#define PortConf_PortPin_PortPin_90 				(79U)

#define PortConf_PortPin_PortPin_91 				(82U)

#define PortConf_PortPin_PortPin_92 				(67U)

#define PortConf_PortPin_PortPin_93 				(68U)

#define PortConf_PortPin_PortPin_94 				(25U)

#define PortConf_PortPin_PortPin_95 				(57U)

#define PortConf_PortPin_PortPin_96 				(43U)

#define PortConf_PortPin_PortPin_97 				(71U)

#define PortConf_PortPin_PortPin_98 				(77U)

#define PortConf_PortPin_PortPin_99 				(85U)

#define PortConf_PortPin_PortPin_100 				(66U)

#define PortConf_PortPin_PortPin_102 				(74U)

#define PortConf_PortPin_PortPin_101 				(76U)

#define PortConf_PortPin_PortPin_103 				(42U)

#define PortConf_PortPin_PortPin_104 				(8U)

#define PortConf_PortPin_PortPin_105 				(26U)

#define PortConf_PortPin_PortPin_106 				(27U)

#define PortConf_PortPin_PortPin_107 				(17U)

#define PortConf_PortPin_PortPin_108 				(61U)

#define PortConf_PortPin_PortPin_109 				(60U)

#define PortConf_PortPin_PortPin_110 				(45U)

#define PortConf_PortPin_PortPin_111 				(35U)

#define PortConf_PortPin_PortPin_112 				(69U)

#define PortConf_PortPin_PortPin_113 				(70U)

#define PortConf_PortPin_PortPin_114 				(86U)

#define PortConf_PortPin_PortPin_115 				(92U)

#define PortConf_PortPin_PortPin_116 				(109U)

#define PortConf_PortPin_PortPin_117 				(110U)

#define PortConf_PortPin_PortPin_118 				(83U)

#define PortConf_PortPin_PortPin_119 				(75U)

#define PortConf_PortPin_PortPin_120 				(84U)

#define PortConf_PortPin_PortPin_121 				(81U)

#define PortConf_PortPin_PortPin_122 				(73U)

#define PortConf_PortPin_PortPin_123 				(44U)

#define PortConf_PortPin_PortPin_124 				(58U)

#define PortConf_PortPin_PortPin_125 				(59U)

#define PortConf_PortPin_PortPin_126 				(52U)


/*</PORT_PIN_CHANNEL_LIST>*/

/* List of symbolic names for Dio interrupt configuration - PortDioConfig */
#define PortConf_PortDioPin_PortDioConfig_0 		(0U)

/**
 *  \name Port Driver Maximum number of configured pins.
 */
#define PORT_MAX_PIN_CONFIG					127U

/**
 *  \name Port Driver Maximum Dio Interrupts configured.
 */
#define PORT_MAX_GPIO_INTR_CONFIG			1U


/**
 *  \name Port Driver Maximum number of modes per pin
 *
 *  Maximum number of runtime changeable port pin modes per pin
 *  This value is calculated based on actual configuration and is
 *  not the maximum number of modes supported by SoC (16)
 *  @{
 */
#define PORT_MAX_MUXMODE (2U)
/* @} */	

/** \brief Interrupt Error ID */
#define PORT_INTR_ERROR_ID 			255U

/** \Max GPIO Pins (Range -> 0 to 138)*/
#define PORT_MAX_GPIO_PINS          139U

/** \Max GPIO Banks (Range -> Bank0[A] to Bank8[I])*/
#define PORT_MAX_GPIO_BANKS         9U

/** \Number of channels each bank */
#define PORT_CHANNELS_PER_BANK      16U

/** \brief Interrupt Status Buffer Size */
#define PORT_INTR_BUF_SIZE  		160U

/** \brief bank interrupt suffix - used to access bank idx */
#define PORT_GPIO_BANK_SUFFIX		150U

/** \brief Interrupt SubRoutine type */
#define PORT_ISR_TYPE     			PORT_ISR_CAT1

/**
 *  \name Service enable/diable defines
 *
 *  Pre-compile switches for enabling/disabling PORT MCAL APIs
 *  @{
 */
/** \brief Enable/Disable Port_SetPinDirection() */
#define PORT_SET_PIN_DIRECTION_API       (STD_ON) 
/** \brief Enable/Disable Port_RefreshPinDirection() */
#define PORT_REFRESH_PORT_DIRECTION_API  (STD_ON) 
/** \brief Enable/Disable Port_GetVersionInfo() */
#define PORT_VERSION_INFO_API            (STD_ON) 
/** \brief Enable/Disable Port_SetPinMode() */
#define PORT_SET_PIN_MODE_API            (STD_ON) 
/** \brief Enable/Disable development error detection */
#define PORT_DEV_ERROR_DETECT            (STD_ON) 
/** \brief Enable/Disable SAFETI Configuration register readback */
#define PORT_SAFETI_API                      (STD_OFF) 
/** \brief enable/disable the use of Interrupt Functionality */
#define PORT_ENABLE_INTR_API             (STD_ON) 
/** \brief enable/disable the use of Port_GetInterruptStatus API */
#define PORT_GET_INTR_ST_API             (STD_ON) 
/** \brief enable/disable the use of Port_ClearInterruptStatus API */
#define PORT_CLR_INTR_ST_API             (STD_ON) 
/** \brief GPIO Ownership for R5F Cores */

#define PORT_GPIO_BASE     0x52000000U
#define PORT_GPIO_R5F_SEL  0x0U

/* @} */


/**********************************************************************************************************************
 *  STATIC TESTS
 *********************************************************************************************************************/


/** \brief Counter ID for counter used to count wait ticks */
#define PORT_OS_COUNTER_ID               ((CounterType)0U)

/**
*  \brief PORT timeout.
*   Each tick is 31.25us (for 32K Counter). Wait for 5s which comes to
*   below value
*/
#define PORT_TIMEOUT_DURATION            (32000U)

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/*
*Design: MCAL-13973, MCAL-14024, MCAL-13989
*/
/**
 *  \brief Enum of Port Direction used in Port_SetPinDirection()
 */
typedef enum
{
    PORT_PIN_OUT,
    /**< PORT_PIN_OUT */
    PORT_PIN_IN,
    /**< PORT_PIN_IN */
    PORT_PIN_DEFAULT
    /**< PORT_PIN_DEFAULT */
} Port_PinDirectionType;

/**
 *  \brief Enum of Port Level
 */
typedef enum
{
    PORT_PIN_LEVEL_LOW,
    PORT_PIN_LEVEL_HIGH,
} Port_PinLevelValueType;

/**
 *  \brief Enum of Port Slew Control
 */
typedef enum
{
    PORT_PIN_SLEWCONTROL_FAST_SLEW,
    PORT_PIN_SLEWCONTROL_SLOW_SLEW,
    PORT_PIN_SLEWCONTROL_DEFAULT,
} Port_PinSlewControlType;

/**
 *  \brief Enum of Port Pin Output override selection
 */
typedef enum
{
    PORT_PIN_DISABLE_OUTPUT_OVERRIDE,
    PORT_PIN_ENABLE_OUTPUT_OVERRIDE,
    PORT_PIN_OUTPUT_RETAIN_HW_CTRL
} Port_PinOutputOverrideCtrl;

/**
 *  \brief Enum of Port Pin Input override selection
 */
typedef enum
{
    PORT_PIN_DISABLE_INPUT_OVERRIDE,
    PORT_PIN_ENABLE_INPUT_OVERRIDE,
    PORT_PIN_INPUT_RETAIN_HW_CTRL
} Port_PinInputOverrideCtrl;
/**
 *  \brief Enum of Port Pin Up/Down Type selection
 */
typedef enum
{
    PORT_PIN_PULLTYPE_PULLDOWN,
    PORT_PIN_PULLTYPE_PULLUP,
    PORT_PIN_PULLTYPE_DEFAULT
} Port_PinPullSelectType;


/**
 *  \brief Enum of Port Pin pull inihibit selection
 */
typedef enum
{
    PORT_PIN_PULL_INHIBIT_ENABLE,
    PORT_PIN_PULL_INHIBIT_DISABLE,
    PORT_PIN_PULL_INHIBIT_DEFAULT

} Port_PinPullInhibitEnableType;

/**
 *  \brief Enum of Port input inversion
 */
typedef enum
{
    PORT_NONINV,
    PORT_INV,
    PORT_INVTYPE_DEFAULT
} Port_InputInversion;

/**
 *  \brief Enum of Port input qualifier type select
 */
typedef enum
{
    PORT_SYNC_QUAL,
    PORT_THREE_SAMPLE_QUAL,
    PORT_SIX_SAMPLE_QUAL,
    PORT_ASYNC_QUAL,
    PORT_QUALTYPE_DEFAULT
} Port_InputQualType;

/** \brief Type for symbolic name of Port pins */
typedef uint16 Port_PinType;


/*
*Design: MCAL-14019, MCAL-13996, MCAL-14037, MCAL-14043
*/
/**
 *  \brief Enum of Port Pin Mode selection
 */
typedef enum
{
    PORT_PIN_MODE_GPIOAB,
    /**< Set Pin for  GPIO Port AB mode */

    PORT_PIN_MODE_GPIOCD,
    /**< Set Pin for GPIO Port CD mode */

    PORT_PIN_MODE_GPIOEF,
    /**< Set Pin for  GPIO Port EF mode */

    PORT_PIN_MODE_GPIOGH,
    /**< Set Pin for GPIO Port GH mode */

    PORT_PIN_MODE_GPIOI,
    /**< Set Pin for GPIO mode */

    PORT_PIN_MODE_MCAN0,
    /**< Set Pin for MCAN0 (CAN FD) mode */
    PORT_PIN_MODE_MCAN1,
    /**< Set Pin for MCAN1 (CAN FD) mode */
    PORT_PIN_MODE_MCAN2,
    /**< Set Pin for MCAN2(CAN FD) mode */
    PORT_PIN_MODE_MCAN3,
    /**< Set Pin for MCAN3(CAN FD) mode */

    PORT_PIN_MODE_SPI0,
    /**< Set Pin for MIBSPI0 mode */
    PORT_PIN_MODE_SPI1,
    /**< Set Pin for MIBSPI1 mode */
    PORT_PIN_MODE_SPI2,
    /**< Set Pin for MIBSPI2 mode */
    PORT_PIN_MODE_SPI3,
    /**< Set Pin for MIBSPI3 mode */
    PORT_PIN_MODE_SPI4,
    /**< Set Pin for MIBSPI4 mode */

    PORT_PIN_MODE_QSPI0,
    /**< Set Pin for QSPI mode */
    PORT_PIN_MODE_JTAG,
    /**< Set Pin for JTAG mode */
    PORT_PIN_MODE_TRACE,
    /**< Set Pin for TRACE mode */

    PORT_PIN_MODE_I2C0,
    /**< Set Pin for I2C0 mode */
    PORT_PIN_MODE_I2C1,
    /**< Set Pin for I2C1 mode */
    PORT_PIN_MODE_I2C2,
    /**< Set Pin for I2C2 mode */
    PORT_PIN_MODE_I2C3,
    /**< Set Pin for I2C3 mode */

    PORT_PIN_MODE_MII,
    /**< Set Pin for MII mode */
    PORT_PIN_MODE_RMII1,
    /**< Set Pin for RMII1 mode */
    PORT_PIN_MODE_RMII2,
    /**< Set Pin for RMII2 mode */

    PORT_PIN_MODE_RGMII1,
    /**< Set Pin for RGMII1 mode */
    PORT_PIN_MODE_RGMII2,
    /**< Set Pin for RGMII2 mode */

    PORT_PIN_MODE_MDIO0,
    /**< Set Pin for MDIO mode */
    PORT_PIN_MODE_CPTS0,
    /**< Set Pin for CPTS0 mode */
    PORT_PIN_MODE_UART0,
    /**< Set Pin for UART0 modes */
    PORT_PIN_MODE_UART1,
    /**< Set Pin for UART1 modes */
    PORT_PIN_MODE_UART2,
    /**< Set Pin for UART2 modes */
    PORT_PIN_MODE_UART3,
    /**< Set Pin for UART3 modes */
    PORT_PIN_MODE_UART4,
    /**< Set Pin for UART3 modes */
    PORT_PIN_MODE_UART5,
    /**< Set Pin for UART5 modes */
    PORT_PIN_MODE_ECAP0,
    /**< Set Pin for ECAP0 mode */
    PORT_PIN_MODE_PR0_UART0,
    /**< Set Pin for UART0 mode */
    PORT_PIN_MODE_LIN0,
    /**< Set Pin for LON0 mode */
    PORT_PIN_MODE_LIN1,
    /**< Set Pin for LIN1 mode */
    PORT_PIN_MODE_LIN2,
    /**< Set Pin for LIN2 mode */
    PORT_PIN_MODE_LIN3,
    /**< Set Pin for LIN3 mode */
    PORT_PIN_MODE_LIN4,
    /**< Set Pin for LIN mode */
    PORT_PIN_MODE_EPWM0,
    /**< Set Pin for EPWM0 mode */
    PORT_PIN_MODE_EPWM1,
    /**< Set Pin for EPWM1 mode */
    PORT_PIN_MODE_EPWM2,
    /**< Set Pin for EPWM2 mode */
    PORT_PIN_MODE_EPWM3,
    /**< Set Pin for EPWM3A mode */
    PORT_PIN_MODE_EPWM4,
     /**< Set Pin for EPWM1A mode */
    PORT_PIN_MODE_EPWM5,
     /**< Set Pin for EPWM5A mode */
    PORT_PIN_MODE_EPWM6,
     /**< Set Pin for EPWM6A mode */
    PORT_PIN_MODE_EPWM7,
     /**< Set Pin for EPWM7A mode */
    PORT_PIN_MODE_EPWM8,
     /**< Set Pin for EPWM8A mode */
    PORT_PIN_MODE_EPWM9,
     /**< Set Pin for EPWM9A mode */
    PORT_PIN_MODE_EPWM10,
     /**< Set Pin for EPWM510. mode */
    PORT_PIN_MODE_EPWM11,
     /**< Set Pin for EPWM11A mode */
    PORT_PIN_MODE_EPWM12,
     /**< Set Pin for EPWM12A mode */
    PORT_PIN_MODE_EPWM13,
     /**< Set Pin for EPWM13A mode */
    PORT_PIN_MODE_EPWM14,
     /**< Set Pin for EPWM14A mode */
    PORT_PIN_MODE_EPWM15,
     /**< Set Pin for EPWM15A mode */
    PORT_PIN_MODE_EPWM16,
     /**< Set Pin for EPWM16A mode */
    PORT_PIN_MODE_EPWM17,
     /**< Set Pin for EPWM17A mode */
    PORT_PIN_MODE_EPWM18,
     /**< Set Pin for EPWM18A mode */
    PORT_PIN_MODE_EPWM19,
     /**< Set Pin for EPWM19A mode */
    PORT_PIN_MODE_EPWM20,
     /**< Set Pin for EPWM20A mode */
    PORT_PIN_MODE_EPWM21,
     /**< Set Pin for EPWM21A mode */
    PORT_PIN_MODE_EPWM22,
     /**< Set Pin for EPW22A mode */
    PORT_PIN_MODE_EPWM23,
     /**< Set Pin for EPWM23A mode */
    PORT_PIN_MODE_EPWM24,
     /**< Set Pin for EPWM24A mode */
    PORT_PIN_MODE_EPWM25,
     /**< Set Pin for EPWM25A mode */
    PORT_PIN_MODE_EPWM26,
     /**< Set Pin for EPWM26A mode */
    PORT_PIN_MODE_EPWM27,
     /**< Set Pin for EPWM27A mode */
    PORT_PIN_MODE_EPWM28,
     /**< Set Pin for EPWM28A mode */
    PORT_PIN_MODE_EPWM29,
     /**< Set Pin for EPWM29A mode */
    PORT_PIN_MODE_EPWM30,
     /**< Set Pin for EPWM30A mode */
    PORT_PIN_MODE_EPWM31,
     /**< Set Pin for EPWM31A mode */
    PORT_PIN_MODE_XBAROUT,
    /**< Set Pin for XBAR mode */
    PORT_PIN_MODE_PRU0_GIO,
    /**< Set Pin for PRU0 mode */
    PORT_PIN_MODE_PRU1_GIO,
    /**< Set Pin for PRU0 mode */
    PORT_PIN_MODE_TRC,
    /**< Set Pin for TRC */
    PORT_PIN_MODE_SDFM0,
    /**< Set Pin for SDFM0 */
    PORT_PIN_MODE_SDFM1,
    /**< Set Pin for SDFM1 */
    PORT_PIN_MODE_MMC0,
    /**< Set Pin for MMC0 */
    PORT_PIN_MODE_FSIRX0,
    /**< Set Pin for FSIRX0 */
    PORT_PIN_MODE_FSIRX1,
    /**< Set Pin for FSIRX1 */
    PORT_PIN_MODE_FSIRX2,
    /**< Set Pin for FSIRX2 */
    PORT_PIN_MODE_FSIRX3,
    /**< Set Pin for FSIRX3 */
    PORT_PIN_MODE_FSITX0,
    /**< Set Pin for FSITX0 */
    PORT_PIN_MODE_FSITX1,
    /**< Set Pin for FSITX1 */
    PORT_PIN_MODE_FSITX2,
    /**< Set Pin for FSITX2 */
    PORT_PIN_MODE_FSITX3,
    /**< Set Pin for FSITX3 */
    PORT_PIN_MODE_EQEP0,
    /**< Set Pin for EQEP0 */
    PORT_PIN_MODE_EQEP1,
    /**< Set Pin for EQEP1 */
    PORT_PIN_MODE_EQEP2,
    /**< Set Pin for EQEP2 */
    PORT_PIN_MODE_PR0_IEP0,
    /**< Set Pin for PR0_IEP0 */
    PORT_PIN_MODE_GPMC0,
    /**< Set Pin for GPMC0 */
    PORT_PIN_MODE_CLKOUT,
    /**< Set Pin for CLKOUT */
    PORT_PIN_MODE_EXT_REFCLK,
    /**< Set Pin for EXT_REFCLK */
    PORT_PIN_MODE_PR0_MDIO0,
    /**< Set Pin for PR0_MDIO0 */
    PORT_PIN_MODE_INVALID,
    /**< Invalid pin mode. For internal use */
} Port_PinModeType;

/**
 *  \brief GPIO Bank Details
 *
 */
typedef enum
{
	PORT_GPIO_BANK_0 = 0,  	/* Bank A */
	PORT_GPIO_BANK_1 = 1,	/* Bank B */
	PORT_GPIO_BANK_2 = 2,	/* Bank C */
	PORT_GPIO_BANK_3 = 3,	/* Bank D */
	PORT_GPIO_BANK_4 = 4,	/* Bank E */
	PORT_GPIO_BANK_5 = 5,	/* Bank F */
	PORT_GPIO_BANK_6 = 6,	/* Bank G */
	PORT_GPIO_BANK_7 = 7,	/* Bank H */
	PORT_GPIO_BANK_8 = 8,	/* Bank I */	
}Port_GpioBank;

/**
 *  \brief GPIO channels details
 *
 */
typedef enum
{
    PORT_GPIO_CH_0 = 0,		/* Bank A */
    PORT_GPIO_CH_1 = 1,
    PORT_GPIO_CH_2 = 2,
    PORT_GPIO_CH_3 = 3,
    PORT_GPIO_CH_4 = 4,
    PORT_GPIO_CH_5 = 5,
    PORT_GPIO_CH_6 = 6,
    PORT_GPIO_CH_7 = 7,
    PORT_GPIO_CH_8 = 8,
    PORT_GPIO_CH_9 = 9,
    PORT_GPIO_CH_10 = 10,
    PORT_GPIO_CH_11 = 11,
    PORT_GPIO_CH_12 = 12,
    PORT_GPIO_CH_13 = 13,
    PORT_GPIO_CH_14 = 14,
    PORT_GPIO_CH_15 = 15,
    PORT_GPIO_CH_16 = 16,	/* Bank B */
    PORT_GPIO_CH_17 = 17,
    PORT_GPIO_CH_18 = 18,
    PORT_GPIO_CH_19 = 19,
    PORT_GPIO_CH_20 = 20,
    PORT_GPIO_CH_21 = 21,
    PORT_GPIO_CH_22 = 22,
    PORT_GPIO_CH_23 = 23,
    PORT_GPIO_CH_24 = 24,
    PORT_GPIO_CH_25 = 25,
    PORT_GPIO_CH_26 = 26,
    PORT_GPIO_CH_27 = 27,
    PORT_GPIO_CH_28 = 28,
    PORT_GPIO_CH_29 = 29,
    PORT_GPIO_CH_30 = 30,
    PORT_GPIO_CH_31 = 31,
    PORT_GPIO_CH_32 = 32,	/* Bank C */
    PORT_GPIO_CH_33 = 33,
    PORT_GPIO_CH_34 = 34,
    PORT_GPIO_CH_35 = 35,
    PORT_GPIO_CH_36 = 36,
    PORT_GPIO_CH_37 = 37,
    PORT_GPIO_CH_38 = 38,
    PORT_GPIO_CH_39 = 39,
    PORT_GPIO_CH_40 = 40,
    PORT_GPIO_CH_41 = 41,
    PORT_GPIO_CH_42 = 42,
    PORT_GPIO_CH_43 = 43,
    PORT_GPIO_CH_44 = 44,
    PORT_GPIO_CH_45 = 45,
    PORT_GPIO_CH_46 = 46,
    PORT_GPIO_CH_47 = 47,
    PORT_GPIO_CH_48 = 48,	/* Bank D */
    PORT_GPIO_CH_49 = 49,
    PORT_GPIO_CH_50 = 50,
    PORT_GPIO_CH_51 = 51,
    PORT_GPIO_CH_52 = 52,
    PORT_GPIO_CH_53 = 53,
    PORT_GPIO_CH_54 = 54,
    PORT_GPIO_CH_55 = 55,
    PORT_GPIO_CH_56 = 56,
    PORT_GPIO_CH_57 = 57,
    PORT_GPIO_CH_58 = 58,
    PORT_GPIO_CH_59 = 59,
    PORT_GPIO_CH_60 = 60,
    PORT_GPIO_CH_61 = 61,
    PORT_GPIO_CH_62 = 62,
    PORT_GPIO_CH_63 = 63,		
    PORT_GPIO_CH_64 = 64,	/* Bank E */
    PORT_GPIO_CH_65 = 65,
    PORT_GPIO_CH_66 = 66,
    PORT_GPIO_CH_67 = 67,
    PORT_GPIO_CH_68 = 68,
    PORT_GPIO_CH_69 = 69,
    PORT_GPIO_CH_70 = 70,
    PORT_GPIO_CH_71 = 71,
    PORT_GPIO_CH_72 = 72,
    PORT_GPIO_CH_73 = 73,
    PORT_GPIO_CH_74 = 74,
    PORT_GPIO_CH_75 = 75,
    PORT_GPIO_CH_76 = 76,
    PORT_GPIO_CH_77 = 77,
    PORT_GPIO_CH_78 = 78,
    PORT_GPIO_CH_79 = 79,
    PORT_GPIO_CH_80 = 80,	/* Bank F */
    PORT_GPIO_CH_81 = 81,
    PORT_GPIO_CH_82 = 82,
    PORT_GPIO_CH_83 = 83,
    PORT_GPIO_CH_84 = 84,
    PORT_GPIO_CH_85 = 85,
    PORT_GPIO_CH_86 = 86,
    PORT_GPIO_CH_87 = 87,
    PORT_GPIO_CH_88 = 88,
    PORT_GPIO_CH_89 = 89,
    PORT_GPIO_CH_90 = 90,
    PORT_GPIO_CH_91 = 91,
    PORT_GPIO_CH_92 = 92,
    PORT_GPIO_CH_93 = 93,
    PORT_GPIO_CH_94 = 94,
    PORT_GPIO_CH_95 = 95,
    PORT_GPIO_CH_96 = 96,	/* Bank G */
    PORT_GPIO_CH_97 = 97,
    PORT_GPIO_CH_98 = 98,
    PORT_GPIO_CH_99 = 99,
    PORT_GPIO_CH_100 = 100,		
    PORT_GPIO_CH_101 = 101,
    PORT_GPIO_CH_102 = 102,
    PORT_GPIO_CH_103 = 103,
    PORT_GPIO_CH_104 = 104,
    PORT_GPIO_CH_105 = 105,
    PORT_GPIO_CH_106 = 106,
    PORT_GPIO_CH_107 = 107,
    PORT_GPIO_CH_108 = 108,
    PORT_GPIO_CH_109 = 109,
    PORT_GPIO_CH_110 = 110,
    PORT_GPIO_CH_111 = 111,
    PORT_GPIO_CH_112 = 112,	/* Bank H */
    PORT_GPIO_CH_113 = 113,
    PORT_GPIO_CH_114 = 114,
    PORT_GPIO_CH_115 = 115,
    PORT_GPIO_CH_116 = 116,
    PORT_GPIO_CH_117 = 117,
    PORT_GPIO_CH_118 = 118,
    PORT_GPIO_CH_119 = 119,
    PORT_GPIO_CH_120 = 120,
    PORT_GPIO_CH_121 = 121,
    PORT_GPIO_CH_122 = 122,
    PORT_GPIO_CH_123 = 123,
    PORT_GPIO_CH_124 = 124,
    PORT_GPIO_CH_125 = 125,
    PORT_GPIO_CH_126 = 126,
    PORT_GPIO_CH_127 = 127,
    PORT_GPIO_CH_128 = 128,	/* Bank I */
    PORT_GPIO_CH_129 = 129,
    PORT_GPIO_CH_130 = 130,
    PORT_GPIO_CH_131 = 131,
    PORT_GPIO_CH_132 = 132,
    PORT_GPIO_CH_133 = 133,
    PORT_GPIO_CH_134 = 134,
    PORT_GPIO_CH_135 = 135,
    PORT_GPIO_CH_136 = 136,
    PORT_GPIO_CH_137 = 137,
    PORT_GPIO_CH_138 = 138,	
}Port_GpioChannel;

/**
 *  \brief GPIO Pin Edge trigger intruppt selection 
 */
typedef enum
{
	PORT_FALLING_EDGE = 0,
    PORT_RISING_EDGE,
    PORT_BOTH_EDGE,
} Port_EdgeTrig;

/**
 *  \brief GPIO Interrupt Type
 */
typedef enum
{
	PORT_CHANNEL_INTR = 0,
	PORT_BANK_INTR,
} Port_IntrType;

/**
 *  \brief  Notification callback function pointer 
 *
 *  PortBankNum --> GPIO bank numbers[A(0) to I(8)] , If configured as bank interrupt else value PORT_INTR_ERROR_ID
 *
 *  PortBankChNum --> GPIO Channel numbers[0 to 138] , If configured as channel interrupt else value PORT_INTR_ERROR_ID
 */
typedef void (*Port_IsrNotificationType)(uint8 PortBankNum, uint8 PortBankChNum, Port_EdgeTrig Edge);

/**
 *  \brief GPIO Pin Intruppt Registers Status
 */
typedef struct
{
    volatile uint8 IntrIdxNum[ PORT_INTR_BUF_SIZE ];
	
} Port_IntrStatus;

/**
 *  \brief Pin Mode map structure
 *
 *  Structure to map selected mode to corresponding PAD CONFIG MUXMODE value
 */
typedef struct
{
    Port_PinModeType mode;
    /**< Selected pin mode */
    uint32          muxmode;
    /**< Function Select/Muxmode for selected pin mode */
} Port_PinModeConfigType;

/**
 *  \brief Pin Configuration structure
 */
typedef struct
{
    Port_PinType             Port_PinId;
    /**< Port Pin Id */
    boolean                  Port_DirectionChangeable;
    /**< Flag indicating if pin direction is changeable */
    boolean                  Port_PinModeChangeable;
    /**< Flag indicating if Pin mode is changeable */
    Port_PinLevelValueType   Port_PinLevelValue;
    /**< Pin level value */
    Port_PinDirectionType    Port_PinDirection;
    /**< Pin direction  @sa Port_PinDirectionType */
    uint32                   Port_NumPortModes;
    /**< Number of modes supported for this pin */
    Port_PinModeConfigType   Port_PinMode[PORT_MAX_MUXMODE];
    /**< Pin mode @sa Port_PinModeType */
    Port_PinModeType         Port_PinInitialMode;
    /**< Pin initial mode @sa Port_PinModeType */
    Port_PinPullSelectType   Port_PullTypeSelect;
    /**< Type of PULL U/D selection @sa Port_PinPullSelectType */
    Port_PinSlewControlType  Port_SlewControl;
    /**< Slew control configuration @sa Port_PinSlewControlType */
    Port_PinPullInhibitEnableType Port_PullInhibitEnable;
    /**< Pull inhibit control configuration @sa Port_PinPullInhibitEnableType*/
    Port_PinInputOverrideCtrl Port_InputOverride_Ctrl;
    /**< Active Low input override control*/
    Port_PinOutputOverrideCtrl Port_OutputOverride_Ctrl;
    /**< Active Low output override control*/
    uint32                   Port_RegOffsetAddr;
    /**< Register base address for configuring this pin */
    uint32                   Port_PinDioRegId;
    /**< GPIO register id corresponding to this pin */
    uint32                   Port_PinDioChannelId;
    /**< GPIO channel corresponding to this pin in GPIO register */
    const sint8             *Port_PinSignalName;
    /**< Pin signal name.Just for information. Not used internally.Can be NULL
    **/
    const sint8             *Port_PinName;

    /**< Pin name.Just for information. Not used internally.Can be NULL */

    boolean                 Port_PinHSmasterEnable;
    /** HSMASTER bit value **/

    boolean                 Port_PinHSmodeEnable;
    /** HSMODE bit value **/

    Port_InputInversion     Port_InversionSelect;
    /** select value for choosing inverted version of PAD input for chip**/

    Port_InputQualType      Port_QualifierTypeSelect;
    /** select value for choosing input qualifer type for PAD. **/
} Port_PinConfigType;


/**
 *  \brief Port GPIO initialization configuration
 */
typedef struct
{
	uint8 					   Port_DioPinNumber;
	/**< GPIO Pin number */
    Port_EdgeTrig			   Port_PinSelectEdgeTrigger;
	/**< GPIO Edge Trigger Interrupt (Rising/Falling) */
    Port_IntrType			   Port_PinSelectInterruptType;
	/**< Select GPIO Interrupt Type*/
    Port_IsrNotificationType   Port_DioInterruptNotification;
	/**< ISR callback function pointer*/
	
} Port_DioRegConfigType;


/*
*Design: MCAL-13969, MCAL-13974, MCAL-14011, MCAL-13983, MCAL-13999, MCAL-14042
*/
/**
 *  \brief PORT Module ROOT configuration
 */
typedef struct Port_ConfigType_s
{
    uint16 NumberOfPortPins;
    /**< Number of pins individually configure. Should not conflict with
     *   pins enabled by selecting module enable */
    P2CONST(Port_PinConfigType, AUTOMATIC, PORT_PBCFG) PinConfig_pt;
    /**< Pointer to pin configuration structure */
    uint32 NumberOfGPIORegs;
    /**< Number of GPIO registers to configure */
    P2CONST(Port_DioRegConfigType, AUTOMATIC, PORT_PBCFG) DioConfig_pt;
    /**< DIO config structure */

} Port_ConfigType;

/**
 *  \GPIO XBAR out pins mapping 
 *   Below macros stores inforamtion about xbarout Intr. pin configuration which is done in MCU Driver.
 *  @{
 */            
#define  PORT_GPIO_BANK_1_ACTIVE             /** PortDioConfig_0, VIM_MODULE0_0 R5F-Core-0 **/ 

/**********************************************************************************************************************
 *  GLOBAL DATA TYPES AND STRUCTURES
 *********************************************************************************************************************/

extern const struct Port_ConfigType_s PortConfigSet_0;


/**********************************************************************************************************************
 *  GLOBAL FUNCTION PROTOTYPES
 *********************************************************************************************************************/

#ifdef __cplusplus
}
#endif

#endif  /* PORT_CFG_H */


/**********************************************************************************************************************
 *  END OF FILE: Port_Cfg.h
 *********************************************************************************************************************/
