/* ======================================================================
*   Copyright (C) 2022-2023 Texas Instruments Incorporated
*
*   All rights reserved. Property of Texas Instruments Incorporated.
*   Restricted rights to use, duplicate or disclose this code are
*   granted through contract.
*
*   The program may not be used without the written permission
*   of Texas Instruments Incorporated or against the terms and conditions
*   stipulated in the agreement under which this program has been
*   supplied.
* ==================================================================== */
 /***************************************************************************
  Project: am263mcal10
  Date   : 2024-12-27 16:47:51

  This file is generated by EB Tresos
  Do not modify this file, otherwise the software may behave in unexpected way.

 *****************************************************************************/

/*
 * Module switch
 */
/**********************************************************************************************************************
 *  INCLUDES
 *********************************************************************************************************************/
 #include "Can.h"
 #include "Can_Cfg.h"

/**********************************************************************************************************************
 *  VERSION CHECK
 *********************************************************************************************************************/

/** \brief Can configuration Major Version */
#define CAN_CFG_C_MAJOR_VERSION           (10U)
/** \brief Can configuration Minor Version */
#define CAN_CFG_C_MINOR_VERSION           (0U)
/** \brief Can configuration Patch Version */
#define CAN_CFG_C_PATCH_VERSION           (0U)

/*  Version checking  */
 #if (   (CAN_SW_MAJOR_VERSION != (10U))||(CAN_SW_MINOR_VERSION != (0U)))
  #error "Version numbers of Can_Cfg.c and Can.h are inconsistent!"
#endif
#if (   (CAN_CFG_MAJOR_VERSION != (10U))||(CAN_CFG_MINOR_VERSION != (0U)))
  #error "Version numbers of Can_Cfg.c and Can_Cfg.h are inconsistent!"
#endif
/**********************************************************************************************************************
 *  GLOBAL DATA
 *********************************************************************************************************************/
#define CAN_START_SEC_CONFIG_DATA
#include "Can_MemMap.h"



/* Controller structure defined here for all config sets */


const struct Can_ControllerStruct_PC
    CanConfigSet_PC_CanController_0 =
{
    CanConf_CanController_CanController_0,      /* Id as provided by GUI */

    (boolean)TRUE,   /* Contoller is used=1 or not_used=0*/
    0x52600000U, /* Can Controller Base Address */
			(boolean)FALSE,    /* Automatic wakeup via bus activity */
    CAN_TX_RX_PROCESSING_INTERRUPT,  /* Can Rx Processing Type */
    CAN_TX_RX_PROCESSING_INTERRUPT,  /* Can Tx Processing Type */
    (boolean)TRUE,/* BusOff  TRUE = Interrupt FALSE = Polling */
	(boolean)FALSE,    /* TRUE = Interrupt FALSE = Polling */
	(boolean)TRUE,    /* Auto retransmission on Tx error Enable/Disable */
	NULL_PTR,
	    CAN_CONTROLLER_INSTANCE_MCAN0,  /* Controller Instance */
};



const struct Can_ControllerStruct_PC
    *CanConfigSet_CanController_List_PC[CAN_NUM_CONTROLLER]=
{
    &CanConfigSet_PC_CanController_0,
};



/* All the Mailbox objects(MB's) will be defined here for all config sets */
static const struct Can_MailboxStruct_PC
    CanConfigSet_PC_CanHardwareObject_0 =
{
    CanConf_CanHardwareObject_CanHardwareObject_0,  /* CanObjectId - Holds handle Id */
};
static const struct Can_MailboxStruct_PC
    CanConfigSet_PC_CanHardwareObject_8 =
{
    CanConf_CanHardwareObject_CanHardwareObject_8,  /* CanObjectId - Holds handle Id */
};


/* List of the Mailboxes */
const struct Can_MailboxStruct_PC
    *CanConfigSet_CanHardwareObject_List_PC[CAN_NUM_MAILBOXES] =
{
    &CanConfigSet_PC_CanHardwareObject_0,
    &CanConfigSet_PC_CanHardwareObject_8,
};


#define  CAN_STOP_SEC_CONFIG_DATA
#include "Can_MemMap.h"

/*******************************************************************************
 *  End of File: Can_Cfg.c
 ******************************************************************************/
