/* ======================================================================
*   Copyright (C) 2022-2023 Texas Instruments Incorporated
*
*   All rights reserved. Property of Texas Instruments Incorporated.
*   Restricted rights to use, duplicate or disclose this code are
*   granted through contract.
*
*   The program may not be used without the written permission
*   of Texas Instruments Incorporated or against the terms and conditions
*   stipulated in the agreement under which this program has been
*   supplied.
* ==================================================================== */
 /***************************************************************************
  Project: am263mcal10
  Date   : 2024-12-27 16:47:51

  This file is generated by EB Tresos
  Do not modify this file, otherwise the software may behave in unexpected way.

 *****************************************************************************/

/*
 * Module switch
 */
#define CAN_PBCFG_SOURCE
/**********************************************************************************************************************
 *  INCLUDES
 *********************************************************************************************************************/
 #include "Can.h"
 #include "Can_Cfg.h"

/**********************************************************************************************************************
 *  VERSION CHECK
 *********************************************************************************************************************/

/** \brief Can configuration Major Version */
#define CAN_PBCFG_C_MAJOR_VERSION           (10U)
/** \brief Can configuration Minor Version */
#define CAN_PBCFG_C_MINOR_VERSION           (0U)
/** \brief Can configuration Patch Version */
#define CAN_PBCFG_C_PATCH_VERSION           (0U)

/*  Version checking  */
 #if (   (CAN_SW_MAJOR_VERSION != (10U))||(CAN_SW_MINOR_VERSION != (0U)))
  #error "Version numbers of Can_PBcfg.c and Can.h are inconsistent!"
#endif
#if (   (CAN_CFG_MAJOR_VERSION != (10U))||(CAN_CFG_MINOR_VERSION != (0U)))
  #error "Version numbers of Can_PBcfg.c and Can_Cfg.h are inconsistent!"
#endif
/**********************************************************************************************************************
 *  GLOBAL DATA
 *********************************************************************************************************************/
#define CAN_START_SEC_CONFIG_DATA
#include "Can_MemMap.h"




/* Baud Rate Structure for all configsets */
static Can_BaudConfigType
    CanConfigSet_CanController_0_CanControllerBaudrateConfig_0 =
{
    500U,      /* in Kbps */
    20U,       /* Prop Segement value */
    14U,          /* Phase Segment 1 */
    5U,          /* Phase Segment 2 */
    1U, /* Sync jump width */
    40U, /* Sum of all timing parameters */
    4U,   /* Controller BRP value for Baud */
	 /* Data phase Baudrate */
    {
        5000U,     /* in Kbps */
        3U,        /* Prop Segement value */
        3U,           /* Phase Segment 1 */
        1U,           /* Phase Segment 2 */
        1U,  /* Sync jump width */
        8U, /* Sum of all timing parameters */
        2U,   /* Controller BRP value for Baud */
        14U, /* Specifies the Transceiver Delay Compensation Offset */
        (boolean)TRUE, /* Specifies if the bit rate switching shall be used */
    }
};

/*List of the Baudrate structures */
static Can_BaudConfigType
    *CanConfigSet_CanController_0_BaudRateConfigList[]=
{
    &CanConfigSet_CanController_0_CanControllerBaudrateConfig_0,
};


/* Controller structure defined here for all config sets */
static Can_ControllerType
    CanConfigSet_CanController_0 =
{
    &CanConfigSet_CanController_0_CanControllerBaudrateConfig_0,  /* pointer to default Baud structure */
    CanConfigSet_CanController_0_BaudRateConfigList,  /* List of available Baudrate structs */
};

/*List of the Controller structures */
static Can_ControllerType
    *CanConfigSet_CanController_List[]=
{
    &CanConfigSet_CanController_0,
};


static Can_HwFilterType
    CanConfigSet_CanHardwareObject_8_CanHwFilter_0 =
{
    0U,  /*CanHwFilterCode*/
    0U,  /*Filter Mask*/
};

static Can_HwFilterType
    *CanConfigSet_CanHardwareObject_8_HwFilterConfigList[]=
{
    &CanConfigSet_CanHardwareObject_8_CanHwFilter_0,
};
/* All the Mailbox objects(MB's) will be defined here for all config sets */
                
static Can_MailboxType
    CanConfigSet_CanHardwareObject_0 =
{
    0U,  /*  CanHandleType 0=Full, 1=Basic */
    0U,  /* CanIdType 0=standard 1=Extended 2=Mixed*/
    0U,  /* HwHandle i.e Mailbox - Hw object in the controller */
    1U,   /* Length of the Mailbox */
    CAN_MAILBOX_DIRECTION_TX,  /* CanObjectType - Direction of Mailbox*/
    &CanConfigSet_PC_CanController_0,  /* Controller */
    NULL_PTR,  /* List of HW Filter structs */
    0U,   /* Hw Filter Count */
    204U,   /* Padding value for CAN FD message */
    (boolean)FALSE,   /* CanHardwareObjectUsesPolling */
    (boolean)FALSE,  /* CanTriggerTransmitEnable */
	};

static Can_MailboxType
    CanConfigSet_CanHardwareObject_8 =
{
    0U,  /*  CanHandleType 0=Full, 1=Basic */
    0U,  /* CanIdType 0=standard 1=Extended 2=Mixed*/
    0U,  /* HwHandle i.e Mailbox - Hw object in the controller */
    1U,   /* Length of the Mailbox */
    CAN_MAILBOX_DIRECTION_RX,  /* CanObjectType - Direction of Mailbox*/
    &CanConfigSet_PC_CanController_0,  /* Controller */
    CanConfigSet_CanHardwareObject_8_HwFilterConfigList,  /* List of HW Filter structs */
    1U, /* Hw Filter Count */
    204U,   /* Padding value for CAN FD message */
    (boolean)FALSE,   /* CanHardwareObjectUsesPolling */
	    (boolean)FALSE,   /* CanTriggerTransmitEnable */
};



/* List of the Mailboxes */
static Can_MailboxType
    *CanConfigSet_CanHardwareObject_List[] =
{
    &CanConfigSet_CanHardwareObject_0,
    &CanConfigSet_CanHardwareObject_8,
};

#define CAN_STOP_SEC_CONFIG_DATA
#include "Can_MemMap.h"

#define CAN_START_SEC_CONFIG_DATA
#include "Can_MemMap.h"

/*Can Config struct */
const struct Can_ConfigType_s CanConfigSet =
{
    CanConfigSet_CanController_List,    /* List of all controllers in this config set */
    (1U),    /* max Controllers */
    CanConfigSet_CanHardwareObject_List,
    (2U),    /* total number of mail boxes in this configset */
    .MaxBaudConfigID =
    {
        [0] = 0U
    }
};

#define  CAN_STOP_SEC_CONFIG_DATA
#include "Can_MemMap.h"
/*********************************************************************************************************************
 *  End of File: Can_PBcfg.c
 *********************************************************************************************************************/
