
/* ======================================================================
 *   Copyright (C) 2022 Texas Instruments Incorporated
 *
 *   All rights reserved. Property of Texas Instruments Incorporated.
 *   Restricted rights to use, duplicate or disclose this code are
 *   granted through contract.
 *
 *   The program may not be used without the written permission
 *   of Texas Instruments Incorporated or against the terms and conditions
 *   stipulated in the agreement under which this program has been
 *   supplied.
 * ==================================================================== */

/**
 *  \file     Gpt_PBcfg.c
 *
 *  \brief    This file contains generated post build configuration file
 *            for GPT MCAL driver
 *
 */

 /*********************************************************************************************************************
    Project: am263mcal10
    Date   : 2024-12-27 16:47:51
    10.0.0
    4.6.0
    AUTOSAR 4.3.1 0

    This file is generated by EB Tresos
    Do not modify this file, otherwise the software may behave in unexpected way.

 *********************************************************************************************************************/
#include "Std_Types.h"
#include "Gpt.h"

#define GPT_PBCFG_C_MAJOR_VERSION    (10U)
#define GPT_PBCFG_C_MINOR_VERSION    (0U)
#define GPT_PBCFG_C_PATCH_VERSION    (0U)

/* ---- Perform version checking  ----------------------------------------- */

#if ((GPT_SW_MAJOR_VERSION != (10U))||(GPT_SW_MINOR_VERSION != (0U)))
    #error "Version numbers of Gpt_PBcfg.c and Gpt.h are inconsistent!"
#endif

#if ((GPT_CFG_MAJOR_VERSION != (10U))||(GPT_CFG_MINOR_VERSION != (0U)))
  #error "Version numbers of Gpt_PBcfg.c and Gpt_Cfg.h are inconsistent!"
#endif


#define GPT_START_SEC_CONST_UNSPECIFIED
#include "Gpt_MemMap.h"


/*LDRA_INSPECTED 25 D : MISRAC_2012_R.8.9
 * "Reason - Global scope for the register base address" */
const uint32 Gpt_RTIChannelAddr[GPT_RTI_MODULES] =
{
    SOC_RTI1_REG_BASE,
    SOC_RTI2_REG_BASE,
    SOC_RTI3_REG_BASE,
	SOC_RTI4_REG_BASE
};

#define GPT_STOP_SEC_CONST_UNSPECIFIED
/*LDRA_INSPECTED 338 S : MISRAC_2012_R.20.1
 * "Reason - Required to comply with AUTOSAR memmap spec " */
#include "Gpt_MemMap.h"

#define GPT_START_SEC_CONFIG_DATA
/* MCAL: MISRAC_19.1
 * "Reason - This is the format to use for specifying memory sections." */
#include "Gpt_MemMap.h"

extern void Gpt_Channel_Notify5(void);
extern void Gpt_Channel_Notify6(void);
extern void Gpt_Channel_Notify7(void);
extern void Gpt_Channel_Notify8(void);
extern void Gpt_Channel_Notify9(void);
extern void Gpt_Channel_Notify10(void);
extern void Gpt_Channel_Notify11(void);
extern void Gpt_Channel_Notify12(void);
extern void Gpt_Channel_Notify13(void);
extern void Gpt_Channel_Notify14(void);
extern void Gpt_Channel_Notify15(void);
extern void Gpt_Channel_Notify16(void);

/* Gpt Channel Configuration parameters */
static CONST(Gpt_ChannelConfigType, GPT_PBCFG) Gpt_ChannelConfigSet_0_ChannelConfig[12] =
{
    [0] =
    {	
        .ChannelId = (GPT_RTI_CHANNEL5),
        .ChannelMode = (GPT_CH_MODE_CONTINUOUS),  /* Gpt Channel Mode */
        .CounterBlk = GPT_RTI_COUNTER0,
        .GptChannelTickFrequency = 1U,  /* Pre-scalar value to be set */
        .Notification_pt = Gpt_Channel_Notify5,  /* Notification Call Back function */
        .GptChannelClksrcRef = 200U  /* Gpt Clock derived from Mcu in MHz*/
    },
    [1] =
    {	
        .ChannelId = (GPT_RTI_CHANNEL6),
        .ChannelMode = (GPT_CH_MODE_CONTINUOUS),  /* Gpt Channel Mode */
        .CounterBlk = GPT_RTI_COUNTER0,
        .GptChannelTickFrequency = 1U,  /* Pre-scalar value to be set */
        .Notification_pt = Gpt_Channel_Notify6,  /* Notification Call Back function */
        .GptChannelClksrcRef = 200U  /* Gpt Clock derived from Mcu in MHz*/
    },
    [2] =
    {	
        .ChannelId = (GPT_RTI_CHANNEL7),
        .ChannelMode = (GPT_CH_MODE_ONESHOT),  /* Gpt Channel Mode */
        .CounterBlk = GPT_RTI_COUNTER1,
        .GptChannelTickFrequency = 1U,  /* Pre-scalar value to be set */
        .Notification_pt = Gpt_Channel_Notify7,  /* Notification Call Back function */
        .GptChannelClksrcRef = 200U  /* Gpt Clock derived from Mcu in MHz*/
    },
    [3] =
    {	
        .ChannelId = (GPT_RTI_CHANNEL8),
        .ChannelMode = (GPT_CH_MODE_ONESHOT),  /* Gpt Channel Mode */
        .CounterBlk = GPT_RTI_COUNTER1,
        .GptChannelTickFrequency = 1U,  /* Pre-scalar value to be set */
        .Notification_pt = Gpt_Channel_Notify8,  /* Notification Call Back function */
        .GptChannelClksrcRef = 200U  /* Gpt Clock derived from Mcu in MHz*/
    },
    [4] =
    {	
        .ChannelId = (GPT_RTI_CHANNEL9),
        .ChannelMode = (GPT_CH_MODE_CONTINUOUS),  /* Gpt Channel Mode */
        .CounterBlk = GPT_RTI_COUNTER0,
        .GptChannelTickFrequency = 1U,  /* Pre-scalar value to be set */
        .Notification_pt = Gpt_Channel_Notify9,  /* Notification Call Back function */
        .GptChannelClksrcRef = 200U  /* Gpt Clock derived from Mcu in MHz*/
    },
    [5] =
    {	
        .ChannelId = (GPT_RTI_CHANNEL10),
        .ChannelMode = (GPT_CH_MODE_ONESHOT),  /* Gpt Channel Mode */
        .CounterBlk = GPT_RTI_COUNTER0,
        .GptChannelTickFrequency = 1U,  /* Pre-scalar value to be set */
        .Notification_pt = Gpt_Channel_Notify10,  /* Notification Call Back function */
        .GptChannelClksrcRef = 200U  /* Gpt Clock derived from Mcu in MHz*/
    },
    [6] =
    {	
        .ChannelId = (GPT_RTI_CHANNEL11),
        .ChannelMode = (GPT_CH_MODE_ONESHOT),  /* Gpt Channel Mode */
        .CounterBlk = GPT_RTI_COUNTER1,
        .GptChannelTickFrequency = 1U,  /* Pre-scalar value to be set */
        .Notification_pt = Gpt_Channel_Notify11,  /* Notification Call Back function */
        .GptChannelClksrcRef = 200U  /* Gpt Clock derived from Mcu in MHz*/
    },
    [7] =
    {	
        .ChannelId = (GPT_RTI_CHANNEL12),
        .ChannelMode = (GPT_CH_MODE_CONTINUOUS),  /* Gpt Channel Mode */
        .CounterBlk = GPT_RTI_COUNTER1,
        .GptChannelTickFrequency = 1U,  /* Pre-scalar value to be set */
        .Notification_pt = Gpt_Channel_Notify12,  /* Notification Call Back function */
        .GptChannelClksrcRef = 200U  /* Gpt Clock derived from Mcu in MHz*/
    },
    [8] =
    {	
        .ChannelId = (GPT_RTI_CHANNEL13),
        .ChannelMode = (GPT_CH_MODE_CONTINUOUS),  /* Gpt Channel Mode */
        .CounterBlk = GPT_RTI_COUNTER0,
        .GptChannelTickFrequency = 1U,  /* Pre-scalar value to be set */
        .Notification_pt = Gpt_Channel_Notify13,  /* Notification Call Back function */
        .GptChannelClksrcRef = 200U  /* Gpt Clock derived from Mcu in MHz*/
    },
    [9] =
    {	
        .ChannelId = (GPT_RTI_CHANNEL14),
        .ChannelMode = (GPT_CH_MODE_ONESHOT),  /* Gpt Channel Mode */
        .CounterBlk = GPT_RTI_COUNTER0,
        .GptChannelTickFrequency = 1U,  /* Pre-scalar value to be set */
        .Notification_pt = Gpt_Channel_Notify14,  /* Notification Call Back function */
        .GptChannelClksrcRef = 200U  /* Gpt Clock derived from Mcu in MHz*/
    },
    [10] =
    {	
        .ChannelId = (GPT_RTI_CHANNEL15),
        .ChannelMode = (GPT_CH_MODE_ONESHOT),  /* Gpt Channel Mode */
        .CounterBlk = GPT_RTI_COUNTER1,
        .GptChannelTickFrequency = 1U,  /* Pre-scalar value to be set */
        .Notification_pt = Gpt_Channel_Notify15,  /* Notification Call Back function */
        .GptChannelClksrcRef = 200U  /* Gpt Clock derived from Mcu in MHz*/
    },
    [11] =
    {	
        .ChannelId = (GPT_RTI_CHANNEL16),
        .ChannelMode = (GPT_CH_MODE_CONTINUOUS),  /* Gpt Channel Mode */
        .CounterBlk = GPT_RTI_COUNTER1,
        .GptChannelTickFrequency = 1U,  /* Pre-scalar value to be set */
        .Notification_pt = Gpt_Channel_Notify16,  /* Notification Call Back function */
        .GptChannelClksrcRef = 200U  /* Gpt Clock derived from Mcu in MHz*/
    }
};

/*<GPT_CONFIGURATION>*/
CONST(Gpt_ConfigType, GPT_PBCFG) Gpt_ChannelConfigSet_0 =
{
    Gpt_ChannelConfigSet_0_ChannelConfig,/*Pointer to Channel Configuration*/
    12/*Number of Channels*/
};

/*</GPT_CONFIGURATION>*/
#define GPT_STOP_SEC_CONFIG_DATA
#include "Gpt_MemMap.h"
/*----- End of File --------------------------------------------------------*/


