
/* ======================================================================
 *   Copyright (c) 2022-2023 Texas Instruments Incorporated
 *
 *   All rights reserved. Property of Texas Instruments Incorporated.
 *   Restricted rights to use, duplicate or disclose this code are
 *   granted through contract.
 *
 *   The program may not be used without the written permission
 *   of Texas Instruments Incorporated or against the terms and conditions
 *   stipulated in the agreement under which this program has been
 *   supplied.
 * ==================================================================== */

/**
 *  \file     Port_PBcfg.c
 *
 *  \brief    This file contains generated post build configuration file
 *            for PORT MCAL driver
 *
 */

 /**********************************************************************************************************************
    Project: am263mcal10
    Date   : 2024-12-27 16:47:51

    This file is generated by EB Tresos
    Do not modify this file, otherwise the software may behave in unexpected way.

 *********************************************************************************************************************/

/*
*Design: MCAL-13987,MCAL-14022
*/

#define PORT_CFG_SOURCE

/**********************************************************************************************************************
 *  INCLUDES
 *********************************************************************************************************************/
#include "Std_Types.h"
#include "Port.h"
#include "hw_ctrl_core.h"

/**********************************************************************************************************************
 *  VERSION CHECK
 *********************************************************************************************************************/

/*  Version checking  */
#if ((PORT_SW_MAJOR_VERSION != (10U))||(PORT_SW_MINOR_VERSION != (0U)))
   #error "Version numbers of Port_PBcfg.c and Port.h are inconsistent!"
#endif

#if ((PORT_CFG_MAJOR_VERSION != (10U))||(PORT_CFG_MINOR_VERSION != (0U)))
  #error "Version numbers of Port_PBcfg.c and Port_Cfg.h are inconsistent!"
#endif

/**********************************************************************************************************************
 *  GLOBAL FUNCTION PROTOTYPES
 *********************************************************************************************************************/
  
/**********************************************************************************************************************
 *  LOCAL MACROS
 **********************************************************************************************************************/

/*MCAL: S MR:1.1 <APPROVED> "Reason - Start Section Code is also defined Port.h" */
#define PORT_START_SEC_CONFIG_DATA
/*MCAL: S MR:19.1 <APPROVED> "Reason - This is the format for specifying memory sections" */
#include "Port_MemMap.h"

/*<PORT_PIN_CONFIGURATION>*/
static CONST( Port_PinConfigType, PORT_PBCFG) PortConfigSet_0_PinConfig[ PORT_MAX_PIN_CONFIG ] =
{
    {
         .Port_PinId = 41,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_DEFAULT,
         .Port_OutputOverride_Ctrl = PORT_PIN_DISABLE_OUTPUT_OVERRIDE,
         .Port_InputOverride_Ctrl = PORT_PIN_DISABLE_INPUT_OVERRIDE,
         .Port_DirectionChangeable = TRUE,
         .Port_PinModeChangeable = TRUE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_OUT,
         .Port_PinInitialMode =  PORT_PIN_MODE_GPIOGH,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_GPIOGH,

                .muxmode = 7,
            },
         },
         .Port_PinDioRegId = (4U - 1U), /* GPIO register index is 0 based */
         .Port_PinDioChannelId = 24,
         .Port_RegOffsetAddr = PINC15_PRU1_GIO18,
         .Port_PinSignalName = (const sint8 *)"GPIOGH_120",
         .Port_PinName        = (const sint8 *)"PIN_C15",
    },
    {
         .Port_PinId = 24,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_DEFAULT,
         .Port_OutputOverride_Ctrl = PORT_PIN_DISABLE_OUTPUT_OVERRIDE,
         .Port_InputOverride_Ctrl = PORT_PIN_DISABLE_INPUT_OVERRIDE,
         .Port_DirectionChangeable = TRUE,
         .Port_PinModeChangeable = TRUE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_OUT,
         .Port_PinInitialMode =  PORT_PIN_MODE_GPIOGH,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_GPIOGH,

                .muxmode = 7,
            },
         },
         .Port_PinDioRegId = (4U - 1U), /* GPIO register index is 0 based */
         .Port_PinDioChannelId = 26,
         .Port_RegOffsetAddr = PINB16_SDFM0_CLK0,
         .Port_PinSignalName = (const sint8 *)"GPIOGH_122",
         .Port_PinName        = (const sint8 *)"PIN_B16",
    },
    {
         .Port_PinId = 6,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_DEFAULT,
         .Port_OutputOverride_Ctrl = PORT_PIN_DISABLE_OUTPUT_OVERRIDE,
         .Port_InputOverride_Ctrl = PORT_PIN_DISABLE_INPUT_OVERRIDE,
         .Port_DirectionChangeable = TRUE,
         .Port_PinModeChangeable = TRUE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_OUT,
         .Port_PinInitialMode =  PORT_PIN_MODE_GPIOI,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_GPIOI,

                .muxmode = 7,
            },
         },
         .Port_PinDioRegId = (5U - 1U), /* GPIO register index is 0 based */
         .Port_PinDioChannelId = 0,
         .Port_RegOffsetAddr = PINA15_SDFM0_CLK3,
         .Port_PinSignalName = (const sint8 *)"GPIOI_128",
         .Port_PinName        = (const sint8 *)"PIN_A15",
    },
    {
         .Port_PinId = 14,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_DEFAULT,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = TRUE,
         .Port_PinModeChangeable = TRUE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_IN,
         .Port_PinInitialMode =  PORT_PIN_MODE_LIN0,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 2,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_LIN0,

                .muxmode = 1,
            },
            [1] =
            {
                .mode = PORT_PIN_MODE_UART0,

                .muxmode = 0,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PINA7_UART0_RXD,
         .Port_PinSignalName = (const sint8 *)"GPIOAB_27",
         .Port_PinName        = (const sint8 *)"PIN_A7",
    },
    {
         .Port_PinId = 13,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_DEFAULT,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = TRUE,
         .Port_PinModeChangeable = TRUE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_OUT,
         .Port_PinInitialMode =  PORT_PIN_MODE_LIN0,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 2,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_LIN0,

                .muxmode = 1,
            },
            [1] =
            {
                .mode = PORT_PIN_MODE_UART0,

                .muxmode = 0,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PINA6_UART0_TXD,
         .Port_PinSignalName = (const sint8 *)"GPIOAB_28",
         .Port_PinName        = (const sint8 *)"PIN_A6",
    },
    {
         .Port_PinId = 2,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_ENABLE,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = FALSE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_DEFAULT,
         .Port_PinInitialMode =  PORT_PIN_MODE_SPI0,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_SPI0,

                .muxmode = 0,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PINA11_SPI0_CLK,
         .Port_PinSignalName = (const sint8 *)"SPI0_CLK",
         .Port_PinName        = (const sint8 *)"PIN_A11",
    },
    {
         .Port_PinId = 37,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_ENABLE,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = FALSE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_DEFAULT,
         .Port_PinInitialMode =  PORT_PIN_MODE_SPI0,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_SPI0,

                .muxmode = 0,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PINC11_SPI0_CS0,
         .Port_PinSignalName = (const sint8 *)"SPI0_CS0",
         .Port_PinName        = (const sint8 *)"PIN_C11",
    },
    {
         .Port_PinId = 36,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_ENABLE,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = FALSE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_DEFAULT,
         .Port_PinInitialMode =  PORT_PIN_MODE_SPI0,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_SPI0,

                .muxmode = 0,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PINC10_SPI0_D0,
         .Port_PinSignalName = (const sint8 *)"SPI0_D0",
         .Port_PinName        = (const sint8 *)"PIN_C10",
    },
    {
         .Port_PinId = 19,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_ENABLE,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = FALSE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_DEFAULT,
         .Port_PinInitialMode =  PORT_PIN_MODE_SPI0,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_SPI0,

                .muxmode = 0,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PINB11_SPI0_D1,
         .Port_PinSignalName = (const sint8 *)"SPI0_D1",
         .Port_PinName        = (const sint8 *)"PIN_B11",
    },
    {
         .Port_PinId = 126,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_DEFAULT,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = FALSE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_DEFAULT,
         .Port_PinInitialMode =  PORT_PIN_MODE_QSPI0,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_QSPI0,

                .muxmode = 0,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PINN2_QSPI0_CLK,
         .Port_PinSignalName = (const sint8 *)"QSPI0_CLK",
         .Port_PinName        = (const sint8 *)"PIN_N2",
    },
    {
         .Port_PinId = 122,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_DEFAULT,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = FALSE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_DEFAULT,
         .Port_PinInitialMode =  PORT_PIN_MODE_QSPI0,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_QSPI0,

                .muxmode = 0,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PINN1_QSPI0_D0,
         .Port_PinSignalName = (const sint8 *)"QSPI0_D0",
         .Port_PinName        = (const sint8 *)"PIN_N1",
    },
    {
         .Port_PinId = 127,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_DEFAULT,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = FALSE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_DEFAULT,
         .Port_PinInitialMode =  PORT_PIN_MODE_QSPI0,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_QSPI0,

                .muxmode = 0,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PINN4_QSPI0_D1,
         .Port_PinSignalName = (const sint8 *)"QSPI0_D1",
         .Port_PinName        = (const sint8 *)"PIN_N4",
    },
    {
         .Port_PinId = 121,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_DEFAULT,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = FALSE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_DEFAULT,
         .Port_PinInitialMode =  PORT_PIN_MODE_QSPI0,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_QSPI0,

                .muxmode = 0,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PINN4_QSPI0_D2,
         .Port_PinSignalName = (const sint8 *)"QSPI0_D2",
         .Port_PinName        = (const sint8 *)"PIN_M4",
    },
    {
         .Port_PinId = 134,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_DEFAULT,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = FALSE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_DEFAULT,
         .Port_PinInitialMode =  PORT_PIN_MODE_QSPI0,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_QSPI0,

                .muxmode = 0,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PINN4_QSPI0_D3,
         .Port_PinSignalName = (const sint8 *)"QSPI0_D3",
         .Port_PinName        = (const sint8 *)"PIN_P3",
    },
    {
         .Port_PinId = 128,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_DEFAULT,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = FALSE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_DEFAULT,
         .Port_PinInitialMode =  PORT_PIN_MODE_QSPI0,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_QSPI0,

                .muxmode = 0,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PINP1_QSPI0_CSN0,
         .Port_PinSignalName = (const sint8 *)"QSPI0_CSn0",
         .Port_PinName        = (const sint8 *)"PIN_P1",
    },
    {
         .Port_PinId = 102,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_DISABLE,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = FALSE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_IN,
         .Port_PinInitialMode =  PORT_PIN_MODE_RGMII2,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_RGMII2,

                .muxmode = 3,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PINK17_PRU0_GIO0,
         .Port_PinSignalName = (const sint8 *)"RGMII2_RD0",
         .Port_PinName        = (const sint8 *)"PIN_K17",
    },
    {
         .Port_PinId = 103,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_DISABLE,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = FALSE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_IN,
         .Port_PinInitialMode =  PORT_PIN_MODE_RGMII2,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_RGMII2,

                .muxmode = 3,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PINK18_PRU0_GIO1,
         .Port_PinSignalName = (const sint8 *)"RGMII2_RD1",
         .Port_PinName        = (const sint8 *)"PIN_K18",
    },
    {
         .Port_PinId = 95,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_DISABLE,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = FALSE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_IN,
         .Port_PinInitialMode =  PORT_PIN_MODE_RGMII2,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_RGMII2,

                .muxmode = 3,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PINJ18_PRU0_GIO2,
         .Port_PinSignalName = (const sint8 *)"RGMII2_RD2",
         .Port_PinName        = (const sint8 *)"PIN_J18",
    },
    {
         .Port_PinId = 94,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_DISABLE,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = FALSE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_IN,
         .Port_PinInitialMode =  PORT_PIN_MODE_RGMII2,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_RGMII2,

                .muxmode = 3,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PINJ17_PRU0_GIO3,
         .Port_PinSignalName = (const sint8 *)"RGMII2_RD3",
         .Port_PinName        = (const sint8 *)"PIN_J17",
    },
    {
         .Port_PinId = 101,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_DISABLE,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = FALSE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_IN,
         .Port_PinInitialMode =  PORT_PIN_MODE_RGMII2,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_RGMII2,

                .muxmode = 3,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PINK16_PRU0_GIO4,
         .Port_PinSignalName = (const sint8 *)"RGMII2_RX_CTL",
         .Port_PinName        = (const sint8 *)"PIN_K16",
    },
    {
         .Port_PinId = 100,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_DISABLE,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = FALSE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_IN,
         .Port_PinInitialMode =  PORT_PIN_MODE_RGMII2,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_RGMII2,

                .muxmode = 3,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PINK15_PRU0_GIO6,
         .Port_PinSignalName = (const sint8 *)"RGMII2_RXC",
         .Port_PinName        = (const sint8 *)"PIN_K15",
    },
    {
         .Port_PinId = 116,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_DISABLE,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = FALSE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_OUT,
         .Port_PinInitialMode =  PORT_PIN_MODE_RGMII2,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_RGMII2,

                .muxmode = 3,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PINM16_PRU0_GIO11,
         .Port_PinSignalName = (const sint8 *)"RGMII2_TD0",
         .Port_PinName        = (const sint8 *)"PIN_M16",
    },
    {
         .Port_PinId = 115,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_DISABLE,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = FALSE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_OUT,
         .Port_PinInitialMode =  PORT_PIN_MODE_RGMII2,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_RGMII2,

                .muxmode = 3,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PINM15_PRU0_GIO12,
         .Port_PinSignalName = (const sint8 *)"RGMII2_TD1",
         .Port_PinName        = (const sint8 *)"PIN_M15",
    },
    {
         .Port_PinId = 90,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_DISABLE,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = FALSE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_OUT,
         .Port_PinInitialMode =  PORT_PIN_MODE_RGMII2,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_RGMII2,

                .muxmode = 3,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PINH17_PRU0_GIO13,
         .Port_PinSignalName = (const sint8 *)"RGMII2_TD2",
         .Port_PinName        = (const sint8 *)"PIN_H17",
    },
    {
         .Port_PinId = 89,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_DISABLE,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = FALSE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_OUT,
         .Port_PinInitialMode =  PORT_PIN_MODE_RGMII2,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_RGMII2,

                .muxmode = 3,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PINH16_PRU0_GIO14,
         .Port_PinSignalName = (const sint8 *)"RGMII2_TD3",
         .Port_PinName        = (const sint8 *)"PIN_H16",
    },
    {
         .Port_PinId = 108,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_DISABLE,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = FALSE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_OUT,
         .Port_PinInitialMode =  PORT_PIN_MODE_RGMII2,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_RGMII2,

                .muxmode = 3,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PINL16_PRU0_GIO15,
         .Port_PinSignalName = (const sint8 *)"RGMII2_TX_CTL",
         .Port_PinName        = (const sint8 *)"PIN_L16",
    },
    {
         .Port_PinId = 91,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_DISABLE,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = FALSE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_OUT,
         .Port_PinInitialMode =  PORT_PIN_MODE_RGMII2,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_RGMII2,

                .muxmode = 3,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PINH18_PRU0_GIO16,
         .Port_PinSignalName = (const sint8 *)"RGMII2_TXC",
         .Port_PinName        = (const sint8 *)"PIN_H18",
    },
    {
         .Port_PinId = 117,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_DISABLE,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = FALSE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_OUT,
         .Port_PinInitialMode =  PORT_PIN_MODE_MDIO0,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_MDIO0,

                .muxmode = 0,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PINM17_MDIO0_MDC,
         .Port_PinSignalName = (const sint8 *)"MDIO0_MDC",
         .Port_PinName        = (const sint8 *)"PIN_M17",
    },
    {
         .Port_PinId = 123,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_DISABLE,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = FALSE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_OUT,
         .Port_PinInitialMode =  PORT_PIN_MODE_MDIO0,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_MDIO0,

                .muxmode = 0,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PINN16_MDIO0_MDIO,
         .Port_PinSignalName = (const sint8 *)"MDIO0_MDIO",
         .Port_PinName        = (const sint8 *)"PIN_N16",
    },
    {
         .Port_PinId = 142,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_DISABLE,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = FALSE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_IN,
         .Port_PinInitialMode =  PORT_PIN_MODE_RGMII1,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_RGMII1,

                .muxmode = 0,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PINU17_RGMII1_RD0,
         .Port_PinSignalName = (const sint8 *)"RGMII1_RD0",
         .Port_PinName        = (const sint8 *)"PIN_U17",
    },
    {
         .Port_PinId = 140,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_DISABLE,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = FALSE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_IN,
         .Port_PinInitialMode =  PORT_PIN_MODE_RGMII1,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_RGMII1,

                .muxmode = 0,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PINT17_RGMII1_RD1,
         .Port_PinSignalName = (const sint8 *)"RGMII1_RD1",
         .Port_PinName        = (const sint8 *)"PIN_T17",
    },
    {
         .Port_PinId = 143,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_DISABLE,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = FALSE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_IN,
         .Port_PinInitialMode =  PORT_PIN_MODE_RGMII1,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_RGMII1,

                .muxmode = 0,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PINU18_RGMII1_RD2,
         .Port_PinSignalName = (const sint8 *)"RGMII1_RD2",
         .Port_PinName        = (const sint8 *)"PIN_U18",
    },
    {
         .Port_PinId = 141,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_DISABLE,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = FALSE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_IN,
         .Port_PinInitialMode =  PORT_PIN_MODE_RGMII1,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_RGMII1,

                .muxmode = 0,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PINT18_RGMII1_RD3,
         .Port_PinSignalName = (const sint8 *)"RGMII1_RD3",
         .Port_PinName        = (const sint8 *)"PIN_T18",
    },
    {
         .Port_PinId = 137,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_DISABLE,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = FALSE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_IN,
         .Port_PinInitialMode =  PORT_PIN_MODE_RGMII1,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_RGMII1,

                .muxmode = 0,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PINR18_RGMII1_RX_CTL,
         .Port_PinSignalName = (const sint8 *)"RGMII1_RX_CTL",
         .Port_PinName        = (const sint8 *)"PIN_R18",
    },
    {
         .Port_PinId = 136,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_DISABLE,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = FALSE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_IN,
         .Port_PinInitialMode =  PORT_PIN_MODE_RGMII1,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_RGMII1,

                .muxmode = 0,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PINR17_RGMII1_RXC,
         .Port_PinSignalName = (const sint8 *)"RGMII1_RXC",
         .Port_PinName        = (const sint8 *)"PIN_R17",
    },
    {
         .Port_PinId = 130,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_DISABLE,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = FALSE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_OUT,
         .Port_PinInitialMode =  PORT_PIN_MODE_RGMII1,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_RGMII1,

                .muxmode = 0,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PINP16_RGMII1_TD0,
         .Port_PinSignalName = (const sint8 *)"RGMII1_TD0",
         .Port_PinName        = (const sint8 *)"PIN_P16",
    },
    {
         .Port_PinId = 131,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_DISABLE,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = FALSE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_OUT,
         .Port_PinInitialMode =  PORT_PIN_MODE_RGMII1,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_RGMII1,

                .muxmode = 0,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PINP17_RGMII1_TD1,
         .Port_PinSignalName = (const sint8 *)"RGMII1_TD1",
         .Port_PinName        = (const sint8 *)"PIN_P17",
    },
    {
         .Port_PinId = 132,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_DISABLE,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = FALSE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_OUT,
         .Port_PinInitialMode =  PORT_PIN_MODE_RGMII1,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_RGMII1,

                .muxmode = 0,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PINP18_RGMII1_TD2,
         .Port_PinSignalName = (const sint8 *)"RGMII1_TD2",
         .Port_PinName        = (const sint8 *)"PIN_P18",
    },
    {
         .Port_PinId = 124,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_DISABLE,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = FALSE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_OUT,
         .Port_PinInitialMode =  PORT_PIN_MODE_RGMII1,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_RGMII1,

                .muxmode = 0,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PINN17_RGMII1_TD3,
         .Port_PinSignalName = (const sint8 *)"RGMII1_TD3",
         .Port_PinName        = (const sint8 *)"PIN_N17",
    },
    {
         .Port_PinId = 118,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_DISABLE,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = FALSE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_OUT,
         .Port_PinInitialMode =  PORT_PIN_MODE_RGMII1,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_RGMII1,

                .muxmode = 0,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PINM18_RGMII1_TX_CTL,
         .Port_PinSignalName = (const sint8 *)"RGMII1_TX_CTL",
         .Port_PinName        = (const sint8 *)"PIN_M18",
    },
    {
         .Port_PinId = 125,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_DISABLE,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = FALSE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_OUT,
         .Port_PinInitialMode =  PORT_PIN_MODE_RGMII1,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_RGMII1,

                .muxmode = 0,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PINN18_RGMII1_TXC,
         .Port_PinSignalName = (const sint8 *)"RGMII1_TXC",
         .Port_PinName        = (const sint8 *)"PIN_N18",
    },
    {
         .Port_PinId = 4,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_DISABLE,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = FALSE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_OUT,
         .Port_PinInitialMode =  PORT_PIN_MODE_I2C0,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_I2C0,

                .muxmode = 0,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PINA13_I2C0_SCL,
         .Port_PinSignalName = (const sint8 *)"I2C0_SCL",
         .Port_PinName        = (const sint8 *)"PIN_A13",
    },
    {
         .Port_PinId = 21,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_DISABLE,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = FALSE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_OUT,
         .Port_PinInitialMode =  PORT_PIN_MODE_I2C0,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_I2C0,

                .muxmode = 0,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PINB13_I2C0_SDA,
         .Port_PinSignalName = (const sint8 *)"I2C0_SDA",
         .Port_PinName        = (const sint8 *)"PIN_B13",
    },
    {
         .Port_PinId = 49,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_DISABLE,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = FALSE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_OUT,
         .Port_PinInitialMode =  PORT_PIN_MODE_I2C2,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_I2C2,

                .muxmode = 1,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PINC7_UART0_RTSN,
         .Port_PinSignalName = (const sint8 *)"I2C2_SCL",
         .Port_PinName        = (const sint8 *)"PIN_C7",
    },
    {
         .Port_PinId = 32,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_DISABLE,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = FALSE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_DEFAULT,
         .Port_PinInitialMode =  PORT_PIN_MODE_I2C2,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_I2C2,

                .muxmode = 1,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PINB7_UART0_CTSn,
         .Port_PinSignalName = (const sint8 *)"I2C2_SDA",
         .Port_PinName        = (const sint8 *)"PIN_B7",
    },
    {
         .Port_PinId = 114,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_DEFAULT,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = FALSE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_DEFAULT,
         .Port_PinInitialMode =  PORT_PIN_MODE_MCAN0,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_MCAN0,

                .muxmode = 0,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PINM1_MCAN0_RX,
         .Port_PinSignalName = (const sint8 *)"MCAN0_RX",
         .Port_PinName        = (const sint8 *)"PIN_M1",
    },
    {
         .Port_PinId = 107,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_DEFAULT,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = FALSE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_DEFAULT,
         .Port_PinInitialMode =  PORT_PIN_MODE_MCAN0,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_MCAN0,

                .muxmode = 0,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PINL1_MCAN0_TX,
         .Port_PinSignalName = (const sint8 *)"MCAN0_TX",
         .Port_PinName        = (const sint8 *)"PIN_L1",
    },
    {
         .Port_PinId = 111,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_DEFAULT,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = FALSE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_DEFAULT,
         .Port_PinInitialMode =  PORT_PIN_MODE_MCAN1,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_MCAN1,

                .muxmode = 0,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PINL2_MCAN1_RX,
         .Port_PinSignalName = (const sint8 *)"MCAN1_RX",
         .Port_PinName        = (const sint8 *)"PIN_L2",
    },
    {
         .Port_PinId = 99,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_DEFAULT,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = FALSE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_DEFAULT,
         .Port_PinInitialMode =  PORT_PIN_MODE_MCAN1,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_MCAN1,

                .muxmode = 0,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PINK1_MCAN1_TX,
         .Port_PinSignalName = (const sint8 *)"MCAN1_TX",
         .Port_PinName        = (const sint8 *)"PIN_K1",
    },
    {
         .Port_PinId = 80,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_DEFAULT,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = FALSE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_DEFAULT,
         .Port_PinInitialMode =  PORT_PIN_MODE_EPWM9,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_EPWM9,

                .muxmode = 0,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PING1_EPWM9_A,
         .Port_PinSignalName = (const sint8 *)"EPWM9_A",
         .Port_PinName        = (const sint8 *)"PIN_G1",
    },
    {
         .Port_PinId = 55,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_DEFAULT,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = FALSE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_IN,
         .Port_PinInitialMode =  PORT_PIN_MODE_ECAP0,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_PULLDOWN,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_INVTYPE_DEFAULT,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_FAST_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_ECAP0,

                .muxmode = 0,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PIND14_SDFM0_D0,
         .Port_PinSignalName = (const sint8 *)"ECAP0_APWM_OUT",
         .Port_PinName        = (const sint8 *)"PIN_D14",
    },
    {
         .Port_PinId = 113,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_DEFAULT,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = FALSE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_DEFAULT,
         .Port_PinInitialMode =  PORT_PIN_MODE_QSPI0,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_QSPI0,

                .muxmode = 0,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PINLB_CLKLB,
         .Port_PinSignalName = (const sint8 *)"QSPI0_CLKLB",
         .Port_PinName        = (const sint8 *)"PIN_LB",
    },
    {
         .Port_PinId = 138,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_DEFAULT,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = FALSE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_DEFAULT,
         .Port_PinInitialMode =  PORT_PIN_MODE_QSPI0,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_QSPI0,

                .muxmode = 0,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PINR3_QSPI0_CSN1,
         .Port_PinSignalName = (const sint8 *)"QSPI0_CSn1",
         .Port_PinName        = (const sint8 *)"PIN_R3",
    },
    {
         .Port_PinId = 3,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_DEFAULT,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = FALSE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_DEFAULT,
         .Port_PinInitialMode =  PORT_PIN_MODE_MCAN2,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_MCAN2,

                .muxmode = 0,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PINA12_MCAN2_RX,
         .Port_PinSignalName = (const sint8 *)"MCAN2_RX",
         .Port_PinName        = (const sint8 *)"PIN_A12",
    },
    {
         .Port_PinId = 20,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_DEFAULT,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = FALSE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_DEFAULT,
         .Port_PinInitialMode =  PORT_PIN_MODE_MCAN2,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_MCAN2,

                .muxmode = 0,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PINB12_MCAN2_TX,
         .Port_PinSignalName = (const sint8 *)"MCAN2_TX",
         .Port_PinName        = (const sint8 *)"PIN_B12",
    },
    {
         .Port_PinId = 1,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_ENABLE,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = FALSE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_DEFAULT,
         .Port_PinInitialMode =  PORT_PIN_MODE_SPI1,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_SPI1,

                .muxmode = 0,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PINA10_SPI1_CLK,
         .Port_PinSignalName = (const sint8 *)"SPI1_CLK",
         .Port_PinName        = (const sint8 *)"PIN_A10",
    },
    {
         .Port_PinId = 51,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_ENABLE,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = FALSE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_DEFAULT,
         .Port_PinInitialMode =  PORT_PIN_MODE_SPI1,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_SPI1,

                .muxmode = 0,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PINC9_SPI1_CS0,
         .Port_PinSignalName = (const sint8 *)"SPI1_CS0",
         .Port_PinName        = (const sint8 *)"PIN_C9",
    },
    {
         .Port_PinId = 18,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_ENABLE,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = FALSE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_DEFAULT,
         .Port_PinInitialMode =  PORT_PIN_MODE_SPI1,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_SPI1,

                .muxmode = 0,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PINB10_SPI1_D0,
         .Port_PinSignalName = (const sint8 *)"SPI1_D0",
         .Port_PinName        = (const sint8 *)"PIN_B10",
    },
    {
         .Port_PinId = 64,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_ENABLE,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = FALSE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_DEFAULT,
         .Port_PinInitialMode =  PORT_PIN_MODE_SPI1,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_SPI1,

                .muxmode = 0,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PIND9_SPI1_D1,
         .Port_PinSignalName = (const sint8 *)"SPI1_D1",
         .Port_PinName        = (const sint8 *)"PIN_D9",
    },
    {
         .Port_PinId = 34,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_ENABLE,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = FALSE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_DEFAULT,
         .Port_PinInitialMode =  PORT_PIN_MODE_LIN1,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_LIN1,

                .muxmode = 0,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PINB9_LIN1_TXD,
         .Port_PinSignalName = (const sint8 *)"LIN1_TXD",
         .Port_PinName        = (const sint8 *)"PIN_B9",
    },
    {
         .Port_PinId = 16,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_ENABLE,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = FALSE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_DEFAULT,
         .Port_PinInitialMode =  PORT_PIN_MODE_LIN1,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_LIN1,

                .muxmode = 0,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PINA9_LIN1_RXD,
         .Port_PinSignalName = (const sint8 *)"LIN1_RXD",
         .Port_PinName        = (const sint8 *)"PIN_A9",
    },
    {
         .Port_PinId = 33,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_ENABLE,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = FALSE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_DEFAULT,
         .Port_PinInitialMode =  PORT_PIN_MODE_SPI2,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_SPI2,

                .muxmode = 2,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PINB8_LIN2_RXD,
         .Port_PinSignalName = (const sint8 *)"SPI2_D0",
         .Port_PinName        = (const sint8 *)"PIN_B8",
    },
    {
         .Port_PinId = 15,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_ENABLE,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = FALSE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_DEFAULT,
         .Port_PinInitialMode =  PORT_PIN_MODE_SPI2,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_SPI2,

                .muxmode = 2,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PINA8_LIN2_TXD,
         .Port_PinSignalName = (const sint8 *)"SPI2_D1",
         .Port_PinName        = (const sint8 *)"PIN_A8",
    },
    {
         .Port_PinId = 22,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_ENABLE,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = FALSE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_DEFAULT,
         .Port_PinInitialMode =  PORT_PIN_MODE_SPI4,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_SPI4,

                .muxmode = 3,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PINB14_EQEP0_A,
         .Port_PinSignalName = (const sint8 *)"SPI4_CLK",
         .Port_PinName        = (const sint8 *)"PIN_B14",
    },
    {
         .Port_PinId = 5,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_ENABLE,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = FALSE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_DEFAULT,
         .Port_PinInitialMode =  PORT_PIN_MODE_SPI4,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_SPI4,

                .muxmode = 3,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PINA14_EQEP0_B,
         .Port_PinSignalName = (const sint8 *)"SPI4_CS0",
         .Port_PinName        = (const sint8 *)"PIN_A14",
    },
    {
         .Port_PinId = 104,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_ENABLE,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = FALSE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_DEFAULT,
         .Port_PinInitialMode =  PORT_PIN_MODE_SPI4,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_SPI4,

                .muxmode = 2,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PINK2_EPWM12_A,
         .Port_PinSignalName = (const sint8 *)"SPI4_CS1",
         .Port_PinName        = (const sint8 *)"PIN_K2",
    },
    {
         .Port_PinId = 38,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_ENABLE,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = FALSE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_DEFAULT,
         .Port_PinInitialMode =  PORT_PIN_MODE_SPI4,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_SPI4,

                .muxmode = 3,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PINC12_EQEP0_S,
         .Port_PinSignalName = (const sint8 *)"SPI4_D0",
         .Port_PinName        = (const sint8 *)"PIN_C12",
    },
    {
         .Port_PinId = 53,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_ENABLE,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = FALSE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_DEFAULT,
         .Port_PinInitialMode =  PORT_PIN_MODE_SPI4,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_SPI4,

                .muxmode = 3,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PIND11_EQEP0_I,
         .Port_PinSignalName = (const sint8 *)"SPI4_D1",
         .Port_PinName        = (const sint8 *)"PIN_D11",
    },
    {
         .Port_PinId = 12,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_DEFAULT,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = TRUE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_IN,
         .Port_PinInitialMode =  PORT_PIN_MODE_UART0,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_UART0,

                .muxmode = 1,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PINA5_MMC0_CD,
         .Port_PinSignalName = (const sint8 *)"UART0_CTSn",
         .Port_PinName        = (const sint8 *)"PIN_A5",
    },
    {
         .Port_PinId = 48,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_DEFAULT,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = TRUE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_OUT,
         .Port_PinInitialMode =  PORT_PIN_MODE_UART0,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_UART0,

                .muxmode = 1,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PINC6_MMC0_WP,
         .Port_PinSignalName = (const sint8 *)"UART0_RTSn",
         .Port_PinName        = (const sint8 *)"PIN_C6",
    },
    {
         .Port_PinId = 31,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_DEFAULT,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = TRUE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_IN,
         .Port_PinInitialMode =  PORT_PIN_MODE_UART0,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_UART0,

                .muxmode = 1,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PINB6_MMC0_CLK,
         .Port_PinSignalName = (const sint8 *)"UART0_RXD",
         .Port_PinName        = (const sint8 *)"PIN_B6",
    },
    {
         .Port_PinId = 11,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_DEFAULT,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = TRUE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_OUT,
         .Port_PinInitialMode =  PORT_PIN_MODE_UART0,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_UART0,

                .muxmode = 1,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PINA4_MMC0_CMD,
         .Port_PinSignalName = (const sint8 *)"UART0_TXD",
         .Port_PinName        = (const sint8 *)"PIN_A4",
    },
    {
         .Port_PinId = 87,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_DEFAULT,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = TRUE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_IN,
         .Port_PinInitialMode =  PORT_PIN_MODE_UART1,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_UART1,

                .muxmode = 1,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PING4_EPWM10_A,
         .Port_PinSignalName = (const sint8 *)"UART1_CTSn",
         .Port_PinName        = (const sint8 *)"PIN_G4",
    },
    {
         .Port_PinId = 98,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_DEFAULT,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = TRUE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_IN,
         .Port_PinInitialMode =  PORT_PIN_MODE_UART1,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_UART1,

                .muxmode = 1,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PINJ4_EPWM12_B,
         .Port_PinSignalName = (const sint8 *)"UART1_DCDn",
         .Port_PinName        = (const sint8 *)"PIN_J4",
    },
    {
         .Port_PinId = 144,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_DEFAULT,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = TRUE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_IN,
         .Port_PinInitialMode =  PORT_PIN_MODE_UART1,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_UART1,

                .muxmode = 1,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PINV17_EPWM14_A,
         .Port_PinSignalName = (const sint8 *)"UART1_DSRn",
         .Port_PinName        = (const sint8 *)"PIN_V17",
    },
    {
         .Port_PinId = 105,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_DEFAULT,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = TRUE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_OUT,
         .Port_PinInitialMode =  PORT_PIN_MODE_UART1,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_UART1,

                .muxmode = 1,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PINK3_EPWM13_B,
         .Port_PinSignalName = (const sint8 *)"UART1_DTRn",
         .Port_PinName        = (const sint8 *)"PIN_K3",
    },
    {
         .Port_PinId = 106,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_DEFAULT,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = TRUE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_IN,
         .Port_PinInitialMode =  PORT_PIN_MODE_UART1,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_UART1,

                .muxmode = 1,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PINK4_EPWM13_A,
         .Port_PinSignalName = (const sint8 *)"UART1_RIn",
         .Port_PinName        = (const sint8 *)"PIN_K4",
    },
    {
         .Port_PinId = 96,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_DEFAULT,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = TRUE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_OUT,
         .Port_PinInitialMode =  PORT_PIN_MODE_UART1,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_UART1,

                .muxmode = 1,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PINJ2_EPWM9_B,
         .Port_PinSignalName = (const sint8 *)"UART1_RTSn",
         .Port_PinName        = (const sint8 *)"PIN_J2",
    },
    {
         .Port_PinId = 112,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_DEFAULT,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = TRUE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_IN,
         .Port_PinInitialMode =  PORT_PIN_MODE_UART1,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_UART1,

                .muxmode = 0,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PINL3_UART1_RXD,
         .Port_PinSignalName = (const sint8 *)"UART1_RXD",
         .Port_PinName        = (const sint8 *)"PIN_L3",
    },
    {
         .Port_PinId = 120,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_DEFAULT,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = TRUE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_OUT,
         .Port_PinInitialMode =  PORT_PIN_MODE_UART1,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_UART1,

                .muxmode = 0,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PINM3_UART1_TXD,
         .Port_PinSignalName = (const sint8 *)"UART1_TXD",
         .Port_PinName        = (const sint8 *)"PIN_M3",
    },
    {
         .Port_PinId = 88,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_DEFAULT,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = TRUE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_IN,
         .Port_PinInitialMode =  PORT_PIN_MODE_UART1,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_INVTYPE_DEFAULT,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_UART2,

                .muxmode = 1,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PINH1_EPWM11_A,
         .Port_PinSignalName = (const sint8 *)"UART2_CTSn",
         .Port_PinName        = (const sint8 *)"PIN_H1",
    },
    {
         .Port_PinId = 97,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_DEFAULT,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = TRUE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_OUT,
         .Port_PinInitialMode =  PORT_PIN_MODE_UART2,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_UART2,

                .muxmode = 1,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PINJ3_EPWM10_B,
         .Port_PinSignalName = (const sint8 *)"UART2_RTSn",
         .Port_PinName        = (const sint8 *)"PIN_J3",
    },
    {
         .Port_PinId = 30,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_DEFAULT,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = TRUE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_IN,
         .Port_PinInitialMode =  PORT_PIN_MODE_UART2,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_UART2,

                .muxmode = 1,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PINB5_MMC0_D0,
         .Port_PinSignalName = (const sint8 *)"UART2_RXD",
         .Port_PinName        = (const sint8 *)"PIN_B5",
    },
    {
         .Port_PinId = 10,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_DEFAULT,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = FALSE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_OUT,
         .Port_PinInitialMode =  PORT_PIN_MODE_UART2,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_UART2,

                .muxmode = 1,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PINA3_MMC0_D2,
         .Port_PinSignalName = (const sint8 *)"UART2_TXD",
         .Port_PinName        = (const sint8 *)"PIN_A3",
    },
    {
         .Port_PinId = 54,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_DEFAULT,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = TRUE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_IN,
         .Port_PinInitialMode =  PORT_PIN_MODE_UART5,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_UART5,

                .muxmode = 2,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PIND13_SDFM0_D1,
         .Port_PinSignalName = (const sint8 *)"UART5_CTSn",
         .Port_PinName        = (const sint8 *)"PIN_D13",
    },
    {
         .Port_PinId = 7,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_DEFAULT,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = TRUE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_OUT,
         .Port_PinInitialMode =  PORT_PIN_MODE_UART5,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_UART5,

                .muxmode = 2,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PINA16_SDFM0_CLK1,
         .Port_PinSignalName = (const sint8 *)"UART5_RTSn",
         .Port_PinName        = (const sint8 *)"PIN_A16",
    },
    {
         .Port_PinId = 135,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_DEFAULT,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = FALSE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_IN,
         .Port_PinInitialMode =  PORT_PIN_MODE_UART5,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_UART5,

                .muxmode = 1,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PINR16_EPWM15_B,
         .Port_PinSignalName = (const sint8 *)"UART5_RXD",
         .Port_PinName        = (const sint8 *)"PIN_R16",
    },
    {
         .Port_PinId = 129,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_DEFAULT,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = TRUE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_OUT,
         .Port_PinInitialMode =  PORT_PIN_MODE_UART5,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_UART5,

                .muxmode = 1,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PINP15_EPWM15_A,
         .Port_PinSignalName = (const sint8 *)"UART5_TXD",
         .Port_PinName        = (const sint8 *)"PIN_P15",
    },
    {
         .Port_PinId = 65,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_DEFAULT,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = FALSE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_IN,
         .Port_PinInitialMode =  PORT_PIN_MODE_FSIRX0,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_FSIRX1,

                .muxmode = 6,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PINE1_EPWM6_A,
         .Port_PinSignalName = (const sint8 *)"FSIRX1_CLK",
         .Port_PinName        = (const sint8 *)"PIN_E1",
    },
    {
         .Port_PinId = 78,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_DEFAULT,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = FALSE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_IN,
         .Port_PinInitialMode =  PORT_PIN_MODE_FSIRX1,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_FSIRX1,

                .muxmode = 6,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PINF3_EPWM6_B,
         .Port_PinSignalName = (const sint8 *)"FSIRX1_DATA0",
         .Port_PinName        = (const sint8 *)"PIN_F3",
    },
    {
         .Port_PinId = 79,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_DEFAULT,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = FALSE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_IN,
         .Port_PinInitialMode =  PORT_PIN_MODE_FSIRX1,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_FSIRX1,

                .muxmode = 6,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PINF4_EPWM7_A,
         .Port_PinSignalName = (const sint8 *)"FSIRX1_DATA1",
         .Port_PinName        = (const sint8 *)"PIN_F4",
    },
    {
         .Port_PinId = 82,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_DEFAULT,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = FALSE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_IN,
         .Port_PinInitialMode =  PORT_PIN_MODE_FSIRX2,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_FSIRX2,

                .muxmode = 3,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PING16_PRU1_GIO1,
         .Port_PinSignalName = (const sint8 *)"FSIRX2_CLK",
         .Port_PinName        = (const sint8 *)"PIN_G16",
    },
    {
         .Port_PinId = 67,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_DEFAULT,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = FALSE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_IN,
         .Port_PinInitialMode =  PORT_PIN_MODE_FSIRX2,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_FSIRX2,

                .muxmode = 3,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PINE17_PRU1_GIO2,
         .Port_PinSignalName = (const sint8 *)"FSIRX2_DATA0",
         .Port_PinName        = (const sint8 *)"PIN_E17",
    },
    {
         .Port_PinId = 68,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_DEFAULT,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = FALSE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_IN,
         .Port_PinInitialMode =  PORT_PIN_MODE_FSIRX2,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_FSIRX2,

                .muxmode = 3,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PINE18_PRU1_GIO3,
         .Port_PinSignalName = (const sint8 *)"FSIRX2_DATA1",
         .Port_PinName        = (const sint8 *)"PIN_E18",
    },
    {
         .Port_PinId = 25,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_DEFAULT,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = FALSE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_IN,
         .Port_PinInitialMode =  PORT_PIN_MODE_FSIRX3,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_FSIRX3,

                .muxmode = 3,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PINB17_PRU1_GIO12,
         .Port_PinSignalName = (const sint8 *)"FSIRX3_CLK",
         .Port_PinName        = (const sint8 *)"PIN_B17",
    },
    {
         .Port_PinId = 57,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_DEFAULT,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = TRUE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_IN,
         .Port_PinInitialMode =  PORT_PIN_MODE_FSIRX3,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_FSIRX3,

                .muxmode = 3,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PIND16_PRU1_GIO13,
         .Port_PinSignalName = (const sint8 *)"FSIRX3_DATA0",
         .Port_PinName        = (const sint8 *)"PIN_D16",
    },
    {
         .Port_PinId = 43,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_DEFAULT,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = FALSE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_IN,
         .Port_PinInitialMode =  PORT_PIN_MODE_FSIRX3,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_FSIRX3,

                .muxmode = 3,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PINC17_PRU1_GIO14,
         .Port_PinSignalName = (const sint8 *)"FSIRX3_DATA1",
         .Port_PinName        = (const sint8 *)"PIN_C17",
    },
    {
         .Port_PinId = 71,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_DEFAULT,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = FALSE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_OUT,
         .Port_PinInitialMode =  PORT_PIN_MODE_FSITX1,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_FSITX1,

                .muxmode = 6,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PINE4_EPWM4_B,
         .Port_PinSignalName = (const sint8 *)"FSITX1_CLK",
         .Port_PinName        = (const sint8 *)"PIN_E4",
    },
    {
         .Port_PinId = 77,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_DEFAULT,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = FALSE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_OUT,
         .Port_PinInitialMode =  PORT_PIN_MODE_FSITX1,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_FSITX1,

                .muxmode = 6,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PINF2_EPWM5_A,
         .Port_PinSignalName = (const sint8 *)"FSITX1_DATA0",
         .Port_PinName        = (const sint8 *)"PIN_F2",
    },
    {
         .Port_PinId = 85,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_DEFAULT,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = FALSE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_OUT,
         .Port_PinInitialMode =  PORT_PIN_MODE_FSITX1,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_FSITX1,

                .muxmode = 6,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PING2_EPWM5_B,
         .Port_PinSignalName = (const sint8 *)"FSITX1_DATA1",
         .Port_PinName        = (const sint8 *)"PIN_G2",
    },
    {
         .Port_PinId = 66,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_DEFAULT,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = FALSE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_OUT,
         .Port_PinInitialMode =  PORT_PIN_MODE_FSITX2,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_FSITX2,

                .muxmode = 3,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PINE16_PRU1_GIO6,
         .Port_PinSignalName = (const sint8 *)"FSITX2_CLK",
         .Port_PinName        = (const sint8 *)"PIN_E16",
    },
    {
         .Port_PinId = 74,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_DEFAULT,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = FALSE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_OUT,
         .Port_PinInitialMode =  PORT_PIN_MODE_FSITX2,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_FSITX2,

                .muxmode = 3,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PINF16_PRU1_GIO4,
         .Port_PinSignalName = (const sint8 *)"FSITX2_DATA0",
         .Port_PinName        = (const sint8 *)"PIN_F16",
    },
    {
         .Port_PinId = 76,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_DEFAULT,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = FALSE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_OUT,
         .Port_PinInitialMode =  PORT_PIN_MODE_FSITX2,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_FSITX2,

                .muxmode = 3,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PINF18_PRU1_GIO0,
         .Port_PinSignalName = (const sint8 *)"FSITX2_DATA1",
         .Port_PinName        = (const sint8 *)"PIN_F18",
    },
    {
         .Port_PinId = 42,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_DEFAULT,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = FALSE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_OUT,
         .Port_PinInitialMode =  PORT_PIN_MODE_FSITX3,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_FSITX3,

                .muxmode = 3,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PINC16_PRU1_GIO16,
         .Port_PinSignalName = (const sint8 *)"FSITX3_CLK",
         .Port_PinName        = (const sint8 *)"PIN_C16",
    },
    {
         .Port_PinId = 8,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_DEFAULT,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = FALSE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_OUT,
         .Port_PinInitialMode =  PORT_PIN_MODE_FSITX3,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_FSITX3,

                .muxmode = 3,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PINA17_PRU1_GIO15,
         .Port_PinSignalName = (const sint8 *)"FSITX3_DATA0",
         .Port_PinName        = (const sint8 *)"PIN_A17",
    },
    {
         .Port_PinId = 26,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_DEFAULT,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = FALSE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_OUT,
         .Port_PinInitialMode =  PORT_PIN_MODE_FSITX3,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_FSITX3,

                .muxmode = 3,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PINB18_PRU1_GIO11,
         .Port_PinSignalName = (const sint8 *)"FSITX3_DATA1",
         .Port_PinName        = (const sint8 *)"PIN_B18",
    },
    {
         .Port_PinId = 27,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_DEFAULT,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = FALSE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_DEFAULT,
         .Port_PinInitialMode =  PORT_PIN_MODE_EPWM0,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_EPWM0,

                .muxmode = 0,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PINB2_EPWM0_A,
         .Port_PinSignalName = (const sint8 *)"EPWM0_A",
         .Port_PinName        = (const sint8 *)"PIN_B2",
    },
    {
         .Port_PinId = 17,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_DEFAULT,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = FALSE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_DEFAULT,
         .Port_PinInitialMode =  PORT_PIN_MODE_EPWM0,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_EPWM0,

                .muxmode = 0,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PINB1_EPWM0_B,
         .Port_PinSignalName = (const sint8 *)"EPWM0_B",
         .Port_PinName        = (const sint8 *)"PIN_B1",
    },
    {
         .Port_PinId = 61,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_DEFAULT,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = FALSE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_DEFAULT,
         .Port_PinInitialMode =  PORT_PIN_MODE_EPWM1,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_EPWM1,

                .muxmode = 0,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PIND3_EPWM1_A,
         .Port_PinSignalName = (const sint8 *)"EPWM1_A",
         .Port_PinName        = (const sint8 *)"PIN_D3",
    },
    {
         .Port_PinId = 60,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_DEFAULT,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = FALSE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_DEFAULT,
         .Port_PinInitialMode =  PORT_PIN_MODE_EPWM1,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_EPWM1,

                .muxmode = 0,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PIND2_EPWM1_B,
         .Port_PinSignalName = (const sint8 *)"EPWM1_B",
         .Port_PinName        = (const sint8 *)"PIN_D2",
    },
    {
         .Port_PinId = 45,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_DEFAULT,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = FALSE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_DEFAULT,
         .Port_PinInitialMode =  PORT_PIN_MODE_EPWM2,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_EPWM2,

                .muxmode = 0,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PINC2_EPWM2_A,
         .Port_PinSignalName = (const sint8 *)"EPWM2_A",
         .Port_PinName        = (const sint8 *)"PIN_C2",
    },
    {
         .Port_PinId = 35,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_DEFAULT,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = FALSE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_DEFAULT,
         .Port_PinInitialMode =  PORT_PIN_MODE_EPWM2,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_EPWM2,

                .muxmode = 0,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PINC1_EPWM2_B,
         .Port_PinSignalName = (const sint8 *)"EPWM2_B",
         .Port_PinName        = (const sint8 *)"PIN_C1",
    },
    {
         .Port_PinId = 69,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_DEFAULT,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = FALSE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_DEFAULT,
         .Port_PinInitialMode =  PORT_PIN_MODE_EPWM3,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_EPWM3,

                .muxmode = 0,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PINE2_EPWM3_A,
         .Port_PinSignalName = (const sint8 *)"EPWM3_A",
         .Port_PinName        = (const sint8 *)"PIN_E2",
    },
    {
         .Port_PinId = 70,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_DEFAULT,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = FALSE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_DEFAULT,
         .Port_PinInitialMode =  PORT_PIN_MODE_EPWM3,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_EPWM3,

                .muxmode = 0,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PINE3_EPWM3_B,
         .Port_PinSignalName = (const sint8 *)"EPWM3_B",
         .Port_PinName        = (const sint8 *)"PIN_E3",
    },
    {
         .Port_PinId = 86,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_DEFAULT,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = FALSE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_DEFAULT,
         .Port_PinInitialMode =  PORT_PIN_MODE_EPWM8,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_EPWM8,

                .muxmode = 0,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PING3_EPWM8_A,
         .Port_PinSignalName = (const sint8 *)"EPWM8_A",
         .Port_PinName        = (const sint8 *)"PIN_G3",
    },
    {
         .Port_PinId = 92,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_DEFAULT,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = FALSE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_DEFAULT,
         .Port_PinInitialMode =  PORT_PIN_MODE_EPWM8,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_EPWM8,

                .muxmode = 0,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PINH2_EPWM8_B,
         .Port_PinSignalName = (const sint8 *)"EPWM8_B",
         .Port_PinName        = (const sint8 *)"PIN_H2",
    },
    {
         .Port_PinId = 109,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_DEFAULT,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = FALSE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_DEFAULT,
         .Port_PinInitialMode =  PORT_PIN_MODE_EPWM21,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_EPWM21,

                .muxmode = 5,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PINL17_PR0_MDIO0_MDIO,
         .Port_PinSignalName = (const sint8 *)"EPWM21_A",
         .Port_PinName        = (const sint8 *)"PIN_L17",
    },
    {
         .Port_PinId = 110,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_DEFAULT,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = FALSE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_DEFAULT,
         .Port_PinInitialMode =  PORT_PIN_MODE_EPWM21,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_EPWM21,

                .muxmode = 5,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PINL18_PR0_MDIO0_MDC,
         .Port_PinSignalName = (const sint8 *)"EPWM21_B",
         .Port_PinName        = (const sint8 *)"PIN_L18",
    },
    {
         .Port_PinId = 83,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_DEFAULT,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = FALSE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_DEFAULT,
         .Port_PinInitialMode =  PORT_PIN_MODE_EPWM22,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_EPWM22,

                .muxmode = 5,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PING17_PRU0_GIO5,
         .Port_PinSignalName = (const sint8 *)"EPWM22_A",
         .Port_PinName        = (const sint8 *)"PIN_G17",
    },
    {
         .Port_PinId = 75,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_DEFAULT,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = FALSE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_DEFAULT,
         .Port_PinInitialMode =  PORT_PIN_MODE_EPWM22,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_EPWM22,

                .muxmode = 5,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PINF17_PRU0_GIO9,
         .Port_PinSignalName = (const sint8 *)"EPWM22_B",
         .Port_PinName        = (const sint8 *)"PIN_F17",
    },
    {
         .Port_PinId = 84,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_DEFAULT,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = FALSE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_LOW,
         .Port_PinDirection = PORT_PIN_DEFAULT,
         .Port_PinInitialMode =  PORT_PIN_MODE_EPWM23,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_EPWM23,

                .muxmode = 5,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PING18_PRU0_GIO10,
         .Port_PinSignalName = (const sint8 *)"EPWM23_A",
         .Port_PinName        = (const sint8 *)"PIN_G18",
    },
    {
         .Port_PinId = 81,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_DEFAULT,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = FALSE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_DEFAULT,
         .Port_PinInitialMode =  PORT_PIN_MODE_EPWM23,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_EPWM23,

                .muxmode = 5,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PING15_PRU0_GIO8,
         .Port_PinSignalName = (const sint8 *)"EPWM23_B",
         .Port_PinName        = (const sint8 *)"PIN_G15",
    },
    {
         .Port_PinId = 73,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_DEFAULT,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = FALSE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_DEFAULT,
         .Port_PinInitialMode =  PORT_PIN_MODE_EPWM30,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_EPWM30,

                .muxmode = 5,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PINF15_PRU1_GIO5,
         .Port_PinSignalName = (const sint8 *)"EPWM30_A",
         .Port_PinName        = (const sint8 *)"PIN_F15",
    },
    {
         .Port_PinId = 44,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_DEFAULT,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = FALSE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_DEFAULT,
         .Port_PinInitialMode =  PORT_PIN_MODE_EPWM30,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_EPWM30,

                .muxmode = 5,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PINC18_PRU1_GIO9,
         .Port_PinSignalName = (const sint8 *)"EPWM30_B",
         .Port_PinName        = (const sint8 *)"PIN_C18",
    },
    {
         .Port_PinId = 58,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_DEFAULT,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = FALSE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_DEFAULT,
         .Port_PinInitialMode =  PORT_PIN_MODE_EPWM31,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_EPWM31,

                .muxmode = 5,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PIND17_PRU1_GIO10,
         .Port_PinSignalName = (const sint8 *)"EPWM31_A",
         .Port_PinName        = (const sint8 *)"PIN_D17",
    },
    {
         .Port_PinId = 59,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_DEFAULT,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = FALSE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_HIGH,
         .Port_PinDirection = PORT_PIN_DEFAULT,
         .Port_PinInitialMode =  PORT_PIN_MODE_EPWM31,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_DEFAULT,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_NONINV,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_SLOW_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_EPWM31,

                .muxmode = 5,
            },
         },
         .Port_PinDioRegId = PORT_DIO_INVALID_REG_ID, /* GPIO register index is 0 based */
         .Port_PinDioChannelId = PORT_DIO_INVALID_REG_ID,
         .Port_RegOffsetAddr = PIND18_PRU1_GIO8,
         .Port_PinSignalName = (const sint8 *)"EPWM31_B",
         .Port_PinName        = (const sint8 *)"PIN_D18",
    },
    {
         .Port_PinId = 52,
         .Port_PullInhibitEnable = PORT_PIN_PULL_INHIBIT_DISABLE,
         .Port_OutputOverride_Ctrl = PORT_PIN_OUTPUT_RETAIN_HW_CTRL,
         .Port_InputOverride_Ctrl = PORT_PIN_INPUT_RETAIN_HW_CTRL,
         .Port_DirectionChangeable = FALSE,
         .Port_PinModeChangeable = FALSE,
         .Port_PinLevelValue = PORT_PIN_LEVEL_LOW,
         .Port_PinDirection = PORT_PIN_OUT,
         .Port_PinInitialMode =  PORT_PIN_MODE_GPIOCD,
         .Port_PullTypeSelect = PORT_PIN_PULLTYPE_PULLDOWN,
         .Port_PinHSmasterEnable = FALSE,
         .Port_PinHSmodeEnable = FALSE,
         .Port_InversionSelect = PORT_INVTYPE_DEFAULT,
         .Port_QualifierTypeSelect = PORT_QUALTYPE_DEFAULT,
         .Port_SlewControl = PORT_PIN_SLEWCONTROL_FAST_SLEW,
         .Port_NumPortModes = 1,
         .Port_PinMode =
         {            [0] =
            {
                .mode = PORT_PIN_MODE_GPIOCD,

                .muxmode = 7,
            },
         },
         .Port_PinDioRegId = (2U - 1U), /* GPIO register index is 0 based */
         .Port_PinDioChannelId = 19,
         .Port_RegOffsetAddr = PIND1_EPWM4_A,
         .Port_PinSignalName = (const sint8 *)"GPIOCD_51",
         .Port_PinName        = (const sint8 *)"PIN_D1",
    },
};

/*<PORT_PIN_CONFIGURATION>*/
static CONST( Port_DioRegConfigType, PORT_PBCFG) PortConfigSet_0_DioConfig[ PORT_MAX_GPIO_INTR_CONFIG ] =
{
    [0] =
    {
         .Port_DioPinNumber = 21,
         .Port_PinSelectEdgeTrigger = PORT_RISING_EDGE,
         .Port_PinSelectInterruptType = PORT_BANK_INTR,
#if(PORT_ENABLE_INTR_API == STD_ON)
         .Port_DioInterruptNotification = (Port_IsrNotificationType) NULL_PTR,
#endif
    },
};

/*</PORT_PIN_CONFIGURATION>*/
CONST(Port_ConfigType, PORT_PBCFG) PortConfigSet_0 =
{
    .NumberOfPortPins = 127,
    .PinConfig_pt = PortConfigSet_0_PinConfig,
    .NumberOfGPIORegs = 1,
    .DioConfig_pt = PortConfigSet_0_DioConfig,
};

#define PORT_STOP_SEC_CONFIG_DATA
#include "Port_MemMap.h"


/**********************************************************************************************************************
 *  END OF FILE: Port_PBcfg.c                                                                                         *
 **********************************************************************************************************************/



