/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ctoolstrace.scripting;

import com.ti.ccstudio.scripting.environment.ScriptingException;
import com.ti.ctoolstrace.scripting.CToolsTraceChannelStatus;

public class CToolsTraceChannel {
    private String m_sReceiverName;
    private long m_cObjectIndex;
    private boolean m_bInitialized;
    private CToolsTraceChannelStatus m_receiverStatus;

    CToolsTraceChannel(String string) {
        this.m_sReceiverName = string;
        try {
            this.m_cObjectIndex = this.getTraceChannel(this.m_sReceiverName);
        }
        catch (ScriptingException scriptingException) {
            this.m_cObjectIndex = 0L;
            System.out.println(scriptingException.getMessage());
        }
        this.m_receiverStatus = new CToolsTraceChannelStatus();
    }

    public synchronized void addTraceTargets(String[] stringArray) throws ScriptingException {
        this.loadChannelCReference(this.m_cObjectIndex);
        this.addTraceSources(stringArray);
    }

    public synchronized void setupTraceChannel(String string) throws ScriptingException {
        this.loadChannelCReference(this.m_cObjectIndex);
        this.importProperties(string);
    }

    public synchronized void startTraceRecording() throws ScriptingException {
        this.loadChannelCReference(this.m_cObjectIndex);
        this.startRecording();
    }

    public synchronized void stopTraceRecording() throws ScriptingException {
        this.loadChannelCReference(this.m_cObjectIndex);
        this.stopRecording();
    }

    public synchronized CToolsTraceChannelStatus getStatus() throws ScriptingException {
        long l = 0L;
        try {
            l = this.getReceiverStatus();
        }
        catch (ScriptingException scriptingException) {
            System.out.println("getStatus error:" + scriptingException.getMessage());
            l = 0L;
        }
        catch (Exception exception) {
            System.out.println("Unknow getStatus error");
            l = 0L;
        }
        this.m_receiverStatus.updateStatus(l);
        return this.m_receiverStatus;
    }

    public synchronized void getBinaryTraceData(String string) throws ScriptingException {
        this.loadChannelCReference(this.m_cObjectIndex);
        this.getTraceData(string, 0, "", true);
    }

    public synchronized native String[] getColumnNames(boolean var1) throws ScriptingException;

    public synchronized native void setTextOutputColumns(String[] var1) throws ScriptingException;

    public synchronized void getTextTraceData(String string) throws ScriptingException {
        this.loadChannelCReference(this.m_cObjectIndex);
        this.getTraceData(string, 0, "", false);
    }

    public synchronized void getDecodedTraceData(String string, int n, String string2) throws ScriptingException {
        this.loadChannelCReference(this.m_cObjectIndex);
        this.getTraceData(string, n, string2, false);
    }

    private synchronized native long getTraceChannel(String var1) throws ScriptingException;

    private synchronized native void loadChannelCReference(long var1) throws ScriptingException;

    private synchronized native long getReceiverStatus() throws ScriptingException;

    private synchronized native void addTraceSources(String[] var1) throws ScriptingException;

    private synchronized native void importProperties(String var1) throws ScriptingException;

    private synchronized native void getTraceData(String var1, int var2, String var3, boolean var4) throws ScriptingException;

    private synchronized native void startRecording() throws ScriptingException;

    private synchronized native void stopRecording() throws ScriptingException;
}

