//*****************************************************************************
//
// blinky.c - Simple example to blink the on-board LED.
//
// Copyright (c) 2013-2015 Texas Instruments Incorporated.  All rights reserved.
// Software License Agreement
// 
// Texas Instruments (TI) is supplying this software for use solely and
// exclusively on TI's microcontroller products. The software is owned by
// TI and/or its suppliers, and is protected under applicable copyright
// laws. You may not combine this software with "viral" open-source
// software in order to form a larger program.
// 
// THIS SOFTWARE IS PROVIDED "AS IS" AND WITH ALL FAULTS.
// NO WARRANTIES, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT
// NOT LIMITED TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. TI SHALL NOT, UNDER ANY
// CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL, OR CONSEQUENTIAL
// DAMAGES, FOR ANY REASON WHATSOEVER.
// 
// This is part of revision 2.1.1.71 of the EK-TM4C1294XL Firmware Package.
//
//*****************************************************************************

#include <stdint.h>
#include <stdbool.h>
#include "inc/tm4c1294ncpdt.h"
#include "driverlib/sysctl.h"
#define SYSCTL_PERIPH_EPHY0     0xf0003000  // Ethernet PHY0

#ifndef EMAC_PHY_CONFIG
#define EMAC_PHY_CONFIG         (EMAC_PHY_TYPE_INTERNAL |                     \
                                 EMAC_PHY_INT_MDIX_EN |                       \
                                 EMAC_PHY_AN_100B_T_FULL_DUPLEX)
#endif

#define EMAC_PHY_TYPE_INTERNAL              0x00000000
#define EMAC_PHY_INT_MDIX_EN                0x00000400
#define EMAC_PHY_AN_100B_T_FULL_DUPLEX      0x0000000E
#define EMAC_PHY_TYPE_MASK                  0xC0000000

//*****************************************************************************
//
//! \addtogroup example_list
//! <h1>Blinky (blinky)</h1>
//!
//! A very simple example that blinks the on-board LED using direct register
//! access.
//
//*****************************************************************************

//*****************************************************************************
//
// Blink the on-board LED.
//
//*****************************************************************************
int
main(void)
{

	volatile uint32_t g_ui32SysClock;
    volatile uint32_t ui32Loop;

    //
    // Make sure the main oscillator is enabled because this is required by
    // the PHY.  The system must have a 25MHz crystal attached to the OSC
    // pins.  The SYSCTL_MOSC_HIGHFREQ parameter is used when the crystal
    // frequency is 10MHz or higher.
    //
    SysCtlMOSCConfigSet(SYSCTL_MOSC_HIGHFREQ);

    //
    // Run from the PLL at 120 MHz.
    //
    g_ui32SysClock = SysCtlClockFreqSet((SYSCTL_XTAL_25MHZ |
                                             SYSCTL_OSC_MAIN |
                                             SYSCTL_USE_PLL |
                                             SYSCTL_CFG_VCO_480), 120000000);


    //
    // Enable the GPIO port that is used for the on-board LED.
    //
    SYSCTL_RCGCGPIO_R = SYSCTL_RCGCGPIO_R12;

    //
    // Do a dummy read to insert a few cycles after enabling the peripheral.
    //
    ui32Loop = SYSCTL_RCGCGPIO_R;

    //
    // Enable the GPIO pin for the LED (PN0).  Set the direction as output, and
    // enable the GPIO pin for digital function.
    //
    GPIO_PORTN_DIR_R = 0x01;
    GPIO_PORTN_DEN_R = 0x01;

    //
    // Turn on the LED.
    //
    GPIO_PORTN_DATA_R |= 0x01;

    //
    // Delay for a bit.
    //
    for(ui32Loop = 0; ui32Loop < 200000; ui32Loop++)
    {
    }

    FLASH_CONF_R |= FLASH_CONF_FPFOFF;			//

    /*Ethernet MAC Initialization*/
    SYSCTL_RCGCEMAC_R |= 0x01;					//clock enable
    SYSCTL_SREMAC_R  |= 0x01;					//software reset
    while (1 == (0x01 & SYSCTL_PREMAC_R));		//wait until reset
    SYSCTL_SREMAC_R &= ~0x01;					//software reset off
    while (0 == (0x01 & SYSCTL_PREMAC_R));		//wait until access ready

    /*Ethernet PHY Initialization*/
    SYSCTL_RCGCEPHY_R |= 0x01;
    SYSCTL_SREPHY_R |= 0x01;
    while (1 == (0x01 & SYSCTL_PREPHY_R));
    SYSCTL_SREPHY_R &= ~0x01;
    while (0 == (0x01 & SYSCTL_PREPHY_R));


    //
    // Turn off the LED.
    //
    GPIO_PORTN_DATA_R &= ~(0x01);

    //
    // Delay for a bit.
    //
    for(ui32Loop = 0; ui32Loop < 200000; ui32Loop++)
    {
    }

    SysCtlReset();

}
