//*****************************************************************************
//
// usb_mouse_structs.h - Data structures defining the mouse USB device.
//
// Copyright (c) 2013-2020 Texas Instruments Incorporated.  All rights reserved.
// Software License Agreement
// 
// Texas Instruments (TI) is supplying this software for use solely and
// exclusively on TI's microcontroller products. The software is owned by
// TI and/or its suppliers, and is protected under applicable copyright
// laws. You may not combine this software with "viral" open-source
// software in order to form a larger program.
// 
// THIS SOFTWARE IS PROVIDED "AS IS" AND WITH ALL FAULTS.
// NO WARRANTIES, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT
// NOT LIMITED TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. TI SHALL NOT, UNDER ANY
// CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL, OR CONSEQUENTIAL
// DAMAGES, FOR ANY REASON WHATSOEVER.
// 
// This is part of revision 2.2.0.295 of the EK-TM4C1294XL Firmware Package.
//
//*****************************************************************************

#ifndef __USB_HIDDFU_STRUCTS_H__
#define __USB_HIDDFU_STRUCTS_H__

extern uint32_t MouseHandler(void *pvCBData, uint32_t ui32Event,
                             uint32_t ui32MsgData, void *pvMsgData);
extern uint32_t DFUDetachCallback(void *pvCBData, uint32_t ui32Event,
                                  uint32_t ui32MsgData, void *pvMsgData);

extern tUSBDHIDMouseDevice g_sMouseDevice;
extern tUSBDDFUDevice g_sDFUDevice;
extern tUSBDCompositeDevice g_sCompDevice;

#define DESCRIPTOR_BUFFER_SIZE  (COMPOSITE_DDFU_SIZE + COMPOSITE_DHID_SIZE)
extern uint8_t g_pui8DescriptorBuffer[];

#endif // __USB_HIDDFU_STRUCTS_H__
