;-------------------------------------------------------------------------------
 ;  Copyright (C) 2023 Texas Instruments Incorporated
 ;
 ;  Redistribution and use in source and binary forms, with or without
 ;  modification, are permitted provided that the following conditions
 ;  are met:
 ;
 ;    Redistributions of source code must retain the above copyright
 ;    notice, this list of conditions and the following disclaimer.
 ;
 ;    Redistributions in binary form must reproduce the above copyright
 ;    notice, this list of conditions and the following disclaimer in the
 ;    documentation and/or other materials provided with the
 ;    distribution.
 ;
 ;    Neither the name of Texas Instruments Incorporated nor the names of
 ;    its contributors may be used to endorse or promote products derived
 ;    from this software without specific prior written permission.
 ;
 ;  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 ;  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 ;  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 ;  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 ;  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 ;  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 ;  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 ;  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 ;  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 ;  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 ;  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
;-------------------------------------------------------------------------------

        .text

; FUNCTION DEF: uint32 CycleCounterP_getCount32(void) 
        .global CycleCounterP_getCount32
        .sect ".text.pmu"
        .arm
        .align 2
CycleCounterP_getCount32:
        mrc     p15, #0, r0, c9, c13, #0  ; read PMCCNTR
        bx      LR

; FUNCTION DEF: void PmuP_setup(uint32) 
        .global PmuP_setup
        .sect ".text.pmu"
        .arm
        .align 2
PmuP_setup:
        mcr     p15, #0, r0, c9, c12, #0 ; write Pmcr
        bx      LR

; FUNCTION DEF: void PmuP_enableCounters(uint32) 
        .global PmuP_enableCounters
        .sect ".text.pmu"
        .arm
        .align 2
PmuP_enableCounters:
        mcr     p15, #0, r0, c9, c12, #1  ; write PMCNTENSET
        bx      LR

; FUNCTION DEF: void PmuP_disableCounters(uint32) 
        .global PmuP_disableCounters
        .sect ".text.pmu"
        .arm
        .align 2
PmuP_disableCounters:
        mcr     p15, #0, r0, c9, c12, #2  ; write PMCNTENCLR
        bx      LR

; FUNCTION DEF: uint32 PmuP_getOverflowStatus(void) 
        .global PmuP_getOverflowStatus
        .sect ".text.pmu"
        .arm
        .align 2
PmuP_getOverflowStatus:
        mrc     p15, #0, r0, c9, c12, #3  ; read PMOVSR
        bx      LR

; FUNCTION DEF: uint32 PmuP_clearOverflowStatus(void) 
        .global PmuP_clearOverflowStatus
        .sect ".text.pmu"
        .arm
        .align 2
PmuP_clearOverflowStatus:
        mcr     p15, #0, r0, c9, c12, #3  ; write PMOVSR
        bx      LR

	.end

