/* ======================================================================
*   Copyright (C) 2023 Texas Instruments Incorporated
*
*   All rights reserved. Property of Texas Instruments Incorporated.
*   Restricted rights to use, duplicate or disclose this code are
*   granted through contract.
*
*   The program may not be used without the written permission
*   of Texas Instruments Incorporated or against the terms and conditions
*   stipulated in the agreement under which this program has been
*   supplied.
* ==================================================================== */
 /***************************************************************************
  Project: AM263P_CAN
  Date   : 2023-12-13 15:29:36

  This file is generated by EB Tresos
  Do not modify this file, otherwise the software may behave in unexpected way.

 *****************************************************************************/

/*
 * Module switch
 */
/**********************************************************************************************************************
 *  INCLUDES
 *********************************************************************************************************************/
 #include "Can.h"
 #include "Can_Cfg.h"

/**********************************************************************************************************************
 *  VERSION CHECK
 *********************************************************************************************************************/

/** \brief Can configuration Major Version */
#define CAN_CFG_C_MAJOR_VERSION           (10U)
/** \brief Can configuration Minor Version */
#define CAN_CFG_C_MINOR_VERSION           (1U)
/** \brief Can configuration Patch Version */
#define CAN_CFG_C_PATCH_VERSION           (0U)

/*  Version checking  */
 #if (   (CAN_SW_MAJOR_VERSION != (10U))||(CAN_SW_MINOR_VERSION != (1U)))
  #error "Version numbers of Can_Cfg.c and Can.h are inconsistent!"
#endif
#if (   (CAN_CFG_MAJOR_VERSION != (10U))||(CAN_CFG_MINOR_VERSION != (1U)))
  #error "Version numbers of Can_Cfg.c and Can_Cfg.h are inconsistent!"
#endif
/**********************************************************************************************************************
 *  GLOBAL DATA
 *********************************************************************************************************************/
#define CAN_START_SEC_CONFIG_DATA
#include "Can_MemMap.h"



/* Controller structure defined here for all config sets */


const struct Can_ControllerStruct_PC
    CanConfigSet_PC_CanController_0 =
{
    CanConf_CanController_CanController_0,      /* Id as provided by GUI */
    (boolean)TRUE,   /* Contoller is used=1 or not_used=0*/
    0x52600000U, /* Can Controller Base Address */
							(boolean)FALSE,    /* Automatic wakeup via bus activity */
    CAN_TX_RX_PROCESSING_MIXED,  /* Can Rx Processing Type */
    CAN_TX_RX_PROCESSING_MIXED,  /* Can Tx Processing Type */
    (boolean)FALSE,/* BusOff  TRUE = Interrupt FALSE = Polling */
	(boolean)TRUE,    /* TRUE = Interrupt FALSE = Polling */
	(boolean)TRUE,    /* Auto retransmission on Tx error Enable/Disable */
	NULL_PTR,
	    CAN_CONTROLLER_INSTANCE_MCAN0,  /* Controller Instance */
};
const struct Can_ControllerStruct_PC
    CanConfigSet_PC_CanController_1 =
{
    CanConf_CanController_CanController_1,      /* Id as provided by GUI */
    (boolean)TRUE,   /* Contoller is used=1 or not_used=0*/
    0x52610000U, /* Can Controller Base Address */
							(boolean)FALSE,    /* Automatic wakeup via bus activity */
    CAN_TX_RX_PROCESSING_MIXED,  /* Can Rx Processing Type */
    CAN_TX_RX_PROCESSING_MIXED,  /* Can Tx Processing Type */
    (boolean)FALSE,/* BusOff  TRUE = Interrupt FALSE = Polling */
	(boolean)FALSE,    /* TRUE = Interrupt FALSE = Polling */
	(boolean)TRUE,    /* Auto retransmission on Tx error Enable/Disable */
	NULL_PTR,
	    CAN_CONTROLLER_INSTANCE_MCAN1,  /* Controller Instance */
};
const struct Can_ControllerStruct_PC
    CanConfigSet_PC_CanController_2 =
{
    CanConf_CanController_CanController_2,      /* Id as provided by GUI */
    (boolean)TRUE,   /* Contoller is used=1 or not_used=0*/
    0x52620000U, /* Can Controller Base Address */
							(boolean)FALSE,    /* Automatic wakeup via bus activity */
    CAN_TX_RX_PROCESSING_MIXED,  /* Can Rx Processing Type */
    CAN_TX_RX_PROCESSING_MIXED,  /* Can Tx Processing Type */
    (boolean)FALSE,/* BusOff  TRUE = Interrupt FALSE = Polling */
	(boolean)FALSE,    /* TRUE = Interrupt FALSE = Polling */
	(boolean)TRUE,    /* Auto retransmission on Tx error Enable/Disable */
	NULL_PTR,
	    CAN_CONTROLLER_INSTANCE_MCAN2,  /* Controller Instance */
};
const struct Can_ControllerStruct_PC
    CanConfigSet_PC_CanController_3 =
{
    CanConf_CanController_CanController_3,      /* Id as provided by GUI */
    (boolean)TRUE,   /* Contoller is used=1 or not_used=0*/
    0x52630000U, /* Can Controller Base Address */
							(boolean)FALSE,    /* Automatic wakeup via bus activity */
    CAN_TX_RX_PROCESSING_MIXED,  /* Can Rx Processing Type */
    CAN_TX_RX_PROCESSING_MIXED,  /* Can Tx Processing Type */
    (boolean)FALSE,/* BusOff  TRUE = Interrupt FALSE = Polling */
	(boolean)FALSE,    /* TRUE = Interrupt FALSE = Polling */
	(boolean)TRUE,    /* Auto retransmission on Tx error Enable/Disable */
	NULL_PTR,
	    CAN_CONTROLLER_INSTANCE_MCAN3,  /* Controller Instance */
};
const struct Can_ControllerStruct_PC
    CanConfigSet_PC_CanController_4 =
{
    CanConf_CanController_CanController_4,      /* Id as provided by GUI */
    (boolean)TRUE,   /* Contoller is used=1 or not_used=0*/
    0x52640000U, /* Can Controller Base Address */
							(boolean)FALSE,    /* Automatic wakeup via bus activity */
    CAN_TX_RX_PROCESSING_MIXED,  /* Can Rx Processing Type */
    CAN_TX_RX_PROCESSING_MIXED,  /* Can Tx Processing Type */
    (boolean)FALSE,/* BusOff  TRUE = Interrupt FALSE = Polling */
	(boolean)FALSE,    /* TRUE = Interrupt FALSE = Polling */
	(boolean)TRUE,    /* Auto retransmission on Tx error Enable/Disable */
	NULL_PTR,
	    CAN_CONTROLLER_INSTANCE_MCAN4,  /* Controller Instance */
};



const struct Can_ControllerStruct_PC
    *CanConfigSet_CanController_List_PC[CAN_NUM_CONTROLLER]=
{
    &CanConfigSet_PC_CanController_0,
    &CanConfigSet_PC_CanController_1,
    &CanConfigSet_PC_CanController_2,
    &CanConfigSet_PC_CanController_3,
    &CanConfigSet_PC_CanController_4,
};



/* All the Mailbox objects(MB's) will be defined here for all config sets */
static const struct Can_MailboxStruct_PC
    CanConfigSet_PC_CanHardwareObject_0 =
{
    CanConf_CanHardwareObject_CanHardwareObject_0,  /* CanObjectId - Holds handle Id */
};
static const struct Can_MailboxStruct_PC
    CanConfigSet_PC_CanHardwareObject_1 =
{
    CanConf_CanHardwareObject_CanHardwareObject_1,  /* CanObjectId - Holds handle Id */
};
static const struct Can_MailboxStruct_PC
    CanConfigSet_PC_CanHardwareObject_2 =
{
    CanConf_CanHardwareObject_CanHardwareObject_2,  /* CanObjectId - Holds handle Id */
};
static const struct Can_MailboxStruct_PC
    CanConfigSet_PC_CanHardwareObject_3 =
{
    CanConf_CanHardwareObject_CanHardwareObject_3,  /* CanObjectId - Holds handle Id */
};
static const struct Can_MailboxStruct_PC
    CanConfigSet_PC_CanHardwareObject_4 =
{
    CanConf_CanHardwareObject_CanHardwareObject_4,  /* CanObjectId - Holds handle Id */
};
static const struct Can_MailboxStruct_PC
    CanConfigSet_PC_CanHardwareObject_5 =
{
    CanConf_CanHardwareObject_CanHardwareObject_5,  /* CanObjectId - Holds handle Id */
};
static const struct Can_MailboxStruct_PC
    CanConfigSet_PC_CanHardwareObject_6 =
{
    CanConf_CanHardwareObject_CanHardwareObject_6,  /* CanObjectId - Holds handle Id */
};
static const struct Can_MailboxStruct_PC
    CanConfigSet_PC_CanHardwareObject_7 =
{
    CanConf_CanHardwareObject_CanHardwareObject_7,  /* CanObjectId - Holds handle Id */
};
static const struct Can_MailboxStruct_PC
    CanConfigSet_PC_CanHardwareObject_8 =
{
    CanConf_CanHardwareObject_CanHardwareObject_8,  /* CanObjectId - Holds handle Id */
};
static const struct Can_MailboxStruct_PC
    CanConfigSet_PC_CanHardwareObject_9 =
{
    CanConf_CanHardwareObject_CanHardwareObject_9,  /* CanObjectId - Holds handle Id */
};
static const struct Can_MailboxStruct_PC
    CanConfigSet_PC_CanHardwareObject_10 =
{
    CanConf_CanHardwareObject_CanHardwareObject_10,  /* CanObjectId - Holds handle Id */
};
static const struct Can_MailboxStruct_PC
    CanConfigSet_PC_CanHardwareObject_11 =
{
    CanConf_CanHardwareObject_CanHardwareObject_11,  /* CanObjectId - Holds handle Id */
};
static const struct Can_MailboxStruct_PC
    CanConfigSet_PC_CanHardwareObject_12 =
{
    CanConf_CanHardwareObject_CanHardwareObject_12,  /* CanObjectId - Holds handle Id */
};
static const struct Can_MailboxStruct_PC
    CanConfigSet_PC_CanHardwareObject_13 =
{
    CanConf_CanHardwareObject_CanHardwareObject_13,  /* CanObjectId - Holds handle Id */
};
static const struct Can_MailboxStruct_PC
    CanConfigSet_PC_CanHardwareObject_14 =
{
    CanConf_CanHardwareObject_CanHardwareObject_14,  /* CanObjectId - Holds handle Id */
};
static const struct Can_MailboxStruct_PC
    CanConfigSet_PC_CanHardwareObject_15 =
{
    CanConf_CanHardwareObject_CanHardwareObject_15,  /* CanObjectId - Holds handle Id */
};
static const struct Can_MailboxStruct_PC
    CanConfigSet_PC_CanHardwareObject_16 =
{
    CanConf_CanHardwareObject_CanHardwareObject_16,  /* CanObjectId - Holds handle Id */
};
static const struct Can_MailboxStruct_PC
    CanConfigSet_PC_CanHardwareObject_17 =
{
    CanConf_CanHardwareObject_CanHardwareObject_17,  /* CanObjectId - Holds handle Id */
};
static const struct Can_MailboxStruct_PC
    CanConfigSet_PC_CanHardwareObject_18 =
{
    CanConf_CanHardwareObject_CanHardwareObject_18,  /* CanObjectId - Holds handle Id */
};
static const struct Can_MailboxStruct_PC
    CanConfigSet_PC_CanHardwareObject_19 =
{
    CanConf_CanHardwareObject_CanHardwareObject_19,  /* CanObjectId - Holds handle Id */
};


/* List of the Mailboxes */
const struct Can_MailboxStruct_PC
    *CanConfigSet_CanHardwareObject_List_PC[CAN_NUM_MAILBOXES] =
{
    &CanConfigSet_PC_CanHardwareObject_0,
    &CanConfigSet_PC_CanHardwareObject_1,
    &CanConfigSet_PC_CanHardwareObject_2,
    &CanConfigSet_PC_CanHardwareObject_3,
    &CanConfigSet_PC_CanHardwareObject_4,
    &CanConfigSet_PC_CanHardwareObject_5,
    &CanConfigSet_PC_CanHardwareObject_6,
    &CanConfigSet_PC_CanHardwareObject_7,
    &CanConfigSet_PC_CanHardwareObject_8,
    &CanConfigSet_PC_CanHardwareObject_9,
    &CanConfigSet_PC_CanHardwareObject_10,
    &CanConfigSet_PC_CanHardwareObject_11,
    &CanConfigSet_PC_CanHardwareObject_12,
    &CanConfigSet_PC_CanHardwareObject_13,
    &CanConfigSet_PC_CanHardwareObject_14,
    &CanConfigSet_PC_CanHardwareObject_15,
    &CanConfigSet_PC_CanHardwareObject_16,
    &CanConfigSet_PC_CanHardwareObject_17,
    &CanConfigSet_PC_CanHardwareObject_18,
    &CanConfigSet_PC_CanHardwareObject_19,
};


#define  CAN_STOP_SEC_CONFIG_DATA
#include "Can_MemMap.h"

/*******************************************************************************
 *  End of File: Can_Cfg.c
 ******************************************************************************/
