/* ======================================================================
*   Copyright (C) 2023 Texas Instruments Incorporated
*
*   All rights reserved. Property of Texas Instruments Incorporated.
*   Restricted rights to use, duplicate or disclose this code are
*   granted through contract.
*
*   The program may not be used without the written permission
*   of Texas Instruments Incorporated or against the terms and conditions
*   stipulated in the agreement under which this program has been
*   supplied.
* ==================================================================== */
 /***************************************************************************
  Project: AM263P_CAN
  Date   : 2023-12-13 15:29:36

  This file is generated by EB Tresos
  Do not modify this file, otherwise the software may behave in unexpected way.

 *****************************************************************************/

/*
 * Module switch
 */
#define CAN_PBCFG_SOURCE
/**********************************************************************************************************************
 *  INCLUDES
 *********************************************************************************************************************/
 #include "Can.h"
 #include "Can_Cfg.h"

/**********************************************************************************************************************
 *  VERSION CHECK
 *********************************************************************************************************************/

/** \brief Can configuration Major Version */
#define CAN_PBCFG_C_MAJOR_VERSION           (10U)
/** \brief Can configuration Minor Version */
#define CAN_PBCFG_C_MINOR_VERSION           (1U)
/** \brief Can configuration Patch Version */
#define CAN_PBCFG_C_PATCH_VERSION           (0U)

/*  Version checking  */
 #if (   (CAN_SW_MAJOR_VERSION != (10U))||(CAN_SW_MINOR_VERSION != (1U)))
  #error "Version numbers of Can_PBcfg.c and Can.h are inconsistent!"
#endif
#if (   (CAN_CFG_MAJOR_VERSION != (10U))||(CAN_CFG_MINOR_VERSION != (1U)))
  #error "Version numbers of Can_PBcfg.c and Can_Cfg.h are inconsistent!"
#endif
/**********************************************************************************************************************
 *  GLOBAL DATA
 *********************************************************************************************************************/
#define CAN_START_SEC_CONFIG_DATA
#include "Can_MemMap.h"




/* Baud Rate Structure for all configsets */
static Can_BaudConfigType
    CanConfigSet_CanController_0_CanControllerBaudrateConfig_0 =
{
    1000U,      /* in Kbps */
    20U,       /* Prop Segement value */
    14U,          /* Phase Segment 1 */
    5U,          /* Phase Segment 2 */
    1U, /* Sync jump width */
    40U, /* Sum of all timing parameters */
    2U,   /* Controller BRP value for Baud */
	 /* Data phase Baudrate */
    {
        5000U,     /* in Kbps */
        3U,        /* Prop Segement value */
        3U,           /* Phase Segment 1 */
        1U,           /* Phase Segment 2 */
        1U,  /* Sync jump width */
        8U, /* Sum of all timing parameters */
        2U,   /* Controller BRP value for Baud */
        14U, /* Specifies the Transceiver Delay Compensation Offset */
        (boolean)TRUE, /* Specifies if the bit rate switching shall be used */
    }
};
static Can_BaudConfigType
    CanConfigSet_CanController_1_CanControllerBaudrateConfig_0 =
{
    1000U,      /* in Kbps */
    20U,       /* Prop Segement value */
    14U,          /* Phase Segment 1 */
    5U,          /* Phase Segment 2 */
    1U, /* Sync jump width */
    40U, /* Sum of all timing parameters */
    2U,   /* Controller BRP value for Baud */
	 /* Data phase Baudrate */
    {
        5000U,     /* in Kbps */
        3U,        /* Prop Segement value */
        3U,           /* Phase Segment 1 */
        1U,           /* Phase Segment 2 */
        1U,  /* Sync jump width */
        8U, /* Sum of all timing parameters */
        2U,   /* Controller BRP value for Baud */
        14U, /* Specifies the Transceiver Delay Compensation Offset */
        (boolean)TRUE, /* Specifies if the bit rate switching shall be used */
    }
};
static Can_BaudConfigType
    CanConfigSet_CanController_2_CanControllerBaudrateConfig_0 =
{
    500U,      /* in Kbps */
    20U,       /* Prop Segement value */
    14U,          /* Phase Segment 1 */
    5U,          /* Phase Segment 2 */
    1U, /* Sync jump width */
    40U, /* Sum of all timing parameters */
    4U,   /* Controller BRP value for Baud */
	 /* Data phase Baudrate */
    {
        2500U,     /* in Kbps */
        3U,        /* Prop Segement value */
        3U,           /* Phase Segment 1 */
        1U,           /* Phase Segment 2 */
        1U,  /* Sync jump width */
        8U, /* Sum of all timing parameters */
        4U,   /* Controller BRP value for Baud */
        14U, /* Specifies the Transceiver Delay Compensation Offset */
        (boolean)TRUE, /* Specifies if the bit rate switching shall be used */
    }
};
static Can_BaudConfigType
    CanConfigSet_CanController_3_CanControllerBaudrateConfig_0 =
{
    500U,      /* in Kbps */
    20U,       /* Prop Segement value */
    14U,          /* Phase Segment 1 */
    5U,          /* Phase Segment 2 */
    1U, /* Sync jump width */
    40U, /* Sum of all timing parameters */
    4U,   /* Controller BRP value for Baud */
	 /* Data phase Baudrate */
    {
        2500U,     /* in Kbps */
        3U,        /* Prop Segement value */
        3U,           /* Phase Segment 1 */
        1U,           /* Phase Segment 2 */
        1U,  /* Sync jump width */
        8U, /* Sum of all timing parameters */
        4U,   /* Controller BRP value for Baud */
        14U, /* Specifies the Transceiver Delay Compensation Offset */
        (boolean)TRUE, /* Specifies if the bit rate switching shall be used */
    }
};
static Can_BaudConfigType
    CanConfigSet_CanController_4_CanControllerBaudrateConfig_0 =
{
    1000U,      /* in Kbps */
    20U,       /* Prop Segement value */
    14U,          /* Phase Segment 1 */
    5U,          /* Phase Segment 2 */
    1U, /* Sync jump width */
    40U, /* Sum of all timing parameters */
    2U,   /* Controller BRP value for Baud */
	 /* Data phase Baudrate */
    {
        5000U,     /* in Kbps */
        3U,        /* Prop Segement value */
        3U,           /* Phase Segment 1 */
        1U,           /* Phase Segment 2 */
        1U,  /* Sync jump width */
        8U, /* Sum of all timing parameters */
        2U,   /* Controller BRP value for Baud */
        14U, /* Specifies the Transceiver Delay Compensation Offset */
        (boolean)TRUE, /* Specifies if the bit rate switching shall be used */
    }
};

/*List of the Baudrate structures */
static Can_BaudConfigType
    *CanConfigSet_CanController_0_BaudRateConfigList[]=
{
    &CanConfigSet_CanController_0_CanControllerBaudrateConfig_0,
};

static Can_BaudConfigType
    *CanConfigSet_CanController_1_BaudRateConfigList[]=
{
    &CanConfigSet_CanController_1_CanControllerBaudrateConfig_0,
};

static Can_BaudConfigType
    *CanConfigSet_CanController_2_BaudRateConfigList[]=
{
    &CanConfigSet_CanController_2_CanControllerBaudrateConfig_0,
};

static Can_BaudConfigType
    *CanConfigSet_CanController_3_BaudRateConfigList[]=
{
    &CanConfigSet_CanController_3_CanControllerBaudrateConfig_0,
};

static Can_BaudConfigType
    *CanConfigSet_CanController_4_BaudRateConfigList[]=
{
    &CanConfigSet_CanController_4_CanControllerBaudrateConfig_0,
};


/* Controller structure defined here for all config sets */
static Can_ControllerType
    CanConfigSet_CanController_0 =
{
    &CanConfigSet_CanController_0_CanControllerBaudrateConfig_0,  /* pointer to default Baud structure */
    CanConfigSet_CanController_0_BaudRateConfigList,  /* List of available Baudrate structs */
};
static Can_ControllerType
    CanConfigSet_CanController_1 =
{
    &CanConfigSet_CanController_1_CanControllerBaudrateConfig_0,  /* pointer to default Baud structure */
    CanConfigSet_CanController_1_BaudRateConfigList,  /* List of available Baudrate structs */
};
static Can_ControllerType
    CanConfigSet_CanController_2 =
{
    &CanConfigSet_CanController_2_CanControllerBaudrateConfig_0,  /* pointer to default Baud structure */
    CanConfigSet_CanController_2_BaudRateConfigList,  /* List of available Baudrate structs */
};
static Can_ControllerType
    CanConfigSet_CanController_3 =
{
    &CanConfigSet_CanController_3_CanControllerBaudrateConfig_0,  /* pointer to default Baud structure */
    CanConfigSet_CanController_3_BaudRateConfigList,  /* List of available Baudrate structs */
};
static Can_ControllerType
    CanConfigSet_CanController_4 =
{
    &CanConfigSet_CanController_4_CanControllerBaudrateConfig_0,  /* pointer to default Baud structure */
    CanConfigSet_CanController_4_BaudRateConfigList,  /* List of available Baudrate structs */
};

/*List of the Controller structures */
static Can_ControllerType
    *CanConfigSet_CanController_List[]=
{
    &CanConfigSet_CanController_0,
    &CanConfigSet_CanController_1,
    &CanConfigSet_CanController_2,
    &CanConfigSet_CanController_3,
    &CanConfigSet_CanController_4,
};


static Can_HwFilterType
    CanConfigSet_CanHardwareObject_8_CanHwFilter_0 =
{
    193U,  /*CanHwFilterCode*/
    4294967295U,  /*Filter Mask*/
};
static Can_HwFilterType
    CanConfigSet_CanHardwareObject_9_CanHwFilter_0 =
{
    194U,  /*CanHwFilterCode*/
    4294967295U,  /*Filter Mask*/
};
static Can_HwFilterType
    CanConfigSet_CanHardwareObject_9_CanHwFilter_1 =
{
    195U,  /*CanHwFilterCode*/
    4294967295U,  /*Filter Mask*/
};
static Can_HwFilterType
    CanConfigSet_CanHardwareObject_10_CanHwFilter_0 =
{
    190U,  /*CanHwFilterCode*/
    4294967295U,  /*Filter Mask*/
};
static Can_HwFilterType
    CanConfigSet_CanHardwareObject_10_CanHwFilter_1 =
{
    193U,  /*CanHwFilterCode*/
    4294967295U,  /*Filter Mask*/
};
static Can_HwFilterType
    CanConfigSet_CanHardwareObject_11_CanHwFilter_0 =
{
    192U,  /*CanHwFilterCode*/
    4294967295U,  /*Filter Mask*/
};
static Can_HwFilterType
    CanConfigSet_CanHardwareObject_11_CanHwFilter_1 =
{
    64U,  /*CanHwFilterCode*/
    4294967295U,  /*Filter Mask*/
};
static Can_HwFilterType
    CanConfigSet_CanHardwareObject_12_CanHwFilter_0 =
{
    193U,  /*CanHwFilterCode*/
    4294967295U,  /*Filter Mask*/
};
static Can_HwFilterType
    CanConfigSet_CanHardwareObject_13_CanHwFilter_0 =
{
    192U,  /*CanHwFilterCode*/
    4294967295U,  /*Filter Mask*/
};
static Can_HwFilterType
    CanConfigSet_CanHardwareObject_14_CanHwFilter_0 =
{
    193U,  /*CanHwFilterCode*/
    4294967295U,  /*Filter Mask*/
};
static Can_HwFilterType
    CanConfigSet_CanHardwareObject_14_CanHwFilter_1 =
{
    65U,  /*CanHwFilterCode*/
    4294967295U,  /*Filter Mask*/
};
static Can_HwFilterType
    CanConfigSet_CanHardwareObject_15_CanHwFilter_0 =
{
    192U,  /*CanHwFilterCode*/
    4294967295U,  /*Filter Mask*/
};
static Can_HwFilterType
    CanConfigSet_CanHardwareObject_18_CanHwFilter_0 =
{
    190U,  /*CanHwFilterCode*/
    4294967295U,  /*Filter Mask*/
};
static Can_HwFilterType
    CanConfigSet_CanHardwareObject_18_CanHwFilter_1 =
{
    193U,  /*CanHwFilterCode*/
    4294967295U,  /*Filter Mask*/
};
static Can_HwFilterType
    CanConfigSet_CanHardwareObject_19_CanHwFilter_0 =
{
    192U,  /*CanHwFilterCode*/
    4294967295U,  /*Filter Mask*/
};
static Can_HwFilterType
    CanConfigSet_CanHardwareObject_19_CanHwFilter_1 =
{
    64U,  /*CanHwFilterCode*/
    4294967295U,  /*Filter Mask*/
};

static Can_HwFilterType
    *CanConfigSet_CanHardwareObject_8_HwFilterConfigList[]=
{
    &CanConfigSet_CanHardwareObject_8_CanHwFilter_0,
};
static Can_HwFilterType
    *CanConfigSet_CanHardwareObject_9_HwFilterConfigList[]=
{
    &CanConfigSet_CanHardwareObject_9_CanHwFilter_0,
    &CanConfigSet_CanHardwareObject_9_CanHwFilter_1,
};
static Can_HwFilterType
    *CanConfigSet_CanHardwareObject_10_HwFilterConfigList[]=
{
    &CanConfigSet_CanHardwareObject_10_CanHwFilter_0,
    &CanConfigSet_CanHardwareObject_10_CanHwFilter_1,
};
static Can_HwFilterType
    *CanConfigSet_CanHardwareObject_11_HwFilterConfigList[]=
{
    &CanConfigSet_CanHardwareObject_11_CanHwFilter_0,
    &CanConfigSet_CanHardwareObject_11_CanHwFilter_1,
};
static Can_HwFilterType
    *CanConfigSet_CanHardwareObject_12_HwFilterConfigList[]=
{
    &CanConfigSet_CanHardwareObject_12_CanHwFilter_0,
};
static Can_HwFilterType
    *CanConfigSet_CanHardwareObject_13_HwFilterConfigList[]=
{
    &CanConfigSet_CanHardwareObject_13_CanHwFilter_0,
};
static Can_HwFilterType
    *CanConfigSet_CanHardwareObject_14_HwFilterConfigList[]=
{
    &CanConfigSet_CanHardwareObject_14_CanHwFilter_0,
    &CanConfigSet_CanHardwareObject_14_CanHwFilter_1,
};
static Can_HwFilterType
    *CanConfigSet_CanHardwareObject_15_HwFilterConfigList[]=
{
    &CanConfigSet_CanHardwareObject_15_CanHwFilter_0,
};
static Can_HwFilterType
    *CanConfigSet_CanHardwareObject_18_HwFilterConfigList[]=
{
    &CanConfigSet_CanHardwareObject_18_CanHwFilter_0,
    &CanConfigSet_CanHardwareObject_18_CanHwFilter_1,
};
static Can_HwFilterType
    *CanConfigSet_CanHardwareObject_19_HwFilterConfigList[]=
{
    &CanConfigSet_CanHardwareObject_19_CanHwFilter_0,
    &CanConfigSet_CanHardwareObject_19_CanHwFilter_1,
};
/* All the Mailbox objects(MB's) will be defined here for all config sets */
                        
static Can_MailboxType
    CanConfigSet_CanHardwareObject_0 =
{
    0U,  /*  CanHandleType 0=Full, 1=Basic */
    2U,  /* CanIdType 0=standard 1=Extended 2=Mixed*/
    0U,  /* HwHandle i.e Mailbox - Hw object in the controller */
    1U,   /* Length of the Mailbox */
    CAN_MAILBOX_DIRECTION_TX,  /* CanObjectType - Direction of Mailbox*/
    &CanConfigSet_PC_CanController_0,  /* Controller */
    NULL_PTR,  /* List of HW Filter structs */
    0U,   /* Hw Filter Count */
    204U,   /* Padding value for CAN FD message */
    (boolean)TRUE,  /* CanHardwareObjectUsesPolling */
    (boolean)FALSE,  /* CanTriggerTransmitEnable */
	};

static Can_MailboxType
    CanConfigSet_CanHardwareObject_1 =
{
    0U,  /*  CanHandleType 0=Full, 1=Basic */
    2U,  /* CanIdType 0=standard 1=Extended 2=Mixed*/
    1U,  /* HwHandle i.e Mailbox - Hw object in the controller */
    1U,   /* Length of the Mailbox */
    CAN_MAILBOX_DIRECTION_TX,  /* CanObjectType - Direction of Mailbox*/
    &CanConfigSet_PC_CanController_0,  /* Controller */
    NULL_PTR,  /* List of HW Filter structs */
    0U,   /* Hw Filter Count */
    204U,   /* Padding value for CAN FD message */
    (boolean)FALSE,  /* CanHardwareObjectUsesPolling */
    (boolean)FALSE,  /* CanTriggerTransmitEnable */
	};

static Can_MailboxType
    CanConfigSet_CanHardwareObject_2 =
{
    0U,  /*  CanHandleType 0=Full, 1=Basic */
    2U,  /* CanIdType 0=standard 1=Extended 2=Mixed*/
    2U,  /* HwHandle i.e Mailbox - Hw object in the controller */
    3U,   /* Length of the Mailbox */
    CAN_MAILBOX_DIRECTION_TX,  /* CanObjectType - Direction of Mailbox*/
    &CanConfigSet_PC_CanController_1,  /* Controller */
    NULL_PTR,  /* List of HW Filter structs */
    0U,   /* Hw Filter Count */
    204U,   /* Padding value for CAN FD message */
    (boolean)TRUE,  /* CanHardwareObjectUsesPolling */
    (boolean)FALSE,  /* CanTriggerTransmitEnable */
	};

static Can_MailboxType
    CanConfigSet_CanHardwareObject_3 =
{
    0U,  /*  CanHandleType 0=Full, 1=Basic */
    2U,  /* CanIdType 0=standard 1=Extended 2=Mixed*/
    3U,  /* HwHandle i.e Mailbox - Hw object in the controller */
    5U,   /* Length of the Mailbox */
    CAN_MAILBOX_DIRECTION_TX,  /* CanObjectType - Direction of Mailbox*/
    &CanConfigSet_PC_CanController_1,  /* Controller */
    NULL_PTR,  /* List of HW Filter structs */
    0U,   /* Hw Filter Count */
    204U,   /* Padding value for CAN FD message */
    (boolean)FALSE,  /* CanHardwareObjectUsesPolling */
    (boolean)FALSE,  /* CanTriggerTransmitEnable */
	};

static Can_MailboxType
    CanConfigSet_CanHardwareObject_4 =
{
    0U,  /*  CanHandleType 0=Full, 1=Basic */
    2U,  /* CanIdType 0=standard 1=Extended 2=Mixed*/
    4U,  /* HwHandle i.e Mailbox - Hw object in the controller */
    1U,   /* Length of the Mailbox */
    CAN_MAILBOX_DIRECTION_TX,  /* CanObjectType - Direction of Mailbox*/
    &CanConfigSet_PC_CanController_2,  /* Controller */
    NULL_PTR,  /* List of HW Filter structs */
    0U,   /* Hw Filter Count */
    0U,   /* Padding value for CAN FD message */
    (boolean)TRUE,  /* CanHardwareObjectUsesPolling */
    (boolean)FALSE,  /* CanTriggerTransmitEnable */
	};

static Can_MailboxType
    CanConfigSet_CanHardwareObject_5 =
{
    0U,  /*  CanHandleType 0=Full, 1=Basic */
    2U,  /* CanIdType 0=standard 1=Extended 2=Mixed*/
    5U,  /* HwHandle i.e Mailbox - Hw object in the controller */
    1U,   /* Length of the Mailbox */
    CAN_MAILBOX_DIRECTION_TX,  /* CanObjectType - Direction of Mailbox*/
    &CanConfigSet_PC_CanController_2,  /* Controller */
    NULL_PTR,  /* List of HW Filter structs */
    0U,   /* Hw Filter Count */
    0U,   /* Padding value for CAN FD message */
    (boolean)FALSE,  /* CanHardwareObjectUsesPolling */
    (boolean)FALSE,  /* CanTriggerTransmitEnable */
	};

static Can_MailboxType
    CanConfigSet_CanHardwareObject_6 =
{
    0U,  /*  CanHandleType 0=Full, 1=Basic */
    2U,  /* CanIdType 0=standard 1=Extended 2=Mixed*/
    6U,  /* HwHandle i.e Mailbox - Hw object in the controller */
    3U,   /* Length of the Mailbox */
    CAN_MAILBOX_DIRECTION_TX,  /* CanObjectType - Direction of Mailbox*/
    &CanConfigSet_PC_CanController_3,  /* Controller */
    NULL_PTR,  /* List of HW Filter structs */
    0U,   /* Hw Filter Count */
    0U,   /* Padding value for CAN FD message */
    (boolean)TRUE,  /* CanHardwareObjectUsesPolling */
    (boolean)FALSE,  /* CanTriggerTransmitEnable */
	};

static Can_MailboxType
    CanConfigSet_CanHardwareObject_7 =
{
    0U,  /*  CanHandleType 0=Full, 1=Basic */
    2U,  /* CanIdType 0=standard 1=Extended 2=Mixed*/
    7U,  /* HwHandle i.e Mailbox - Hw object in the controller */
    2U,   /* Length of the Mailbox */
    CAN_MAILBOX_DIRECTION_TX,  /* CanObjectType - Direction of Mailbox*/
    &CanConfigSet_PC_CanController_3,  /* Controller */
    NULL_PTR,  /* List of HW Filter structs */
    0U,   /* Hw Filter Count */
    0U,   /* Padding value for CAN FD message */
    (boolean)FALSE,  /* CanHardwareObjectUsesPolling */
    (boolean)FALSE,  /* CanTriggerTransmitEnable */
	};

static Can_MailboxType
    CanConfigSet_CanHardwareObject_8 =
{
    1U,  /*  CanHandleType 0=Full, 1=Basic */
    2U,  /* CanIdType 0=standard 1=Extended 2=Mixed*/
    0U,  /* HwHandle i.e Mailbox - Hw object in the controller */
    1U,   /* Length of the Mailbox */
    CAN_MAILBOX_DIRECTION_RX,  /* CanObjectType - Direction of Mailbox*/
    &CanConfigSet_PC_CanController_0,  /* Controller */
    CanConfigSet_CanHardwareObject_8_HwFilterConfigList,  /* List of HW Filter structs */
    1U, /* Hw Filter Count */
    204U,   /* Padding value for CAN FD message */
    (boolean)TRUE,  /* CanHardwareObjectUsesPolling */
	    (boolean)FALSE,   /* CanTriggerTransmitEnable */
};

static Can_MailboxType
    CanConfigSet_CanHardwareObject_9 =
{
    1U,  /*  CanHandleType 0=Full, 1=Basic */
    2U,  /* CanIdType 0=standard 1=Extended 2=Mixed*/
    1U,  /* HwHandle i.e Mailbox - Hw object in the controller */
    1U,   /* Length of the Mailbox */
    CAN_MAILBOX_DIRECTION_RX,  /* CanObjectType - Direction of Mailbox*/
    &CanConfigSet_PC_CanController_0,  /* Controller */
    CanConfigSet_CanHardwareObject_9_HwFilterConfigList,  /* List of HW Filter structs */
    2U, /* Hw Filter Count */
    204U,   /* Padding value for CAN FD message */
    (boolean)FALSE,  /* CanHardwareObjectUsesPolling */
	    (boolean)FALSE,   /* CanTriggerTransmitEnable */
};

static Can_MailboxType
    CanConfigSet_CanHardwareObject_10 =
{
    1U,  /*  CanHandleType 0=Full, 1=Basic */
    2U,  /* CanIdType 0=standard 1=Extended 2=Mixed*/
    0U,  /* HwHandle i.e Mailbox - Hw object in the controller */
    1U,   /* Length of the Mailbox */
    CAN_MAILBOX_DIRECTION_RX,  /* CanObjectType - Direction of Mailbox*/
    &CanConfigSet_PC_CanController_1,  /* Controller */
    CanConfigSet_CanHardwareObject_10_HwFilterConfigList,  /* List of HW Filter structs */
    2U, /* Hw Filter Count */
    204U,   /* Padding value for CAN FD message */
    (boolean)TRUE,  /* CanHardwareObjectUsesPolling */
	    (boolean)FALSE,   /* CanTriggerTransmitEnable */
};

static Can_MailboxType
    CanConfigSet_CanHardwareObject_11 =
{
    0U,  /*  CanHandleType 0=Full, 1=Basic */
    2U,  /* CanIdType 0=standard 1=Extended 2=Mixed*/
    0U,  /* HwHandle i.e Mailbox - Hw object in the controller */
    5U,   /* Length of the Mailbox */
    CAN_MAILBOX_DIRECTION_RX,  /* CanObjectType - Direction of Mailbox*/
    &CanConfigSet_PC_CanController_1,  /* Controller */
    CanConfigSet_CanHardwareObject_11_HwFilterConfigList,  /* List of HW Filter structs */
    2U, /* Hw Filter Count */
    204U,   /* Padding value for CAN FD message */
    (boolean)FALSE,  /* CanHardwareObjectUsesPolling */
	    (boolean)FALSE,   /* CanTriggerTransmitEnable */
};

static Can_MailboxType
    CanConfigSet_CanHardwareObject_12 =
{
    1U,  /*  CanHandleType 0=Full, 1=Basic */
    2U,  /* CanIdType 0=standard 1=Extended 2=Mixed*/
    0U,  /* HwHandle i.e Mailbox - Hw object in the controller */
    1U,   /* Length of the Mailbox */
    CAN_MAILBOX_DIRECTION_RX,  /* CanObjectType - Direction of Mailbox*/
    &CanConfigSet_PC_CanController_2,  /* Controller */
    CanConfigSet_CanHardwareObject_12_HwFilterConfigList,  /* List of HW Filter structs */
    1U, /* Hw Filter Count */
    204U,   /* Padding value for CAN FD message */
    (boolean)TRUE,  /* CanHardwareObjectUsesPolling */
	    (boolean)FALSE,   /* CanTriggerTransmitEnable */
};

static Can_MailboxType
    CanConfigSet_CanHardwareObject_13 =
{
    1U,  /*  CanHandleType 0=Full, 1=Basic */
    2U,  /* CanIdType 0=standard 1=Extended 2=Mixed*/
    1U,  /* HwHandle i.e Mailbox - Hw object in the controller */
    1U,   /* Length of the Mailbox */
    CAN_MAILBOX_DIRECTION_RX,  /* CanObjectType - Direction of Mailbox*/
    &CanConfigSet_PC_CanController_2,  /* Controller */
    CanConfigSet_CanHardwareObject_13_HwFilterConfigList,  /* List of HW Filter structs */
    1U, /* Hw Filter Count */
    0U,   /* Padding value for CAN FD message */
    (boolean)FALSE,  /* CanHardwareObjectUsesPolling */
	    (boolean)FALSE,   /* CanTriggerTransmitEnable */
};

static Can_MailboxType
    CanConfigSet_CanHardwareObject_14 =
{
    0U,  /*  CanHandleType 0=Full, 1=Basic */
    2U,  /* CanIdType 0=standard 1=Extended 2=Mixed*/
    0U,  /* HwHandle i.e Mailbox - Hw object in the controller */
    3U,   /* Length of the Mailbox */
    CAN_MAILBOX_DIRECTION_RX,  /* CanObjectType - Direction of Mailbox*/
    &CanConfigSet_PC_CanController_3,  /* Controller */
    CanConfigSet_CanHardwareObject_14_HwFilterConfigList,  /* List of HW Filter structs */
    2U, /* Hw Filter Count */
    0U,   /* Padding value for CAN FD message */
    (boolean)TRUE,  /* CanHardwareObjectUsesPolling */
	    (boolean)FALSE,   /* CanTriggerTransmitEnable */
};

static Can_MailboxType
    CanConfigSet_CanHardwareObject_15 =
{
    1U,  /*  CanHandleType 0=Full, 1=Basic */
    2U,  /* CanIdType 0=standard 1=Extended 2=Mixed*/
    0U,  /* HwHandle i.e Mailbox - Hw object in the controller */
    1U,   /* Length of the Mailbox */
    CAN_MAILBOX_DIRECTION_RX,  /* CanObjectType - Direction of Mailbox*/
    &CanConfigSet_PC_CanController_3,  /* Controller */
    CanConfigSet_CanHardwareObject_15_HwFilterConfigList,  /* List of HW Filter structs */
    1U, /* Hw Filter Count */
    0U,   /* Padding value for CAN FD message */
    (boolean)FALSE,  /* CanHardwareObjectUsesPolling */
	    (boolean)FALSE,   /* CanTriggerTransmitEnable */
};

static Can_MailboxType
    CanConfigSet_CanHardwareObject_16 =
{
    0U,  /*  CanHandleType 0=Full, 1=Basic */
    2U,  /* CanIdType 0=standard 1=Extended 2=Mixed*/
    8U,  /* HwHandle i.e Mailbox - Hw object in the controller */
    1U,   /* Length of the Mailbox */
    CAN_MAILBOX_DIRECTION_TX,  /* CanObjectType - Direction of Mailbox*/
    &CanConfigSet_PC_CanController_4,  /* Controller */
    NULL_PTR,  /* List of HW Filter structs */
    0U,   /* Hw Filter Count */
    204U,   /* Padding value for CAN FD message */
    (boolean)TRUE,  /* CanHardwareObjectUsesPolling */
    (boolean)FALSE,  /* CanTriggerTransmitEnable */
	};

static Can_MailboxType
    CanConfigSet_CanHardwareObject_17 =
{
    0U,  /*  CanHandleType 0=Full, 1=Basic */
    2U,  /* CanIdType 0=standard 1=Extended 2=Mixed*/
    9U,  /* HwHandle i.e Mailbox - Hw object in the controller */
    1U,   /* Length of the Mailbox */
    CAN_MAILBOX_DIRECTION_TX,  /* CanObjectType - Direction of Mailbox*/
    &CanConfigSet_PC_CanController_4,  /* Controller */
    NULL_PTR,  /* List of HW Filter structs */
    0U,   /* Hw Filter Count */
    204U,   /* Padding value for CAN FD message */
    (boolean)FALSE,  /* CanHardwareObjectUsesPolling */
    (boolean)FALSE,  /* CanTriggerTransmitEnable */
	};

static Can_MailboxType
    CanConfigSet_CanHardwareObject_18 =
{
    1U,  /*  CanHandleType 0=Full, 1=Basic */
    2U,  /* CanIdType 0=standard 1=Extended 2=Mixed*/
    0U,  /* HwHandle i.e Mailbox - Hw object in the controller */
    1U,   /* Length of the Mailbox */
    CAN_MAILBOX_DIRECTION_RX,  /* CanObjectType - Direction of Mailbox*/
    &CanConfigSet_PC_CanController_4,  /* Controller */
    CanConfigSet_CanHardwareObject_18_HwFilterConfigList,  /* List of HW Filter structs */
    2U, /* Hw Filter Count */
    204U,   /* Padding value for CAN FD message */
    (boolean)TRUE,  /* CanHardwareObjectUsesPolling */
	    (boolean)FALSE,   /* CanTriggerTransmitEnable */
};

static Can_MailboxType
    CanConfigSet_CanHardwareObject_19 =
{
    0U,  /*  CanHandleType 0=Full, 1=Basic */
    2U,  /* CanIdType 0=standard 1=Extended 2=Mixed*/
    0U,  /* HwHandle i.e Mailbox - Hw object in the controller */
    5U,   /* Length of the Mailbox */
    CAN_MAILBOX_DIRECTION_RX,  /* CanObjectType - Direction of Mailbox*/
    &CanConfigSet_PC_CanController_4,  /* Controller */
    CanConfigSet_CanHardwareObject_19_HwFilterConfigList,  /* List of HW Filter structs */
    2U, /* Hw Filter Count */
    204U,   /* Padding value for CAN FD message */
    (boolean)FALSE,  /* CanHardwareObjectUsesPolling */
	    (boolean)FALSE,   /* CanTriggerTransmitEnable */
};



/* List of the Mailboxes */
static Can_MailboxType
    *CanConfigSet_CanHardwareObject_List[] =
{
    &CanConfigSet_CanHardwareObject_0,
    &CanConfigSet_CanHardwareObject_1,
    &CanConfigSet_CanHardwareObject_2,
    &CanConfigSet_CanHardwareObject_3,
    &CanConfigSet_CanHardwareObject_4,
    &CanConfigSet_CanHardwareObject_5,
    &CanConfigSet_CanHardwareObject_6,
    &CanConfigSet_CanHardwareObject_7,
    &CanConfigSet_CanHardwareObject_8,
    &CanConfigSet_CanHardwareObject_9,
    &CanConfigSet_CanHardwareObject_10,
    &CanConfigSet_CanHardwareObject_11,
    &CanConfigSet_CanHardwareObject_12,
    &CanConfigSet_CanHardwareObject_13,
    &CanConfigSet_CanHardwareObject_14,
    &CanConfigSet_CanHardwareObject_15,
    &CanConfigSet_CanHardwareObject_16,
    &CanConfigSet_CanHardwareObject_17,
    &CanConfigSet_CanHardwareObject_18,
    &CanConfigSet_CanHardwareObject_19,
};

#define CAN_STOP_SEC_CONFIG_DATA
#include "Can_MemMap.h"

#define CAN_START_SEC_CONFIG_DATA
#include "Can_MemMap.h"

/*Can Config struct */
const struct Can_ConfigType_s CanConfigSet =
{
    CanConfigSet_CanController_List,    /* List of all controllers in this config set */
    (5U),    /* max Controllers */
    CanConfigSet_CanHardwareObject_List,
    (20U),    /* total number of mail boxes in this configset */
    .MaxBaudConfigID =
    {
        [0] = 0U,
        [1] = 0U,
        [2] = 0U,
        [3] = 0U,
        [4] = 0U
    }
};

#define  CAN_STOP_SEC_CONFIG_DATA
#include "Can_MemMap.h"
/*********************************************************************************************************************
 *  End of File: Can_PBcfg.c
 *********************************************************************************************************************/
