/* ======================================================================
 *   Copyright (C) 2023 Texas Instruments Incorporated
 *
 *   All rights reserved. Property of Texas Instruments Incorporated.
 *   Restricted rights to use, duplicate or disclose this code are
 *   granted through contract.
 *
 *   The program may not be used without the written permission
 *   of Texas Instruments Incorporated or against the terms and conditions
 *   stipulated in the agreement under which this program has been
 *   supplied.
 * ==================================================================== */

/**
 *  \file     Cdd_I2c_Cfg.h
 *
 *  \brief    This file contains generated pre compile configurations
 *            for CDD I2C MCAL driver
 *
 */

/******************************************************************************
    Project         : i2c263p
    Date            : 2023-12-14 20:38:44
    SW Ver          : 10.1.0
    Module Rele Ver : AUTOSAR 4.3.1 0

    This file is generated by EB Tresos
    Do not modify this file,otherwise the software may behave in unexpected way.
******************************************************************************/


#ifndef CDD_I2C_CFG_H_
#define CDD_I2C_CFG_H_

/**
 * \addtogroup CDD_I2C I2c API GUIDE Header file
 * @{
 */

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

#include "Dem.h"

#include "Det.h"

#ifdef __cplusplus
extern "C" {
#endif

#ifndef DOXYGEN_SHOULD_SKIP_THIS

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

/**
 *  \name I2c Driver Configuration SW Version Info
 *
 *  Defines for I2c Driver configuration version
 *  @{
 */
/** \brief I2c configuration Major Version */
#define CDD_I2C_CFG_MAJOR_VERSION           (10U)
/** \brief I2c configuration Minor Version */
#define CDD_I2C_CFG_MINOR_VERSION           (1U)
/** \brief I2c configuration Patch Version */
#define CDD_I2C_CFG_PATCH_VERSION           (0U)


/**
*  \brief I2c Build Variant.
*   Build variants.(i.e Pre Compile and Post Build)
*/

#define CDD_I2C_PRE_COMPILE_VARIANT (STD_ON)

/** \brief Enable/disable CDD I2c dev detect error */
#define CDD_I2C_DEV_ERROR_DETECT                                                (STD_ON)

/** \brief Enable/disable Interrupts  */
#define CDD_I2C_POLLING_MODE                                                    (STD_OFF)

/** \brief Enable/disable version info API */
#define CDD_I2C_VERSION_INFO_API                                                (STD_ON)

/** \brief Arbitration loss mode interrupt enabled/disabled */
#define CDD_I2C_ARBITRATION_LOSS                                                (STD_ON)       

/** \brief CDD_I2C check to treat NACK as errors */
#define CDD_I2C_TREAT_NACK_AS_ERROR                                             (STD_ON)    

/** \brief CDD_I2C check to enable deque API */
#define CDD_I2C_CANCEL_API                                                      (STD_ON)

/** \brief CDD_I2C check to enable get driver status API */
#define CDD_I2C_GET_STATUS_API                                                  (STD_ON)

/** \brief CDD_I2C check to process same sequence ID multiple times in queue */
#define CDD_I2C_PROCESS_SAME_SEQUENCE_MULTIPLE_TIMES_IN_QUEUE                   (STD_ON)

/** \brief ISR type (Only include if polling mode is off) */
#define CDD_I2C_ISR_TYPE                        (CDD_I2C_ISR_CAT2)

/** \brief Counter ID for counter used to count wait ticks */
#define CDD_I2C_OS_COUNTER_ID               (0U)

/** \brief CDD_I2C arbitration loss timeout period in ticks */
#define CDD_I2C_RESET_TIMEOUT                   (400000000U)

/** \brief CDD_I2C poll timeout period in ticks */
#define CDD_I2C_POLL_TIMEOUT                    (400000000U)

/** \brief CDD_I2C queue timeout period in ticks */
#define CDD_I2C_QUEUE_TIMEOUT                   (800000000U)

/** \brief CDD_I2C maximum queue size to store message pointers for reception or transmission */
#define CDD_I2C_MAX_QUEUE_SIZE                  (10U)

/** \brief CDD_I2C maximum number of Cdd_I2c_Sequence, user configurable */
#define CDD_I2C_MAXIMUM_SEQUENCE_NUMBER          (8U)

/** \brief Symbolic Name for I2c Sequence 0 */
#define CddI2cConf_CddI2cSequence_CddI2cSequence_0   (0U)

/** \brief Symbolic Name for I2c Sequence 1 */
#define CddI2cConf_CddI2cSequence_CddI2cSequence_1   (1U)

/** \brief Symbolic Name for I2c Sequence 2 */
#define CddI2cConf_CddI2cSequence_CddI2cSequence_2   (2U)

/** \brief Symbolic Name for I2c Sequence 3 */
#define CddI2cConf_CddI2cSequence_CddI2cSequence_3   (3U)

/** \brief Symbolic Name for I2c Sequence 4 */
#define CddI2cConf_CddI2cSequence_CddI2cSequence_4   (4U)

/** \brief Symbolic Name for I2c Sequence 5 */
#define CddI2cConf_CddI2cSequence_CddI2cSequence_5   (5U)

/** \brief Symbolic Name for I2c Sequence 6 */
#define CddI2cConf_CddI2cSequence_CddI2cSequence_6   (6U)

/** \brief Symbolic Name for I2c Sequence 7 */
#define CddI2cConf_CddI2cSequence_CddI2cSequence_7   (7U)


/** \brief CDD_I2C maximum number of channels available, user configurable */
#define CDD_I2C_MAXIMUM_CHANNEL_NUMBER          (8U)

/** \brief Symbolic Name for I2c Channel 0 */
#define CddI2cConf_CddI2cChannel_CddI2cChannel_0   (0U)

/** \brief Symbolic Name for I2c Channel 1 */
#define CddI2cConf_CddI2cChannel_CddI2cChannel_1   (1U)

/** \brief Symbolic Name for I2c Channel 2 */
#define CddI2cConf_CddI2cChannel_CddI2cChannel_2   (2U)

/** \brief Symbolic Name for I2c Channel 3 */
#define CddI2cConf_CddI2cChannel_CddI2cChannel_3   (3U)

/** \brief Symbolic Name for I2c Channel 4 */
#define CddI2cConf_CddI2cChannel_CddI2cChannel_4   (4U)

/** \brief Symbolic Name for I2c Channel 5 */
#define CddI2cConf_CddI2cChannel_CddI2cChannel_5   (5U)

/** \brief Symbolic Name for I2c Channel 6 */
#define CddI2cConf_CddI2cChannel_CddI2cChannel_6   (6U)

/** \brief Symbolic Name for I2c Channel 7 */
#define CddI2cConf_CddI2cChannel_CddI2cChannel_7   (7U)


/** \brief CDD_I2C Transmission buffer maximum size, user configurable */
#define CDD_I2C_TX_RX_BUFFER_MAXIMUM_SIZE       (255U)

/** \brief CDD_I2C maximum Number of hardware units available, SOC specific */
#define CDD_I2C_HW_UNITS_MAX                    (4U)        

/** \brief CDD_I2C Number of hardware units used, user configurable */
#define CDD_I2C_HW_UNITS_USED                   (2U)         

/** \brief CDD_I2C HW unit 0, SOC specific */
#define CDD_I2C_HW_UNIT_0                       (0U)

/** \brief CDD_I2C HW unit 1, SOC specific */
#define CDD_I2C_HW_UNIT_1                       (1U)

/** \brief CDD_I2C HW unit 2, SOC specific */
#define CDD_I2C_HW_UNIT_2                       (2U)

/** \brief CDD_I2C HW unit 3, SOC specific */
#define CDD_I2C_HW_UNIT_3                       (3U)

/** \brief List of the channels used to enable the respective IRQ's*/

#define USED_CDD_I2C_HW_UNIT_0

#define USED_CDD_I2C_HW_UNIT_1

#define USED_CDD_I2C_HW_UNIT_2


#endif /* DOXYGEN_SHOULD_SKIP_THIS */

/**
 * @}
 */

/* ========================================================================== */
/*                           Global variables                                 */
/* ========================================================================== */

extern const struct Cdd_I2c_ConfigType_s CddI2cInitParams;

/* ========================================================================== */
/*                           Callback functions                               */
/* ========================================================================== */
extern void I2c_Temperature_Data_Write_Complete(void);
extern void I2c_Eeprom_Data_Write_Complete(void);
extern void I2c_Eeprom_Address_Ptr_Reset(void);
extern void I2c_Temperature_Read_Callback(void);
extern void I2c_Eeprom_Read_Callback(void);
extern void I2c_Iomux_Write_Callback(void);
extern void I2c_Iomux_Write_Callback_Ptr(void);
extern void I2c_Iomux_Read_Callback(void);

extern void I2c_Temperature_Data_Write_Fail(uint8 Error_Code);
extern void I2c_Eeprom_Data_Write_Fail(uint8 Error_Code);
extern void I2c_Eeprom_Address_Ptr_Fail(uint8 Error_Code);
extern void I2c_Temperature_Read_Callback_Fail(uint8 Error_Code);
extern void I2c_Eeprom_Read_Callback_Fail(uint8 Error_Code);
extern void I2c_Iomux_Write_Callback_Fail(uint8 Error_Code);
extern void I2c_Iomux_Write_Callback_Ptr_Fail(uint8 Error_Code);
extern void I2c_Iomux_Read_Callback_Fail(uint8 Error_Code);

#ifdef __cplusplus
}
#endif


#endif  /* #ifndef Cdd_I2C_CFG_H_ */
