/* ======================================================================
 *   Copyright (C) 2023 Texas Instruments Incorporated
 *
 *   All rights reserved. Property of Texas Instruments Incorporated.
 *   Restricted rights to use, duplicate or disclose this code are
 *   granted through contract.
 *
 *   The program may not be used without the written permission
 *   of Texas Instruments Incorporated or against the terms and conditions
 *   stipulated in the agreement under which this program has been
 *   supplied.
 * ==================================================================== */

/**
 *  \file     Mcu_Cfg.h
 *
 *  \brief    This file contains generated pre compile configuration file
 *            for MCU MCAL driver
 *
 */


 /*********************************************************************************************************************

    Project: Mcu_am263px
	Date   : 2024-03-01 17:41:33

    This file is generated by EB Tresos
    Do not modify this file, otherwise the software may behave in unexpected way.

 *********************************************************************************************************************/
 /* Protection against multiple inclusion */
#ifndef MCU_CFG_H
#define MCU_CFG_H

/**
 * \addtogroup MCU Mcu
 * @{
 */

 #ifndef DOXYGEN_SHOULD_SKIP_THIS

/*********************************************************************************************************************
 * Standard Header Files
 *********************************************************************************************************************/

/*********************************************************************************************************************
 * Other Header Files
 *********************************************************************************************************************/

#include "Dem.h"

#ifdef __cplusplus
extern "C" {
#endif

/**********************************************************************************************************************
 * Version Check
 *********************************************************************************************************************/
/** \brief MCU Config ID */
#define MCU_CFG_ID                      (0x1U)

/* Requirements: SWS_Mcu_00129 */
/**
 *  \name Mcu Driver Configuration SW Version Info
 *
 *  Defines for Mcu Driver configuration version
 *  @{
 */
/** \brief Mcu configuration Major Version */
#define MCU_CFG_MAJOR_VERSION           (10U)
/** \brief Mcu configuration Minor Version */
#define MCU_CFG_MINOR_VERSION           (1U)
/** \brief Mcu configuration Patch Version */
#define MCU_CFG_PATCH_VERSION           (0U)
/* @} */


/*********************************************************************************************************************
 * Exported enums
 *********************************************************************************************************************/
/**
* \brief  Type of McuModes supported
*/
enum
{
   MCU_MODE_NORMAL = 1 /*!< Mcu normal mode. Only supported mode */
};

/*********************************************************************************************************************
 * Exported Preprocessor #define Constants
 *********************************************************************************************************************/
/** \brief Enable/Disable Development Error Detection */
#define MCU_DEV_ERROR_DETECT       (STD_ON)
/** \brief Enable/Disable Mcu_CheckRamState() API */
#define MCU_GET_RAM_STATE_API      (STD_ON)
/** \brief Enable/Disable Mcu_InitClock() API */
#define MCU_INIT_CLOCK_API         (STD_ON)
/** \brief Enable/Disable Mcu_PerformReset() API */
#define MCU_PERFORM_RESET_API      (STD_ON)
/** \brief Enable/Disable Mcu_GetVersionInfo() API */
#define MCU_GET_VERSION_INFO_API   (STD_ON)
/** \brief Enable/Disable Mcu_InitRamSection() API */
#define MCU_INIT_RAM_API           (STD_ON)
/** \brief Enable/Disable PLL support */
#define MCU_NO_PLL                 (STD_ON)
/** \brief Enable/Disable Mcu_ClearResetReason() API */
#define MCU_REGISTER_READBACK_API (STD_ON)
/** \brief Enable/Disable MCU Interrupt Crossbar */
#define MCU_INTRCROSSBAR_ENABLE      (STD_ON)
/** \brief Enable/Disable MCU Input Crossbar */
#define MCU_INPUT_CROSSBAR_ENABLE      (STD_ON)
/** \brief Enable/Disable MCU PWM Enable */
#define MCU_PWM_ENABLE (STD_ON)
/** \brief Enable/Disable MCU ADC Enable */
#define MCU_ADC_ENABLE (STD_ON)

/*
Reset Reason Config
*/
/*<MCU_CFG_RESETREASONUSERCONFIG_LIST>*/

#define McuConf_McuResetReasonConf_MCU_POWER_ON_RESET (1U)


#define McuConf_McuResetReasonConf_MCU_WARM_RESET_WDT0 (2U)


#define McuConf_McuResetReasonConf_MCU_WARM_RESET_WDT1 (3U)


#define McuConf_McuResetReasonConf_MCU_WARM_RESET_WDT2 (4U)


#define McuConf_McuResetReasonConf_MCU_WARM_RESET_WDT3 (5U)


#define McuConf_McuResetReasonConf_MCU_WARM_RESET (6U)


#define McuConf_McuResetReasonConf_MCU_EXT_PAD_RESET (7U)


#define McuConf_McuResetReasonConf_MCU_HSM_WDT_RESET (8U)


#define McuConf_McuResetReasonConf_MCU_DEBUGGER_RESET (9U)


#define McuConf_McuResetReasonConf_MCU_WARM_RESET_TEMP0 (10U)


#define McuConf_McuResetReasonConf_MCU_WARM_RESET_TEMP1 (11U)


#define McuConf_McuResetReasonConf_MCU_WARM_RESET_VMON1_oV (12U)


#define McuConf_McuResetReasonConf_MCU_WARM_RESET_VMON2_oV (13U)


#define McuConf_McuResetReasonConf_MCU_WARM_RESET_VMON3_oV (14U)


#define McuConf_McuResetReasonConf_MCU_WARM_RESET_VMON5_oV (15U)


#define McuConf_McuResetReasonConf_MCU_WARM_RESET_VMON1_uV (16U)


#define McuConf_McuResetReasonConf_MCU_WARM_RESET_VMON2_uV (17U)


#define McuConf_McuResetReasonConf_MCU_WARM_RESET_VMON3_uV (18U)


#define McuConf_McuResetReasonConf_MCU_WARM_RESET_VMON5_uV (19U)


#define McuConf_McuResetReasonConf_MCU_WARM_RESET_VMON7_uV (20U)


#define McuConf_McuResetReasonConf_MCU_WARM_RESET_VMON8_uV (21U)


#define McuConf_McuResetReasonConf_MCU_WARM_RESET_ESM (22U)


#define McuConf_McuResetReasonConf_MCU_WARM_RESET_SYS_CLK_LOSS (23U)


#define McuConf_McuResetReasonConf_MCU_RESET_UNDEFINED (24U)




/*
 * The following defines shall be used as input
 * parameter for: Mcu_SetMode(),
 *                Mcu_InitClock()
 *                Mcu_InitRamSection()
 */

/*<MCU_CFG_MODEUSERCONFIG_LIST>*/


#define McuConf_McuModeSettingConf_McuModeSettingConf_0 MCU_MODE_NORMAL


/*</MCU_CFG_MODEUSERCONFIG_LIST>*/

#define MCU_VARIANT_PRE_COMPILE       (STD_OFF)

#define MCU_VARIANT_POST_BUILD        (STD_ON)



/*
* Clock configuration
*/
/* SourceId : MCU_SourceId_040 */
/*<MCU_CFG_CLOCKUSERCONFIG_LIST>*/
#define McuConf_McuClockSettingConfig_McuClockSettingConfig_OSPI (0U)
#define McuConf_McuClockSettingConfig_McuClockSettingConfig_MCAN0 (1U)
#define McuConf_McuClockSettingConfig_McuClockSettingConfig_MCAN1 (2U)
#define McuConf_McuClockSettingConfig_McuClockSettingConfig_MCAN2 (3U)
#define McuConf_McuClockSettingConfig_McuClockSettingConfig_MCAN3 (4U)
#define McuConf_McuClockSettingConfig_McuClockSettingConfig_MCAN4 (5U)
#define McuConf_McuClockSettingConfig_McuClockSettingConfig_MCAN5 (6U)
#define McuConf_McuClockSettingConfig_McuClockSettingConfig_MCAN6 (7U)
#define McuConf_McuClockSettingConfig_McuClockSettingConfig_MCAN7 (8U)
#define McuConf_McuClockSettingConfig_McuClockSettingConfig_RTI0 (9U)
#define McuConf_McuClockSettingConfig_McuClockSettingConfig_RTI1 (10U)
#define McuConf_McuClockSettingConfig_McuClockSettingConfig_RTI2 (11U)
#define McuConf_McuClockSettingConfig_McuClockSettingConfig_RTI3 (12U)
#define McuConf_McuClockSettingConfig_McuClockSettingConfig_RTI4 (13U)
#define McuConf_McuClockSettingConfig_McuClockSettingConfig_RTI5 (14U)
#define McuConf_McuClockSettingConfig_McuClockSettingConfig_RTI6 (15U)
#define McuConf_McuClockSettingConfig_McuClockSettingConfig_RTI7 (16U)
#define McuConf_McuClockSettingConfig_McuClockSettingConfig_MCSPI0 (17U)
#define McuConf_McuClockSettingConfig_McuClockSettingConfig_MCSPI1 (18U)
#define McuConf_McuClockSettingConfig_McuClockSettingConfig_MCSPI2 (19U)
#define McuConf_McuClockSettingConfig_McuClockSettingConfig_MCSPI3 (20U)
#define McuConf_McuClockSettingConfig_McuClockSettingConfig_MCSPI4 (21U)
#define McuConf_McuClockSettingConfig_McuClockSettingConfig_MCSPI5 (22U)
#define McuConf_McuClockSettingConfig_McuClockSettingConfig_MCSPI6 (23U)
#define McuConf_McuClockSettingConfig_McuClockSettingConfig_MCSPI7 (24U)
#define McuConf_McuClockSettingConfig_McuClockSettingConfig_I2C (25U)
#define McuConf_McuClockSettingConfig_McuClockSettingConfig_SCI0 (26U)
#define McuConf_McuClockSettingConfig_McuClockSettingConfig_SCI1 (27U)
#define McuConf_McuClockSettingConfig_McuClockSettingConfig_SCI2 (28U)
#define McuConf_McuClockSettingConfig_McuClockSettingConfig_SCI3 (29U)
#define McuConf_McuClockSettingConfig_McuClockSettingConfig_SCI4 (30U)
#define McuConf_McuClockSettingConfig_McuClockSettingConfig_SCI5 (31U)
#define McuConf_McuClockSettingConfig_McuClockSettingConfig_CPTS (32U)
#define McuConf_McuClockSettingConfig_McuClockSettingConfig_RGMI_CLK (33U)
#define McuConf_McuClockSettingConfig_McuClockSettingConfig_MII100_CLK (34U)
#define McuConf_McuClockSettingConfig_McuClockSettingConfig_MII10_CLK (35U)
#define McuConf_McuClockSettingConfig_McuClockSettingConfig_WDT0 (36U)
#define McuConf_McuClockSettingConfig_McuClockSettingConfig_WDT1 (37U)
#define McuConf_McuClockSettingConfig_McuClockSettingConfig_WDT2 (38U)
#define McuConf_McuClockSettingConfig_McuClockSettingConfig_WDT3 (39U)
#define McuConf_McuClockSettingConfig_McuClockSettingConfig_FSI (40U)

/*</MCU_CFG_CLOCKUSERCONFIG_LIST>*/

/*
* RAM Section configuration
*/
/*<MCU_CFG_RAMSECTIONUSERCONFIG_LIST>*/
#define McuRamSectorSettingConf_0 (0U)

/*</MCU_CFG_RAMSECTIONUSERCONFIG_LIST>*/


/** \brief Counter ID for counter used to count wait ticks */
#define MCU_OS_COUNTER_ID               ((CounterType)1U)

/**
*  \brief MCU timeout.
*   Each tick is 31.25us (for 32K Counter). Wait for 5s which comes to
*   below value
*/
#define MCU_TIMEOUT_DURATION            (32000U)

/** \brief MCU PLL timeout.*/
#define MCU_PLL_TIMEOUT_DURATION            (13200U)



/* MCU DEM Event Configuration*/
#ifndef MCU_E_CLOCK_FAILURE
/** \brief MCU Clock failed - AUTOSAR ECUC Driver SWS Item - ECUC_Mcu_00188*/
#define MCU_E_CLOCK_FAILURE (DemConf_DemEventParameter_MCU_E_CLOCK_FAILURE)
#endif

#ifndef MCU_E_HARDWARE_ERROR
/** \brief Hardware failed */
#define MCU_E_HARDWARE_ERROR          (DemConf_DemEventParameter_MCU_E_HARDWARE_ERROR)
#endif
/* @} */
/* MCU Clock Config Size */
#define MCU_CLOCK_CONFIG (41U)

/* MCU CDD PWM Channel */
#define MCU_NUM_OF_CDD_PWM_CHANNELS (2U)

/* MCU CDD PWM Channel */
#define MCU_NUM_OF_ASR_PWM_CHANNELS (1U)

/* MCU PWM Channel */
#define MCU_PWM_CHANNEL (3U)

/* MCU ADC Channel */
#define MCU_ADC_HWUNIT (1U)

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

/*********************************************************************************************************************
 * Exported Type Declarations
 *********************************************************************************************************************/

 /* Requirements: SWS_Mcu_00252,SWS_Mcu_00234 */
/**
 *  \brief  This is the type of the reset enumerator containing the subset of
 *  reset types. <br>
 *  It is not required that all reset types are supported by hardware
 *
 */
typedef enum
{
    /* Requirements: SWS_Mcu_00134 */
    /** \brief Reset Reason Cleared */
    MCU_RESET_CLEAR,
    /** \brief POR Reset */
    MCU_POWER_ON_RESET,
    /** \brief Warm Reset due to MSS_WDT0 */
    MCU_WARM_RESET_WDT0,
    /** \brief Warm Reset due to MSS_WDT1 */
	MCU_WARM_RESET_WDT1,
    /** \brief Warm Reset due to MSS_WDT2 */
	MCU_WARM_RESET_WDT2,
    /** \brief Warm Reset due to MSS_WDT3 */
	MCU_WARM_RESET_WDT3,
    /** \brief Warm Reset due to TOPRCM WARM_RESET_CONFIG */
    MCU_WARM_RESET,
    /** \brief External Pad Reset */
    MCU_EXT_PAD_RESET,
    /** \brief Warm Reset due to HSM WDT */
    MCU_HSM_WDT_RESET,
    /** \brief Warm Reset due to Debugger reset */
	MCU_DEBUGGER_RESET,
    /** \brief Warm Reset due to Temperature sensor 0 */
	MCU_WARM_RESET_TEMP0,
    /** \brief Warm Reset due to Temperature sensor 1 */
	MCU_WARM_RESET_TEMP1,
    /** \brief UNDEFINED  reset */
    MCU_RESET_UNDEFINED,
    /** \brief Warm Reset due to Voltage monitor1_oV */
	MCU_WARM_RESET_VMON1_oV,
    /** \brief Warm Reset due to Voltage monitor2_oV */
    MCU_WARM_RESET_VMON2_oV,
    /** \brief Warm Reset due to Voltage monitor3_oV */
    MCU_WARM_RESET_VMON3_oV,
    /** \brief Warm Reset due to Voltage monitor5_oV */
    MCU_WARM_RESET_VMON5_oV,
    /** \brief Warm Reset due to Voltage monitor0_uV */
    MCU_WARM_RESET_VMON0_uV,
    /** \brief Warm Reset due to Voltage monitor1_uV */
    MCU_WARM_RESET_VMON1_uV,
    /** \brief Warm Reset due to Voltage monitor2_uV */
    MCU_WARM_RESET_VMON2_uV,
    /** \brief Warm Reset due to Voltage monitor3_uV */
    MCU_WARM_RESET_VMON3_uV,
    /** \brief Warm Reset due to Voltage monitor5_uV */
    MCU_WARM_RESET_VMON5_uV,
    /** \brief Warm Reset due to Voltage monitor7_uV */
    MCU_WARM_RESET_VMON7_uV,
    /** \brief Warm Reset due to Voltage monitor8_uV */
    MCU_WARM_RESET_VMON8_uV,
    /** \brief Warm Reset due to ESM                 */
    MCU_WARM_RESET_ESM,
    /** \brief Warm Reset due to Sys clock loss      */
    MCU_WARM_RESET_SYS_CLK_LOSS,
} Mcu_ResetType;


/**
 *  \enum Mcu_ClkModuleIdType
 *  \brief Clock source config modules id enum
 *
 *  Clock source config ids defines are used to set clock source for specific
 *  modules
 */
typedef enum
{
    /** \brief System Clock, clock select is ignored */
    MCU_CLKSRC_MODULE_ID_SYSCLK,
    /** \brief MSS MCAN0 clock */
    MCU_CLKSRC_MODULE_ID_MCAN0,
    /** \brief MSS MCAN1 clock */
    MCU_CLKSRC_MODULE_ID_MCAN1,
    /** \brief MSS MCAN2 clock */
	MCU_CLKSRC_MODULE_ID_MCAN2,
    /** \brief MSS MCAN3 clock */
	MCU_CLKSRC_MODULE_ID_MCAN3,
    /** \brief MSS MCAN4 clock */
    MCU_CLKSRC_MODULE_ID_MCAN4,
    /** \brief MSS MCAN5 clock */
    MCU_CLKSRC_MODULE_ID_MCAN5,
    /** \brief MSS MCAN6 clock */
	MCU_CLKSRC_MODULE_ID_MCAN6,
    /** \brief MSS MCAN7 clock */
	MCU_CLKSRC_MODULE_ID_MCAN7,
    /** \brief MSS RTI0 clock */
    MCU_CLKSRC_MODULE_ID_RTI0,
    /** \brief MSS RTI1 clock */
    MCU_CLKSRC_MODULE_ID_RTI1,
    /** \brief MSS RTI2 clock */
    MCU_CLKSRC_MODULE_ID_RTI2,
    /** \brief MSS RTI3 clock */
	MCU_CLKSRC_MODULE_ID_RTI3,
    /** \brief MSS RTI4 clock */
    MCU_CLKSRC_MODULE_ID_RTI4,
    /** \brief MSS RTI5 clock */
    MCU_CLKSRC_MODULE_ID_RTI5,
    /** \brief MSS RTI6 clock */
    MCU_CLKSRC_MODULE_ID_RTI6,
    /** \brief MSS RTI7 clock */
	MCU_CLKSRC_MODULE_ID_RTI7,
    /** \brief MSS WDT clock */
    MCU_CLKSRC_MODULE_ID_WDT0,
    /** \brief MSS WDT clock */
	MCU_CLKSRC_MODULE_ID_WDT1,
    /** \brief MSS WDT clock */
	MCU_CLKSRC_MODULE_ID_WDT2,
    /** \brief MSS WDT clock */
	MCU_CLKSRC_MODULE_ID_WDT3,
    /** \brief MSS OSPI clock */
    MCU_CLKSRC_MODULE_ID_OSPI,
    /** \brief MSS SPI0 clock */
    MCU_CLKSRC_MODULE_ID_MCSPI0,
    /** \brief MSS SPI1 clock */
	MCU_CLKSRC_MODULE_ID_MCSPI1,
    /** \brief MSS SPI2 clock */
	MCU_CLKSRC_MODULE_ID_MCSPI2,
    /** \brief MSS SPI3 clock */
	MCU_CLKSRC_MODULE_ID_MCSPI3,
    /** \brief MSS SPI4 clock */
	MCU_CLKSRC_MODULE_ID_MCSPI4,
    /** \brief MSS SPI5 clock */
	MCU_CLKSRC_MODULE_ID_MCSPI5,
    /** \brief MSS SPI6 clock */
	MCU_CLKSRC_MODULE_ID_MCSPI6,
    /** \brief MSS SPI7 clock */
	MCU_CLKSRC_MODULE_ID_MCSPI7,
    /** \brief MSS SPIB clock */
    MCU_CLKSRC_MODULE_ID_SPIB,
    /** \brief MSS I2C clock */
    MCU_CLKSRC_MODULE_ID_I2C,
    /** \brief MSS SCIA clock */
    MCU_CLKSRC_MODULE_ID_SCI0,
    /** \brief MSS SCIB clock */
    MCU_CLKSRC_MODULE_ID_SCI1,
    /** \brief MSS SCIB clock */
	MCU_CLKSRC_MODULE_ID_SCI2,
    /** \brief MSS SCIB clock */
	MCU_CLKSRC_MODULE_ID_SCI3,
    /** \brief MSS SCIB clock */
	MCU_CLKSRC_MODULE_ID_SCI4,
    /** \brief MSS SCIB clock */
	MCU_CLKSRC_MODULE_ID_SCI5,
    /** \brief MSS CPSW clock */
    MCU_CLKSRC_MODULE_ID_CPSW,
    /** \brief MSS CPTS clock */
    MCU_CLKSRC_MODULE_ID_CPTS,
    /** \brief MSS MCU CLKOUT0 clock */
    MCU_CLKSRC_MODULE_ID_MCU_CLKOUT0,
    /** \brief MSS MCU CLKOUT1 clock */
    MCU_CLKSRC_MODULE_ID_MCU_CLKOUT1,
    /** \brief MSS PMIC CLKOUT clock */
    MCU_CLKSRC_MODULE_ID_PMIC_CLKOUT,
    /** \brief MSS MII 100 CLK clock */
    MCU_CLKSRC_MODULE_ID_MII100_CLK,
    /** \brief MSS MII 10 CLK clock */
    MCU_CLKSRC_MODULE_ID_MII10_CLK,
    /** \brief MSS RGMI CLK clock */
    MCU_CLKSRC_MODULE_ID_RGMI_CLK,
    /** \brief MSS CONTROLSS CLK clock */
	MCU_CLKSRC_MODULE_ID_CONTROLSS_CLK,
    /** \brief MSS Module ID max */
    MCU_CLKSRC_MODULE_ID_MAX
} Mcu_ClkModuleIdType;

/**
 * \brief  This is the type of the clock source in clock tree that is selectable
 *         for  peripheral. Please see TRM to map clock source to module.
 */
typedef enum
{
    /** \brief Clocksource 0 */
    MCU_CLKSRC_0 = 0,
    /** \brief Clocksource 1 */
    MCU_CLKSRC_1,
    /** \brief Clocksource 2 */
    MCU_CLKSRC_2,
    /** \brief Clocksource 3 */
    MCU_CLKSRC_3,
    /** \brief Clocksource 4 */
    MCU_CLKSRC_4,
    /** \brief Clocksource 5 */
    MCU_CLKSRC_5,
    /** \brief Clocksource 6 */
    MCU_CLKSRC_6,
    /** \brief Clocksource 7 */
    MCU_CLKSRC_7,
    /** \brief Clocksource max */
    MCU_CLKSRC_MAX
}Mcu_ClkSourceIdType;

/* Requirements: SWS_Mcu_00030 */
/**
 *  \brief Structure for data pre-setting to be initialized
 */
typedef struct
{
    /** \brief RAM section base address, Destination */
    P2VAR(uint8, AUTOMATIC, MCU_RAM_COPY) Mcu_RamSectionBaseAddress;
    /** \brief RAM Default Value */
    uint8  Mcu_RamDefaultValue;
    /** \brief Section Size */
    uint32 Mcu_RamSectionBytes;

} Mcu_RamSectionConfigType;

/* Requirements: SWS_Mcu_00031 */
/**
 *  \brief Structure for module clock setting
 */
typedef struct
{
    /** \brief ModuleId for which clock setting to be applied */
    Mcu_ClkModuleIdType Mcu_ClockModuleId;
    /** \brief Clock source Id for the module */
    Mcu_ClkSourceIdType Mcu_ClockSourceId;
    /** \brief Clock divider value for the module  */
    uint32              Mcu_ClockDiv;
    /** \brief Apply this configuration at Mcu_init time*/
    boolean             Mcu_InitCfg;

} Mcu_ClockConfigType;


/**
 *  \brief Structure for PWM clock configuration
 */
typedef struct
{
    /** \brief Channel id of PWM */
    uint8 Mcu_PwmChannelId;
    /** \brief Group id of PWM */
    uint8 Mcu_PwmGroupId;

} Mcu_PwmConfigType;

/**
 *  \brief Structure for ADC Buffer configuration
 */
typedef struct
{
    /** \brief HW id of ADC */
    uint8 Mcu_AdcHWUniId;

} Mcu_AdcConfigType;

/**
 *  \brief Structure for PRCM configuration
 */
typedef struct
{
    /** \brief Moudle Id to enable/disable */
    uint8 Mcu_RcmModuleId;
    /** \brief Moudle mode to set @sa MCAL_MCU_API:RCM modules mode defines */
    uint8 Mcu_RcmModuleMode;

} Mcu_RCMConfigType;

/**
 *  \brief Pointer to RamConfig structure
 */
typedef P2CONST (Mcu_RamSectionConfigType, AUTOMATIC, MCU_PBCFG)
Mcu_RamConfigPtrType;

/**
   \brief Pointer to PrcmConfig structure
*
*/
typedef P2CONST (Mcu_RCMConfigType, AUTOMATIC, MCU_PBCFG)
Mcu_RCMConfigPtrType;

/**
 *  \brief Pointer to Clock Config structure
 */
typedef P2CONST (Mcu_ClockConfigType, AUTOMATIC, MCU_PBCFG)
Mcu_ClockConfigPtrType;

/**
 *  \brief Pointer to PWM Clock Config structure
 */
typedef P2CONST (Mcu_PwmConfigType, AUTOMATIC, MCU_PBCFG)
Mcu_PwmConfigPtrType;

/**
 *  \brief Pointer to ADC buffer Config structure
 */
typedef P2CONST (Mcu_AdcConfigType, AUTOMATIC, MCU_PBCFG)
Mcu_AdcConfigPtrType;

/**
 *  \brief MCU CONFIG Register READBACK structure
 */
typedef struct
{
    /** \brief Clock source select */
    uint32 CLKSRCSEL0;
}Mcu_RegisterReadbackType;

/* Requirements: SWS_Mcu_00249,SWS_Mcu_00131 */
/**
 *  \brief MCU CONFIG ROOT structure
 */
typedef struct Mcu_ConfigType_s
{
    /** \brief Reset mode to be used @sa  MCAL_MCU_API:ResetModes */
    /* Requirements: SWS_Mcu_00030 */
    uint8                    Mcu_ResetMode;
    /** \brief Configration of Ram Sections */
    Mcu_RamConfigPtrType     Mcu_ConfigRamSection;
    /** \brief Number of entries in Mcu_ConfigRamSection */
    /* Requirements: SWS_Mcu_00031, SWS_Mcu_00019 */
    uint8                    Mcu_NumberOfRamSectors;
    /** \brief Configuration of Module functional clock source */
    Mcu_ClockConfigPtrType   Mcu_ClockConfig;
    /** \brief Number of entries in Mcu_ClockConfig */
    uint8                    Mcu_NumberOfClockConfig;
	#if (STD_OFF == MCU_NO_PLL)
    /** \brief PLL Configuration */
    Mcu_PllConfigPtrType     Mcu_PllConfig;
    /** \brief PLL source selection */
    Mcu_PllSourceIdType      Mcu_PllSourceId;
	#endif
	#if (STD_ON == MCU_PWM_ENABLE)
    /** \brief PWM Configuration */
	Mcu_PwmConfigPtrType     Mcu_Pwmconfig;
	#endif
	#if (STD_ON == MCU_ADC_ENABLE)
    /** \brief ADC Configuration */
	Mcu_AdcConfigPtrType     Mcu_AdcConfig;
	#endif
} Mcu_ConfigType;

#ifndef DOXYGEN_SHOULD_SKIP_THIS

/** @brief Number of ETPWM instances */
#define MCU_CSL_ETPWM_PER_CNT                (32U)

/*Control MMRs partition*/
#define MCU_TOP_CTRL_PARTITION0                                (2)
#define MCU_CONTROLSS_CTRL_PARTITION0                          (3)
/*Clock and reset MMRs partition*/
#define MCU_TOP_RCM_PARTITION0                                 (5)

#define MCU_CSL_CONTROLSS_CTRL_EPWM_STATICXBAR_SEL0                          (0x00000004U)

#define MCU_CSL_TOP_RCM_U_BASE                                                   (0x53200000ul)
#define MCU_CSL_TOP_CTRL_U_BASE                                              (0x50D80000ul)
#define MCU_CSL_CONTROLSS_CTRL_U_BASE                                        (0x502F0000ul)
#define MCU_CSL_CONTROLSS_CTRL_LOCK0_KICK0                                   (0x00001008U)
#define MCU_CSL_CONTROLSS_CTRL_LOCK0_KICK1                                   (0x0000100CU)

#define MCU_CSL_CONTROLSS_CTRL_EPWM_CLKSYNC                                  (0x00000010U)

/* EPWM_CLKSYNC */
#define MCU_CSL_CONTROLSS_CTRL_EPWM_CLKSYNC_BIT_MASK                         (0xFFFFFFFFU)

#define MCU_CSL_TOP_CTRL_LOCK0_KICK0                                          (0x00001008U)
#define MCU_CSL_TOP_CTRL_LOCK0_KICK1                                          (0x0000100CU)
#define MCU_CSL_TOP_RCM_LOCK0_KICK0                                           (0x00001008U)
#define MCU_CSL_TOP_RCM_LOCK0_KICK1                                           (0x0000100CU)

/* define the unlock and lock values for MSS_CTRL, TOP_CTRL, MSS_RCM, TOP_RCM*/
#define MCU_TEST_KICK_LOCK_VAL                           (0x00000000U)
#define MCU_TEST_KICK0_UNLOCK_VAL                        (0x01234567U)
#define MCU_TEST_KICK1_UNLOCK_VAL                        (0x0FEDCBA8U)

/* EPWM_CHANNELS */
#define MCU_PWM_CHANNEL_0   0
#define MCU_PWM_CHANNEL_1   1
#define MCU_PWM_CHANNEL_2   2
#define MCU_PWM_CHANNEL_3   3
#define MCU_PWM_CHANNEL_4   4
#define MCU_PWM_CHANNEL_5   5
#define MCU_PWM_CHANNEL_6   6
#define MCU_PWM_CHANNEL_7   7
#define MCU_PWM_CHANNEL_8   8
#define MCU_PWM_CHANNEL_9   9
#define MCU_PWM_CHANNEL_10 10
#define MCU_PWM_CHANNEL_11 11
#define MCU_PWM_CHANNEL_12 12
#define MCU_PWM_CHANNEL_13 13
#define MCU_PWM_CHANNEL_14 14
#define MCU_PWM_CHANNEL_15 15
#define MCU_PWM_CHANNEL_16 16
#define MCU_PWM_CHANNEL_17 17
#define MCU_PWM_CHANNEL_18 18
#define MCU_PWM_CHANNEL_19 19
#define MCU_PWM_CHANNEL_20 20
#define MCU_PWM_CHANNEL_21 21
#define MCU_PWM_CHANNEL_22 22
#define MCU_PWM_CHANNEL_23 23
#define MCU_PWM_CHANNEL_24 24
#define MCU_PWM_CHANNEL_25 25
#define MCU_PWM_CHANNEL_26 26
#define MCU_PWM_CHANNEL_27 27
#define MCU_PWM_CHANNEL_28 28
#define MCU_PWM_CHANNEL_29 29
#define MCU_PWM_CHANNEL_30 30
#define MCU_PWM_CHANNEL_31 31

/* EPWM_GROUPS */
#define MCU_PWM_CONTROLSS_G0   0
#define MCU_PWM_CONTROLSS_G1   1
#define MCU_PWM_CONTROLSS_G2   2
#define MCU_PWM_CONTROLSS_G3   3

/* ADC_GROUPS */
#define MCU_ADC_HWUNIT_0   0
#define MCU_ADC_HWUNIT_1   1
#define MCU_ADC_HWUNIT_2   2
#define MCU_ADC_HWUNIT_3   3
#define MCU_ADC_HWUNIT_4   4
#define MCU_ADC_HWUNIT_5   5
#define MCU_ADC_HWUNIT_6   6

/* ADC BUFFER CONTROL */
#define MCU_CSL_TOP_CTRL_ADC_REFBUF0_CTRL                                     (0x00000C00U)
#define MCU_CSL_TOP_CTRL_ADC_REFBUF1_CTRL                                     (0x00000C04U)
#define MCU_CSL_TOP_CTRL_ADC_REFBUF2_CTRL                                     (0x00000C94U)

#define MCU_CSL_TOP_CTRL_ADC_REF_COMP_CTRL                                    (0x00000C08U)

void Mcu_IntXbar(void);
void Mcu_InputXbar(void);
void Mcu_GpioXbarConfig(void);

/*********************************************************************************************************************
 *  Exported Object Declarations
 *********************************************************************************************************************/

/** \brief MCU Configuration struct declaration */
extern const struct Mcu_ConfigType_s McuModuleConfiguration;


#endif /* DOXYGEN_SHOULD_SKIP_THIS */

#ifdef __cplusplus
}
#endif

/**
* @}
*/

#endif /* #ifndef MCU_CFG_H */
/**********************************************************************************************************************
 *  End of File: Mcu_Cfg.h
 *********************************************************************************************************************/
