
/* ======================================================================
 *   Copyright (C) 2023 Texas Instruments Incorporated
 *
 *   All rights reserved. Property of Texas Instruments Incorporated.
 *   Restricted rights to use, duplicate or disclose this code are
 *   granted through contract.
 *
 *   The program may not be used without the written permission
 *   of Texas Instruments Incorporated or against the terms and conditions
 *   stipulated in the agreement under which this program has been
 *   supplied.
 * ==================================================================== */

/**
 *  \file     Mcu_PBcfg.c
 *
 *  \brief    This file contains generated post build configuration file
 *            for MCU MCAL driver
 *
 */

 /*********************************************************************************************************************

    Project: Mcu_am263px
	Date   : 2024-03-01 17:41:33

    This file is generated by EB Tresos
    Do not modify this file, otherwise the software may behave in unexpected way.

 *********************************************************************************************************************/

/* Module switch */
#define MCU_PBCFG_SOURCE

/**********************************************************************************************************************
 * Standard Header Files
 **********************************************************************************************************************/

/*********************************************************************************************************************
 * Other Header Files
 *********************************************************************************************************************/
#include "Mcu.h"
#include "Mcu_Xbar.h"
/**********************************************************************************************************************
 *  Version Check
 *********************************************************************************************************************/

/*  Version checking  */
#if ((MCU_SW_MAJOR_VERSION != (10U))||(MCU_SW_MINOR_VERSION != (1U)))
   #error "Version numbers of Mcu_PBcfg.c and Mcu.h are inconsistent!"
#endif

#if ((MCU_CFG_MAJOR_VERSION != (10U))||(MCU_CFG_MINOR_VERSION != (1U)))
  #error "Version numbers of Mcu_PBcfg.c and Mcu_Cfg.h are inconsistent!"
#endif
/**********************************************************************************************************************
 * Local Preprocessor #define Constants
 **********************************************************************************************************************/

/**********************************************************************************************************************
 * Local Preprocessor #define Macros
 **********************************************************************************************************************/

/**********************************************************************************************************************
 * Local Data Types and Structures
 **********************************************************************************************************************/
#define MCU_START_SEC_CONFIG_DATA
#include "Mcu_MemMap.h"

/**********************************************************************************************************************
 * Constants for Post-Build Configuration
 **********************************************************************************************************************/

/* SourceId : MCU_SourceId_031 */


static CONST(Mcu_RamSectionConfigType, MCU_CONFIG_DATA) Mcu_RamSectionConfig[] =
{
    {
	   ((uint8*)0x70000000),
	   0xbeU,
	   256U
    }

};


#define  MCU_STOP_SEC_CONFIG_DATA
#include "Mcu_MemMap.h"

#define  MCU_START_SEC_CONFIG_DATA
#include "Mcu_MemMap.h"
/* SourceId : MCU_SourceId_031 */

static CONST(Mcu_ClockConfigType, MCU_CONFIG_DATA) Mcu_ClockConfiguration[] =
{
    [0] =
    {
        .Mcu_ClockModuleId = MCU_CLKSRC_MODULE_ID_OSPI,
        .Mcu_ClockSourceId = MCU_CLKSRC_4,
        .Mcu_ClockDiv = 2,
        .Mcu_InitCfg  = TRUE,
    },
    [1] =
    {
        .Mcu_ClockModuleId = MCU_CLKSRC_MODULE_ID_MCAN0,
        .Mcu_ClockSourceId = MCU_CLKSRC_4,
        .Mcu_ClockDiv = 4,
        .Mcu_InitCfg  = TRUE,
    },
    [2] =
    {
        .Mcu_ClockModuleId = MCU_CLKSRC_MODULE_ID_MCAN1,
        .Mcu_ClockSourceId = MCU_CLKSRC_4,
        .Mcu_ClockDiv = 4,
        .Mcu_InitCfg  = TRUE,
    },
    [3] =
    {
        .Mcu_ClockModuleId = MCU_CLKSRC_MODULE_ID_MCAN2,
        .Mcu_ClockSourceId = MCU_CLKSRC_4,
        .Mcu_ClockDiv = 4,
        .Mcu_InitCfg  = TRUE,
    },
    [4] =
    {
        .Mcu_ClockModuleId = MCU_CLKSRC_MODULE_ID_MCAN3,
        .Mcu_ClockSourceId = MCU_CLKSRC_4,
        .Mcu_ClockDiv = 4,
        .Mcu_InitCfg  = TRUE,
    },
    [5] =
    {
        .Mcu_ClockModuleId = MCU_CLKSRC_MODULE_ID_MCAN4,
        .Mcu_ClockSourceId = MCU_CLKSRC_4,
        .Mcu_ClockDiv = 4,
        .Mcu_InitCfg  = TRUE,
    },
    [6] =
    {
        .Mcu_ClockModuleId = MCU_CLKSRC_MODULE_ID_MCAN5,
        .Mcu_ClockSourceId = MCU_CLKSRC_4,
        .Mcu_ClockDiv = 4,
        .Mcu_InitCfg  = TRUE,
    },
    [7] =
    {
        .Mcu_ClockModuleId = MCU_CLKSRC_MODULE_ID_MCAN6,
        .Mcu_ClockSourceId = MCU_CLKSRC_4,
        .Mcu_ClockDiv = 4,
        .Mcu_InitCfg  = TRUE,
    },
    [8] =
    {
        .Mcu_ClockModuleId = MCU_CLKSRC_MODULE_ID_MCAN7,
        .Mcu_ClockSourceId = MCU_CLKSRC_4,
        .Mcu_ClockDiv = 4,
        .Mcu_InitCfg  = TRUE,
    },
    [9] =
    {
        .Mcu_ClockModuleId = MCU_CLKSRC_MODULE_ID_RTI0,
        .Mcu_ClockSourceId = MCU_CLKSRC_2,
        .Mcu_ClockDiv = 0,
        .Mcu_InitCfg  = TRUE,
    },
    [10] =
    {
        .Mcu_ClockModuleId = MCU_CLKSRC_MODULE_ID_RTI1,
        .Mcu_ClockSourceId = MCU_CLKSRC_2,
        .Mcu_ClockDiv = 0,
        .Mcu_InitCfg  = TRUE,
    },
    [11] =
    {
        .Mcu_ClockModuleId = MCU_CLKSRC_MODULE_ID_RTI2,
        .Mcu_ClockSourceId = MCU_CLKSRC_2,
        .Mcu_ClockDiv = 0,
        .Mcu_InitCfg  = TRUE,
    },
    [12] =
    {
        .Mcu_ClockModuleId = MCU_CLKSRC_MODULE_ID_RTI3,
        .Mcu_ClockSourceId = MCU_CLKSRC_2,
        .Mcu_ClockDiv = 0,
        .Mcu_InitCfg  = TRUE,
    },
    [13] =
    {
        .Mcu_ClockModuleId = MCU_CLKSRC_MODULE_ID_RTI4,
        .Mcu_ClockSourceId = MCU_CLKSRC_2,
        .Mcu_ClockDiv = 0,
        .Mcu_InitCfg  = TRUE,
    },
    [14] =
    {
        .Mcu_ClockModuleId = MCU_CLKSRC_MODULE_ID_RTI5,
        .Mcu_ClockSourceId = MCU_CLKSRC_2,
        .Mcu_ClockDiv = 0,
        .Mcu_InitCfg  = TRUE,
    },
    [15] =
    {
        .Mcu_ClockModuleId = MCU_CLKSRC_MODULE_ID_RTI6,
        .Mcu_ClockSourceId = MCU_CLKSRC_2,
        .Mcu_ClockDiv = 0,
        .Mcu_InitCfg  = TRUE,
    },
    [16] =
    {
        .Mcu_ClockModuleId = MCU_CLKSRC_MODULE_ID_RTI7,
        .Mcu_ClockSourceId = MCU_CLKSRC_2,
        .Mcu_ClockDiv = 0,
        .Mcu_InitCfg  = TRUE,
    },
    [17] =
    {
        .Mcu_ClockModuleId = MCU_CLKSRC_MODULE_ID_MCSPI0,
        .Mcu_ClockSourceId = MCU_CLKSRC_4,
        .Mcu_ClockDiv = 7,
        .Mcu_InitCfg  = TRUE,
    },
    [18] =
    {
        .Mcu_ClockModuleId = MCU_CLKSRC_MODULE_ID_MCSPI1,
        .Mcu_ClockSourceId = MCU_CLKSRC_4,
        .Mcu_ClockDiv = 7,
        .Mcu_InitCfg  = TRUE,
    },
    [19] =
    {
        .Mcu_ClockModuleId = MCU_CLKSRC_MODULE_ID_MCSPI2,
        .Mcu_ClockSourceId = MCU_CLKSRC_4,
        .Mcu_ClockDiv = 7,
        .Mcu_InitCfg  = TRUE,
    },
    [20] =
    {
        .Mcu_ClockModuleId = MCU_CLKSRC_MODULE_ID_MCSPI3,
        .Mcu_ClockSourceId = MCU_CLKSRC_4,
        .Mcu_ClockDiv = 7,
        .Mcu_InitCfg  = TRUE,
    },
    [21] =
    {
        .Mcu_ClockModuleId = MCU_CLKSRC_MODULE_ID_MCSPI4,
        .Mcu_ClockSourceId = MCU_CLKSRC_4,
        .Mcu_ClockDiv = 7,
        .Mcu_InitCfg  = TRUE,
    },
    [22] =
    {
        .Mcu_ClockModuleId = MCU_CLKSRC_MODULE_ID_MCSPI5,
        .Mcu_ClockSourceId = MCU_CLKSRC_4,
        .Mcu_ClockDiv = 7,
        .Mcu_InitCfg  = TRUE,
    },
    [23] =
    {
        .Mcu_ClockModuleId = MCU_CLKSRC_MODULE_ID_MCSPI6,
        .Mcu_ClockSourceId = MCU_CLKSRC_4,
        .Mcu_ClockDiv = 7,
        .Mcu_InitCfg  = TRUE,
    },
    [24] =
    {
        .Mcu_ClockModuleId = MCU_CLKSRC_MODULE_ID_MCSPI7,
        .Mcu_ClockSourceId = MCU_CLKSRC_4,
        .Mcu_ClockDiv = 7,
        .Mcu_InitCfg  = TRUE,
    },
    [25] =
    {
        .Mcu_ClockModuleId = MCU_CLKSRC_MODULE_ID_I2C,
        .Mcu_ClockSourceId = MCU_CLKSRC_3,
        .Mcu_ClockDiv = 1,
        .Mcu_InitCfg  = TRUE,
    },
    [26] =
    {
        .Mcu_ClockModuleId = MCU_CLKSRC_MODULE_ID_SCI0,
        .Mcu_ClockSourceId = MCU_CLKSRC_3,
        .Mcu_ClockDiv = 3,
        .Mcu_InitCfg  = TRUE,
    },
    [27] =
    {
        .Mcu_ClockModuleId = MCU_CLKSRC_MODULE_ID_SCI1,
        .Mcu_ClockSourceId = MCU_CLKSRC_3,
        .Mcu_ClockDiv = 3,
        .Mcu_InitCfg  = TRUE,
    },
    [28] =
    {
        .Mcu_ClockModuleId = MCU_CLKSRC_MODULE_ID_SCI2,
        .Mcu_ClockSourceId = MCU_CLKSRC_3,
        .Mcu_ClockDiv = 3,
        .Mcu_InitCfg  = TRUE,
    },
    [29] =
    {
        .Mcu_ClockModuleId = MCU_CLKSRC_MODULE_ID_SCI3,
        .Mcu_ClockSourceId = MCU_CLKSRC_3,
        .Mcu_ClockDiv = 3,
        .Mcu_InitCfg  = TRUE,
    },
    [30] =
    {
        .Mcu_ClockModuleId = MCU_CLKSRC_MODULE_ID_SCI4,
        .Mcu_ClockSourceId = MCU_CLKSRC_3,
        .Mcu_ClockDiv = 3,
        .Mcu_InitCfg  = TRUE,
    },
    [31] =
    {
        .Mcu_ClockModuleId = MCU_CLKSRC_MODULE_ID_SCI5,
        .Mcu_ClockSourceId = MCU_CLKSRC_3,
        .Mcu_ClockDiv = 3,
        .Mcu_InitCfg  = TRUE,
    },
    [32] =
    {
        .Mcu_ClockModuleId = MCU_CLKSRC_MODULE_ID_CPTS,
        .Mcu_ClockSourceId = MCU_CLKSRC_2,
        .Mcu_ClockDiv = 0,
        .Mcu_InitCfg  = TRUE,
    },
    [33] =
    {
        .Mcu_ClockModuleId = MCU_CLKSRC_MODULE_ID_RGMI_CLK,
        .Mcu_ClockSourceId = MCU_CLKSRC_3,
        .Mcu_ClockDiv = 1,
        .Mcu_InitCfg  = TRUE,
    },
    [34] =
    {
        .Mcu_ClockModuleId = MCU_CLKSRC_MODULE_ID_MII100_CLK,
        .Mcu_ClockSourceId = MCU_CLKSRC_3,
        .Mcu_ClockDiv = 9,
        .Mcu_InitCfg  = TRUE,
    },
    [35] =
    {
        .Mcu_ClockModuleId = MCU_CLKSRC_MODULE_ID_MII10_CLK,
        .Mcu_ClockSourceId = MCU_CLKSRC_3,
        .Mcu_ClockDiv = 99,
        .Mcu_InitCfg  = TRUE,
    },
    [36] =
    {
        .Mcu_ClockModuleId = MCU_CLKSRC_MODULE_ID_WDT0,
        .Mcu_ClockSourceId = MCU_CLKSRC_2,
        .Mcu_ClockDiv = 0,
        .Mcu_InitCfg  = TRUE,
    },
    [37] =
    {
        .Mcu_ClockModuleId = MCU_CLKSRC_MODULE_ID_WDT1,
        .Mcu_ClockSourceId = MCU_CLKSRC_2,
        .Mcu_ClockDiv = 0,
        .Mcu_InitCfg  = TRUE,
    },
    [38] =
    {
        .Mcu_ClockModuleId = MCU_CLKSRC_MODULE_ID_WDT2,
        .Mcu_ClockSourceId = MCU_CLKSRC_2,
        .Mcu_ClockDiv = 0,
        .Mcu_InitCfg  = TRUE,
    },
    [39] =
    {
        .Mcu_ClockModuleId = MCU_CLKSRC_MODULE_ID_WDT3,
        .Mcu_ClockSourceId = MCU_CLKSRC_2,
        .Mcu_ClockDiv = 0,
        .Mcu_InitCfg  = TRUE,
    },
    [40] =
    {
        .Mcu_ClockModuleId = MCU_CLKSRC_MODULE_ID_CONTROLSS_CLK,
        .Mcu_ClockSourceId = MCU_CLKSRC_2,
        .Mcu_ClockDiv = 3,
        .Mcu_InitCfg  = TRUE,
    }
};

static CONST(Mcu_PwmConfigType, MCU_PBCFG) Mcu_PwmConfiguration[MCU_PWM_CHANNEL] =
{
     /* PWM Module Channel Configuration. */
    [0] =
    {
        .Mcu_PwmChannelId = 9U,
        .Mcu_PwmGroupId = 0U,
    },
     /* CDD PWM Module Channel Configuration. */
    [1] =
    {
        .Mcu_PwmChannelId = 0U,
        .Mcu_PwmGroupId = 0U,
    },
    [2] =
    {
        .Mcu_PwmChannelId = 1U,
        .Mcu_PwmGroupId = 0U,
    }
};

static CONST(Mcu_AdcConfigType, MCU_PBCFG) Mcu_AdcConfiguration[MCU_ADC_HWUNIT] =
{
    [0] =
    {
        .Mcu_AdcHWUniId = MCU_ADC_HWUNIT_1,
    }
};

#define  MCU_STOP_SEC_CONFIG_DATA
#include "Mcu_MemMap.h"

#define  MCU_START_SEC_CONFIG_DATA
#include "Mcu_MemMap.h"

/*<MCU_CFG_CONFIG>*/
/* SourceId : MCU_SourceId_041 */

CONST(Mcu_ConfigType, MCU_CONFIG_DATA) McuModuleConfiguration =
{
    .Mcu_ResetMode = MCU_PERFORM_RESET_MODE_WARM,
    /**< Reset mode to be used @sa  MCAL_MCU_API:ResetModes */
    .Mcu_ConfigRamSection = Mcu_RamSectionConfig,
    /**< Configration of Ram Sections */
    .Mcu_NumberOfRamSectors =  1,
    /**< Number of entries in Mcu_ConfigRamSection */
    .Mcu_ClockConfig = Mcu_ClockConfiguration,
    /**< Configuration of Module functional clock source */
    .Mcu_NumberOfClockConfig = 41,
    /**< Number of entries in Mcu_ClockConfig */
#if (STD_OFF == MCU_NO_PLL)
    .Mcu_PllConfig = Mcu_PLLConfiguration,
    /**< PLL Configuration */
    .Mcu_PllSourceId = MCU_CLKSRC_DPLL,
    /**< PLL source selection */
#endif
#if (STD_ON == MCU_PWM_ENABLE)
    .Mcu_Pwmconfig = Mcu_PwmConfiguration,
    /**< PWM Configuration */
#endif
#if (STD_ON == MCU_ADC_ENABLE)
    .Mcu_AdcConfig = Mcu_AdcConfiguration,
    /**< ADC Configuration */
#endif
};

void Mcu_IntXbar(void)
{
    /* Interrupt XBAR */

    MCU_xbarSelectInterruptXBarInputSource(MCU_CSL_CONTROLSS_INTXBAR_U_BASE, MCU_INTRXBAR0_OUT_0,MCU_INT_XBAR_EPWM9_INT, 0, 0, 0, 0, 0, 0);
    MCU_xbarSelectInterruptXBarInputSource(MCU_CSL_CONTROLSS_INTXBAR_U_BASE, MCU_INTRXBAR0_OUT_1,0, 0, MCU_INT_XBAR_ADC1_INT1, 0, 0, 0, 0);
    MCU_xbarSelectInterruptXBarInputSource(MCU_CSL_CONTROLSS_INTXBAR_U_BASE, MCU_INTRXBAR0_OUT_3,0, 0, 0, MCU_INT_XBAR_FSITX1_INT1N, 0, 0, 0);
    MCU_xbarSelectInterruptXBarInputSource(MCU_CSL_CONTROLSS_INTXBAR_U_BASE, MCU_INTRXBAR0_OUT_4,0, 0, 0, MCU_INT_XBAR_FSIRX1_INT1N, 0, 0, 0);
    MCU_xbarSelectInterruptXBarInputSource(MCU_CSL_CONTROLSS_INTXBAR_U_BASE, MCU_INTRXBAR0_OUT_22,0, 0, 0, 0, 0, MCU_INT_XBAR_ECAP0_INT, 0);
    MCU_xbarSelectInterruptXBarInputSource(MCU_CSL_CONTROLSS_INTXBAR_U_BASE, MCU_INTRXBAR0_OUT_5,MCU_INT_XBAR_EPWM0_INT, 0, 0, 0, 0, 0, 0);
    MCU_xbarSelectInterruptXBarInputSource(MCU_CSL_CONTROLSS_INTXBAR_U_BASE, MCU_INTRXBAR0_OUT_6,0, MCU_INT_XBAR_EPWM0_TZINT, 0, 0, 0, 0, 0);
    MCU_xbarSelectInterruptXBarInputSource(MCU_CSL_CONTROLSS_INTXBAR_U_BASE, MCU_INTRXBAR0_OUT_10,0, 0, 0, MCU_INT_XBAR_FSITX1_INT2N, 0, 0, 0);
    MCU_xbarSelectInterruptXBarInputSource(MCU_CSL_CONTROLSS_INTXBAR_U_BASE, MCU_INTRXBAR0_OUT_11,0, 0, 0, MCU_INT_XBAR_FSIRX1_INT2N, 0, 0, 0);
    MCU_xbarSelectInterruptXBarInputSource(MCU_CSL_CONTROLSS_INTXBAR_U_BASE, MCU_INTRXBAR0_OUT_12,0, 0, 0, MCU_INT_XBAR_FSITX0_INT1N, 0, 0, 0);
    MCU_xbarSelectInterruptXBarInputSource(MCU_CSL_CONTROLSS_INTXBAR_U_BASE, MCU_INTRXBAR0_OUT_13,0, 0, 0, MCU_INT_XBAR_FSITX0_INT2N, 0, 0, 0);
    MCU_xbarSelectInterruptXBarInputSource(MCU_CSL_CONTROLSS_INTXBAR_U_BASE, MCU_INTRXBAR0_OUT_14,0, 0, 0, MCU_INT_XBAR_FSIRX0_INT1N, 0, 0, 0);
    MCU_xbarSelectInterruptXBarInputSource(MCU_CSL_CONTROLSS_INTXBAR_U_BASE, MCU_INTRXBAR0_OUT_15,0, 0, 0, MCU_INT_XBAR_FSIRX0_INT2N, 0, 0, 0);
    MCU_xbarSelectInterruptXBarInputSource(MCU_CSL_CONTROLSS_INTXBAR_U_BASE, MCU_INTRXBAR0_OUT_9,0, 0, 0, MCU_INT_XBAR_FSIRX2_INT1N, 0, 0, 0);
    MCU_xbarSelectInterruptXBarInputSource(MCU_CSL_CONTROLSS_INTXBAR_U_BASE, MCU_INTRXBAR0_OUT_16,0, 0, 0, MCU_INT_XBAR_FSIRX2_INT2N, 0, 0, 0);
    MCU_xbarSelectInterruptXBarInputSource(MCU_CSL_CONTROLSS_INTXBAR_U_BASE, MCU_INTRXBAR0_OUT_7,0, 0, 0, MCU_INT_XBAR_FSITX2_INT1N, 0, 0, 0);
    MCU_xbarSelectInterruptXBarInputSource(MCU_CSL_CONTROLSS_INTXBAR_U_BASE, MCU_INTRXBAR0_OUT_8,0, 0, 0, MCU_INT_XBAR_FSITX2_INT2N, 0, 0, 0);
    MCU_xbarSelectInterruptXBarInputSource(MCU_CSL_CONTROLSS_INTXBAR_U_BASE, MCU_INTRXBAR0_OUT_19,0, 0, 0, MCU_INT_XBAR_FSIRX3_INT1N, 0, 0, 0);
    MCU_xbarSelectInterruptXBarInputSource(MCU_CSL_CONTROLSS_INTXBAR_U_BASE, MCU_INTRXBAR0_OUT_20,0, 0, 0, MCU_INT_XBAR_FSIRX3_INT2N, 0, 0, 0);
    MCU_xbarSelectInterruptXBarInputSource(MCU_CSL_CONTROLSS_INTXBAR_U_BASE, MCU_INTRXBAR0_OUT_17,0, 0, 0, MCU_INT_XBAR_FSITX3_INT1N, 0, 0, 0);
    MCU_xbarSelectInterruptXBarInputSource(MCU_CSL_CONTROLSS_INTXBAR_U_BASE, MCU_INTRXBAR0_OUT_18,0, 0, 0, MCU_INT_XBAR_FSITX3_INT2N, 0, 0, 0);

}

          
void Mcu_InputXbar(void)
{
    /* Input XBAR */

    MCU_xbarSelectInputXBarInputSource(MCU_CSL_CONTROLSS_INPUTXBAR_U_BASE, MCU_INPUT_XBAR0_OUT_1, 0, MCU_INPUT_XBAR_GPIO0, 0);
    MCU_xbarSelectInputXBarInputSource(MCU_CSL_CONTROLSS_INPUTXBAR_U_BASE, MCU_INPUT_XBAR0_OUT_0, 0, MCU_INPUT_XBAR_GPIO61, 0);
    MCU_xbarSelectInputXBarInputSource(MCU_CSL_CONTROLSS_INPUTXBAR_U_BASE, MCU_INPUT_XBAR0_OUT_2, 0, MCU_INPUT_XBAR_GPIO122, 0);

}

    
void Mcu_GpioXbarConfig(void)
{
	/* GPIO XBAR */
  MCU_xbarSelectGpioIntrXbarInputSource(MCU_CSL_GPIO_INTR_XBAR_U_BASE, MCU_GPIO_INT_XBAR_VIM_MODULE0_0, MCU_GPIO_0_BANK_INTR_1);
}

/*</MCU_CFG_CONFIG>*/ 
#define  MCU_STOP_SEC_CONFIG_DATA
#include "Mcu_MemMap.h"
/**********************************************************************************************************************
 *  End of File: Mcu_PBcfg.c
 *********************************************************************************************************************/


