/*
 * main.c
 */
 
 #include <stdbool.h>
#include <stdint.h>
#include "inc/hw_ints.h"
#include "inc/hw_memmap.h"
#include "driverlib/gpio.h"
#include "driverlib/interrupt.h"
#include "driverlib/pin_map.h"
#include "driverlib/pwm.h"
#include "driverlib/sysctl.h"
#include "driverlib/uart.h"
#include "utils/uartstdio.h"



int g_duty;


 
//*****************************************************************************
//
// The interrupt handler for the for PWM0 interrupts.
//
//*****************************************************************************
void
PWM0IntHandler(void)
{
	int s_div ;
    //
    // Clear the PWM0 LOAD interrupt flag.  This flag gets set when the PWM
    // counter gets reloaded.
    //
    PWMGenIntClear(PWM0_BASE, PWM_GEN_0, PWM_INT_CNT_LOAD);

    s_div = PWMGenPeriodGet(PWM0_BASE, PWM_GEN_0) * g_duty / 100;
    PWMPulseWidthSet(PWM0_BASE, PWM_OUT_0, s_div);


}

/*
 * Write Bootcfg register.
 */
void DldInit(void)
{

	// ===================================================
	// 1. Write BOOTCFG offset to FMA register 0x400FD000
	// FMA: D31-D20 RESERVED, D19-D0 OFFSET
	// ===================================================
	*((volatile uint32_t *)(0x400FD000)) = (uint32_t)0x75100000;   // this

	// =================================================
	// 2 . Write bootcfg data to FMD register 0x400FD004.
	// D31-D0 DATA
	// =================================================
	*((volatile uint32_t *)(0x400FD004)) = (uint32_t)0xFFFf33fe;	// Bootcfg value
						// check PB4 pin, EN = 1, KEY = 1, POL = 1,NW = 1, DBG1 = 1, DBG0 = 0

	//=======================================================================
	// 3. Write FMC register 0x400FD008
	// D31-D16 WRKEY, D15-D4 reserved, D3 COMT, D2 MERASE, D1 ERASE, D0 WRITE
	//=======================================================================
	*((volatile uint32_t *)(0x400FD008)) = (uint32_t)0xA4420008; // tried setting write and commit here also

	return;

}

//*****************************************************************************
//
// Configure PWM0 for a load interrupt.  This interrupt will trigger everytime
// the PWM0 counter gets reloaded.  In the interrupt, 0.1% will be added to
// the current duty cycle.  This will continue until a duty cycle of 75% is
// received, then the duty cycle will get reset to 0.1%.
//
//*****************************************************************************
int
main(void)
{

	DldInit();	// This function is executed only if wants to write Bootcfg register.

    //
    // Set the clocking to run directly from the external crystal/oscillator.
    // TODO: The SYSCTL_XTAL_ value must be changed to match the value of the
    // crystal on your board.
    //
#if defined(TARGET_IS_TM4C129_RA0) ||                                         \
    defined(TARGET_IS_TM4C129_RA1) ||                                         \
    defined(TARGET_IS_TM4C129_RA2)
    g_ui32SysClock = SysCtlClockFreqSet((SYSCTL_XTAL_25MHZ |
                                       SYSCTL_OSC_MAIN |
                                       SYSCTL_USE_OSC), 25000000);
#else
    SysCtlClockSet(SYSCTL_SYSDIV_1 | SYSCTL_USE_OSC | SYSCTL_OSC_MAIN |
                   SYSCTL_XTAL_16MHZ);
#endif

    //
    // Set the PWM clock to the system clock.
    //
    SysCtlPWMClockSet(SYSCTL_PWMDIV_1);


    g_duty = 10;	// pwm initial value

    //
    // The PWM peripheral must be enabled for use.
    //
    SysCtlPeripheralEnable(SYSCTL_PERIPH_PWM0);

    //
    // For this example PWM0 is used with PortB Pin6.  The actual port and pins
    // used may be different on your part, consult the data sheet for more
    // information.  GPIO port B needs to be enabled so these pins can be used.
    // TODO: change this to whichever GPIO port you are using.
    //
    SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOB);

    //
    // Configure the GPIO pin muxing to select PWM00 functions for these pins.
    // This step selects which alternate function is available for these pins.
    // This is necessary if your part supports GPIO pin function muxing.
    // Consult the data sheet to see which functions are allocated per pin.
    // TODO: change this to select the port/pin you are using.
    //
    GPIOPinConfigure(GPIO_PB6_M0PWM0);

    //
    // Configure the PWM function for this pin.
    // Consult the data sheet to see which functions are allocated per pin.
    // TODO: change this to select the port/pin you are using.
    //
    GPIOPinTypePWM(GPIO_PORTB_BASE, GPIO_PIN_6);

    //
    // Configure the PWM0 to count down without synchronization.
    //
    PWMGenConfigure(PWM0_BASE, PWM_GEN_0,
                    PWM_GEN_MODE_DOWN | PWM_GEN_MODE_NO_SYNC);

    //
    // Set the PWM period to 250Hz.  To calculate the appropriate parameter
    // use the following equation: N = (1 / f) * SysClk.  Where N is the
    // function parameter, f is the desired frequency, and SysClk is the
    // system clock frequency.
    // In this case you get: (1 / 250Hz) * 16MHz = 64000 cycles.  Note that
    // the maximum period you can set is 2^16.
    //
//    PWMGenPeriodSet(PWM0_BASE, PWM_GEN_0, 64000);
    PWMGenPeriodSet(PWM0_BASE, PWM_GEN_0, 400);

    PWMDeadBandEnable(PWM0_BASE, PWM_GEN_0, 10,10);

	//
    // For this example the PWM0 duty cycle will be variable.  The duty cycle
    // will start at 0.1% (0.01 * 64000 cycles = 640 cycles) and will increase
    // to 75% (0.5 * 64000 cycles = 32000 cycles).  After a duty cycle of 75%
    // is reached, it is reset to 0.1%.  This dynamic adjustment of the pulse
    // width is done in the PWM0 load interrupt, which increases the duty
    // cycle by 0.1% everytime the reload interrupt is received.
    //
    PWMPulseWidthSet(PWM0_BASE, PWM_OUT_0, 64);

    //
    // Enable processor interrupts.
    //
    IntMasterEnable();

    //
    // Allow PWM0 generated interrupts.  This configuration is done to
    // differentiate fault interrupts from other PWM0 related interrupts.
    //
    PWMIntEnable(PWM0_BASE, PWM_INT_GEN_0);

    //
    // Enable the PWM0 LOAD interrupt on PWM0.
    //
    PWMGenIntTrigEnable(PWM0_BASE, PWM_GEN_0, PWM_INT_CNT_LOAD);

    //
    // Enable the PWM0 interrupts on the processor (NVIC).
    //
    IntEnable(INT_PWM0_0);

    //
    // Enable the PWM0 output signal (PD0).
    //
    PWMOutputState(PWM0_BASE, PWM_OUT_0_BIT, true);

    //
    // Enables the PWM generator block.
    //
    PWMGenEnable(PWM0_BASE, PWM_GEN_0);


    //
    // Loop forever while the PWM signals are generated and PWM0 interrupts
    // get received.
    //
    while(1);

}
