/** @file sys_main.c 
*   @brief Application main file
*   @date 11-Dec-2018
*   @version 04.07.01
*
*   This file contains an empty main function,
*   which can be used for the application.
*/

/* 
* Copyright (C) 2009-2018 Texas Instruments Incorporated - www.ti.com 
* 
* 
*  Redistribution and use in source and binary forms, with or without 
*  modification, are permitted provided that the following conditions 
*  are met:
*
*    Redistributions of source code must retain the above copyright 
*    notice, this list of conditions and the following disclaimer.
*
*    Redistributions in binary form must reproduce the above copyright
*    notice, this list of conditions and the following disclaimer in the 
*    documentation and/or other materials provided with the   
*    distribution.
*
*    Neither the name of Texas Instruments Incorporated nor the names of
*    its contributors may be used to endorse or promote products derived
*    from this software without specific prior written permission.
*
*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
*  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*
*/


/* USER CODE BEGIN (0) */
#include <stdio.h>
#include <string.h>
#include <stdarg.h>
#include "sys_core.h"
#include "system.h"
#include "gio.h"
#include "sys_dma.h"
#include "rti.h"
#include "het.h"
#include "sci.h"
#include "lin.h"
#include "sys_vim.h"
#include "spi.h"
#include "adc.h"
#include "ti_fee.h"
#include "F021.h"
#include "bl_flash.h"
#include "bl_config.h"
/* USER CODE END */

/* Include Files */

#include "sys_common.h"

/* USER CODE BEGIN (1) */
#define Enable_SCI_Out

#define BLOCK_PAYLOAD_MAX_LENGTH  992u

//#define DEBUG_RESULT_1
//#define DEBUG_RESULT_2

uint16 u16JobResult, Status;
Std_ReturnType oResult = E_OK;

// VS size = { VS header 32bytes + ( block header 24bytes + block payload "BLOCK_PAYLOAD_MAX_LENGTH"bytes ) * 16 block } = 32 + (24 + 992) * 16 = 16288bytes
uint8 write_data[BLOCK_PAYLOAD_MAX_LENGTH];
uint8 read_data[16][BLOCK_PAYLOAD_MAX_LENGTH];

unsigned char pattern;
uint16 u16writecounter;

unsigned int FeeVirtualSectorNumber;
unsigned char VsState, u8EEPIndex;
unsigned char u8VirtualSector;
uint8 Test_Recovery;
uint8 Test_Cancel;

/*****************************************************************************
 *
 * This is the data buffer used for update status.
 *
 * g_pulUpdateSuccess[] are used to store application update status and application
 * image's version etc
 ******************************************************************************/

uint32_t g_pulUpdateSuccess[] =
        { 0x5A5A5A5A, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 };
uint32_t g_ulUpdateStatusAddr = APP_STATUS_ADDRESS;

void delayus(uint16 us);
void delayms(uint16 ms);
void delay(void);
void sci_printf(sciBASE_t *sci, char *format, ...);
void api_fee_write_block(uint32 blocknum, uint8 *buf);
void api_fee_read_block(uint32 blocknum, uint8 *buf, uint32 buf_length);
void api_fee_invalidate_total_block(void);

/* USER CODE END */

/** @fn void main(void)
*   @brief Application main function
*   @note This function is empty by default.
*
*   This function is called after startup.
*   The user can use this function to implement the application.
*/

/* USER CODE BEGIN (2) */
uint32 RTI_TIMEOUT, _10usTmr, _1msTmr, _1sTmr, main_cnt;

extern unsigned int apiLoadStart;
extern unsigned int apiLoadSize;
extern unsigned int apiRunStart;

/* USER CODE END */

int main(void)
{
/* USER CODE BEGIN (3) */

    /* Copy the flash APIs to SRAM*/
    memcpy(&apiRunStart, &apiLoadStart, (uint32_t) &apiLoadSize);

    /* initialize gio     */
    gioInit();

    /* Initialize RTI driver */
    rtiInit();
    rtiEnableNotification(rtiNOTIFICATION_COMPARE0);
    rtiEnableNotification(rtiNOTIFICATION_COMPARE1);
    rtiEnableNotification(rtiNOTIFICATION_COMPARE2);
    rtiEnableNotification(rtiNOTIFICATION_COMPARE3);

    /* IRQ Ȱȭ - CPS Ϳ I ÷  */
    /* Note: This is usually done by the OS or in an svc dispatcher */
    _enable_interrupt_();

    rtiStartCounter(rtiCOUNTER_BLOCK0);
    rtiStartCounter(rtiCOUNTER_BLOCK1);

    /* initialize sci/sci-lin, even parity , 1 stop bits */
    sciInit();

    /* initialize ADC  */
    /* Group1 -> Channel 0 and 1                        */
    /* HW trigger trigger source as GIOB  Pin 0         */
    adcInit();
    adcCalibration(adcREG1);
    adcCalibration(adcREG2);
    adcStartConversion(adcREG1, adcGROUP1);
    adcStartConversion(adcREG2, adcGROUP1);

    sci_printf(scilinREG, "EEPROM Test\n\r");

    /* FEE ʱȭ (  ǰ   ʱȭ) */
    TI_Fee_Init();
    do
    {
        TI_Fee_MainFunction();
        delay(); //delayms(1);
        Status = TI_Fee_GetStatus(0);
    }
    while (Status != IDLE);

    static uint16_t test_value, old_test_value, test_status, test_block_num;
    uint32 loop;

    while (1)
    {
        main_cnt++;

        if (_10usTmr != 0u)
        {
            _10usTmr = 0u;
        }

        if (_1msTmr != 0u)
        {
            _1msTmr = 0u;
        }

        if (_1sTmr != 0u)
        {
            // 1.   
            if(old_test_value != test_value)
            {
                /* RAM 迭 ʱȭ */
                for (loop = 0; loop < BLOCK_PAYLOAD_MAX_LENGTH; loop++)
                {
                    write_data[loop] = test_value;
                }
            }

#if defined (DEBUG_RESULT_1)
            switch (test_status)
            {
            case 0u:    // test case 0
                test_value = 0x01;
                break;
            case 1u:    // ü  ȿȭ
                api_fee_invalidate_total_block();
                test_status++;
                break;
            case 2u:    // ü  write
                for (test_block_num = 1; test_block_num <= 16; test_block_num++)
                {
                    api_fee_write_block(test_block_num, &write_data[0]);
                }
                test_status++;
                break;
            case 3u:    // ü  read
                for (test_block_num = 1; test_block_num <= 16; test_block_num++)
                {
                    api_fee_read_block(test_block_num, &read_data[test_block_num - 1][0], (uint32)BLOCK_PAYLOAD_MAX_LENGTH);
                }
                test_status++;
                break;
            case 4u:    // test case 0
                test_value++;
                if(test_value == 0xAAu)
                {
                    test_value = 0x01u;
                }
                test_status = 1u;
                break;
            default:
                break;
            }
#elif defined (DEBUG_RESULT_2)
            switch (test_status)
            {
            case 0u:    // test case 0
                test_value = 0x01;
                break;
            case 1u:    // ü  ȿȭ
                api_fee_invalidate_total_block();
                test_status++;
                break;
            case 2u:    // ü  ȿȭ
                api_fee_invalidate_total_block();
                test_status++;
                break;
            case 3u:    // ü  write
                for (test_block_num = 1; test_block_num <= 16; test_block_num++)
                {
                    api_fee_write_block(test_block_num, &write_data[0]);
                }
                test_status++;
                break;
            case 4u:    // ü  read
                for (test_block_num = 1; test_block_num <= 16; test_block_num++)
                {
                    api_fee_read_block(test_block_num, &read_data[test_block_num - 1][0], (uint32)BLOCK_PAYLOAD_MAX_LENGTH);
                }
                test_status++;
                break;
            case 5u:    // test case 0
                test_value++;
                if(test_value == 0xAAu)
                {
                    test_value = 0x01u;
                }
                test_status = 1u;
                break;
            default:
                break;
            }
#else
            // 2. InvalidateBlock -> Write Block -> Read Block
            switch (test_status)
            {
            case 0u:    // test case 0
//                test_value++;
//                test_status++;
                break;
            case 1u:    // ü  write
                for (test_block_num = 1; test_block_num <= 16; test_block_num++)
                {
                    api_fee_write_block(test_block_num, &write_data[0]);
                }
                test_status = 0u;
                break;
            case 2u:    // ü  read
                for (test_block_num = 1; test_block_num <= 16; test_block_num++)
                {
                    api_fee_read_block(test_block_num, &read_data[test_block_num - 1][0], (uint32)BLOCK_PAYLOAD_MAX_LENGTH);
                }
                test_status = 0u;
                break;
            case 3u: // Ư  write
                api_fee_write_block(test_block_num, &write_data[0]);
                test_status = 0u;
                break;
            case 4u:    // Ư  read
                api_fee_read_block(test_block_num, &read_data[test_block_num - 1][0], (uint32)BLOCK_PAYLOAD_MAX_LENGTH);
                test_status = 0u;
                break;
            case 5u:    // ü  ȿȭ
                api_fee_invalidate_total_block();
                test_status = 0u;
                break;
            default:
                break;
            }
#endif
            _1sTmr = 0u;
        }
    }

    /* USER CODE END */

    return 0;
}


/* USER CODE BEGIN (4) */
void delayus(uint16 us)
{
    if (us == 0)
    {
        ;
    }
    else
    {
        //CHANGE THE INTERRUPT COMPARE VALUES (PERIOD OF INTERRUPT)
        //Setup compare 0 value.
        rtiREG1->CMP[0U].COMPx = 10 * us; //10 ticks of clock per microsecond, so multiply by 10
        //Setup update compare 0 value.
        rtiREG1->CMP[0U].UDCPx = 10 * us;

        //ENABLE THE NOTIFICATION FOR THE PERIOD WE SET
        rtiEnableNotification(rtiNOTIFICATION_COMPARE0);

        //START THE COUNTER
        rtiStartCounter(rtiCOUNTER_BLOCK0);

        //WAIT IN LOOP UNTIL THE INTERRUPT HAPPENS (HAPPENS AFTER THE PERIOD WE SET)
        //WHEN INTERRUPT HAPPENS, RTI_NOTIFICATION GETS SET TO 1 IN THAT INTERRUPT
        //GO TO notification.c -> rtiNotification() to see where RTI_TIMEOUT is set to 1
        while (RTI_TIMEOUT == 0)
            ;

        //RESET THE VARIABLE TO 0, FOR THE NEXT TIME WE DO A DELAY
        RTI_TIMEOUT = 0;

        //DISABLE THE INTERRUPT NOTIFICATION
        rtiDisableNotification(rtiNOTIFICATION_COMPARE0);

        //STOP THE COUNTER
        rtiStopCounter(rtiCOUNTER_BLOCK0);

        //RESET COUNTER FOR THE NEXT TIME WE DO A DELAY
        rtiResetCounter(rtiCOUNTER_BLOCK0);
    }
}

void delayms(uint16 ms)
{
    if (ms == 0)
    {
        ;
    }
    else
    {
        rtiREG1->CMP[0U].COMPx = 10000 * ms;
        rtiREG1->CMP[0U].UDCPx = 10000 * ms;
        rtiEnableNotification(rtiNOTIFICATION_COMPARE0);
        rtiStartCounter(rtiCOUNTER_BLOCK0);
        while (RTI_TIMEOUT == 0)
            ;
        RTI_TIMEOUT = 0;
        rtiDisableNotification(rtiNOTIFICATION_COMPARE0);
        rtiStopCounter(rtiCOUNTER_BLOCK0);
        rtiResetCounter(rtiCOUNTER_BLOCK0);
    }
}

void delay(void)
{
    unsigned int dummycnt=0x000FFFU;    // FFU
    do
    {
        dummycnt--;
    }
    while(dummycnt>0);
}

/** @fn void sci_printf(void)
 *   @brief printf over sci function
 *   @note This will transmit a formated variable argument string
 *
 *   This requires sciInit() to be called before to setup SCI2.
 *   Length of resulting string is not to exceed length of local buffer variable.
 *
 *   Use compile time option Enable_CIO for debugging over JTAG to console or file.
 */
void sci_printf(sciBASE_t *sci, char *format, ...)
{
    uint8 cSCI_printfbuffer[256] = { 0 };
    uint32 length;

#ifdef Enable_CIO
    printf(format);
#endif

#ifdef Enable_SCI_Out
    va_list args;
    va_start(args, format);
    length = vsprintf((char*) cSCI_printfbuffer, format, args);
    va_end(args);
    cSCI_printfbuffer[length + 1] = 0;
    cSCI_printfbuffer[length + 2] = 0;
    sciSend(sci, strlen((const char*) cSCI_printfbuffer) + 3,
            cSCI_printfbuffer);
#endif

#ifdef Enable_File_CIO
    fprintf(fid, format);
#endif
} // sci_printf

void api_fee_write_block(uint32 blocknum, uint8 *buf)
{
    _disable_interrupt_();
    TI_Fee_WriteAsync(blocknum, buf);
    do
    {
        TI_Fee_MainFunction();
        delay();
        Status = TI_Fee_GetStatus(0);
    }
    while (Status != IDLE);
    _enable_interrupt_();
}

void api_fee_read_block(uint32 blocknum, uint8 *buf, uint32 buf_length)
{
    _disable_interrupt_();
    oResult = TI_Fee_Read(blocknum, 0, buf, buf_length);
    do
    {
        TI_Fee_MainFunction();
        delay();
        Status = TI_Fee_GetStatus(0);
    }
    while (Status != IDLE);
    _enable_interrupt_();
}

void api_fee_invalidate_total_block(void)
{
    uint32 blocknum;

    _disable_interrupt_();
    for (blocknum = 1; blocknum <= 16; blocknum++)
    {
        TI_Fee_InvalidateBlock(blocknum);
        do
        {
            TI_Fee_MainFunction();
            delay();
            Status = TI_Fee_GetStatus(0);
        }
        while (Status != IDLE);
    }
    _enable_interrupt_();
}

/* USER CODE END */
