## FreeRTOS for TI TMS570LC43x

foxBMS 2 uses FreeRTOS as operating system.
This document gives a short overview of the changes that were applied to have
FreeRTOS working on the ``TI TMS570LC43x`` in a project specific way.

## Basis

The basis for FreeRTOS within the foxBMS 2 project is
``FreeRTOS Kernel V10.4.5``.

## Changes

The ``TI HALCoGen`` code generator provides an option to create FreeRTOS
sources accordingly to the ``HALCoGen`` configuration.
The foxBMS 2 specific configuration of the ``TI TMS570LC43x`` is found in
[conf/hcg](../../../conf/hcg).

However, the generated FreeRTOS sources are not the up-to-date with the current
FreeRTOS Kernel releases (see <https://github.com/FreeRTOS/FreeRTOS-Kernel>).

The FreeRTOS sources downloaded from GitHub have been updated with the required
changes that were included in the generated FreeRTOS sources from TI's
``HALCoGen``. These changes can be found by searching for the text

```
required for Cortex-R5 MPU port - generated by TI HALCoGen - see src/os/freertos/README.ti-halcogen.md for details
```

in

- ``src/os/freertos/**/*.asm``,
- ``src/os/freertos/**/*.c`` and
- ``src/os/freertos/**/*.h``.

The license agreement of the ``HALCoGen`` software and the generated sources
can be read at
``<halcogen-install-dir>/Production_License_Agreement_062612.pdf``.

## Further Reading

Additional information on FreeRTOS usage and changes are found in
[docs/software/configuration/configuration.rst](../../../docs/software/configuration/configuration.rst)
