/*
 * common.h
 *
 */

#ifndef COMMON_H_
#define COMMON_H_

/* Include header files that are used in multiple modules */
    #include <string.h>
    #include <ti/drivers/GPIO.h>
    #include <ti/drivers/UART.h>
    #include <ti_drivers_config.h>

    #include "msp432.h"
    #include "tmp117.h"

/* The control table used by the uDMA controller.  This table must be aligned
 * to a 1024 byte boundary. */
    #if defined(__ICCARM__)
    #pragma data_alignment=1024
    uint8_t pui8ControlTable[1024];
    #elif defined(__TI_ARM__)
    #pragma DATA_ALIGN(pui8ControlTable, 1024)
    uint8_t pui8ControlTable[1024];
    #else
    uint8_t pui8ControlTable[1024] __attribute__ ((aligned(1024)));
    #endif

/* Function Protocols used in multiple modules */

/* Project Global Variables */                   // Do not initialize variable values here! (Compiler error)
    bool        tempReady;                       // semaphore indicating that temperature data is ready

    uint8_t     *temp_result;                    // pointer to temperature sensor data array

/* Project Global Macros */

//*****************************************************************************
// Defines for setting up the system clock.
//*****************************************************************************
    #define SYSTICKHZ               100
    #define SYSTICKMS               (1000 / SYSTICKHZ)

/* MSP432E4Y01 Launchpad main oscillator nominal frequency in Hz */
    #define SYSOSCFREQ    25000000
/* MSP432E4Y01 Launchpad nominal system frequency in Hz */
    #define SYSCLKFREQ    25000000

#endif /* COMMON_H_ */
