#include "common.h"
#include "tmp117.h"

//******************************************************************************
// 
//******************************************************************************
int init_temperature(void) {
    int              result;
    int              param;
    int              status = 0;

    tempTrans.writeBuf     = tempTxBuff;
    tempTrans.readBuf      = tempRxBuff;
    tempTrans.slaveAddress = TEMP_ADDR;

    temp_result = readTemp_reg(ID_REG, TEMP_RD_SIZE);

    while(!tempReady);
    tempReady = false;

    result = (((temp_result[0] & 0x0F) << 8) | temp_result[1]);
    if ((result & DEVICE_ID_MASK) != DEVICE_ID) return -1; // exit with error code -1 to indicate that TMP117 does not respond

    param = CONTINUOUS | CONV_3 | AVG_8 | ALERT | HIGH | DATA_READY; // configure temperature sensor for continuous sampling

    result = writeTemperature(CONFIG_REG, param);
    if (result != 0) status = (1 << 0);

    while(!tempReady);
    tempReady = false;

    temp_result = readTemp_reg(CONFIG_REG, TEMP_RD_SIZE);
    if (temp_result == NULL) status = (1 << 1);

    while(!tempReady);
    tempReady = false;

    if ((((temp_result[0] & 0x0F) << 8) |        // if the returned value does not match the expected value
          temp_result[1]) != param)
        status = (1 << 2);

    temp_result = readTemp_reg(TEMP_REG, TEMP_RD_SIZE); // read temperature result register to set register ID for subsequent reads
    if (temp_result == NULL) status = (1 << 1);

    while(!tempReady);
    tempReady = false;

    return status;
}

int writeTemperature(int dest, int val) {
    bool status;

    tempTxBuff[0] = dest;
    tempTxBuff[1] = (0xFF & val>>8);
    tempTxBuff[2] = (0xFF & val);
    tempTrans.writeCount = TEMP_WR_SIZE;
    tempTrans.readCount = 0;
    status = I2C_transfer(tempI2C, &tempTrans);

    if (status)
        return 0;
    else
        return -1;
}

uint8_t* readTemp_reg(int src, int count) {
    bool status;
    tempTxBuff[0] = src;
    tempTrans.writeCount = 1;
    tempTrans.readCount = count;
    status = I2C_transfer(tempI2C, &tempTrans);

    if (status)
        return tempRxBuff;
    else
        return NULL;
}

uint8_t* readTemp_data(void) {
    bool status;

    tempTrans.writeCount = 0;
    tempTrans.readCount = TEMP_RD_SIZE;
    status = I2C_transfer(tempI2C, &tempTrans);

    if (status)
        return tempRxBuff;
    else
        return NULL;
}

void tempCallBack(I2C_Handle handle, I2C_Transaction *transaction, bool transferStatus){
    tempReady = true;                            // set i2c bus data ready semaphore
}

//******************************************************************************
// Callback function for the GPIO interrupt on TEMP_DRDY.
//******************************************************************************
void tempReadyFxn(uint8_t index)
{
    GPIO_disableInt(TEMP_DRDY);                  // disable TEMP_DRDY interrupt until we service this one
    GPIO_clearInt(TEMP_DRDY);

    temp_result = readTemp_data();               // transfer data from sensor to memory

    GPIO_enableInt(TEMP_DRDY);                   // reenable TEMP_DRDY interrupt
}
