/* Standard Includes */
#include <stdint.h>
#include <stdbool.h>

#include "common.h"

/* Defines for I2C bus parameters */
    #define TEMP_ADDR       0x48
    #define TEMP_REG        0x00
    #define CONFIG_REG      0x01
    #define ID_REG          0x0F
    #define TEMP_RD_SIZE    2
    #define TEMP_WR_SIZE    3
    #define CONTINUOUS      0x0000      // continuous converion
    #define TEMP_ONE_SHOT   0x0C00      // one-shot conversion
    #define CONV_3          0x0180      // 500 mS conversion cycle
    #define AVG_8           0x0020      // 8 averaged conversions
    #define ALERT           0x0000      // Alert mode
    #define HIGH            0x0000      // alert pin acitve low
    #define DATA_READY      0x0004      // alert pin indicates data ready
    #define DEVICE_ID       0x0117      // TMP117 device ID value
    #define DEVICE_ID_MASK  0x0FFF      // device ID field mask

/* Function Prototypes */
    int init_temperature();
    int  writeTemperature(int, int);
    uint8_t* readTemp_reg(int, int);
    uint8_t* readTemp_data();
    void tempCallBack(I2C_Handle, I2C_Transaction *, bool);
    void tempReadyFxn(uint8_t);

/* Function Variables */
    I2C_Transaction         tempTrans;
    uint8_t                 tempTxBuff[TEMP_WR_SIZE];
    uint8_t                 tempRxBuff[TEMP_RD_SIZE];
