/*
 *  Copyright (C) 2021 Texas Instruments Incorporated
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/*
 * Auto generated file
 */

#ifndef TI_DRIVERS_CONFIG_H_
#define TI_DRIVERS_CONFIG_H_

#include <stdint.h>
#include <drivers/hw_include/cslr_soc.h>
#include <drivers/hw_include/hw_types.h>
#include "ti_dpl_config.h"

#ifdef __cplusplus
extern "C" {
#endif


/*
 * Common Functions
 */
void System_init(void);
void System_deinit(void);

/*
 * MCAN
 */
#include <drivers/mcan.h>

/* MCAN Instance Macros */
#define CONFIG_MCAN0_BASE_ADDR (CSL_MCAN2_MSG_RAM_U_BASE)
#define CONFIG_MCAN0_INTR  (CSLR_R5FSS0_CORE0_INTR_MCAN2_MCAN_LVL_INT_0)
#define CONFIG_MCAN0_INTR1 (CSLR_R5FSS0_CORE0_INTR_MCAN2_MCAN_LVL_INT_1)
#define CONFIG_MCAN_NUM_INSTANCES (1U)


/* ----------- TimerP ----------- */
#include <drivers/rti/v0/rti.h>
#include <drivers/soc.h>
#include <kernel/dpl/AddrTranslateP.h>

#define CONFIG_RTI0                        (0u)
#define CONFIG_RTI0_BASE_ADDR              (0x52181000u)
#define CONFIG_RTI0_INPUT_CLK_HZ           (25000000u)
#define CONFIG_RTI0_CNTR0_OUTPUT_CLK_HZ    (1000000u)
#define CONFIG_RTI0_COMP0_SRC              (RTI_TMR_CNT_BLK_INDEX_0)
#define CONFIG_RTI0_COMP0_INPUT_CLK_HZ     (1000000u)
#define CONFIG_RTI0_USEC_PER_TICK_COMP0    (1000000u)
#define CONFIG_RTI0_NSEC_PER_TICK_COMP0    (1000000000u)
#define CONFIG_RTI0_INT_NUM_EVENT0         (91u)
#define CONFIG_RTI0_INT_NUM_EVENT1         (92u)
#define CONFIG_RTI0_INT_NUM_EVENT2         (93u)
#define CONFIG_RTI0_INT_NUM_EVENT3         (94u)
#define CONFIG_RTI0_LOCK_UNLOCK_DOMAIN     (SOC_DOMAIN_ID_MAIN)
#define CONFIG_RTI0_LOCK_UNLOCK_PARTITION  (MSS_RCM_PARTITION0)
#define CONFIG_RTI0_CLOCK_SRC_MUX_ADDR     (0x53208118u)
#define CONFIG_RTI0_CLOCK_SRC_VALUE        (0x0u)
#define CONFIG_RTI0_CLOCK_SRC_WUCPUCLK (0x0u)
#define RTI_NUM_INSTANCES                     (1u)


/*
 * UART
 */
#include <drivers/uart.h>
/* UART Instance Macros */
#define CONFIG_UART0 (0U)
#define CONFIG_UART_NUM_INSTANCES (1U)
#define CONFIG_UART_NUM_DMA_INSTANCES (0U)


#include <drivers/soc.h>
#include <kernel/dpl/CycleCounterP.h>


#ifdef __cplusplus
}
#endif

#endif /* TI_DRIVERS_CONFIG_H_ */
