/*
 *  Copyright (C) 2021 Texas Instruments Incorporated
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/*
 * Auto generated file
 */

#include "ti_drivers_open_close.h"
#include <kernel/dpl/DebugP.h>

void Drivers_open(void)
{
    Drivers_mcanOpen();
    Drivers_rtiOpen();
    Drivers_uartOpen();
}

void Drivers_close(void)
{
    Drivers_mcanClose();
    Drivers_uartClose();
}


void Drivers_mcanOpen(void)
{
    return;
}

void Drivers_mcanClose(void)
{
    return;
}
HwiP_Object gRtiEvent0HwiObj[RTI_NUM_INSTANCES];
HwiP_Object gRtiEvent1HwiObj[RTI_NUM_INSTANCES];
HwiP_Object gRtiEvent2HwiObj[RTI_NUM_INSTANCES];
HwiP_Object gRtiEvent3HwiObj[RTI_NUM_INSTANCES];

void RTI0_event0Isr(void *args)
{
    void RTIPeriodicISR(void *args);

    RTIPeriodicISR(args);
    RTI_intStatusClear(CONFIG_RTI0_BASE_ADDR, RTI_TMR_INT_INT0_FLAG);
    HwiP_clearInt(CONFIG_RTI0_INT_NUM_EVENT0);
}

void Drivers_rtiOpen(void)
{
    HwiP_Params rtiHwiParams;
    int32_t status;
    uint32_t baseAddr;
    uint32_t cntrPrescaler;
    uint64_t timeInNsec;
    uint32_t compPrescaler;

    baseAddr = CONFIG_RTI0_BASE_ADDR;

    /* Configure RTI input clock source */
    SOC_controlModuleUnlockMMR(SOC_DOMAIN_ID_MAIN, MSS_RCM_PARTITION0);
    *(volatile uint32_t*)AddrTranslateP_getLocalAddr(CONFIG_RTI0_CLOCK_SRC_MUX_ADDR) = CONFIG_RTI0_CLOCK_SRC_WUCPUCLK;
    SOC_controlModuleLockMMR(SOC_DOMAIN_ID_MAIN, MSS_RCM_PARTITION0);

    /* Enable/Disable Continue on Suspend */
    RTIG_setStallMode(baseAddr, RTI_GC_STALL_MODE_OFF);

    /* Configure Counter block 0 */
    cntrPrescaler = (CONFIG_RTI0_INPUT_CLK_HZ/CONFIG_RTI0_CNTR0_OUTPUT_CLK_HZ) - 1;
    RTI_counterConfigure(baseAddr, RTI_TMR_CNT_BLK_INDEX_0, RTI_TMR_CLK_SRC_COUNTER, RTI_TMR_NTU_0, cntrPrescaler);
    RTI_captureConfig(baseAddr, RTI_TMR_CNT_BLK_INDEX_0, RTI_TMR_CAPTURE_EVT_1);


    /* Configure Compare event 0 */
    timeInNsec = CONFIG_RTI0_NSEC_PER_TICK_COMP0;
    if(timeInNsec == 0)
    {
        timeInNsec = CONFIG_RTI0_USEC_PER_TICK_COMP0 * 1000U;
    }
    compPrescaler = (timeInNsec*CONFIG_RTI0_COMP0_INPUT_CLK_HZ)/1000000000;

    RTI_compareEventConfig(baseAddr, RTI_TMR_CMP_BLK_INDEX_0, CONFIG_RTI0_COMP0_SRC, compPrescaler, compPrescaler);
    RTI_intStatusClear(baseAddr, RTI_TMR_INT_INT0_FLAG);
    HwiP_Params_init(&rtiHwiParams);
    rtiHwiParams.intNum = CONFIG_RTI0_INT_NUM_EVENT0;
    rtiHwiParams.callback = RTI0_event0Isr;
    rtiHwiParams.isPulse = 0;
    rtiHwiParams.priority = 4;
    status = HwiP_construct(&gRtiEvent0HwiObj[CONFIG_RTI0], &rtiHwiParams);
    DebugP_assertNoLog(status==SystemP_SUCCESS);

    RTI_intEnable(baseAddr, RTI_TMR_INT_INT0_FLAG);

    RTI_intDisable(baseAddr, RTI_TMR_INT_DMA0_FLAG);

}

/*
 * UART
 */

/* UART Driver handles */
UART_Handle gUartHandle[CONFIG_UART_NUM_INSTANCES];

#include <drivers/uart/v0/lld/dma/uart_dma.h>
#include <kernel/dpl/ClockP.h>
#include <drivers/edma.h>
/* EDMA driver confiurations */
EDMA_Config gEdmaConfig[] =
{
};

uint32_t gEdmaConfigNum = 0;

UART_DmaChConfig gUartDmaChConfig[CONFIG_UART_NUM_INSTANCES] =
{
                NULL,
};

/* UART Driver Parameters */
UART_Params gUartParams[CONFIG_UART_NUM_INSTANCES] =
{
        {
            .baudRate           = 115200,
            .dataLength         = UART_LEN_8,
            .stopBits           = UART_STOPBITS_1,
            .parityType         = UART_PARITY_NONE,
            .readMode           = UART_TRANSFER_MODE_BLOCKING,
            .readReturnMode     = UART_READ_RETURN_MODE_FULL,
            .writeMode          = UART_TRANSFER_MODE_BLOCKING,
            .readCallbackFxn    = NULL,
            .writeCallbackFxn   = NULL,
            .hwFlowControl      = FALSE,
            .hwFlowControlThr   = UART_RXTRIGLVL_16,
            .transferMode       = UART_CONFIG_MODE_INTERRUPT,
            .skipIntrReg         = FALSE,
            .uartDmaIndex = -1,
            .intrNum            = 38U,
            .intrPriority       = 4U,
            .operMode           = UART_OPER_MODE_16X,
            .rxTrigLvl          = UART_RXTRIGLVL_8,
            .txTrigLvl          = UART_TXTRIGLVL_32,
            .rxEvtNum           = 0U,
            .txEvtNum           = 0U,
        },
};

void Drivers_uartOpen(void)
{
    uint32_t instCnt;
    int32_t  status = SystemP_SUCCESS;

    for(instCnt = 0U; instCnt < CONFIG_UART_NUM_INSTANCES; instCnt++)
    {
        gUartHandle[instCnt] = NULL;   /* Init to NULL so that we can exit gracefully */
    }

    /* Open all instances */
    for(instCnt = 0U; instCnt < CONFIG_UART_NUM_INSTANCES; instCnt++)
    {
        gUartHandle[instCnt] = UART_open(instCnt, &gUartParams[instCnt]);
        if(NULL == gUartHandle[instCnt])
        {
            DebugP_logError("UART open failed for instance %d !!!\r\n", instCnt);
            status = SystemP_FAILURE;
            break;
        }
    }

    if(SystemP_FAILURE == status)
    {
        Drivers_uartClose();   /* Exit gracefully */
    }

    return;
}

void Drivers_uartClose(void)
{
    uint32_t instCnt;

    /* Close all instances that are open */
    for(instCnt = 0U; instCnt < CONFIG_UART_NUM_INSTANCES; instCnt++)
    {
        if(gUartHandle[instCnt] != NULL)
        {
            UART_close(gUartHandle[instCnt]);
            gUartHandle[instCnt] = NULL;
        }
    }

    return;
}
