//*****************************************************************************
//
// simple_tx.c - Example demonstrating simple CAN message transmission.
//
//*****************************************************************************

#include <stdbool.h>
#include <stdint.h>
#include <stdio.h>
#include "hw_types.h"
#include "hw_can.h"
#include "hw_ints.h"
#include "hw_memmap.h"
#include "can.h"
#include "gpio.h"
#include "interrupt.h"
#include "pin_map.h"
#include "sysctl.h"
#include "uart.h"
#include "rom.h"
#include "rom_map.h"
//#include "utils/uartstdio.h"
#include "pin_map.h"


#define RED_LED   GPIO_PIN_1
#define BLUE_LED  GPIO_PIN_2
#define GREEN_LED GPIO_PIN_3

bool ColorToggle = true;

//*****************************************************************************
volatile uint32_t g_ui32MsgCount = 0;

//*****************************************************************************
//
// A flag to indicate that some transmission error occurred.
//
//*****************************************************************************
volatile bool g_bErrFlag = 0;

//*****************************************************************************
//
// This function provides a 1 second delay using a simple polling method.
//
//*****************************************************************************

#define CAN_BITRATE 125000
#define DISABLE_CAN_AUTO_RETRANSMIT false

uint32_t g_SysClock;
volatile bool g_bRxFlag  = false;
uint8_t RxData[8];
tCANMsgObject TxMsgObjConfig;
tCANMsgObject RxMsgObjConfig;
uint8_t TxData[8] = {1,2,3,4,5,6,7,8};

void DelayFunction(void)
{
    //
    // Delay cycles for 1 second
    //
    SysCtlDelay(12000000);
}

//*****************************************************************************
//
// This function is the interrupt handler for the CAN peripheral.  It checks
// for the cause of the interrupt, and maintains a count of all messages that
// have been transmitted.
//
//*****************************************************************************
void
CANIntHandler(void)
{
    uint32_t ui32Status;

    GPIOPinWrite(GPIO_PORTF_BASE, GREEN_LED, GREEN_LED);
    GPIOPinWrite(GPIO_PORTF_BASE, RED_LED,   0);

    //
    // Read the CAN interrupt status to find the cause of the interrupt
    //
    ui32Status = CANIntStatus(CAN0_BASE, CAN_INT_STS_CAUSE);

    //
    // If the cause is a controller status interrupt, then get the status
    //
    if(ui32Status == CAN_INT_INTID_STATUS)
    {
        //
        // Read the controller status.  This will return a field of status
        // error bits that can indicate various errors.  Error processing
        // is not done in this example for simplicity.  Refer to the
        // API documentation for details about the error status bits.
        // The act of reading this status will clear the interrupt.  If the
        // CAN peripheral is not connected to a CAN bus with other CAN devices
        // present, then errors will occur and will be indicated in the
        // controller status.
        //
        ui32Status = CANStatusGet(CAN0_BASE, CAN_STS_CONTROL);

        //
        // Set a flag to indicate some errors may have occurred.
        //
        g_bErrFlag = 1;
    }

    //
    // Check if the cause is message object 1, which what we are using for
    // sending messages.
    //
    else if(ui32Status == 1)
    {
        //
        // Getting to this point means that the TX interrupt occurred on
        // message object 1, and the message TX is complete.  Clear the
        // message object interrupt.
        //
        CANIntClear(CAN0_BASE, 1);

        // Increment a counter to keep track of how many messages have been
        // sent.
        g_ui32MsgCount++;

        //
        // Since the message was sent, clear any error flags.
        //
        g_bErrFlag = 0;
    }
    else if (ui32Status == 2)
    {
        CANMessageGet(CAN0_BASE, 2, &RxMsgObjConfig, true);
        CANIntClear(CAN0_BASE, 2);
        g_bRxFlag = true;
    }

    //
    // Otherwise, something unexpected caused the interrupt.  This should
    // never happen.
    //
    else
    {
        //
        // Spurious interrupt handling can go here.
        //
    }
}

//*****************************************************************************
//
// Configure the CAN and enter a loop to transmit periodic CAN messages.
//
//*****************************************************************************


int main(void)
{

    SysCtlClockSet(SYSCTL_SYSDIV_2_5 | SYSCTL_XTAL_20MHZ | SYSCTL_USE_PLL | SYSCTL_OSC_MAIN);  // Should be 80MHz
/*
    SysCtlMOSCConfigSet(SYSCTL_MOSC_HIGHFREQ);
    g_SysClock = MAP_SysCtlClockFreqSet((SYSCTL_XTAL_12MHZ |
                                                 SYSCTL_OSC_MAIN |
                                                 SYSCTL_USE_PLL |
                                                 SYSCTL_CFG_VCO_480), 120000000);

    SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOB);
    GPIOPinConfigure(GPIO_PB1_CAN1TX);
    GPIOPinConfigure(GPIO_PB0_CAN1RX);
    GPIOPinTypeCAN(GPIO_PORTB_BASE, GPIO_PIN_1 | GPIO_PIN_0);
    SysCtlPeripheralEnable(SYSCTL_PERIPH_CAN1);
    while (!SysCtlPeripheralReady(SYSCTL_PERIPH_CAN1));
*/
    SysCtlPeripheralEnable(SYSCTL_PERIPH_CAN0);                             // Enable CAN 0.
    while( ! SysCtlPeripheralReady(SYSCTL_PERIPH_CAN0))  {}

    SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOE);
    SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOF);


    GPIOPinConfigure(GPIO_PE4_CAN0RX);
    GPIOPinConfigure(GPIO_PE5_CAN0TX);
    GPIOPinTypeCAN  (GPIO_PORTE_BASE, GPIO_PIN_4 | GPIO_PIN_5 );      // CAN I/O

    GPIOPinTypeGPIOOutput(GPIO_PORTF_BASE, RED_LED | BLUE_LED | GREEN_LED);
/*
    CANInit(CAN1_BASE);
    CANBitRateSet(CAN1_BASE, g_SysClock, CAN_BITRATE);
    CANRetrySet(CAN1_BASE, DISABLE_CAN_AUTO_RETRANSMIT);

    CANIntRegister(CAN1_BASE, CANIntHandler);
    CANIntEnable(CAN1_BASE, CAN_INT_MASTER | CAN_INT_ERROR | CAN_INT_STATUS);

    // Enable the CAN interrupt on the processor (NVIC).
    IntEnable(INT_CAN1);
    // Enable the CAN for operation.
    CANEnable(CAN1_BASE);
*/
    CANInit(CAN0_BASE);                                                 // Init CAN 0.
    CANBitRateSet(CAN0_BASE, 80000000, 500000);

    CANRetrySet(CAN0_BASE, DISABLE_CAN_AUTO_RETRANSMIT);    // ** Different **

    CANIntRegister(CAN0_BASE, CANIntHandler);
    CANIntEnable(CAN0_BASE, CAN_INT_MASTER | CAN_INT_ERROR | CAN_INT_STATUS);
    IntEnable(INT_CAN0);
    CANEnable(CAN0_BASE);
    IntMasterEnable();          // Master Enable Interrupts.


    TxMsgObjConfig.ui32MsgID     = 0x4;
    TxMsgObjConfig.ui32MsgIDMask = 0x7ff;
    TxMsgObjConfig.ui32Flags     = MSG_OBJ_TX_INT_ENABLE;
    TxMsgObjConfig.ui32MsgLen    = sizeof(TxData);
    TxMsgObjConfig.pui8MsgData   = TxData;

    RxMsgObjConfig.ui32MsgID     = 0x184;
    RxMsgObjConfig.ui32MsgIDMask = 0x7FF;
    RxMsgObjConfig.ui32Flags     = MSG_OBJ_RX_INT_ENABLE;
    RxMsgObjConfig.ui32MsgLen    = 8;
    RxMsgObjConfig.pui8MsgData   = RxData;

    // Configure RX object

    CANMessageSet(CAN0_BASE, 2, &RxMsgObjConfig, MSG_OBJ_TYPE_RX);

    GPIOPinWrite(GPIO_PORTF_BASE, RED_LED, RED_LED);

    while(true) {

        CANMessageSet(CAN0_BASE, 1, &TxMsgObjConfig, MSG_OBJ_TYPE_TX);

        DelayFunction();
/*
        if(ColorToggle) {
            GPIOPinWrite(GPIO_PORTF_BASE, GREEN_LED, GREEN_LED);
            GPIOPinWrite(GPIO_PORTF_BASE, RED_LED,   0);
            ColorToggle = false;
        } else {
            GPIOPinWrite(GPIO_PORTF_BASE, GREEN_LED, 0);
            GPIOPinWrite(GPIO_PORTF_BASE, RED_LED,   RED_LED);
            ColorToggle = true;
        }
*/
    }
    return(0);
}
