/*
 * Copyright (c) 2021, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "ti_msp_dl_config.h"
#include "log.h"

#define read_key DL_GPIO_readPins(GPIOA_PORT, GPIOA_S2_PIN)

void SysTick_Handler(void)
{
    SysTick->CTRL &= ~(1 << 16);    //Clear the interrupt flag bit of SysTick
}

uint8_t Jump_To_App(void)
{
    uint32_t app_partition = *((uint32_t *)FLAG_START_ADDR);
    uint32_t app_msp;
    uint32_t app_entry;
    uint32_t app_addr;

    if (app_partition == APP_PARTITION_FLAG ) {
        app_msp = *((uint32_t *)APP2_START_ADDR);
        app_entry = *((uint32_t *)(APP2_START_ADDR + 4));
        app_addr = APP2_START_ADDR;
        debug_log("Go to APP B.\r\n");
    }else{
        app_msp = *((uint32_t *)APP1_START_ADDR);
        app_entry = *((uint32_t *)(APP1_START_ADDR + 4));
        app_addr = APP1_START_ADDR;
        debug_log("Go to APP A.\r\n");
    }

    if ((app_msp == 0xFFFFFFFF) || (app_entry== 0xFFFFFFFF)) {
        debug_log("Go to APP failed.\r\n");
        return 0;
    }

    __disable_irq();
    __set_MSP(app_msp);
    SCB->VTOR = app_addr;

    void (*AppResetHandler)(void) = (void (*)(void))app_entry;
    AppResetHandler();
    return 1;
}

int main(void)
{
    SYSCFG_DL_init();

    debug_log("\r\nBootloader start.\r\n");

    if(read_key){
        Jump_To_App();
    }

    while (1) {
        debug_log("Bootloader Running...\r\n");
        delay_ms(5000);
    }
}
