#include "log.h"
#include "stdio.h"
#include "stdarg.h"
#include "string.h"

#define LOG_MAX_LEN     256

void debug_uart_send_data(uint8_t* data, uint16_t len)
{
    for(uint16_t i = 0; i < len; i++){
        DL_UART_transmitDataBlocking(DEBUG_UART_INST, data[i]);
    }
}

void debug_log(const char *fmt, ...)
{
  uint16_t data_len = 0;
  va_list args;
  uint8_t data[LOG_MAX_LEN] = {0};

  va_start(args, fmt);
  data_len += vsprintf((char *)data, fmt, args);
  debug_uart_send_data(data,data_len);
  va_end(args);
}