/*
 * commands.h
 *
 *  Created on: Sep 5, 2018
 *      Author: root
 */

#ifndef COMMON_COMMANDS_H_
#define COMMON_COMMANDS_H_

#define CMDSUCCESS 1
#define CMDFAILURE 0

extern const char *NAK_BadArgCount;
extern const char *NAK_BadArg;
extern const char *NAK_BadArgRange;
extern const char *NAK_BadArgLength;
extern const char *NAK_BadArgChar;
extern const char *NAK_BadDigitalIo;

extern int HandleIdAndVersion(char **tokens, int nTokens, char* send_buffer);
extern int HandleReset(char **tokens, int nTokens, char* send_buffer);
extern int HandleFwUpdate(char** tokens, int nTokens, char* send_buffer);

extern int HandleSetIoConfig(char **tokens, int nTokens, char* send_buffer);
extern int HandleGetIoConfig(char **tokens, int nTokens, char* send_buffer);

extern int HandleSetOutputMode(char **tokens, int nTokens, char* send_buffer);
extern int HandleGetOutputMode(char **tokens, int nTokens, char* send_buffer);

extern int HandleSetInputImpedance(char **tokens, int nTokens, char* send_buffer);
extern int HandleGetInputImpedance(char **tokens, int nTokens, char* send_buffer);

extern int HandleSetDigitalOutput(char **tokens, int nTokens, char* send_buffer);
extern int HandleGetDigitalOutput(char **tokens, int nTokens, char* send_buffer);
extern int HandleGetDigitalAnalog(char **tokens, int nTokens, char* send_buffer);

extern int HandleSetDigitalOutputAll(char **tokens, int nTokens, char* send_buffer);
extern int HandleGetDigitalOutputAll(char **tokens, int nTokens, char* send_buffer);
extern int HandleGetDigitalAnalogAll(char **tokens, int nTokens, char* send_buffer);

extern int HandleSetAnalogThresholds(char **tokens, int nTokens, char* send_buffer);
extern int HandleGetAnalogThresholds(char **tokens, int nTokens, char* send_buffer);

extern int HandleSetAnalogOutput(char **tokens, int nTokens, char* send_buffer);
extern int HandleGetAnalogOutput(char **tokens, int nTokens, char* send_buffer);

extern int HandleSetAnalogOutputAll(char **tokens, int nTokens, char* send_buffer);
extern int HandleGetAnalogOutputAll(char **tokens, int nTokens, char* send_buffer);

extern int HandleSetAnalogInput(char **tokens, int nTokens, char* send_buffer);
extern int HandleGetAnalogInput(char **tokens, int nTokens, char* send_buffer);

extern int HandleSetAnalogInputAll(char **tokens, int nTokens, char* send_buffer);
extern int HandleGetAnalogInputAll(char **tokens, int nTokens, char* send_buffer);

extern int HandleSetAnalogFilterCoef(char **tokens, int nTokens, char* send_buffer);
extern int HandleGetAnalogFilterCoef(char **tokens, int nTokens, char* send_buffer);

extern int HandleSetDataStreamDelay(char **tokens, int nTokens, char* send_buffer);
extern int HandleGetDataStreamDelay(char **tokens, int nTokens, char* send_buffer);

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

typedef const char* Command;

typedef int (*Handler)(char **tokens, int nTokens, char* send_buffer);

typedef struct
{
	Command command;
	Handler handler;
} CommandHandler;

extern CommandHandler commandHandlers[];
extern const int NUM_COMMANDS;

#endif /* COMMON_COMMANDS_H_ */
