/*
 * platform.h
 *
 *	This header file declares consts and functions that are common to the Ether-pod and PoE-pod projects.
 *	The which are depend.
 *	The associated platform.c file should con
 *
 *  Created on: Sep 5, 2018
 *      Author: root
 */

#ifndef COMMON_PLATFORM_H_
#define COMMON_PLATFORM_H_

extern const long DATA_STREAM_DELAY_MIN;
extern const long DATA_STREAM_DELAY_MAX;

extern const long DATA_DIGITAL_CHAN_MIN;
extern const long DATA_DIGITAL_CHAN_MAX;

extern const long DATA_ANALOG_CHAN_MIN;
extern const long DATA_ANALOG_CHAN_MAX;

extern const int ANALOG_THRESHOLD_MIN;
extern const int ANALOG_THRESHOLD_MAX;

//extern int GetNumberOfAnalogInputs();
//extern int GetNumberOfDigitalIoPorts();
extern const int NUM_IO_PORTS;
extern const int NUM_IO_GROUPS;
extern const int NUM_ADC_PORTS;
extern const int NUM_DIGITAL_PORTS;
extern const int NUM_ANALOG_PORTS;

extern char* GetPodId();
extern char* GetFirmwareVersion();
extern int SetReset(void);

extern void SetIoConfig(int channelIndex, char state);
extern char GetIoConfig(int channelIndex);
extern char * GetIoConfigAll(void);
extern int ChannelIsOutput(int channelIndex);

extern void SetOutputMode(int channelIndex, char state);
extern char GetOutputMode(int channelIndex);

extern void SetInputImpedance(int channelIndex, char state);
extern char *GetInputImpedanceAll(void);

extern void SetDigitalOutput(int channelIndex, int binaryValue);
// returns 0 if not configured for output, but you shouldn't call this if it isn't
extern int GetDigitalOutput(int channelIndex);
extern char * GetDigitalOutputAll();
void UpdateDigitalOutput(void);

extern void SetAnalogThreshold(int channelIndex, int value);
extern int GetAnalogThreshold(int channelIndex);

void SetAnalogOutput(int channelIndex, int value);
int GetAnalogOutput(int channelIndex);
int GetAnalogInput(int channelIndex);

extern char * GetDigitalInputsAll();
extern char * GetThresholdedAnalogInputsAll();

extern void SetDataStreamDelay(long value);
extern long GetDataStreamDelay();

extern void SetAnalogFilterCoef(long value);
extern long GetAnalogFilterCoef();


#endif /* COMMON_PLATFORM_H_ */
