/*
 * poe.h
 *
 *  Created on: Sep 10, 2018
 *      Author: robert.applebee
 */

#ifndef POE_H_
#define POE_H_

//#include "driverlib/gpio.h"

#define POE_VERSION        "0.36"

#define NUM_CHANS               18

// setting this to a one requires setting LWIP_DHCP to 0 in file lwipopts.h
// setting this to a zero requires setting LWIP_DHCP to 1 in file lwipopts.h
#define STATIC_IP 1

// Read the slot address
#define READ_MYADDR         GPIOPinRead(GPIO_PORTQ_BASE, 0x1F)

struct vm_settings
{
    float DataStreamDelay;
    long AnalogFilterCoef;
    char PodId[8];
};

extern struct vm_settings VM;
extern char tcpIn[];
extern char tcpOut[];
extern char udpOut[];
extern unsigned int g_ui32SysClock;
extern volatile  unsigned int g_delayusTick;
extern unsigned short g_usSeq;

#endif /* POE_H_ */
