#include <stdint.h>
#include <stdbool.h>
#include "inc/tm4c1294ncpdt.h"
#include "inc/hw_memmap.h"
#include "inc/hw_types.h"
#include "driverlib/sysctl.h"
#include "driverlib/interrupt.h"
#include "driverlib/gpio.h"
#include "driverlib/timer.h"


int main(void)
{
	uint32_t ui32Period;
	uint32_t ui32SysClkFreq;

	ui32SysClkFreq = SysCtlClockFreqSet((SYSCTL_XTAL_25MHZ | SYSCTL_OSC_MAIN |
	SYSCTL_USE_PLL | SYSCTL_CFG_VCO_480), 120000000);
	//clock init
	SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOF);
	SysCtlPeripheralEnable(SYSCTL_PERIPH_TIMER0);

	//GPIO init
	GPIOPinTypeGPIOOutput(GPIO_PORTF_AHB_BASE, GPIO_PIN_1);
	//timer init
	TimerConfigure(TIMER0_BASE, TIMER_CFG_PERIODIC);

	ui32Period = ui32SysClkFreq/1000000;

	TimerLoadSet(TIMER0_BASE, TIMER_A, ui32Period -1);

	IntEnable(INT_TIMER0A);
	TimerIntEnable(TIMER0_BASE, TIMER_TIMA_TIMEOUT);
	IntMasterEnable();

	TimerEnable(TIMER0_BASE, TIMER_A);

	SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOF);



while(1)
	{
	}
}

volatile int x = 2;
void Timer0IntHandler(void)
{

	x^=0xF;
	GPIOPinWrite(GPIO_PORTF_AHB_BASE, GPIO_PIN_1, x);


}
