/** @file sys_main.c 
*   @brief Application main file
*   @date 11-Dec-2018
*   @version 04.07.01
*
*   This file contains an empty main function,
*   which can be used for the application.
*/

/* 
* Copyright (C) 2009-2018 Texas Instruments Incorporated - www.ti.com 
* 
* 
*  Redistribution and use in source and binary forms, with or without 
*  modification, are permitted provided that the following conditions 
*  are met:
*
*    Redistributions of source code must retain the above copyright 
*    notice, this list of conditions and the following disclaimer.
*
*    Redistributions in binary form must reproduce the above copyright
*    notice, this list of conditions and the following disclaimer in the 
*    documentation and/or other materials provided with the   
*    distribution.
*
*    Neither the name of Texas Instruments Incorporated nor the names of
*    its contributors may be used to endorse or promote products derived
*    from this software without specific prior written permission.
*
*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
*  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*
*/


/* USER CODE BEGIN (0) */
/* USER CODE END */

/* Include Files */

#include "sys_common.h"

/* USER CODE BEGIN (1) */
#include "etpwm.h"
#include "adc.h"
#include "gio.h"
#include "rti.h"
#include "het.h"
#include "sci.h"
#include "sys_pmu.h"
#include "pinmux.h"
/* USER CODE END */

/** @fn void main(void)
*   @brief Application main function
*   @note This function is empty by default.
*
*   This function is called after startup.
*   The user can use this function to implement the application.
*/

/* USER CODE BEGIN (2) */
uint16 adcValue[2];
adcData_t adc_data[2]; //for 1 channel: channel 8
uint32 count;

volatile unsigned long cycles_PMU_start, cycles_PMU_end, cycles_PMU_measure, cycles_PMU_comp, cycles_PMU_code;
volatile float time_PMU_code;
unsigned int uSeconds_PMU;

extern void rtiNotification(uint32 notification);
extern void adcNotification(adcBASE_t *adc, uint32 group);

void wait(uint32 time);

unsigned int errCount = 0;
unsigned int sampleCount = 0;
/* USER CODE END */

int main(void)
{
/* USER CODE BEGIN (3) */
    gioInit();
       adcInit();
       rtiInit();
       _pmuInit_();
       _pmuEnableCountersGlobal_();

       /* initialize gio     */
       gioInit();
       gioSetDirection(gioPORTB, 1);

       /* initialize ADC  */
       /* Group1 -> Channel 0 and 1                        */
       /* HW trigger trigger source as GIOB  Pin 0         */
       adcInit();

      /* ePWM generate SOCA as a trigger of ADC: 1. Enable SOCA in ePWM config; 2. Disable SOCA_SEL1 by writing 0 to pinmmr35[0]*/
       etpwmInit();
       pinMuxReg->PINMMR35 = 0x000;
       //etpwmREG2->pinmmr35[0] = 0;
       /* Set the COS of ADC module*/
       /* This bit affects emulation operation only. It defines whether the ADC
        * core clock (ADCLK) is immediately halted when the CPU enters
        * debug mode or if it should continue operating normally.*/
       /* ADC module continues all ongoing conversions as per the
        * configurations of the three conversion groups.*/
       adcREG1->OPMODECR |= (0x1 << 24);

       /* Configure epwm time-base counter keeps running in emulation mode */
       //etpwmREG1->TBCTL |= (0x2 << 14);

       _enable_IRQ();
       rtiStartCounter(rtiCOUNTER_BLOCK0);
       etpwmStartTBCLK();

       adcEnableNotification(adcREG1, adcGROUP1);
       adcStartConversion(adcREG1, adcGROUP1);
       rtiEnableNotification(rtiNOTIFICATION_COMPARE0);
       while(1);
/* USER CODE END */

    return 0;
}


/* USER CODE BEGIN (4) */
void adcNotification(adcBASE_t *adc, uint32 group)
{
    gioPORT_t *port;
    port = gioPORTB;

#if 0
     while((adcIsConversionComplete(adcREG1, adcGROUP1)) == 0);
     count = adcGetData(adcREG1, adcGROUP1, &adc_data[0]);
     adcValue[0] =  adc_data[0].value;  //3.0V  input; =3674
     adcValue[1] =  adc_data[1].value;  //1.17V input; =1468
#else //code from VMAX
     adcValue[0] = (uint16)(adcREG1->GxBUF[adcGROUP1].BUF0); // ȡADֵͨ0
     adcValue[1] = (uint16)(adcREG1->GxBUF[adcGROUP1].BUF0); // ȡADֵͨ20
#endif
     if ((adcValue[0] < 2000) || (adcValue[1] > 3000)){
         errCount++;
     }
     sampleCount++;
     if(port->DOUT == 0)
     {
         port->DOUT = 2;
     }
}

void wait(uint32 time)
{
    while(time){time--;};
}


/* Note-You need to remove rtiNotification from notification.c to avoid redefinition */
void rtiNotification(uint32 notification)
{
    gioPORT_t *port;
    port = gioPORTB;

    /* blinky LED every 1 second */
    if(port->DOUT == 2)
    {
        port->DOUT = 0;
    }
    //gioToggleBit(gioPORTA, 0x4); //GIOA[3]
}
/* USER CODE END */
