/*
 *  ======== empty.c ========
 */
// XDCtools Header files /
#include <xdc/std.h>
#include <xdc/runtime/System.h>
#include <stdbool.h>
// BIOS Header files /
#include <ti/sysbios/BIOS.h>
#include <ti/sysbios/knl/Task.h>

// TI-RTOS Header files /
#include <driverlib/sysctl.h>
// #include <ti/drivers/EMAC.h>
#include <ti/drivers/GPIO.h>


// Board Header file /
#include "Board.h"

#define TASKSTACKSIZE   512

Task_Struct task0Struct;
Char task0Stack[TASKSTACKSIZE];
int flag=0;


void button_press(unsigned int index)
{
    flag=1;
}

Void reset(UArg arg0, UArg arg1)           // created a ideal thread
{
    while (1) {
              if(flag==1)
                {
                    System_printf("Reset about to occur\n");
                    System_flush();
                    flag=0;
                    SysCtlReset();

                }

                Task_sleep((unsigned int)arg0);
    }
}

/*
 *  ======== main ========
 */
int main(void)
{
    Task_Params taskParams;
    /* Call board init functions */
    Board_initGeneral();
    // Board_initEMAC();
    Board_initGPIO();
 
    GPIO_setCallback(Board_BUTTON0, button_press);

       GPIO_enableInt(Board_BUTTON0);
     

  
    System_printf("Starting the example.\n");
    /* SysMin will only print to the console when you call flush or exit */
    System_flush();

    /* Start BIOS */
    BIOS_start();

    return (0);
}
