#!/bin/sh

ifconfig eth1 down
ifconfig eth2 down
ifconfig eth3 down
ifconfig eth4 down
ethtool -L eth1 tx 4
ethtool -L eth2 tx 4
ethtool --set-priv-flags eth1 p0-rx-ptype-rrobin off
ethtool --set-priv-flags eth2 p0-rx-ptype-rrobin off

devlink dev param set platform/8000000.ethernet name switch_mode value true cmode runtime
ip link add name br0 type bridge
ip link set dev br0 type bridge ageing_time 1000
ip link set dev eth1 up
ip link set dev eth2 up
sleep 10
ip link set dev eth1 master br0
ip link set dev eth2 master br0
ip link set dev br0 up
ip link set dev br0 type bridge vlan_filtering 1
bridge vlan add dev br0 vid 1 pvid untagged self
bridge vlan add dev eth1 vid 100 master
bridge vlan add dev eth2 vid 100 master

#sync system time to CPSW CPTS
#phc2sys -s CLOCK_REALTIME -c eth0 -m -O 0 > /dev/null &

#calc base_time as now + 2min, give it time to sync
#base=$(((`date +%s` + 2 * 60)*1000000000))
base=0000

tc qdisc replace dev eth1 parent root handle 100 taprio \
    num_tc 3 \
    map 0 0 1 2 0 0 0 0 0 0 0 0 0 0 0 0 \
    queues 1@0 1@1 1@2 \
    base-time $base \
    sched-entry S 4 10000 \
    sched-entry S 2 30000 \
    sched-entry S 1 60000 \
    flags 2
tc qdisc replace dev eth2 parent root handle 100 taprio \
    num_tc 3 \
    map 0 0 1 2 0 0 0 0 0 0 0 0 0 0 0 0 \
    queues 1@0 1@1 1@2 \
    base-time $base \
    sched-entry S 4 10000 \
    sched-entry S 2 30000 \
    sched-entry S 1 60000 \
    flags 2

# Wait for 2 minutes for sync to complete
#sleep 120

echo "Switch setup completed."
