
#include <stdint.h>
#include <stdbool.h>
#include <math.h>
#include "inc/hw_memmap.h"
#include "inc/hw_types.h"
#include "inc/hw_ints.h"
#include "driverlib/debug.h"
#include "driverlib/gpio.h"
#include "driverlib/interrupt.h"
#include "driverlib/pin_map.h"
#include "driverlib/rom.h"
#include "driverlib/sysctl.h"
#include "driverlib/systick.h"
#include "driverlib/uart.h"
#include "utils/uartstdio.h"
#include "sensorlib/hw_bmp180.h"
#include "sensorlib/i2cm_drv.h"
#include "sensorlib/bmp180.h"
#include "drivers/rgb.h"
#include "sensorlib/ak8975.h"
#include "sensorlib/mpu9150.h"
#include "sensorlib/mpu6050.h"
#include "sensorlib/hw_mpu9150.h"
#include <stdint.h>
#include <stdbool.h>
#include <math.h>
#include <time.h>
#include <string.h>
#include <stdlib.h>


#include "inc/hw_types.h"
#include "inc/hw_memmap.h"
#include "inc/hw_hibernate.h"
#include "driverlib/fpu.h"
#include "driverlib/gpio.h"
#include "driverlib/hibernate.h"
#include "driverlib/interrupt.h"
#include "driverlib/pin_map.h"
#include "driverlib/rom.h"
#include "driverlib/sysctl.h"
#include "driverlib/systick.h"
#include "driverlib/uart.h"
#include "utils/uartstdio.h"
#include <stdint.h>
#include <stdbool.h>
#include "inc/hw_memmap.h"
#include "inc/hw_types.h"
#include "driverlib/sysctl.h"
#include "driverlib/gpio.h"
#include "driverlib/debug.h"
#include "driverlib/pwm.h"
#include "driverlib/pin_map.h"
#include "inc/hw_gpio.h"
#include "driverlib/rom.h"
#define PWM_FREQUENCY 55

#define BMP180_I2C_ADDRESS      0x77

#define MPU9150_I2C_ADDRESS     0X68


#define LED_PERIPH SYSCTL_PERIPH_GPIOF
#define LED_BASE GPIO_PORTF_BASE
#define RED_LED GPIO_PIN_1

uint32_t g_pui32Colors[3];


tI2CMInstance g_sI2CInst;


tBMP180 g_sBMP180Inst;

tMPU9150 sMPU9150;

volatile uint_fast8_t g_vui8DataFlag;


volatile bool g_bMPU9150Done;


#ifdef DEBUG
void
__error__(char *pcFilename, uint32_t ui32Line)
{
}
#endif

int32_t functie(int32_t n)
{
    int32_t rez;
    rez = 2*n;
    return(rez);
}


void comenzi(char *str, float *com1, float *com2,float *com3)

{


    float temp[5];
    char buffer[16];
    char com[7];
    int32_t i, j, k, p;
    int32_t n, ns, nf;

    i=0;j=0;k=0;p=0;
    n=0;ns=0;nf=0;

    strcpy(buffer, str);
    n=strlen(buffer);

    for(i=0;i<n; i++)
    {
        if(buffer[i] ==',')
        {
            nf = i;
            for(j=ns;j<nf;j++)
            {
                com[p] = buffer[j];
                p++;
            }
            com[p]='\0';
            temp[k] = atof(com);
                p   = 0;
                com[p] ='\0';
                k++;
                ns  = i+1;
        }
    }

    *com1 =temp[0];
    *com2 =temp[1];
    *com3 =temp[2];
}

void BMP180AppCallback(void* pvCallbackData, uint_fast8_t ui8Status)
{
    if(ui8Status == I2CM_STATUS_SUCCESS)
    {
        g_vui8DataFlag = 1;
    }
}


void MPU9150Callback(void *pvCallbackData, uint_fast8_t ui8Status)
{

    if(ui8Status != I2CM_STATUS_SUCCESS)
    {

    }

    g_bMPU9150Done = true;
}



void
BMP180I2CIntHandler(void)
{

    I2CMIntHandler(&g_sI2CInst);
}

void
MPU9150I2CIntHandler(void)
{

    I2CMIntHandler(&g_sI2CInst);
}


void
SysTickIntHandler()
{

    BMP180DataRead(&g_sBMP180Inst, BMP180AppCallback, &g_sBMP180Inst);

}


/*void
ConfigureUART(void)
{
    //
    // Enable the GPIO Peripheral used by the UART.
    //
    ROM_SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOB);

    //
    // Enable UART1
    //
    ROM_SysCtlPeripheralEnable(SYSCTL_PERIPH_UART1);

    //
    // Configure GPIO Pins for UART mode.
    //
    ROM_GPIOPinConfigure(GPIO_PB0_U1RX);
    ROM_GPIOPinConfigure(GPIO_PB1_U1TX);
    ROM_GPIOPinTypeUART(GPIO_PORTB_BASE, GPIO_PIN_0 | GPIO_PIN_1);

    //
    // Use the internal 16MHz oscillator as the UART clock source.
    //
    UARTClockSourceSet(UART1_BASE, UART_CLOCK_PIOSC);

    //
    // Initialize the UART for console I/O.
    //
    //UARTStdioConfig(0, 115200, 16000000);
    UARTStdioConfig(1, 9600, 16000000);
}*/
void
ConfigureUART(void)
{
    //
    // Enable the GPIO Peripheral used by the UART.
    //
    ROM_SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOA);

    //
    // Enable UART0
    //
    ROM_SysCtlPeripheralEnable(SYSCTL_PERIPH_UART0);

    //
    // Configure GPIO Pins for UART mode.
    //
    ROM_GPIOPinConfigure(GPIO_PA0_U0RX);
    ROM_GPIOPinConfigure(GPIO_PA1_U0TX);
    ROM_GPIOPinTypeUART(GPIO_PORTA_BASE, GPIO_PIN_0 | GPIO_PIN_1);

    //
    // Use the internal 16MHz oscillator as the UART clock source.
    //
    UARTClockSourceSet(UART0_BASE, UART_CLOCK_PIOSC);


    UARTStdioConfig(0, 9600, 16000000);
}


int
main(void)
{

    volatile uint32_t ui32Load;
         volatile uint32_t ui32PWMClock;
         volatile uint8_t ui8Adjust,ui8Adjust1,ui8Adjust2;
         ui8Adjust = 83;


         SysCtlPeripheralEnable(LED_PERIPH);
         SysCtlDelay(3);


    float fTemperature, fPressure, fAltitude;
    int32_t i32IntegerPart, i32IntegerPartAx, i32IntegerPartAy, i32IntegerPartAz;
    int32_t i32FractionPart, i32FractionPartAx,i32FractionPartAy, i32FractionPartAz;
    uint_fast16_t TemperatureRaw;
    float fAccel[3], fGyro[3];
    uint_fast16_t fMagneto[3];



    ROM_SysCtlClockSet(SYSCTL_SYSDIV_5 | SYSCTL_USE_PLL | SYSCTL_XTAL_16MHZ |
                       SYSCTL_OSC_MAIN);
    ROM_SysCtlPWMClockSet(SYSCTL_PWMDIV_64);


    ConfigureUART();


    UARTprintf("\033[2JBMP180 Example\n");


    g_pui32Colors[RED] = 0x8000;
    g_pui32Colors[BLUE] = 0x8000;
    g_pui32Colors[GREEN] = 0x8000;


/*    RGBInit(0);
    RGBColorSet(g_pui32Colors);
    RGBIntensitySet(0.5f);
    RGBEnable();
*/


    ROM_SysCtlPeripheralEnable(SYSCTL_PERIPH_I2C3);
    ROM_SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOD);



    ROM_GPIOPinConfigure(GPIO_PD0_I2C3SCL);
    ROM_GPIOPinConfigure(GPIO_PD1_I2C3SDA);



    GPIOPinTypeI2CSCL(GPIO_PORTD_BASE, GPIO_PIN_0);
    ROM_GPIOPinTypeI2C(GPIO_PORTD_BASE, GPIO_PIN_1);




          SysCtlPeripheralEnable(SYSCTL_PERIPH_PWM1);

           GPIOPinConfigure(GPIO_PF1_M1PWM5);
           GPIOPinConfigure(GPIO_PF2_M1PWM6);
           GPIOPinConfigure(GPIO_PF3_M1PWM7);
           GPIOPinTypePWM(GPIO_PORTF_BASE, GPIO_PIN_1 | GPIO_PIN_2 | GPIO_PIN_3);
           PWMGenConfigure(PWM1_BASE, PWM_GEN_2, PWM_GEN_MODE_DOWN | PWM_GEN_MODE_NO_SYNC);
           PWMGenConfigure(PWM1_BASE, PWM_GEN_3, PWM_GEN_MODE_DOWN | PWM_GEN_MODE_NO_SYNC);




           ui32PWMClock = SysCtlClockGet() / 64;
           ui32Load = (ui32PWMClock / PWM_FREQUENCY) - 1;

           PWMGenConfigure(PWM1_BASE, PWM_GEN_0, PWM_GEN_MODE_DOWN);
           PWMGenPeriodSet(PWM1_BASE, PWM_GEN_0, ui32Load);
           PWMGenPeriodSet(PWM1_BASE, PWM_GEN_2, ui32Load);
           PWMGenPeriodSet(PWM1_BASE, PWM_GEN_3, ui32Load);


           PWMPulseWidthSet(PWM1_BASE, PWM_OUT_5,ui8Adjust * ui32Load / 1000);
           PWMPulseWidthSet(PWM1_BASE, PWM_OUT_6,ui8Adjust * ui32Load / 1000);
           PWMPulseWidthSet(PWM1_BASE, PWM_OUT_7,ui8Adjust * ui32Load / 1000);

           PWMGenEnable(PWM1_BASE, PWM_GEN_2);
           PWMGenEnable(PWM1_BASE, PWM_GEN_3);
           PWMOutputState(PWM1_BASE, PWM_OUT_5_BIT | PWM_OUT_6_BIT | PWM_OUT_7_BIT, true);








    ROM_IntMasterEnable();


    I2CMInit(&g_sI2CInst, I2C3_BASE, INT_I2C3, 0xff, 0xff,
             ROM_SysCtlClockGet());


    BMP180Init(&g_sBMP180Inst, &g_sI2CInst, BMP180_I2C_ADDRESS,
               BMP180AppCallback, &g_sBMP180Inst);

    while(g_vui8DataFlag == 0)
    {

    }


    g_vui8DataFlag = 0;



    g_bMPU9150Done == false;

    MPU9150Init(&sMPU9150, &g_sI2CInst, MPU9150_I2C_ADDRESS, MPU9150Callback, 0);
    while(!g_bMPU9150Done)
    {

    }

    g_bMPU9150Done = false;

    MPU9150ReadModifyWrite(&sMPU9150, MPU9150_O_ACCEL_CONFIG,
    ~MPU9150_ACCEL_CONFIG_AFS_SEL_M,
    MPU9150_ACCEL_CONFIG_AFS_SEL_4G, MPU9150Callback,
    0);


    ROM_SysTickPeriodSet(ROM_SysCtlClockGet() / (10 * 3));
    ROM_SysTickIntEnable();
    ROM_SysTickEnable();

   // RGBBlinkRateSet(1.0f);


    ui32PWMClock = SysCtlClockGet() / 64;
          ui32Load = (ui32PWMClock / PWM_FREQUENCY) - 1;
          PWMGenConfigure(PWM1_BASE, PWM_GEN_0, PWM_GEN_MODE_DOWN);
                PWMGenPeriodSet(PWM1_BASE, PWM_GEN_0, ui32Load);
                PWMGenPeriodSet(PWM1_BASE, PWM_GEN_2, ui32Load);
                PWMGenPeriodSet(PWM1_BASE, PWM_GEN_3, ui32Load);
                PWMPulseWidthSet(PWM1_BASE, PWM_OUT_5,ui8Adjust * ui32Load / 1000);
                PWMPulseWidthSet(PWM1_BASE, PWM_OUT_6,ui8Adjust * ui32Load / 1000);

             PWMPulseWidthSet(PWM1_BASE, PWM_OUT_7,ui8Adjust * ui32Load / 1000);
             PWMGenEnable(PWM1_BASE, PWM_GEN_2);
             PWMGenEnable(PWM1_BASE, PWM_GEN_3);
             PWMOutputState(PWM1_BASE, PWM_OUT_5_BIT | PWM_OUT_6_BIT | PWM_OUT_7_BIT, true);
             char  g_cInput[16];
                float d1, d2, d3;

                ROM_FPUEnable();
                ROM_FPUStackingEnable();

         UARTprintf("TEST");
    while(1)
    {




        if(UARTPeek('\r') !=-1)
               {


                   UARTgets(g_cInput,sizeof(g_cInput));
                   UARTprintf("Ce s-a printat: %s\n",g_cInput);
                   comenzi(g_cInput, &d1, &d2, &d3);
                   UARTprintf("%d,%d, %d\n", (int32_t)d1, (int32_t)d2, (int32_t)d3);
                   ui8Adjust = (int32_t)d1;
                   ui8Adjust1 = (int32_t)d2;
                   ui8Adjust2 = (int32_t)d3;




                   ROM_PWMPulseWidthSet(PWM1_BASE, PWM_OUT_5, ui8Adjust * ui32Load / 1000);
                   ROM_PWMPulseWidthSet(PWM1_BASE, PWM_OUT_6, ui8Adjust1 * ui32Load / 1000);
                   ROM_PWMPulseWidthSet(PWM1_BASE, PWM_OUT_7, ui8Adjust2 * ui32Load / 1000);
                   ROM_SysCtlDelay(5000000);
               }











        BMP180DataRead(&g_sBMP180Inst, BMP180AppCallback, &g_sBMP180Inst);
        while(g_vui8DataFlag == 0)
        {

        }


        g_vui8DataFlag = 0;

        while(!g_bMPU9150Done)
           {
           }

        g_bMPU9150Done = false;
        MPU9150DataRead(&sMPU9150, MPU9150Callback, 0);
        while(!g_bMPU9150Done)
        {
        }

        MPU9150DataAccelGetFloat(&sMPU9150, &fAccel[0], &fAccel[1], &fAccel[2]);


        BMP180DataTemperatureGetFloat(&g_sBMP180Inst, &fTemperature);
        BMP180DataTemperatureGetRaw(&g_sBMP180Inst, &TemperatureRaw);



        i32IntegerPartAx = (int32_t) fAccel[0];
        i32FractionPartAx =(int32_t) (fAccel[0] * 1000.0f);
        i32FractionPartAx = i32FractionPartAx - (i32IntegerPartAx * 1000);
        if(i32FractionPartAx < 0)
        {
            i32FractionPartAx *= -1;
        }

        i32IntegerPartAy = (int32_t) fAccel[1];
        i32FractionPartAy =(int32_t) (fAccel[1] * 1000.0f);
        i32FractionPartAy = i32FractionPartAy - (i32IntegerPartAy * 1000);

        if(i32FractionPartAy < 0)
        {
            i32FractionPartAy *= -1;
        }

        i32IntegerPartAz = (int32_t) fAccel[2];
        i32FractionPartAz =(int32_t) (fAccel[2] * 1000.0f);
        i32FractionPartAz = i32FractionPartAz - (i32IntegerPartAz * 1000);

        if(i32FractionPartAz < 0)
        {
            i32FractionPartAz *= -1;
        }






        UARTprintf("%3d.%03d", i32IntegerPartAx, i32FractionPartAx);
        UARTprintf(",");
        UARTprintf("%3d.%03d", i32IntegerPartAy, i32FractionPartAy);
        UARTprintf(",");
        UARTprintf("%3d.%03d", i32IntegerPartAz, i32FractionPartAz);






        MPU9150DataMagnetoGetRaw(&sMPU9150, &fMagneto[0], &fMagneto[1], &fMagneto[2]);


        i32IntegerPart = (int32_t) fMagneto[0];
        i32FractionPart =(int32_t) (fMagneto[0] * 1000.0f);
        i32FractionPart = i32FractionPart - (i32IntegerPart * 1000);
        if(i32FractionPart < 0)
        {
            i32FractionPart *= -1;
        }


        fAltitude = 44330.0f * (1.0f - powf(fPressure / 101325.0f,
                                            1.0f / 5.255f));


        i32IntegerPart = (int32_t) fAltitude;
        i32FractionPart =(int32_t) (fAltitude * 1000.0f);
        i32FractionPart = i32FractionPart - (i32IntegerPart * 1000);
        if(i32FractionPart < 0)
        {
            i32FractionPart *= -1;
        }


        UARTprintf("\n");

        ROM_SysCtlDelay(ROM_SysCtlClockGet() / (10 * 3));

    }
}
