#ifndef IELAD_LIB_H_
#define IELAD_LIB_H_

#include <stdbool.h>

#define DISPLAY_MSG_SYNC_BYTE 0x24

typedef enum
{
    PARSE_NOT_COMPLETE = 0x00,
    PARSE_COMPLETED = 0x01,
    PARSE_CRC_ERROR = 0x02,
    PARSE_ERROR = 0x03
} parserResult;

#define FOREACH_DisplayMsgParserState(DisplayMsgParserState) \
        DisplayMsgParserState(SYNC) \
        DisplayMsgParserState(MESSAGEID) \
        DisplayMsgParserState(MESSAGELENGTH) \
        DisplayMsgParserState(FRAMECOUNTER) \
        DisplayMsgParserState(RESERVEDBYTES) \
        DisplayMsgParserState(PAYLOAD) \

#define GENERATE_ENUM(ENUM) ENUM,
#define GENERATE_STRING(STRING) #STRING,

typedef enum {
    FOREACH_DisplayMsgParserState(GENERATE_ENUM)
} DisplayMsgParserStates;

typedef struct __attribute__ ((__packed__))
{
    DisplayMsgParserStates state;
    unsigned int subState;
    unsigned int payloadCounter;
} ieladParserState;

typedef struct __attribute__ ((__packed__))
{
    int stateNumber;
    int byteCounter;
} parserState;

typedef enum
{
    IELAD_NAV_MSG_ID = 0x01,                    // iELAD to Display
    IELAD_NFCMD_MSG_ID = 0x02,                  // Display to iELAD
    IELAD_BOOT_MSG_ID = 0x03,                   // iELAD to Display
    IELAD_GET_BOOT_MSG_ID = 0x04,               // Display to iELAD
    IELAD_ALIGNMENT_MSG_ID = 0x05,              // Display to iELAD
    IELAD_ALIGNMENT_OK_MSG_ID = 0x06,           // iELAD to Display
    IELAD_RESET_ALIGNMENT_MSG_ID = 0x07,        // Display to iELAD
    IELAD_RESET_ALIGNMENT_OK_MSG_ID = 0x08      // iELAD to Display
} ieladMessageIDs;

typedef struct __attribute__ ((__packed__))
{
    char syncByte;
    unsigned short msgID;
    unsigned short length;
    unsigned char frameCounter;
    unsigned int reserved;
    unsigned int reserved2;
} ieladHeader;

typedef struct __attribute__ ((__packed__))
{
    ieladHeader header;
    unsigned char payload[512];
} ieladMsg;

void initParserState(ieladParserState* state);
parserResult parser(unsigned char data, ieladMsg* displayMsg, ieladParserState* state);

#endif /* IELAD_LIB_H_ */
