/*
 * phyConfig.h
 *
 *  Created on: 11-Jan-2018
 *      Author: balasubramani.c
 */

#ifndef PHYCONFIG_H_
#define PHYCONFIG_H_

#include <stdint.h>
#include <string.h>
#include <stdbool.h>
#include <xdc/std.h>
#include "inc/hw_memmap.h"
#include "driverlib/sysctl.h"
#include "driverlib/pin_map.h"

#define SPI_PERIPHERAL_CLOCK                5000000
#define SPI_DATA_LENGTH                     16
#define SPIETH_DATA_LENGTH                  8
typedef struct SpiStructData
{
    uint32_t ui32SpiBus;
    uint32_t *pui8DataTx;
    uint32_t *pui8DataRx;
    uint32_t ui32TransferCount;
    uint8_t ui8ChipSelect;
    uint32_t CSBaseaddr;
    uint32_t CSpinNum;
}SpiStructType;

#define ETHERNETBYTESTRANSFER           0xc /* Two byte Transfer */
#define WRITE_OPERATION                 1
#define READ_OPERATION                  0

#define PHYCHIP_ID                      0x0000

#define CONFIGSTATUS_SERIALBUS          0x00D8
#define CONFIGSTATUS_DATA               0x003E

#define DSPCONTROLREG_ONE               0x0734
#define DSPCONTROLREG_DATA              0x1020

#define PORTONE_CONTROLREGONE           0x006C
#define PORTONE_CONTROLDATA             0x0000

#define PORTTWO_CONTROLREGONE           0x0084
#define PORTTWO_CONTROLDATA             0x0000

#define SWITCHGLOBALCONTROLREGSEVEN     0x000E
#define SWITCHGLOBALCONTROLDATA         0x0913

#define INT_ENABLEREG                   0x0190
#define INT_ENABLEDATA                  0x8008

#define INT_STATUSREG                   0x0192

#define PORTONE_STATUSREG               0x080
#define PORTTWO_STATUSREG               0x098

#define PHYONE_STATUSREG                0x04E
#define PHYTWO_STATUSREG                0x05A

#define PMCTRL_REG                      0x032

#define WAKEUP_STATUS                   0X0008
#define GLOBAL_LINKSTATUS               0X8000
#define PORT_LINKSTATUS                 0X0020
#define PORT_SPEED                      0x0400
#define PORT_DUPLEX                     0x0200
#define TIVA                            0
#define RTOS                            1

void iocDefaultConfig(void);
void ioc_PhyWriteOperation(uint16_t ui16RegAddr, uint16_t ui8Data);
uint32_t ioc_PhyReadOperation(uint16_t);
void ioc_EthernetPortConfig(void);
void iocEthernetSwitchConfig_ksz8765(void);
void ioc_PhyWriteOperation_ksz8765(uint16_t , uint16_t, bool, bool);
uint16_t ioc_PhyReadOperation_ksz8765(uint16_t, bool, bool);
void ioc_EthernetPortConfig_ksz8765(bool, bool);

#endif /* PHYCONFIG_H_ */
