//*****************************************************************************
//
// Configure the device pins for different signals
//
// Copyright (C) 2014 Texas Instruments Incorporated - http://www.ti.com/ 
// 
// 
//  Redistribution and use in source and binary forms, with or without 
//  modification, are permitted provided that the following conditions 
//  are met:
//
//    Redistributions of source code must retain the above copyright 
//    notice, this list of conditions and the following disclaimer.
//
//    Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the 
//    documentation and/or other materials provided with the   
//    distribution.
//
//    Neither the name of Texas Instruments Incorporated nor the names of
//    its contributors may be used to endorse or promote products derived
//    from this software without specific prior written permission.
//
//  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
//  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
//  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
//  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
//  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
//  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
//  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
//  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
//  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
//  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
//  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
//*****************************************************************************

// This file was automatically generated on ‎29‎-‎12‎-‎2017 at ‎20‎:‎27‎:‎14
// by TI PinMux version 4.0.1510 
//
//*****************************************************************************

#include <stdbool.h>
#include <stdint.h>
#include "inc/hw_gpio.h"
#include "inc/hw_memmap.h"
#include "inc/hw_types.h"
#include "driverlib/gpio.h"
#include "driverlib/pin_map.h"
#include "driverlib/rom.h"
#include "driverlib/rom_map.h"
#include "driverlib/sysctl.h"
#include "pinout.h"

//*****************************************************************************
//
//! \addtogroup pinout_api
//! @{
//
//*****************************************************************************

//*****************************************************************************
//
//! Configures the device pins for the customer specific usage.
//!
//! \return None.
//
//*****************************************************************************
void
PinoutSet(void)
{
    //
    // Enable Peripheral Clocks 
    //
	MAP_SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOA);
	MAP_SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOB);
	MAP_SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOC);
	MAP_SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOD);
	MAP_SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOE);
	MAP_SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOF);
	MAP_SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOG);
	MAP_SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOH);
	MAP_SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOK);
	MAP_SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOL);
	MAP_SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOM);
	MAP_SysCtlPeripheralEnable(SYSCTL_PERIPH_GPION);
	MAP_SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOP);
	MAP_SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOQ);

    //
    // Configure the GPIO Pin Mux for PF1
	// for M0PWM1
    //
	MAP_GPIOPinConfigure(GPIO_PF1_M0PWM1);
	MAP_GPIOPinTypePWM(GPIO_PORTF_BASE, GPIO_PIN_1);

    //
    // Configure the GPIO Pin Mux for PE2
	// for GPIO_PE2
    //
	MAP_GPIOPinTypeGPIOOutput(GPIO_PORTE_BASE, GPIO_PIN_2);

    //
    // Configure the GPIO Pin Mux for PE3
	// for GPIO_PE3
    //
	MAP_GPIOPinTypeGPIOOutput(GPIO_PORTE_BASE, GPIO_PIN_3);

    //
    // Configure the GPIO Pin Mux for PD5
	// for GPIO_PD5
    //
	MAP_GPIOPinTypeGPIOOutput(GPIO_PORTD_BASE, GPIO_PIN_5);

    //
    // Configure the GPIO Pin Mux for PP1
	// for GPIO_PP1
    //
	MAP_GPIOPinTypeGPIOOutput(GPIO_PORTP_BASE, GPIO_PIN_1);

    //
    // Configure the GPIO Pin Mux for PF4
	// for GPIO_PF4
    //
	MAP_GPIOPinTypeGPIOOutput(GPIO_PORTF_BASE, GPIO_PIN_4);

    //
    // Configure the GPIO Pin Mux for PG6
	// for GPIO_PG6
    //
	MAP_GPIOPinTypeGPIOOutput(GPIO_PORTG_BASE, GPIO_PIN_6);

    //
    // Configure the GPIO Pin Mux for PF0
	// for GPIO_PF0
    //
	MAP_GPIOPinTypeGPIOInput(GPIO_PORTF_BASE, GPIO_PIN_0);

    //
    // Configure the GPIO Pin Mux for PK0
	// for GPIO_PK0
    //
	MAP_GPIOPinTypeGPIOOutput(GPIO_PORTK_BASE, GPIO_PIN_0);

    //
    // Configure the GPIO Pin Mux for PK1
	// for GPIO_PK1
    //
	MAP_GPIOPinTypeGPIOOutput(GPIO_PORTK_BASE, GPIO_PIN_1);

    //
    // Configure the GPIO Pin Mux for PK2
	// for GPIO_PK2
    //
	MAP_GPIOPinTypeGPIOInput(GPIO_PORTK_BASE, GPIO_PIN_2);

    //
    // Configure the GPIO Pin Mux for PK3
	// for GPIO_PK3
    //
	MAP_GPIOPinTypeGPIOInput(GPIO_PORTK_BASE, GPIO_PIN_3);

    //
    // Configure the GPIO Pin Mux for PC7
	// for GPIO_PC7
    //
	MAP_GPIOPinTypeGPIOInput(GPIO_PORTC_BASE, GPIO_PIN_7);

    //
    // Configure the GPIO Pin Mux for PC6
	// for GPIO_PC6
    //
	MAP_GPIOPinTypeGPIOOutput(GPIO_PORTC_BASE, GPIO_PIN_6);

    //
    // Configure the GPIO Pin Mux for PH0
	// for GPIO_PH0
    //
	MAP_GPIOPinTypeGPIOOutput(GPIO_PORTH_BASE, GPIO_PIN_0);

    //
    // Configure the GPIO Pin Mux for PH1
	// for GPIO_PH1
    //
	MAP_GPIOPinTypeGPIOOutput(GPIO_PORTH_BASE, GPIO_PIN_1);

    //
    // Configure the GPIO Pin Mux for PH2
	// for GPIO_PH2
    //
	MAP_GPIOPinTypeGPIOOutput(GPIO_PORTH_BASE, GPIO_PIN_2);

    //
    // Configure the GPIO Pin Mux for PH3
	// for GPIO_PH3
    //
	MAP_GPIOPinTypeGPIOOutput(GPIO_PORTH_BASE, GPIO_PIN_3);

    //
    // Configure the GPIO Pin Mux for PM5
	// for GPIO_PM5
    //
	MAP_GPIOPinTypeGPIOOutput(GPIO_PORTM_BASE, GPIO_PIN_5);

    //
    // Configure the GPIO Pin Mux for PM1
	// for GPIO_PM1
    //
	MAP_GPIOPinTypeGPIOOutput(GPIO_PORTM_BASE, GPIO_PIN_1);

    //
    // Configure the GPIO Pin Mux for PM0
	// for GPIO_PM0
    //
	MAP_GPIOPinTypeGPIOOutput(GPIO_PORTM_BASE, GPIO_PIN_0);

    //
    // Configure the GPIO Pin Mux for PL1
	// for GPIO_PL1
    //
	MAP_GPIOPinTypeGPIOOutput(GPIO_PORTL_BASE, GPIO_PIN_1);

    //
    // Configure the GPIO Pin Mux for PL2
	// for GPIO_PL2
    //
	MAP_GPIOPinTypeGPIOInput(GPIO_PORTL_BASE, GPIO_PIN_2);

    //
    // Configure the GPIO Pin Mux for PL3
	// for GPIO_PL3
    //
	MAP_GPIOPinTypeGPIOInput(GPIO_PORTL_BASE, GPIO_PIN_3);

    //
    // Configure the GPIO Pin Mux for PL4
	// for GPIO_PL4
    //
	MAP_GPIOPinTypeGPIOOutput(GPIO_PORTL_BASE, GPIO_PIN_4);

    //
    // Configure the GPIO Pin Mux for PL5
	// for GPIO_PL5
    //
	MAP_GPIOPinTypeGPIOInput(GPIO_PORTL_BASE, GPIO_PIN_5);

    //
    // Configure the GPIO Pin Mux for PM2
	// for GPIO_PM2
    //
	MAP_GPIOPinTypeGPIOInput(GPIO_PORTM_BASE, GPIO_PIN_2);

    //
    // Configure the GPIO Pin Mux for PM3
	// for GPIO_PM3
    //
	MAP_GPIOPinTypeGPIOOutput(GPIO_PORTM_BASE, GPIO_PIN_3);

    //
    // Configure the GPIO Pin Mux for PB3
	// for GPIO_PB3
    //
	MAP_GPIOPinTypeGPIOOutput(GPIO_PORTB_BASE, GPIO_PIN_3);

    //
    // Configure the GPIO Pin Mux for PL7
	// for GPIO_PL7
    //
	MAP_GPIOPinTypeGPIOOutput(GPIO_PORTL_BASE, GPIO_PIN_7);

    //
    // Configure the GPIO Pin Mux for PL6
	// for GPIO_PL6
    //
	MAP_GPIOPinTypeGPIOInput(GPIO_PORTL_BASE, GPIO_PIN_6);

    //
    // Configure the GPIO Pin Mux for PP2
	// for GPIO_PP2
    //
	MAP_GPIOPinTypeGPIOInput(GPIO_PORTP_BASE, GPIO_PIN_2);

    //
    // Configure the GPIO Pin Mux for PQ4
	// for DIVSCLK
    //
	MAP_GPIOPinConfigure(GPIO_PQ4_DIVSCLK);
    GPIODirModeSet(GPIO_PORTQ_BASE, GPIO_PIN_4, GPIO_DIR_MODE_HW);
    GPIOPadConfigSet(GPIO_PORTQ_BASE, GPIO_PIN_4, GPIO_STRENGTH_8MA, GPIO_PIN_TYPE_STD);

    //
    // Configure the GPIO Pin Mux for PC4
	// for U7RX
    //
	MAP_GPIOPinConfigure(GPIO_PC4_U7RX);
	MAP_GPIOPinTypeUART(GPIO_PORTC_BASE, GPIO_PIN_4);

    //
    // Configure the GPIO Pin Mux for PC5
	// for U7TX
    //
	MAP_GPIOPinConfigure(GPIO_PC5_U7TX);
	MAP_GPIOPinTypeUART(GPIO_PORTC_BASE, GPIO_PIN_5);

    //
    // Configure the GPIO Pin Mux for PE4
	// for SSI1XDAT0
    //
	MAP_GPIOPinConfigure(GPIO_PE4_SSI1XDAT0);
	MAP_GPIOPinTypeSSI(GPIO_PORTE_BASE, GPIO_PIN_4);

    //
    // Configure the GPIO Pin Mux for PE5
	// for SSI1XDAT1
    //
	MAP_GPIOPinConfigure(GPIO_PE5_SSI1XDAT1);
	MAP_GPIOPinTypeSSI(GPIO_PORTE_BASE, GPIO_PIN_5);

    //
    // Configure the GPIO Pin Mux for PB4
	// for SSI1FSS
    //
	MAP_GPIOPinConfigure(GPIO_PB4_SSI1FSS);
	MAP_GPIOPinTypeSSI(GPIO_PORTB_BASE, GPIO_PIN_4);

    //
    // Configure the GPIO Pin Mux for PB5
	// for SSI1CLK
    //
	MAP_GPIOPinConfigure(GPIO_PB5_SSI1CLK);
	MAP_GPIOPinTypeSSI(GPIO_PORTB_BASE, GPIO_PIN_5);

    //
    // Configure the GPIO Pin Mux for PQ2
	// for SSI3XDAT0
    //
	MAP_GPIOPinConfigure(GPIO_PQ2_SSI3XDAT0);
	MAP_GPIOPinTypeSSI(GPIO_PORTQ_BASE, GPIO_PIN_2);

    //
    // Configure the GPIO Pin Mux for PQ3
	// for SSI3XDAT1
    //
	MAP_GPIOPinConfigure(GPIO_PQ3_SSI3XDAT1);
	MAP_GPIOPinTypeSSI(GPIO_PORTQ_BASE, GPIO_PIN_3);

    //
    // Configure the GPIO Pin Mux for PQ0
	// for SSI3CLK
    //
	MAP_GPIOPinConfigure(GPIO_PQ0_SSI3CLK);
	MAP_GPIOPinTypeSSI(GPIO_PORTQ_BASE, GPIO_PIN_0);

    //
    // Configure the GPIO Pin Mux for PD1
	// for SSI2XDAT0
    //
	MAP_GPIOPinConfigure(GPIO_PD1_SSI2XDAT0);
	MAP_GPIOPinTypeSSI(GPIO_PORTD_BASE, GPIO_PIN_1);

    //
    // Configure the GPIO Pin Mux for PD6
	// for SSI2XDAT3
    //
	MAP_GPIOPinConfigure(GPIO_PD6_SSI2XDAT3);
	MAP_GPIOPinTypeSSI(GPIO_PORTD_BASE, GPIO_PIN_6);

    //
    // Configure the GPIO Pin Mux for PD0
	// for SSI2XDAT1
    //
	MAP_GPIOPinConfigure(GPIO_PD0_SSI2XDAT1);
	MAP_GPIOPinTypeSSI(GPIO_PORTD_BASE, GPIO_PIN_0);

    //
    // Configure the GPIO Pin Mux for PD2
	// for SSI2FSS
    //
	MAP_GPIOPinConfigure(GPIO_PD2_SSI2FSS);
	MAP_GPIOPinTypeSSI(GPIO_PORTD_BASE, GPIO_PIN_2);

	//
	// Unlock the Port Pin and Set the Commit Bit
	//
	HWREG(GPIO_PORTD_BASE+GPIO_O_LOCK) = GPIO_LOCK_KEY;
	HWREG(GPIO_PORTD_BASE+GPIO_O_CR)   |= GPIO_PIN_7;
	HWREG(GPIO_PORTD_BASE+GPIO_O_LOCK) = 0x0;
	
    //
    // Configure the GPIO Pin Mux for PD7
	// for SSI2XDAT2
    //
	MAP_GPIOPinConfigure(GPIO_PD7_SSI2XDAT2);
	MAP_GPIOPinTypeSSI(GPIO_PORTD_BASE, GPIO_PIN_7);

    //
    // Configure the GPIO Pin Mux for PD3
	// for SSI2CLK
    //
	MAP_GPIOPinConfigure(GPIO_PD3_SSI2CLK);
	MAP_GPIOPinTypeSSI(GPIO_PORTD_BASE, GPIO_PIN_3);

    //
    // Configure the GPIO Pin Mux for PA4
	// for SSI0XDAT0
    //
	MAP_GPIOPinConfigure(GPIO_PA4_SSI0XDAT0);
	MAP_GPIOPinTypeSSI(GPIO_PORTA_BASE, GPIO_PIN_4);

    //
    // Configure the GPIO Pin Mux for PA5
	// for SSI0XDAT1
    //
	MAP_GPIOPinConfigure(GPIO_PA5_SSI0XDAT1);
	MAP_GPIOPinTypeSSI(GPIO_PORTA_BASE, GPIO_PIN_5);

    //
    // Configure the GPIO Pin Mux for PA3
	// for SSI0FSS
    //
	MAP_GPIOPinConfigure(GPIO_PA3_SSI0FSS);
	MAP_GPIOPinTypeSSI(GPIO_PORTA_BASE, GPIO_PIN_3);

    //
    // Configure the GPIO Pin Mux for PA2
	// for SSI0CLK
    //
	MAP_GPIOPinConfigure(GPIO_PA2_SSI0CLK);
	MAP_GPIOPinTypeSSI(GPIO_PORTA_BASE, GPIO_PIN_2);

    //
    // Configure the GPIO Pin Mux for PP0
	// for EN0INTRN
    //
	MAP_GPIOPinConfigure(GPIO_PP0_EN0INTRN);
	GPIOPinTypeEthernetMII(GPIO_PORTP_BASE, GPIO_PIN_0);

    //
    // Configure the GPIO Pin Mux for PK4
	// for EN0RXD3
    //
	MAP_GPIOPinConfigure(GPIO_PK4_EN0RXD3);
	GPIOPinTypeEthernetMII(GPIO_PORTK_BASE, GPIO_PIN_4);

    //
    // Configure the GPIO Pin Mux for PK6
	// for EN0TXD2
    //
	MAP_GPIOPinConfigure(GPIO_PK6_EN0TXD2);
	GPIOPinTypeEthernetMII(GPIO_PORTK_BASE, GPIO_PIN_6);

    //
    // Configure the GPIO Pin Mux for PG5
	// for EN0TXD1
    //
	MAP_GPIOPinConfigure(GPIO_PG5_EN0TXD1);
	GPIOPinTypeEthernetMII(GPIO_PORTG_BASE, GPIO_PIN_5);

    //
    // Configure the GPIO Pin Mux for PA6
	// for EN0RXCK
    //
	MAP_GPIOPinConfigure(GPIO_PA6_EN0RXCK);
	GPIOPinTypeEthernetMII(GPIO_PORTA_BASE, GPIO_PIN_6);

    //
    // Configure the GPIO Pin Mux for PG7
	// for EN0RXDV
    //
	MAP_GPIOPinConfigure(GPIO_PG7_EN0RXDV);
	GPIOPinTypeEthernetMII(GPIO_PORTG_BASE, GPIO_PIN_7);

    //
    // Configure the GPIO Pin Mux for PF2
	// for EN0MDC
    //
	MAP_GPIOPinConfigure(GPIO_PF2_EN0MDC);
	GPIOPinTypeEthernetMII(GPIO_PORTF_BASE, GPIO_PIN_2);

    //
    // Configure the GPIO Pin Mux for PG3
	// for EN0TXEN
    //
	MAP_GPIOPinConfigure(GPIO_PG3_EN0TXEN);
	GPIOPinTypeEthernetMII(GPIO_PORTG_BASE, GPIO_PIN_3);

    //
    // Configure the GPIO Pin Mux for PF3
	// for EN0MDIO
    //
	MAP_GPIOPinConfigure(GPIO_PF3_EN0MDIO);
	GPIOPinTypeEthernetMII(GPIO_PORTF_BASE, GPIO_PIN_3);

    //
    // Configure the GPIO Pin Mux for PQ5
	// for EN0RXD0
    //
	MAP_GPIOPinConfigure(GPIO_PQ5_EN0RXD0);
	GPIOPinTypeEthernetMII(GPIO_PORTQ_BASE, GPIO_PIN_5);

    //
    // Configure the GPIO Pin Mux for PM6
	// for EN0CRS
    //
	MAP_GPIOPinConfigure(GPIO_PM6_EN0CRS);
	GPIOPinTypeEthernetMII(GPIO_PORTM_BASE, GPIO_PIN_6);

    //
    // Configure the GPIO Pin Mux for PK5
	// for EN0RXD2
    //
	MAP_GPIOPinConfigure(GPIO_PK5_EN0RXD2);
	GPIOPinTypeEthernetMII(GPIO_PORTK_BASE, GPIO_PIN_5);

    //
    // Configure the GPIO Pin Mux for PG4
	// for EN0TXD0
    //
	MAP_GPIOPinConfigure(GPIO_PG4_EN0TXD0);
	GPIOPinTypeEthernetMII(GPIO_PORTG_BASE, GPIO_PIN_4);

    //
    // Configure the GPIO Pin Mux for PG2
	// for EN0TXCK
    //
	MAP_GPIOPinConfigure(GPIO_PG2_EN0TXCK);
	GPIOPinTypeEthernetMII(GPIO_PORTG_BASE, GPIO_PIN_2);

    //
    // Configure the GPIO Pin Mux for PQ6
	// for EN0RXD1
    //
	MAP_GPIOPinConfigure(GPIO_PQ6_EN0RXD1);
	GPIOPinTypeEthernetMII(GPIO_PORTQ_BASE, GPIO_PIN_6);

    //
    // Configure the GPIO Pin Mux for PK7
	// for EN0TXD3
    //
	MAP_GPIOPinConfigure(GPIO_PK7_EN0TXD3);
	GPIOPinTypeEthernetMII(GPIO_PORTK_BASE, GPIO_PIN_7);

    //
    // Configure the GPIO Pin Mux for PM7
	// for EN0COL
    //
	MAP_GPIOPinConfigure(GPIO_PM7_EN0COL);
	GPIOPinTypeEthernetMII(GPIO_PORTM_BASE, GPIO_PIN_7);

    //
    // Configure the GPIO Pin Mux for PP5
	// for I2C2SCL
    //
	MAP_GPIOPinConfigure(GPIO_PP5_I2C2SCL);
	MAP_GPIOPinTypeI2CSCL(GPIO_PORTP_BASE, GPIO_PIN_5);

    //
    // Configure the GPIO Pin Mux for PN4
	// for I2C2SDA
    //
	MAP_GPIOPinConfigure(GPIO_PN4_I2C2SDA);
	MAP_GPIOPinTypeI2C(GPIO_PORTN_BASE, GPIO_PIN_4);

    //
    // Configure the GPIO Pin Mux for PA0
	// for I2C9SCL
    //
	MAP_GPIOPinConfigure(GPIO_PA0_I2C9SCL);
	MAP_GPIOPinTypeI2CSCL(GPIO_PORTA_BASE, GPIO_PIN_0);

    //
    // Configure the GPIO Pin Mux for PA1
	// for I2C9SDA
    //
	MAP_GPIOPinConfigure(GPIO_PA1_I2C9SDA);
	MAP_GPIOPinTypeI2C(GPIO_PORTA_BASE, GPIO_PIN_1);

    //
    // Configure the GPIO Pin Mux for PG0
	// for I2C1SCL
    //
	MAP_GPIOPinConfigure(GPIO_PG0_I2C1SCL);
	MAP_GPIOPinTypeI2CSCL(GPIO_PORTG_BASE, GPIO_PIN_0);

    //
    // Configure the GPIO Pin Mux for PG1
	// for I2C1SDA
    //
	MAP_GPIOPinConfigure(GPIO_PG1_I2C1SDA);
	MAP_GPIOPinTypeI2C(GPIO_PORTG_BASE, GPIO_PIN_1);

    //
    // Configure the GPIO Pin Mux for PB0
	// for I2C5SCL
    //
	MAP_GPIOPinConfigure(GPIO_PB0_I2C5SCL);
	MAP_GPIOPinTypeI2CSCL(GPIO_PORTB_BASE, GPIO_PIN_0);

    //
    // Configure the GPIO Pin Mux for PB1
	// for I2C5SDA
    //
	MAP_GPIOPinConfigure(GPIO_PB1_I2C5SDA);
	MAP_GPIOPinTypeI2C(GPIO_PORTB_BASE, GPIO_PIN_1);

}

//*****************************************************************************
//
// Close the Doxygen group.
//! @}
//
//*****************************************************************************

