/*
 * Copyright (c) 2015, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/*
 *  ======== empty.c ========
 */
/* XDCtools Header files */
#include <xdc/std.h>
#include <xdc/cfg/global.h>
#include <xdc/runtime/System.h>

/* BIOS Header files */
#include <ti/sysbios/BIOS.h>

/* TI-RTOS Header files */
// #include <ti/drivers/EMAC.h>
#include <ti/drivers/GPIO.h>
// #include <ti/drivers/I2C.h>
// #include <ti/drivers/SDSPI.h>
// #include <ti/drivers/SPI.h>
// #include <ti/drivers/UART.h>
// #include <ti/drivers/USBMSCHFatFs.h>
// #include <ti/drivers/Watchdog.h>
// #include <ti/drivers/WiFi.h>

#include <xdc/runtime/Log.h>
#include <driverlib/sysctl.h>
#include <driverlib/timer.h>
#include <driverlib/interrupt.h>
#include "inc/hw_memmap.h"
#include "inc/tm4c1294ncpdt.h"

/* Board Header file */
#include "Board.h"


extern "C" void hwiTimer2AFxn(void)
{
	TimerIntClear(TIMER2_BASE, TIMER_TIMA_TIMEOUT);

	Swi_post(swiTimer2A);
}

extern "C" void swiTimer2AFxn(void)
{
	GPIO_toggle(Board_LED0);

	Log_info0("swiTimer2AFxn");
}

extern "C" void hwiTimer2BFxn(void)
{
	TimerIntClear(TIMER2_BASE, TIMER_TIMB_TIMEOUT);

	Swi_post(swiTimer2B);
}

extern "C" void swiTimer2BFxn(void)
{
	GPIO_toggle(Board_LED0);

	Log_info0("swiTimer2BFxn");
}

/*
 *  ======== heartBeatFxn ========
 *  Toggle the Board_LED0. The Task_sleep is determined by arg0 which
 *  is configured for the heartBeat Task instance.
 */
extern "C" Void heartBeatFxn(UArg arg0, UArg arg1)
{
}

/*
 *  ======== main ========
 */
int main(void)
{
    /* Call board init functions */
    Board_initGeneral();
    // Board_initEMAC();
    Board_initGPIO();
    // Board_initI2C();
    // Board_initSDSPI();
    // Board_initSPI();
    // Board_initUART();
    // Board_initUSB(Board_USBDEVICE);
    // Board_initUSBMSCHFatFs();
    // Board_initWatchdog();
    // Board_initWiFi();

    SysCtlPeripheralEnable(SYSCTL_PERIPH_TIMER2);
	TimerClockSourceSet(TIMER2_BASE, TIMER_CLOCK_SYSTEM);

	//TIMER_A
//	TimerConfigure(TIMER2_BASE, TIMER_CFG_A_PERIODIC);
//    TimerLoadSet(TIMER2_BASE, TIMER_A, 0xFF);
//
//	TimerIntEnable(TIMER2_BASE, TIMER_TIMA_TIMEOUT);
//	IntEnable(INT_TIMER2A);
//	IntMasterEnable();
//
//	TimerEnable(TIMER2_BASE, TIMER_A);

	//TIMER_B
	TimerConfigure(TIMER2_BASE, TIMER_CFG_B_PERIODIC);
    TimerLoadSet(TIMER2_BASE, TIMER_B, 0xFF);

	TimerIntEnable(TIMER2_BASE, TIMER_TIMB_TIMEOUT);
	IntEnable(INT_TIMER2B);
	IntMasterEnable();

	TimerEnable(TIMER2_BASE, TIMER_B);

    /* Turn on user LED */
    GPIO_write(Board_LED0, Board_LED_ON);

    System_printf("Starting the example\nSystem provider is set to SysMin. "
                  "Halt the target to view any SysMin contents in ROV.\n");
    /* SysMin will only print to the console when you call flush or exit */
    System_flush();

    /* Start BIOS */
    BIOS_start();

    return (0);
}
