#include "ti_msp_dl_config.h"

/*- GPIOA:
    + Standard Output: PA4 - EOT INT
    + High-Speed Output: PA5 - TX INT
    + Standard Output: PA3 - CPU ACTIVE
    + Standard Output: PA7 - UART BUSY
- SYSCTL
- UART0:
    + RX Pin: PA18
    + TX Pin: PA25
- EVENT
- BOARD:
    + Debug Clock: PA20
    + Debug Data In Out: PA19*/



#define ENABLE_DEBUG

uint8_t data = 0x55;
volatile bool bUARTBusy = 0;

int main(void)
{
    SYSCFG_DL_init();
    delay_cycles(100000);
    DL_GPIO_setPins(GPIO_A_PORT,GPIO_A_PA3_ACTIVE_MODE_PIN );

    NVIC_ClearPendingIRQ(UART_0_INST_INT_IRQN);
    NVIC_EnableIRQ(UART_0_INST_INT_IRQN);

    /* Allow CPU to process instructions after waking */
    DL_SYSCTL_disableSleepOnExit();

    while (DL_UART_isBusy(UART_0_INST));

    /* show UART is busy */
#ifdef ENABLE_DEBUG
    DL_GPIO_setPins(GPIO_A_PORT,GPIO_A_PA7_BUSY_PIN);
#endif
    bUARTBusy = true;

    /* send first byte to start the process */
    DL_UART_Main_transmitData(UART_0_INST, data);

    while (1)
    {
#ifdef ENABLE_DEBUG
        DL_GPIO_clearPins(GPIO_A_PORT,GPIO_A_PA3_ACTIVE_MODE_PIN );
#endif
        /* CPU enters low power mode. UART INT wakes CPU */
        __WFI();

#ifdef ENABLE_DEBUG
        /* show on logic probe CPU is in active mode */
        DL_GPIO_setPins(GPIO_A_PORT,GPIO_A_PA3_ACTIVE_MODE_PIN );
#endif
        /* An interrupt wakes CPU - check if UART interrupt happened */
        if(bUARTBusy == 0)
        {
            /* delay puts delay in between transmitted bytes - modify to change delay or comment out */
            delay_cycles(50000);

            while (DL_UART_isBusy(UART_0_INST));

            DL_UART_Main_transmitData(UART_0_INST, data);

            /* show UART is busy */
#ifdef ENABLE_DEBUG
            DL_GPIO_setPins(GPIO_A_PORT,GPIO_A_PA7_BUSY_PIN);
#endif
            bUARTBusy = 1;
        }

    }// end while
}

void UART_0_INST_IRQHandler(void)
{
#ifdef ENABLE_DEBUG
        /* show on logic proble CPU is in active mode */
        DL_GPIO_setPins(GPIO_A_PORT,GPIO_A_PA3_ACTIVE_MODE_PIN );
#endif
    switch (DL_UART_Main_getPendingInterrupt(UART_0_INST)) {

        case DL_UART_MAIN_IIDX_EOT_DONE:
            /* signal that we are in EOT INT */
#ifdef ENABLE_DEBUG
            DL_GPIO_setPins(GPIO_A_PORT,GPIO_A_PA4_EOT_INT_PIN );
#endif
            __NOP();
            __NOP();
            __NOP();
            __NOP();
            __NOP();
            __NOP();
            __NOP();
            __NOP();

#ifdef ENABLE_DEBUG
            DL_GPIO_clearPins(GPIO_A_PORT,GPIO_A_PA4_EOT_INT_PIN);
#endif
            break;

        case DL_UART_MAIN_IIDX_TX:
            /* signal that we are in TX INT */
#ifdef ENABLE_DEBUG
            DL_GPIO_setPins(GPIO_A_PORT,GPIO_A_PA5_TX_INT_PIN );
#endif
            __NOP();
            __NOP();
            __NOP();
            __NOP();
            __NOP();
            __NOP();
            __NOP();
            __NOP();

#ifdef ENABLE_DEBUG
            DL_GPIO_clearPins(GPIO_A_PORT,GPIO_A_PA5_TX_INT_PIN );
#endif
            break;

        default:
            break;
    }

    bUARTBusy = 0;

#ifdef ENABLE_DEBUG
    DL_GPIO_clearPins(GPIO_A_PORT, (GPIO_A_PA7_BUSY_PIN | GPIO_A_PA3_ACTIVE_MODE_PIN));
#endif

}
