/*
 * Copyright (c) 2015-2016, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/*
 *    ======== uartconsole.c ========
 */

#include <file.h>
#include <stdio.h>
#include <string.h>
#include <stdbool.h>
#include <stdint.h>
#include <inc/hw_memmap.h>
#include <driverlib/gpio.h>

/* XDCtools Header files */
#include <xdc/std.h>
#include <xdc/runtime/Error.h>
#include <xdc/runtime/System.h>

/* BIOS Header files */
#include <ti/sysbios/BIOS.h>
#include <ti/sysbios/utils/Load.h>
#include <ti/sysbios/knl/Task.h>

/* TI-RTOS Header files */
#include <ti/drivers/GPIO.h>
#include <ti/drivers/UART.h>

/* Example/Board Header files */
#include "Board.h"
#include "UARTUtils.h"
#include "USBCDCD_LoggerIdle.h"
#include "MertenBus.h"
//#define TASKSTACKSIZE     1536
#define TASKSTACKSIZE     2536

Task_Struct task0Struct;
Char task0Stack[TASKSTACKSIZE];

/*
 *  ======== consoleFxn ========
 *  Task for this function is created statically. See the project's .cfg file.
 */
Void consoleFxn(UArg arg0, UArg arg1)
{
    //unsigned int sleepDur;
    unsigned int count;
    //unsigned int cpuLoad;
    //char input[128];
    MertenBusTelegramObject tel;
    MertenBusHandle mbHdl;
    count = 1;

    /* printf goes to the UART com port */
//    printf("\f======== Welcome to the Console ========\n");
//    printf("Enter a command followed by return.\n"
//           "Type help for a list of commands.\n\n");
//
//    printf("%d %% ", count++);
//    fflush(stdout);

//    mbHdl = mertenBusInitAndStart(EK_TM4C129EXL_UART2, GPIO_PORTA_BASE, GPIO_PIN_7);
    mbHdl = mertenBusInitAndStart(EK_TM4C129EXL_UART4, GPIO_PORTK_BASE, GPIO_PIN_1);
    MertenBusConstructCommandTelegram(&tel, 255, MB_CMD_SET_LED_LEFT);
    MertenBusAddByteToTelegram(&tel, 127); // green
    MertenBusAddByteToTelegram(&tel, 127); // red
    MertenBusSendTelegram(&tel, mbHdl);

    //MertenBusConstructQueryTelegram(&tel, 255, MB_QRY_MODULE_ADR);
    //MertenBusSendTelegram(&tel, mbHdl);

//    MertenBusConstructCommandTelegram(&tel, 255, MB_CMD_CLEAR_RESET_FLAG);
//    MertenBusSendTelegram(&tel, mbHdl);
    /* Loop forever receiving commands */
    while(true) {

        Task_sleep(10000); // sleep for 10 clock ticks (10ms)
//        /* Get the user's input */
//        scanf("%s", input);
//        /* Flush the remaining characters from stdin since they are not used. */
//        fflush(stdin);
//
//        if (!strcmp(input, "load")) {
//            /* Print the CPU load */
//            cpuLoad = Load_getCPULoad();
//            printf("CPU Load: %d\n", cpuLoad);
//        }
//        else if (!strcmp(input, "sleep")) {
//            /* Put the task to sleep for X ms. */
//            printf("Enter a duration (ms): ");
//            fflush(stdout);
//            scanf("%d", &sleepDur);
//            fflush(stdin);
//            Task_sleep(sleepDur);
//        }
//        else if (!strcmp(input, "exit")) {
//            /* Exit the console task */
//            printf("Are you sure you want to exit the console? Y/N: ");
//            fflush(stdout);
//            scanf("%s", input);
//            fflush(stdin);
//            if ((input[0] == 'y' || input[0] == 'Y') && input[1] == 0x00) {
//                printf("Exiting console, goodbye.\n");
//                Task_exit();
//            }
//        }
//        else {
//            /* Print a list of valid commands. */
//            printf("Valid commands:\n"
//                   "- load: Get the CPU and task load.\n"
//                   "- sleep: Put the console task to sleep.\n"
//                   "- exit: Exit the console task.\n");
//        }
//
//        printf("%d %% ", count++);
//        fflush(stdout);
    }
}

/*
 *  ======== main ========
 */
int main(void)
{
    /* Call board init functions. */
    Board_initGeneral();
    Board_initGPIO();
    Board_initUART();
    Board_initUSB(Board_USBDEVICE);

    /* Construct BIOS objects */
    Task_Params taskParams;

    Task_Params_init(&taskParams);
    taskParams.stackSize = TASKSTACKSIZE;
    taskParams.stack = &task0Stack;
    Task_construct(&task0Struct, (Task_FuncPtr)consoleFxn, &taskParams, NULL);

    /* Turn on user LED */
    GPIO_write(Board_LED0, Board_LED_ON);

    /*
     *  Add the UART device to the system.
     *  All UART peripherals must be setup and the module must be initialized
     *  before opening.  This is done by Board_initUART().  The functions used
     *  are implemented in UARTUtils.c.
     */
//    add_device("UART", _MSA, UARTUtils_deviceopen,
//               UARTUtils_deviceclose, UARTUtils_deviceread,
//               UARTUtils_devicewrite, UARTUtils_devicelseek,
//               UARTUtils_deviceunlink, UARTUtils_devicerename);
//
//    /* Open UART0 for writing to stdout and set buffer */
//    freopen("UART:0", "w", stdout);
//    setvbuf(stdout, NULL, _IOLBF, 128);
//
//    /* Open UART0 for reading from stdin and set buffer */
//    freopen("UART:0", "r", stdin);
//    setvbuf(stdin, NULL, _IOLBF, 128);
//
//    /*
//     *  Initialize UART port 0 used by SysCallback.  This and other SysCallback
//     *  UART functions are implemented in UARTUtils.c. Calls to System_printf
//     *  will go to UART0, the same as printf.
//     */
//    UARTUtils_systemInit(0);
//
//    // System_printf("Starting the UART Console example\n");
//
//    /* Initialize the USB CDC device for logging transport */
//    USBCDCD_init();

    /* Start BIOS */
    BIOS_start();

    return (0);
}
