/* vim:ts=4:sw=4:expandtab
 * (No tabs, indent level is 4 spaces)  */
/*****************************************************************************
 * File:            usb_uart_sender.c
 * Creation Date:   2020.10.09
 * Description:     USB-UART pressure test
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright notice,
 *       this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of provider nor the names of its contributors
 *       may be used to endorse or promote products derived from this software
 *       without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *****************************************************************************/


#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <fcntl.h>
#include <termios.h>
#include <net/if.h>
#include <linux/sockios.h>
#include <linux/can.h>
#include <linux/can/raw.h>
#include <sys/ioctl.h>
#include <errno.h>

/* Return value */
#define FALSE  -1
#define TRUE   0

/* Device node */
#define DEV_NAME     "/dev/ttyACM2"

/* Tx buffer size */
#define TX_NUM       1000

/* Frame tx gap, in microsecond */
#define FRAME_DELAY  2000

typedef struct{
    int can_id;
    int can_dlc;
    unsigned char data[8];
}can_frame;

/*****************************************************************************/
/** main
 *
 * \desc            A demo of usb-uart converter initialization.
 *
 * \param[in]       argc, counter of arguments.
 *
 * \param[in]       argv, argument array.
 *
 * \return          0 if successful.
 * \return          1 if system call returned failure.
 * \return          2 if uart operation failed.
 * \return          99 if other errors.
 *
 *****************************************************************************/
int main(int argc, char *argv[])
{
    int                 fd_uart = FALSE;
    struct can_frame    tx_frame[TX_NUM];
    int                 i_tx = 0;
    int                 nbytes = 0;

    memset(&tx_frame, 0, sizeof(tx_frame));
    fd_uart = open(DEV_NAME, O_RDWR|O_NOCTTY|O_NDELAY);
    if (FALSE == fd_uart)
    {
        perror("Open ttyACM failed!!!");
        return(FALSE);
    }

    /* Tx demo */
    for (i_tx = 0; i_tx < TX_NUM; i_tx++)
    {
        tx_frame[i_tx].can_id = i_tx + 1;
        tx_frame[i_tx].can_dlc = 8;
        tx_frame[i_tx].data[0] = i_tx;
        tx_frame[i_tx].data[1] = i_tx;
        tx_frame[i_tx].data[2] = i_tx;
        tx_frame[i_tx].data[3] = i_tx;
        tx_frame[i_tx].data[4] = i_tx;
        tx_frame[i_tx].data[5] = i_tx;
        tx_frame[i_tx].data[6] = i_tx;
        tx_frame[i_tx].data[7] = i_tx;

        /* send tx_frame[i_tx] */
        nbytes = write(fd_uart, &tx_frame[i_tx], sizeof(tx_frame[i_tx]));
        if (nbytes != sizeof(tx_frame[i_tx]))
        {
            printf("Send Error tx_frame[%d]:%d errno:%d\n",
                    i_tx, nbytes, errno);
            perror("fd_uart write");
            usleep(1000000);
            continue;
        }
       /* the transparent is ok if the FRAME_DELAY is removed. */
       usleep(FRAME_DELAY);
    }

    close(fd_uart);

    return 0;
}


















