// i2c functionality for module 1

#ifndef SRC_I2CFUNC_H_
#define SRC_I2CFUNC_H_

#include <stdbool.h>
#include <stdarg.h>
#include <stdint.h>
#include "inc/hw_types.h"
#include "inc/hw_memmap.h"
#include "driverlib/gpio.h"
#include "driverlib/i2c.h"
#include "driverlib/rom.h"

static bool __i2cinit;
bool InitI2C1(void);

typedef struct {

	bool ( *InitI2C )(void);

	void ( *beginTransmission ) ( uint8_t i2cAddr ); // start transmission, no matter if send or receive
	uint8_t ( *endTransmission )( void ); // end transmission, no matter of send or receive

	void ( *requestFrom )( uint8_t i2cAddr, uint8_t noOfBytes );
	unsigned long ( *read )(void);
	unsigned long ( *readReg )( uint8_t reg );

	void ( *write )(uint8_t data); // write a byte of data
	void ( *writeReg )(uint8_t reg, uint8_t value); // write a register with  desired byte data (made of a )

	bool ( *isAvailable )( uint8_t slave_addr ); // check to see if slave address responds to master's call

} i2cAPI;

extern i2cAPI Wire;

#endif /* SRC_I2CFUNC_H_ */
