/*
 * RDGxxxx.h
 *
 *  Created on: 6 lug 2020
 *      Author: mfantina
 */

#ifndef RDGXXXX_H_
#define RDGXXXX_H_

#define NUM_BUFFERS 4       /* Numero di buffers pacchetti US da FPGA */
#define SIZE_BUFFERS 1024   /* DImensione buffers pacchetti US da FPGA */

/* Struttura Rdg */

typedef struct RdgStruct
{
    uint8_t fpgaUsPackets[NUM_BUFFERS][SIZE_BUFFERS];   /* Pacchetti US provenienti da FPGA e diretti al PC */
    uint8_t pcReqPacket[1024];                          /* Richiesta proveniente da PC e diretta verso FPGA */
    uint8_t fpgaAnswPacket[1024];                       /* Risposta proveniente da FPGA e diretta verso PC */

    uint8_t cntWrittenUsPacket;                         /* Contatore progressivo di pacchetto (da FPGA) scritto su RAM */
    uint8_t cntReadenUsPacket;                          /* Contatore progressivo di pacchetto (verso PC) letto da RAM */

    uint16_t pcReqSize;                                 /* Dimensioni (in byte) della richiesta PC */
    uint16_t fpgaAnswSize;                              /* Dimensioni (in byte) della risposta FPGA */

    bool isPcReqReady;                                  /* True = la richiesta PC  pronta */
    sem_t fpgaAnswReady;                                /* Indica che la risposta FPGA  pronta */

    sem_t semDisconnect;                                /* Segnala l'evento Disconnessione */

    int16_t tcpMsgSock;                                 /* Socket di ascolto connessioni TCP per messaggistica */
    int16_t tcpSmpSock;                                 /* Socket di ascolto connessioni TCP per flusso ultrasuoni */
    int16_t newMsgSock;                                 /* Socket messaggistica */
    int16_t newSmpSock;                                 /* Socket flusso ultrasuoni */

} RdgStruct;

extern RdgStruct Rdg;  /* Istanza struttura Rdg */

void *GestioneSpi(void *arg);
void *Ciclo_ConnettiDisconnetti(void *arg);
int32_t Configure_NWP(void);

#endif /* RDGXXXX_H_ */
