#include <SPI.h>
#include <WiFi.h>

static uint8_t smartConfigLed = RED_LED;
static uint8_t connectedLed = YELLOW_LED;
static uint8_t ipObtainedLed = GREEN_LED;

void setup()
{
  Serial.begin(115200);
  pinMode(smartConfigLed, OUTPUT);
  pinMode(ipObtainedLed, OUTPUT);
  pinMode(connectedLed, OUTPUT);
  
  digitalWrite(smartConfigLed, LOW);
  digitalWrite(ipObtainedLed, LOW);
  digitalWrite(connectedLed, LOW);
  
  pinMode(PUSH2, INPUT_PULLUP);
  
  if(WiFi.begin() == WL_CONNECT_FAILED || digitalRead(PUSH2)) {
    Serial.println("Starting WiFi SmartConfig");
    flashLed(smartConfigLed);
    WiFi.startSmartConfig(false);
    digitalWrite(smartConfigLed, HIGH);
  } else {
    Serial.println("Connecting to stored profile");
  }
  
  while ( WiFi.status() != WL_CONNECTED) {
    // print dots while we wait to connect
    Serial.print(".");
    flashLed(connectedLed);
  }
  digitalWrite(connectedLed, HIGH);

  Serial.print("Connected to SSID: ");
  Serial.println(WiFi.SSID());

  while (WiFi.localIP() == INADDR_NONE) {
    // print dots while we wait for an ip addresss
    Serial.print(".");
    flashLed(ipObtainedLed);
  }
  digitalWrite(ipObtainedLed, HIGH);
  
  Serial.println("\nIP Address obtained");
  Serial.print("IP Address: ");
  Serial.println(WiFi.localIP());
}

void loop()
{
  // Noting to do
}

void listProfiles()
{
  WiFi.init();
  
  int8_t name[32];
  int16_t NameLen;
  uint8_t mac[6];
  uint32_t Priority;
  
  SlSecParams_t SecParams;
  SlGetSecParamsExt_t SecParamsEx;
 
  uint8_t i = 0;
//  sl_WlanProfileDel(WLAN_DEL_ALL_PROFILES);
  
  for(i = 0; i < 7; i++) {
    int16_t ret = sl_WlanProfileGet(i, name, &NameLen, mac, &SecParams, &SecParamsEx, &Priority);
    if(ret < 0)
      continue;
      
    Serial.print("index: ");
    Serial.print(i);
    Serial.print("\tret: ");
    Serial.print(ret);
    Serial.print("SSID: ");
    Serial.println((char *)name);
  }
}  

void flashLed(int ledPin)
{
	/* Flash LED three times. */
	for (int i = 0; i < 3; i++) {
		digitalWrite(ledPin, HIGH);
		delay(100);
		digitalWrite(ledPin, LOW);
		delay(100);
	}
}

