//*****************************************************************************
//
// Application Name        - simplelinklibrary
// Application Version     - 1.3.4
// Application Modify Date - 31th of January 2015
// Application Developer   - Glenn Vassallo
// Application Contact	   - contact@swiftsoftware.com.au
// Application Repository  - https://github.com/remixed123/startproject
//
// Application Overview    - This library provides some of the most common and
//							 useful functions that are required when developing
//						     applications with the CC3100/CC3200.
//
// Application Details     - https://github.com/remixed123/startproject/readme.txt
//
// Further Details         - If you would like to chat about your next CC3200 project
//                           then feel free contact us at contact@swiftsoftware.com.au
//
//*****************************************************************************

#ifndef SIMPLELINKLIBRARY_H_
#define SIMPLELINKLIBRARY_H_

#include "simplelink.h"

//*****************************************************************************
// Device Defines
//*****************************************************************************
#define DEVICE_VERSION			"1.0.0"
#define DEVICE_MANUFACTURE		"SAFER_AGING"
#define DEVICE_NAME 			"SAFER_AGING_TEST"
#define DEVICE_MODEL			"CC3200"
#define DEVICE_AP_DOMAIN_NAME	"saferaging.net"
#define DEVICE_SSID_AP_NAME		"saferagingtest01"

//*****************************************************************************
// Access Point Defines
//*****************************************************************************
#define AP_SSID_NAME           	"BN"
#define AP_SECURITY_TYPE       	SL_SEC_TYPE_WPA  /* Security type (OPEN or WEP or WPA*/
#define AP_SECURITY_KEY        	"SecureNetBN" /* Password of the secured AP */
#define SSID_LEN_MAX        	32
#define BSSID_LEN_MAX       	6

//*****************************************************************************
// mDNS Defines
//*****************************************************************************
#define MDNS_SERVICE  "._control._udp.local"
#define TTL             120
#define UNIQUE_SERVICE  1       /* Set 1 for unique services, 0 otherwise */

//*****************************************************************************
// SimpleLink/WiFi Defines
//*****************************************************************************
#define UDPPORT         4000 /* Port number to which the connection is bound */
#define UDPPACKETSIZE   1024
#define SPI_BIT_RATE    14000000

#define TIMEOUT 5

//*****************************************************************************
// Date and Time Global
//*****************************************************************************
extern SlDateTime_t dateTime;

//*****************************************************************************
// Function Declarations
//*****************************************************************************

char * getMacAddress();
char * getDeviceName();
char * getApDomainName();
char * getSsidName();
int getDeviceTimeDate();

long getHostIP(char* pcHostName, unsigned long * pDestinationIP);

int setDeviceName();
int setApDomainName();
int setSsidName();
int setDeviceTimeDate();

int registerMdnsService();
int unregisterMdnsService();

#endif /* SIMPLELINKLIBRARY_H_ */
