/*
 * Copyright (c) 2016, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <ti/devices/cc32xx/inc/hw_types.h>
#include <ti/drivers/dpl/HwiP.h>
#include <ti/drivers/gpio/GPIOCC32XX.h>
#include <ti_drivers_config.h>
#include <ti/devices/cc32xx/driverlib/rom.h>
#include <ti/devices/cc32xx/driverlib/rom_map.h>
#include <ti/devices/cc32xx/driverlib/hwspinlock.h>
#include <ti/devices/cc32xx/driverlib/prcm.h>
#include <ti/devices/cc32xx/driverlib/spi.h>
#include <ti/devices/cc32xx/inc/hw_memmap.h>
#include <ti/devices/cc32xx/inc/hw_apps_rcm.h>
//#include <ti/devices/cc32xx/driverlib/gpio.h>
//#include <ti/devices/cc32xx/driverlib/pin.h>
#include <ti/drivers/SPI.h>

#include "CC3235S_LAUNCHXL.h"

/*
 *  ======== main_freertos.c ========
 */
#include <stdint.h>
#include <stdbool.h>

/* TI-RTOS Header files */
#include <ti/drivers/GPIO.h>


/*
 *  ======== main ========
 */

int main(void)
{
    int i, j, bit;
    uint16_t temp;

    /* Call board init functions */
    Board_init();

    j = 0;
    while (!j) {
        GPIO_write(TC_CS,0);        // chip select low
        GPIO_write(TC_CLOCK,0);     // start with clock low

        for (i=0; i<16; i++) {      // read the 6675
            GPIO_write(TC_CLOCK,1);
            temp <<= 1;
            bit = GPIO_read(TC_DATA);
            GPIO_write(TC_CLOCK,0);
            temp |= bit;
        }
        GPIO_write(TC_CS,1);        // chip select hi

    }

    return (0);
}

void vApplicationStackOverflowHook(void)
{
    for(;;) ;
}